select R_Request.R_Request_ID, R_Request.C_Order_ID, R_Request.C_Project_ID
from R_Request inner join R_RequestType on 
			(R_Request.R_RequestType_ID = R_RequestType.R_RequestType_ID 
				and R_RequestType.IsMaintRequest = 'S')
			inner join C_Project on R_Request.C_Project_ID = C_Project.C_Project_ID
			inner join C_Order on R_Request.C_Order_ID = C_Order.C_Order_ID
where R_Request.IsActive = 'Y'
	and R_Request.AD_Org_ID = ?	
	and R_Request.CloseDate is not null
	and R_Request.CloseDate <= ?
	and (? = 0 or R_Request.C_Order_ID = ?)
	and (? = 0 or C_Project.C_BPartner_ID = ?)
	and not exists (select 'ko' from C_Invoice WHERE C_Invoice.IsSOTrx='Y' and C_Invoice.C_Project_ID = C_Project.C_Project_ID)
order by R_Request_ID

