select S_ResourceType.NAME as TypeName, S_Resource.NAME ResName, S_ResourceAssignment.ASSIGNDATEFROM, S_Resource.AD_User_ID,
       COALESCE(S_TimeExpenseLine.QTY,0) as QTY, S_TimeExpenseLine.S_TimeExpenseLine_ID, R_RequestResource.IsReported, S_Resource.S_Resource_ID, R_RequestResource.R_RequestResource_ID
 from (((R_Request INNER JOIN R_RequestResource ON R_Request.R_REQUEST_ID = R_RequestResource.R_REQUEST_ID)
         INNER JOIN S_ResourceAssignment ON S_ResourceAssignment.S_RESOURCEASSIGNMENT_ID = R_RequestResource.S_RESOURCEASSIGNMENT_ID)
        INNER JOIN S_Resource ON S_Resource.S_RESOURCE_ID = S_ResourceAssignment.S_RESOURCE_ID)
       INNER JOIN S_ResourceType ON S_ResourceType.S_RESOURCETYPE_ID = COALESCE(R_RequestResource.S_RESOURCETYPE_ID, S_Resource.S_RESOURCETYPE_ID)
      LEFT JOIN ((S_TimeExpenseLine INNER JOIN S_TimeExpense ON S_TimeExpenseLine.S_TIMEEXPENSE_ID = S_TimeExpense.S_TIMEEXPENSE_ID
                                                             AND S_TimeExpense.ISACTIVE = 'Y')
                   INNER JOIN AD_USER ON AD_User.C_BPartner_ID = S_TimeExpense.C_BPartner_ID) --- ID Utente
               ON S_TimeExpenseLine.R_REQUEST_ID = R_Request.R_REQUEST_ID
              AND S_TimeExpenseLine.ISACTIVE = 'Y'  
              AND S_TimeExpenseLine.ISTIMEREPORT = 'Y'
              AND S_TimeExpenseLine.DATEEXPENSE = trunc(S_ResourceAssignment.ASSIGNDATEFROM) --- Data
              AND AD_User.AD_User_ID = S_Resource.AD_User_ID
where R_Request.R_REQUEST_ID = ?
  and R_RequestResource.ISACTIVE = 'Y'
  and (S_Resource.AD_USER_ID = ? OR
        R_Request.SALESREP_ID = ? OR
        R_Request.AD_ROLE_ID = ? OR
        'Y' = ?) -- IsTeamLeader ?
order by S_ResourceAssignment.ASSIGNDATEFROM, S_Resource.NAME