select 'R' as type, S_ResourceType.M_PRODUCT_ID, S_TimeExpenseLine.C_UOM_ID, sum(S_TimeExpenseLine.QTY) as QTY 
 from (((R_Request INNER JOIN R_RequestResource ON R_Request.R_REQUEST_ID = R_RequestResource.R_REQUEST_ID)
        INNER JOIN S_ResourceAssignment ON S_ResourceAssignment.S_RESOURCEASSIGNMENT_ID = R_RequestResource.S_RESOURCEASSIGNMENT_ID)
        INNER JOIN S_Resource ON S_Resource.S_RESOURCE_ID = S_ResourceAssignment.S_RESOURCE_ID)
       INNER JOIN S_ResourceType ON S_ResourceType.S_RESOURCETYPE_ID = COALESCE(R_RequestResource.S_RESOURCETYPE_ID, S_Resource.S_RESOURCETYPE_ID)
      INNER JOIN ((S_TimeExpenseLine INNER JOIN S_TimeExpense ON S_TimeExpenseLine.S_TIMEEXPENSE_ID = S_TimeExpense.S_TIMEEXPENSE_ID
                                                            AND S_TimeExpense.ISACTIVE = 'Y')
                  INNER JOIN AD_USER ON AD_User.C_BPartner_ID = S_TimeExpense.C_BPartner_ID) --- ID Utente
      ON S_TimeExpenseLine.R_REQUEST_ID = R_Request.R_REQUEST_ID
     AND S_TimeExpenseLine.ISACTIVE = 'Y'
     AND S_TimeExpenseLine.ISTIMEREPORT = 'Y'
     AND S_TimeExpenseLine.DATEEXPENSE = trunc(S_ResourceAssignment.ASSIGNDATEFROM) --- Data
     AND AD_User.AD_User_ID = S_Resource.AD_User_ID
  where R_Request.R_REQUEST_ID = ?
    and R_RequestResource.ISACTIVE = 'Y'
group by S_ResourceType.M_PRODUCT_ID,S_TimeExpenseLine.C_UOM_ID
union all
select 'S' as type, s_timeexpenseline.M_Product_ID,  -1 as C_UOM_ID, sum(S_TimeExpenseLine.QTY) as QTY
 from S_TimeExpenseLine
where S_TimeExpenseLine.R_REQUEST_ID = ?
  AND S_TimeExpenseLine.ISACTIVE = 'Y'
  AND S_TimeExpenseLine.ISTIMEREPORT = 'N'
group by s_timeexpenseline.M_Product_ID