select C_Invoice.C_INVOICE_ID, C_Invoice.DOCUMENTNO, C_Invoice.DATEINVOICED, C_Invoice.C_BPARTNER_ID, C_Invoice.IsSOTrx,
       C_Invoice.C_CURRENCY_ID, C_Invoice.DOCSTATUS,
       COALESCE(C_Tax.TAXINDICATOR, C_Tax.NAME) AS TAXNAME,
      CASE WHEN SUBSTR(C_DocType.DOCBASETYPE,3,1)='C' THEN C_InvoiceTax.TAXAMT * -1 ELSE C_InvoiceTax.TAXAMT END AS TAXAMT,
      C_Invoice.C_CONVERSIONTYPE_ID
 from C_InvoiceTax, C_Invoice, C_DocType, C_Tax
where (0=? OR C_InvoiceTax.AD_ORG_ID = ?)--C_InvoiceTax.AD_ORG_ID = ? -- AD_Org_ID
  and C_InvoiceTax.ISACTIVE = 'Y'
  and C_InvoiceTax.TAXAMT <> 0
  and C_Invoice.C_INVOICE_ID = C_InvoiceTax.C_INVOICE_ID
  and ((?='Y' AND C_Invoice.DOCSTATUS in ('CO','CL')) OR (?='N' AND C_Invoice.DOCSTATUS not in ('RE','VO'))) -- IsOnlyCompletedDocs, IsOnlyCompletedDocs
  and C_Invoice.DATEINVOICED >= ? -- Data_Da_Rev
  and C_Invoice.DATEINVOICED <= ? -- Data_A_Rev
  and C_DocType.C_DOCTYPE_ID = CASE WHEN C_Invoice.C_DOCTYPE_ID = 0 THEN C_Invoice.C_DOCTYPETARGET_ID ELSE C_Invoice.C_DOCTYPE_ID END
  and C_Tax.C_TAX_ID = C_InvoiceTax.C_TAX_ID