select C_Order.C_ORDER_ID as RECORD_ID, C_Order.DOCUMENTNO, C_Order.DATEORDERED,
       C_BPartner.C_BPARTNER_ID, C_BPartner.ISTAXEXEMPT,
       C_Order.C_PAYMENTTERM_ID, C_Order.C_CURRENCY_ID, C_Order.DOCSTATUS, C_Order.ISSOTRX,
      CASE WHEN C_Order.INVOICERULE = 'D' THEN C_OrderLine.DATEPROMISED ELSE C_Order.DATEORDERED END AS DateRif,
      SUM((C_OrderLine.QTYENTERED - C_OrderLine.QTYINVOICED)* C_OrderLine.PRICEENTERED) AS AMOUNT, C_Order.C_CONVERSIONTYPE_ID, C_Tax.RATE  
 from C_Order, C_OrderLine, C_BPartner, C_Tax
where C_OrderLine.AD_CLIENT_ID = ? -- AD_Client_ID
  and (0=? OR C_OrderLine.AD_ORG_ID = ?) -- AD_Org_ID, AD_Org_ID
  and C_OrderLine.ISACTIVE = 'Y'
  and C_OrderLine.QTYENTERED > C_OrderLine.QTYINVOICED
  and C_Order.C_ORDER_ID = C_OrderLine.C_ORDER_ID
  and C_Order.ISACTIVE = 'Y'
  and C_Order.ISSOTRX = ? -- Parametro IsSOTRX
  and ((?='Y' AND C_Order.DOCSTATUS in ('CO','CL')) OR (?='N' AND C_Order.DOCSTATUS not in ('RE','VO'))) -- IsOnlyCompletedDocs, IsOnlyCompletedDocs
  and CASE WHEN C_Order.INVOICERULE = 'D' THEN C_OrderLine.DATEPROMISED ELSE C_Order.DATEORDERED END BETWEEN ? AND ? -- Data Da per Ordini SO e ACQ, Data A
  and C_BPartner.C_BPARTNER_ID = COALESCE(C_Order.BILL_BPARTNER_ID, C_Order.C_BPARTNER_ID)
  and C_Tax.C_TAX_ID = C_OrderLine.C_TAX_ID
group by C_Order.C_ORDER_ID, C_Order.DOCUMENTNO, C_Order.DATEORDERED, C_BPartner.C_BPARTNER_ID, C_BPartner.ISTAXEXEMPT,
       C_Order.C_PAYMENTTERM_ID, C_Order.C_CURRENCY_ID, C_Order.DOCSTATUS, C_Order.ISSOTRX,
      CASE WHEN C_Order.INVOICERULE = 'D' THEN C_OrderLine.DATEPROMISED ELSE C_Order.DATEORDERED END, C_Order.C_CONVERSIONTYPE_ID, C_Tax.RATE