select C_Invoice.C_INVOICE_ID, C_Invoice.DOCSTATUS, C_Invoice.DOCUMENTNO, C_Invoice.DATEINVOICED,
       C_Invoice.GRANDTOTAL, C_Invoice.C_CURRENCY_ID, C_Invoice.C_BPARTNER_ID, C_Invoice.IsSOTrx,
       COALESCE(F3P_CFInvPaySchedRv.DUEDATE, C_InvoicePaySchedule.DUEDATE, PaymentTermDueDate(C_Invoice.C_PAYMENTTERM_ID, C_Invoice.DATEINVOICED), C_Invoice.DATEINVOICED) AS PAYMENTDATE,
       InvoiceOpen(C_Invoice.C_INVOICE_ID , COALESCE(C_InvoicePaySchedule.C_INVOICEPAYSCHEDULE_ID,0)) AS OpenAMT,
       C_Invoice.C_ConversionType_ID
from (C_Invoice LEFT JOIN C_InvoicePaySchedule ON C_InvoicePaySchedule.C_INVOICE_ID = C_Invoice.C_INVOICE_ID
                                              AND C_InvoicePaySchedule.ISACTIVE = 'Y')
     LEFT JOIN F3P_CFInvPaySchedRv ON F3P_CFInvPaySchedRv.C_INVOICE_ID = C_Invoice.C_INVOICE_ID
                                  AND (F3P_CFInvPaySchedRv.C_INVOICEPAYSCHEDULE_ID = C_InvoicePaySchedule.C_INVOICEPAYSCHEDULE_ID OR
                                         (F3P_CFInvPaySchedRv.C_INVOICEPAYSCHEDULE_ID IS NULL AND
                                          C_InvoicePaySchedule.C_INVOICEPAYSCHEDULE_ID IS NULL))
where C_Invoice.AD_CLIENT_ID = ? --AD_Client_ID
 and (0=? OR C_Invoice.AD_Org_ID = ?) -- AD_Org_ID, AD_Org_ID
 and C_Invoice.ISSOTRX = ? -- IsSOTrx
 and C_Invoice.ISPAID = 'N'
 and C_Invoice.GRANDTOTAL <> 0
 and ((?='Y' AND C_Invoice.DOCSTATUS in ('CO','CL')) OR (?='N' AND C_Invoice.DOCSTATUS not in ('RE','VO'))) -- IsOnlyCompletedDocs, IsOnlyCompletedDocs  
 and InvoiceOpen(C_Invoice.C_INVOICE_ID , COALESCE(C_InvoicePaySchedule.C_INVOICEPAYSCHEDULE_ID,0)) <>0
order by 9