/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import com.f3p.adempiere.util.ModelFactory;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MCharge;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.eevolution.model.X_C_TaxDefinition;

public class MCTaxDefinition
extends X_C_TaxDefinition {
    private static final String TAX_PRODUCT_WHERE = " AND (M_Product_ID = ? OR M_Product_ID IS NULL) AND (M_Product_Category_ID = ? OR M_Product_Category_ID IS NULL) AND (C_TaxCategory_ID = ? OR C_TaxCategory_ID IS NULL)";
    private static final String TAX_CHARGE_WHERE = " AND (C_TaxCategory_ID = ? OR C_TaxCategory_ID IS NULL)";
    private static final long serialVersionUID = 7592303183972899161L;

    public MCTaxDefinition(Properties ctx, int C_TaxDefinition_ID, String trxName) {
        super(ctx, C_TaxDefinition_ID, trxName);
    }

    public MCTaxDefinition(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static int getC_Tax_ID(Properties ctx, Timestamp tsDate, int AD_OrgType_ID, int C_BPartner_ID, int M_Product_ID, int C_Charge_ID, boolean bIsSOTrx, String sTrxName) {
        MBPartner mBPartner = MBPartner.get((Properties)ctx, (int)C_BPartner_ID);
        String sWhereClause = " (AD_OrgType_ID = ? OR AD_OrgType_ID IS NULL) AND (C_TaxGroup_ID = ? OR C_TaxGroup_ID IS NULL) AND (" + DB.TO_DATE((Timestamp)tsDate, (boolean)true) + " >= ValidFrom OR ValidFrom IS NULL)" + " AND (" + DB.TO_DATE((Timestamp)tsDate, (boolean)true) + " >= ValidTo OR ValidTo IS NULL)" + " AND (C_BPartner_ID = ? OR C_BPartner_ID IS NULL)" + " AND (C_BP_Group_ID = ? OR C_BP_Group_ID IS NULL)" + " AND (IsSoTrx = ? OR IsSoTrx IS NULL)";
        LinkedList<Object> lstParams = new LinkedList<Object>();
        lstParams.add(AD_OrgType_ID);
        lstParams.add(mBPartner.getC_TaxGroup_ID());
        lstParams.add(C_BPartner_ID);
        lstParams.add(mBPartner.getC_BP_Group_ID());
        lstParams.add(bIsSOTrx ? "Y" : "N");
        if (M_Product_ID > 0 && C_Charge_ID > 0) {
            throw new AdempiereException("Only one of M_Product_ID and C_Charge_ID can be specified");
        }
        if (M_Product_ID > 0) {
            MProduct mProduct = ModelFactory.getProduct(ctx, M_Product_ID, sTrxName);
            sWhereClause = String.valueOf(sWhereClause) + TAX_PRODUCT_WHERE;
            lstParams.add(M_Product_ID);
            lstParams.add(mProduct.getM_Product_Category_ID());
            lstParams.add(mProduct.getC_TaxCategory_ID());
        } else if (C_Charge_ID > 0) {
            MCharge mCharge = ModelFactory.getCharge(ctx, C_Charge_ID, sTrxName);
            sWhereClause = String.valueOf(sWhereClause) + TAX_CHARGE_WHERE;
            lstParams.add(mCharge.getC_TaxCategory_ID());
        }
        Query qTax = new Query(ctx, "C_TaxDefinition", sWhereClause, sTrxName);
        X_C_TaxDefinition tDef = (X_C_TaxDefinition)qTax.setApplyAccessFilter(true).setOnlyActiveRecords(true).setOrderBy("SeqNo").setParameters(lstParams).first();
        if (tDef != null) {
            return tDef.getC_Tax_ID();
        }
        return -1;
    }
}

