/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.File;
import java.io.FileWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MCurrency;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaySelectionLine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.PaymentExport;

public class GenericPaymentExport
implements PaymentExport {
    private static CLogger s_log = CLogger.getCLogger(GenericPaymentExport.class);
    private static final int BP_VALUE = 0;
    private static final int BP_NAME = 1;
    private static final int BP_CONTACT = 2;
    private static final int BP_ADDR1 = 3;
    private static final int BP_ADDR2 = 4;
    private static final int BP_CITY = 5;
    private static final int BP_REGION = 6;
    private static final int BP_POSTAL = 7;
    private static final int BP_COUNTRY = 8;
    private static final int BP_REFNO = 9;

    @Override
    public int exportToFile(MPaySelectionCheck[] checks, File file, StringBuffer err) {
        if (checks == null || checks.length == 0) {
            return 0;
        }
        if (file.isDirectory()) {
            err.append("No se puede escribir, el archivo seleccionado es un directorio - " + file.getAbsolutePath());
            s_log.log(Level.SEVERE, err.toString());
            return -1;
        }
        try {
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            s_log.log(Level.WARNING, "Could not delete - " + file.getAbsolutePath(), (Throwable)e);
        }
        char x = '\"';
        int noLines = 0;
        StringBuffer line = null;
        try {
            FileWriter fw = new FileWriter(file);
            line = new StringBuffer();
            line.append(x).append("Value").append(x).append(",").append(x).append("Name").append(x).append(",").append(x).append("Contact").append(x).append(",").append(x).append("Addr1").append(x).append(",").append(x).append("Addr2").append(x).append(",").append(x).append("City").append(x).append(",").append(x).append("State").append(x).append(",").append(x).append("ZIP").append(x).append(",").append(x).append("Country").append(x).append(",").append(x).append("ReferenceNo").append(x).append(",").append(x).append("DocumentNo").append(x).append(",").append(x).append("PayDate").append(x).append(",").append(x).append("Currency").append(x).append(",").append(x).append("PayAmount").append(x).append(",").append(x).append("Comment").append(x).append(Env.NL);
            fw.write(line.toString());
            ++noLines;
            int i = 0;
            while (i < checks.length) {
                MPaySelectionCheck mpp = checks[i];
                if (mpp != null) {
                    String[] bp = GenericPaymentExport.getBPartnerInfo(mpp.getC_BPartner_ID());
                    StringBuffer comment = new StringBuffer();
                    MPaySelectionLine[] psls = mpp.getPaySelectionLines(false);
                    int l = 0;
                    while (l < psls.length) {
                        if (l > 0) {
                            comment.append(", ");
                        }
                        comment.append(psls[l].getInvoice().getDocumentNo());
                        ++l;
                    }
                    line = new StringBuffer();
                    line.append(x).append(bp[0]).append(x).append(",").append(x).append(bp[1]).append(x).append(",").append(x).append(bp[2]).append(x).append(",").append(x).append(bp[3]).append(x).append(",").append(x).append(bp[4]).append(x).append(",").append(x).append(bp[5]).append(x).append(",").append(x).append(bp[6]).append(x).append(",").append(x).append(bp[7]).append(x).append(",").append(x).append(bp[8]).append(x).append(",").append(x).append(bp[9]).append(x).append(",").append(x).append(mpp.getDocumentNo()).append(x).append(",").append(mpp.getParent().getPayDate()).append(",").append(x).append(MCurrency.getISO_Code((Properties)Env.getCtx(), (int)mpp.getParent().getC_Currency_ID())).append(x).append(",").append(mpp.getPayAmt()).append(",").append(x).append(comment.toString()).append(x).append(Env.NL);
                    fw.write(line.toString());
                    ++noLines;
                }
                ++i;
            }
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            err.append(e.toString());
            s_log.log(Level.SEVERE, "", (Throwable)e);
            return -1;
        }
        return noLines;
    }

    private static String[] getBPartnerInfo(int C_BPartner_ID) {
        String[] bp = new String[10];
        String sql = "SELECT bp.Value, bp.Name, c.Name AS Contact, a.Address1, a.Address2, a.City, r.Name AS Region, a.Postal, cc.Name AS Country, bp.ReferenceNo FROM C_BPartner bp, AD_User c, C_BPartner_Location l, C_Location a, C_Region r, C_Country cc WHERE bp.C_BPartner_ID=? AND bp.C_BPartner_ID=c.C_BPartner_ID(+) AND bp.C_BPartner_ID=l.C_BPartner_ID AND l.C_Location_ID=a.C_Location_ID AND a.C_Region_ID=r.C_Region_ID(+) AND a.C_Country_ID=cc.C_Country_ID ORDER BY l.IsBillTo DESC";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                bp[0] = rs.getString(1);
                if (bp[0] == null) {
                    bp[0] = "";
                }
                bp[1] = rs.getString(2);
                if (bp[1] == null) {
                    bp[1] = "";
                }
                bp[2] = rs.getString(3);
                if (bp[2] == null) {
                    bp[2] = "";
                }
                bp[3] = rs.getString(4);
                if (bp[3] == null) {
                    bp[3] = "";
                }
                bp[4] = rs.getString(5);
                if (bp[4] == null) {
                    bp[4] = "";
                }
                bp[5] = rs.getString(6);
                if (bp[5] == null) {
                    bp[5] = "";
                }
                bp[6] = rs.getString(7);
                if (bp[6] == null) {
                    bp[6] = "";
                }
                bp[7] = rs.getString(8);
                if (bp[7] == null) {
                    bp[7] = "";
                }
                bp[8] = rs.getString(9);
                if (bp[8] == null) {
                    bp[8] = "";
                }
                bp[9] = rs.getString(10);
                if (bp[9] == null) {
                    bp[9] = "";
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        return bp;
    }
}

