/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.compiere.Adempiere;
import org.compiere.db.CConnection;
import org.compiere.model.MClient;
import org.compiere.util.CLogConsole;
import org.compiere.util.CLogErrorBuffer;
import org.compiere.util.CLogFile;
import org.compiere.util.CLogFilter;
import org.compiere.util.CLogFormatter;
import org.compiere.util.CLogMgtLog4J;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.ZipUtil;

public class CLogMgt {
    private static ArrayList<Handler> s_handlers = null;
    private static Level s_currentLevel = Level.INFO;
    private static Logger log = Logger.getAnonymousLogger();
    public static final Level[] LEVELS = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL};
    private static final String NL = System.getProperty("line.separator");

    public static void initialize(boolean isClient) {
        CLogFile fh;
        block12: {
            if (s_handlers != null) {
                return;
            }
            if (isClient) {
                LogManager mgr = LogManager.getLogManager();
                try {
                    String fileName = "logClient.properties";
                    InputStream in = CLogMgt.class.getResourceAsStream(fileName);
                    BufferedInputStream bin = new BufferedInputStream(in);
                    mgr.readConfiguration(bin);
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            s_handlers = new ArrayList();
            try {
                Logger rootLogger = Logger.getLogger("");
                Handler[] handlers = rootLogger.getHandlers();
                int i = 0;
                while (i < handlers.length) {
                    if (!s_handlers.contains(handlers[i])) {
                        s_handlers.add(handlers[i]);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                if (e instanceof ClassNotFoundException) break block12;
                System.err.println(e.toString());
            }
        }
        if (CLogErrorBuffer.get((boolean)false) == null) {
            CLogMgt.addHandler((Handler)CLogErrorBuffer.get((boolean)true));
        }
        if (CLogConsole.get((boolean)false) == null) {
            CLogMgt.addHandler((Handler)CLogConsole.get((boolean)true));
        }
        if ((fh = CLogFile.get((boolean)false, null, (boolean)isClient)) == null && !isClient) {
            fh = CLogFile.get((boolean)true, null, (boolean)isClient);
            CLogMgt.addHandler((Handler)fh);
        }
        if (fh != null && !isClient) {
            System.out.println(fh);
        }
        CLogMgt.setFormatter((Formatter)CLogFormatter.get());
        CLogMgt.setFilter((Filter)CLogFilter.get());
        CLogMgtLog4J.initialize(isClient);
    }

    protected static Handler[] getHandlers() {
        Handler[] handlers = new Handler[s_handlers.size()];
        int i = 0;
        while (i < s_handlers.size()) {
            handlers[i] = s_handlers.get(i);
            ++i;
        }
        return handlers;
    }

    public static void addHandler(Handler handler) {
        if (handler == null) {
            return;
        }
        Logger rootLogger = Logger.getLogger("");
        rootLogger.addHandler(handler);
        s_handlers.add(handler);
        log.log(Level.CONFIG, "Handler=" + handler);
    }

    protected static void setFormatter(Formatter formatter) {
        int i = 0;
        while (i < s_handlers.size()) {
            Handler handler = s_handlers.get(i);
            handler.setFormatter(formatter);
            ++i;
        }
        log.log(Level.CONFIG, "Formatter=" + formatter);
    }

    protected static void setFilter(Filter filter) {
        int i = 0;
        while (i < s_handlers.size()) {
            Handler handler = s_handlers.get(i);
            handler.setFilter(filter);
            ++i;
        }
        log.log(Level.CONFIG, "Filter=" + filter);
    }

    public static void setLoggerLevel(Level level, String loggerNamePart) {
        if (level == null) {
            return;
        }
        LogManager mgr = LogManager.getLogManager();
        Enumeration<String> en = mgr.getLoggerNames();
        while (en.hasMoreElements()) {
            String name = en.nextElement().toString();
            if (loggerNamePart != null && name.indexOf(loggerNamePart) == -1) continue;
            Logger lll = Logger.getLogger(name);
            lll.setLevel(level);
        }
    }

    public static void setLevel(Level level) {
        if (level == null) {
            return;
        }
        if (s_handlers == null) {
            CLogMgt.initialize(true);
        }
        int i = 0;
        while (i < s_handlers.size()) {
            Handler handler = s_handlers.get(i);
            handler.setLevel(level);
            ++i;
        }
        CLogMgt.setJDBCDebug(s_currentLevel.intValue() == Level.ALL.intValue());
        if (level.intValue() != s_currentLevel.intValue()) {
            CLogMgt.setLoggerLevel(level, null);
            log.config(level.toString());
        }
        s_currentLevel = level;
    }

    public static void setLevel(int intLevel) {
        CLogMgt.setLevel(String.valueOf(intLevel));
    }

    public static void setLevel(String levelString) {
        if (levelString == null) {
            return;
        }
        int i = 0;
        while (i < LEVELS.length) {
            if (LEVELS[i].getName().equals(levelString)) {
                CLogMgt.setLevel(LEVELS[i]);
                return;
            }
            ++i;
        }
        log.log(Level.CONFIG, "Ignored: " + levelString);
    }

    public static void setJDBCDebug(boolean enable) {
        if (enable) {
            DriverManager.setLogWriter(new PrintWriter(System.err));
        } else {
            DriverManager.setLogWriter(null);
        }
    }

    public static Level getLevel() {
        return s_currentLevel;
    }

    public static int getLevelAsInt() {
        return s_currentLevel.intValue();
    }

    public static boolean isLevel(Level level) {
        if (level == null) {
            return false;
        }
        return level.intValue() >= s_currentLevel.intValue();
    }

    public static boolean isLevelAll() {
        return Level.ALL.intValue() == s_currentLevel.intValue();
    }

    public static boolean isLevelFinest() {
        return Level.FINEST.intValue() >= s_currentLevel.intValue();
    }

    public static boolean isLevelFiner() {
        return Level.FINER.intValue() >= s_currentLevel.intValue();
    }

    public static boolean isLevelFine() {
        return Level.FINE.intValue() >= s_currentLevel.intValue();
    }

    public static boolean isLevelInfo() {
        return Level.INFO.intValue() >= s_currentLevel.intValue();
    }

    public static void enable(boolean enableLogging) {
        if (enableLogging) {
            CLogMgt.setLevel(s_currentLevel);
        } else {
            Level level = s_currentLevel;
            CLogMgt.setLevel(Level.OFF);
            s_currentLevel = level;
        }
    }

    public static void shutdown() {
        LogManager mgr = LogManager.getLogManager();
        mgr.reset();
    }

    public static void printProperties(Properties p, String description, boolean logIt) {
        if (p == null) {
            return;
        }
        if (logIt) {
            log.info(String.valueOf(description) + " - Size=" + p.size() + ", Hash=" + p.hashCode() + "\n" + CLogMgt.getLocalHost());
        } else {
            System.out.println("Log.printProperties = " + description + ", Size=" + p.size() + ", Hash=" + p.hashCode() + "\n" + CLogMgt.getLocalHost());
        }
        Object[] pp = p.keySet().toArray();
        Arrays.sort(pp);
        int i = 0;
        while (i < pp.length) {
            String key = pp[i].toString();
            String value = p.getProperty(key);
            if (logIt) {
                log.config(String.valueOf(key) + "=" + value);
            } else {
                System.out.println("  " + key + " = " + value);
            }
            ++i;
        }
    }

    public static StringBuffer getInfo(StringBuffer sb) {
        Attributes atts;
        if (sb == null) {
            sb = new StringBuffer();
        }
        String eq = " = ";
        sb.append(CLogMgt.getMsg("Host")).append(" = ").append(CLogMgt.getServerInfo()).append(NL);
        sb.append(CLogMgt.getMsg("Database")).append(" = ").append(CLogMgt.getDatabaseInfo()).append(NL);
        sb.append(CLogMgt.getMsg("Schema")).append(" = ").append(CConnection.get().getDbUid()).append(NL);
        sb.append(CLogMgt.getMsg("AD_User_ID")).append(" = ").append(Env.getContext(Env.getCtx(), "#AD_User_Name")).append(NL);
        sb.append(CLogMgt.getMsg("AD_Role_ID")).append(" = ").append(Env.getContext(Env.getCtx(), "#AD_Role_Name")).append(NL);
        sb.append(CLogMgt.getMsg("AD_Client_ID")).append(" = ").append(Env.getContext(Env.getCtx(), "#AD_Client_Name")).append(NL);
        sb.append(CLogMgt.getMsg("AD_Org_ID")).append(" = ").append(Env.getContext(Env.getCtx(), "#AD_Org_Name")).append(NL);
        sb.append(CLogMgt.getMsg("Date")).append(" = ").append(Env.getContext(Env.getCtx(), "#Date")).append(NL);
        sb.append(CLogMgt.getMsg("Printer")).append(" = ").append(Env.getContext(Env.getCtx(), "#Printer")).append(NL);
        Manifest mf = ZipUtil.getManifest((String)"CClient.jar");
        if (mf == null) {
            mf = ZipUtil.getManifest((String)"CTools.jar");
        }
        if (mf != null && (atts = mf.getMainAttributes()) != null) {
            for (Object key : atts.keySet()) {
                if (!key.toString().startsWith("Impl") && !key.toString().startsWith("Spec")) continue;
                sb.append(key).append(" = ").append(atts.get(key)).append(NL);
            }
        }
        sb.append(CLogMgt.getMsg("ImplementationVendor")).append(" = ").append(Adempiere.getImplementationVendor()).append(NL);
        sb.append(CLogMgt.getMsg("ImplementationVersion")).append(" = ").append(Adempiere.getImplementationVersion()).append(NL);
        sb.append("AdempiereHome = ").append(Adempiere.getAdempiereHome()).append(NL);
        sb.append("AdempiereProperties = ").append(Ini.getPropertyFileName()).append(NL);
        int x = 0;
        while (x < s_handlers.size()) {
            if (s_handlers.get(x).getClass() == CLogFile.class) {
                CLogFile clf = (CLogFile)s_handlers.get(x);
                sb.append("LogFile: ").append(clf.getFileName()).append(NL);
            }
            ++x;
        }
        sb.append(Env.getLanguage(Env.getCtx())).append(NL);
        MClient client = MClient.get((Properties)Env.getCtx());
        sb.append(client).append(NL);
        sb.append(CLogMgt.getMsg("IsMultiLingualDocument")).append(" = ").append(client.isMultiLingualDocument()).append(NL);
        sb.append("BaseLanguage = ").append(Env.isBaseLanguage(Env.getCtx(), "AD_Window")).append("/").append(Env.isBaseLanguage(Env.getCtx(), "C_UOM")).append(NL);
        sb.append(Adempiere.getJavaInfo()).append(NL);
        sb.append("java.io.tmpdir=" + System.getProperty("java.io.tmpdir"));
        sb.append(Adempiere.getOSInfo());
        return sb;
    }

    public static StringBuffer getInfoDetail(StringBuffer sb, Properties ctx) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        if (ctx == null) {
            ctx = Env.getCtx();
        }
        CConnection cc = CConnection.get();
        sb.append(NL).append("=== Environment === ").append(Adempiere.getCheckSum()).append(NL).append(Adempiere.getSummaryAscii()).append(NL).append(CLogMgt.getLocalHost()).append(NL).append(String.valueOf(cc.getName()) + " " + cc.getDbUid() + "@" + cc.getConnectionURL()).append(NL).append(cc.getInfo()).append(NL);
        sb.append(NL).append("=== Context ===").append(NL);
        Object[] context = Env.getEntireContext(ctx);
        Arrays.sort(context);
        int i = 0;
        while (i < context.length) {
            sb.append((String)context[i]).append(NL);
            ++i;
        }
        sb.append(NL).append("=== System ===").append(NL);
        Object[] pp = System.getProperties().keySet().toArray();
        Arrays.sort(pp);
        int i2 = 0;
        while (i2 < pp.length) {
            String key = pp[i2].toString();
            String value = System.getProperty(key);
            sb.append(key).append("=").append(value).append(NL);
            ++i2;
        }
        return sb;
    }

    private static String getMsg(String msg) {
        if (DB.isConnected()) {
            return Msg.translate((Properties)Env.getCtx(), (String)msg);
        }
        return msg;
    }

    private static String getServerInfo() {
        StringBuffer sb = new StringBuffer();
        CConnection cc = CConnection.get();
        sb.append(cc.getAppsHost()).append(" : ").append(cc.getAppsPort()).append(" (");
        if (cc.isAppsServerOK(false)) {
            sb.append(CConnection.get().getServerVersion());
        } else {
            sb.append(CLogMgt.getMsg("NotActive"));
        }
        sb.append(")\n  ");
        return sb.toString();
    }

    private static String getDatabaseInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append(CConnection.get().getDbHost()).append(" : ").append(CConnection.get().getDbPort()).append(" / ").append(CConnection.get().getDbName());
        if (CConnection.get().isViaFirewall()) {
            sb.append(CLogMgt.getMsg("via")).append(" ").append(CConnection.get().getFwHost()).append(" : ").append(CConnection.get().getFwPort());
        }
        return sb.toString();
    }

    private static String getLocalHost() {
        try {
            InetAddress id = InetAddress.getLocalHost();
            return id.toString();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "getLocalHost", e);
            return "-no local host info -";
        }
    }

    public CLogMgt() {
        this.testLog();
    }

    private void testLog() {
        final CLogger log1 = CLogger.getCLogger((String)"test");
        log1.log(Level.SEVERE, "severe");
        log1.warning("warning");
        log1.info("Info");
        log1.config("config");
        log1.fine("fine");
        log1.finer("finer");
        log1.entering("myClass", "myMethod", (Object)"parameter");
        log1.exiting("myClass", "myMethod", (Object)"result");
        log1.finest("finest");
        new Thread(){

            @Override
            public void run() {
                log1.info("thread info");
            }
        }.start();
        try {
            Integer.parseInt("ABC");
        }
        catch (Exception e) {
            log1.log(Level.SEVERE, "error message", (Throwable)e);
        }
        log1.log(Level.INFO, "info message 1", (Object)"1Param");
        log1.log(Level.INFO, "info message n", new Object[]{"1Param", "2Param"});
    }

    public static void main(String[] args) {
        CLogMgt.initialize(true);
        new CLogMgt();
    }
}

