/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.io.File;
import java.sql.Connection;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import org.compiere.process.ProcessInfo;
import org.compiere.report.ReportStarter;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Trx;

public class JasperUtil {
    public static final String REPORT_PATH_KEY = "org.compiere.report.path";
    public static final String TEMP_LOCATION_PROP = "com.f3p.resource.tmp";

    public static JasperPrint prepareReport(File fileReport, ProcessInfo pi, Connection con, boolean bSetPathProperty) throws JRException {
        ReportStarter.JasperData data = ReportStarter.processReport(fileReport);
        if (con == null) {
            con = DB.getConnectionRW();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        ReportStarter.addProcessParameters(pi.getAD_PInstance_ID(), params, pi.getTransactionName());
        ReportStarter.addProcessInfoParameters(params, pi.getParameter());
        if (pi.getRecord_ID() > 0) {
            params.put("RECORD_ID", new Integer(pi.getRecord_ID()));
        }
        params.put("AD_PINSTANCE_ID", new Integer(pi.getAD_PInstance_ID()));
        Language currLang = Env.getLanguage(Env.getCtx());
        params.put("CURRENT_LANG", currLang.getAD_Language());
        if (bSetPathProperty) {
            String sPath = System.getProperty(TEMP_LOCATION_PROP, System.getProperty("java.io.tmpdir"));
            File fResourceTempPath = new File(sPath);
            System.setProperty(REPORT_PATH_KEY, fResourceTempPath.getAbsolutePath() + "/");
        }
        return JasperFillManager.fillReport((JasperReport)data.getJasperReport(), params, (Connection)con);
    }

    public static JasperPrint prepareReport(File fileReport, ProcessInfo pi, boolean bSetPathProperty, String sTrxName) throws JRException {
        Trx trx = Trx.get((String)sTrxName, (boolean)false);
        Connection con = trx.getConnection();
        return JasperUtil.prepareReport(fileReport, pi, con, bSetPathProperty);
    }
}

