/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MPInstance;
import org.compiere.model.PO;
import org.compiere.process.ProcessCall;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public abstract class SvrProcess
implements ProcessCall {
    private Properties m_ctx;
    private ProcessInfo m_pi;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private boolean m_locked = false;
    private PO m_lockedObject = null;
    private Trx m_trx;
    protected static String MSG_SaveErrorRowNotFound = "@SaveErrorRowNotFound@";
    protected static String MSG_InvalidArguments = "@InvalidArguments@";

    public final boolean startProcess(Properties ctx, ProcessInfo pi, Trx trx) {
        boolean localTrx;
        this.m_ctx = ctx == null ? Env.getCtx() : ctx;
        this.m_pi = pi;
        this.m_trx = trx;
        boolean bl = localTrx = this.m_trx == null;
        if (localTrx) {
            this.m_trx = Trx.get((String)Trx.createTrxName((String)"SvrProcess"), (boolean)true);
        }
        this.lock();
        boolean success = this.process();
        if (localTrx) {
            if (success) {
                try {
                    this.m_trx.commit(true);
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "Commit failed.", (Throwable)e);
                    this.m_pi.addSummary("Commit Failed.");
                    this.m_pi.setError(true);
                }
            } else {
                this.m_trx.rollback();
            }
            this.m_trx.close();
            this.m_trx = null;
        }
        this.unlock();
        this.postProcess(!this.m_pi.isError());
        return !this.m_pi.isError();
    }

    private boolean process() {
        String msg = null;
        boolean success = true;
        try {
            this.prepare();
            msg = this.doIt();
        }
        catch (Throwable e) {
            msg = e.getLocalizedMessage();
            if (msg == null) {
                msg = e.toString();
            }
            if (e.getCause() != null) {
                this.log.log(Level.SEVERE, msg, e.getCause());
            } else {
                this.log.log(Level.SEVERE, msg, e);
            }
            success = false;
        }
        if ("@Error@".equals(msg)) {
            success = false;
        }
        msg = Msg.parseTranslation((Properties)this.m_ctx, (String)msg);
        this.m_pi.setSummary(msg, !success);
        return success;
    }

    protected abstract void prepare();

    protected abstract String doIt() throws Exception;

    protected void postProcess(boolean success) {
    }

    protected void commit() {
        if (this.m_trx != null) {
            this.m_trx.commit();
        }
    }

    protected void commitEx() throws SQLException {
        if (this.m_trx != null) {
            this.m_trx.commit(true);
        }
    }

    protected void rollback() {
        if (this.m_trx != null) {
            this.m_trx.rollback();
        }
    }

    protected boolean lockObject(PO po) {
        if (this.m_locked || this.m_lockedObject != null) {
            this.unlockObject();
        }
        if (po == null) {
            return false;
        }
        this.m_lockedObject = po;
        this.m_locked = this.m_lockedObject.lock();
        return this.m_locked;
    }

    protected boolean isLocked() {
        return this.m_locked;
    }

    protected boolean unlockObject() {
        boolean success = true;
        if (this.m_locked || this.m_lockedObject != null) {
            success = this.m_lockedObject.unlock(null);
        }
        this.m_locked = false;
        this.m_lockedObject = null;
        return success;
    }

    public ProcessInfo getProcessInfo() {
        return this.m_pi;
    }

    public Properties getCtx() {
        return this.m_ctx;
    }

    protected String getName() {
        return this.m_pi.getTitle();
    }

    protected int getAD_PInstance_ID() {
        return this.m_pi.getAD_PInstance_ID();
    }

    protected int getTable_ID() {
        return this.m_pi.getTable_ID();
    }

    protected int getRecord_ID() {
        return this.m_pi.getRecord_ID();
    }

    protected int getAD_User_ID() {
        block8: {
            if (this.m_pi.getAD_User_ID() == null || this.m_pi.getAD_Client_ID() == null) {
                String sql = "SELECT AD_User_ID, AD_Client_ID FROM AD_PInstance WHERE AD_PInstance_ID=?";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                        pstmt.setInt(1, this.m_pi.getAD_PInstance_ID());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            this.m_pi.setAD_User_ID(rs.getInt(1));
                            this.m_pi.setAD_Client_ID(rs.getInt(2));
                        }
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, sql, (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                Object var2_2 = null;
            }
        }
        if (this.m_pi.getAD_User_ID() == null) {
            return -1;
        }
        return this.m_pi.getAD_User_ID();
    }

    protected int getAD_Client_ID() {
        if (this.m_pi.getAD_Client_ID() == null) {
            this.getAD_User_ID();
            if (this.m_pi.getAD_Client_ID() == null) {
                return 0;
            }
        }
        return this.m_pi.getAD_Client_ID();
    }

    protected ProcessInfoParameter[] getParameter() {
        ProcessInfoParameter[] retValue = this.m_pi.getParameter();
        if (retValue == null) {
            ProcessInfoUtil.setParameterFromDB((ProcessInfo)this.m_pi);
            retValue = this.m_pi.getParameter();
        }
        return retValue;
    }

    public void addLog(int id, Timestamp date, BigDecimal number, String msg) {
        if (this.m_pi != null) {
            this.m_pi.addLog(id, date, number, msg);
        }
        this.log.info(String.valueOf(id) + " - " + date + " - " + number + " - " + msg);
    }

    public void addLog(String msg) {
        if (msg != null) {
            this.addLog(0, null, null, msg);
        }
    }

    public Object doIt(String className, String methodName, Object[] args) {
        try {
            Class<?> clazz = Class.forName(className);
            Object object = clazz.newInstance();
            Method[] methods = clazz.getMethods();
            int i = 0;
            while (i < methods.length) {
                if (methods[i].getName().equals(methodName)) {
                    return methods[i].invoke(object, args);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "doIt", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        return null;
    }

    private void lock() {
        this.log.fine("AD_PInstance_ID=" + this.m_pi.getAD_PInstance_ID());
        try {
            DB.executeUpdate((String)("UPDATE AD_PInstance SET IsProcessing='Y' WHERE AD_PInstance_ID=" + this.m_pi.getAD_PInstance_ID()), null);
        }
        catch (Exception e) {
            this.log.severe("lock() - " + e.getLocalizedMessage());
        }
    }

    private void unlock() {
        try {
            MPInstance mpi = new MPInstance(this.getCtx(), this.m_pi.getAD_PInstance_ID(), null);
            if (mpi.get_ID() == 0) {
                this.log.log(Level.SEVERE, "Did not find PInstance " + this.m_pi.getAD_PInstance_ID());
                return;
            }
            mpi.setIsProcessing(false);
            mpi.setResult(!this.m_pi.isError());
            mpi.setErrorMsg(this.m_pi.getSummary());
            mpi.save();
            this.log.fine(mpi.toString());
            ProcessInfoUtil.saveLogToDB((ProcessInfo)this.m_pi);
        }
        catch (Exception e) {
            this.log.severe("unlock() - " + e.getLocalizedMessage());
        }
    }

    public String get_TrxName() {
        if (this.m_trx != null) {
            return this.m_trx.getTrxName();
        }
        return null;
    }

    public void changeProcessInfo(ProcessInfo pi, Properties ctx) {
        if (pi != null) {
            this.m_pi = pi;
        }
        if (ctx != null) {
            this.m_ctx = ctx;
        }
    }

    public void setTrx(Trx trx) {
        this.m_trx = trx;
    }
}

