/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import org.compiere.model.MAttachment;
import org.compiere.model.MRequest;
import org.compiere.model.MUser;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogMgt;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.EMailAuthenticator;

public class RequestEMailProcessor
extends SvrProcess {
    private String p_IMAPHost = null;
    private String p_IMAPUser = null;
    private String p_IMAPPwd = null;
    private String p_RequestFolder = null;
    private String p_InboxFolder = null;
    private String p_ErrorFolder = null;
    private int C_BPartner_ID = 0;
    private int AD_User_ID = 0;
    private int AD_Role_ID = 0;
    private int SalesRep_ID = 0;
    private int R_RequestType_ID = 0;
    private String p_DefaultPriority = null;
    private String p_DefaultConfidentiality = null;
    private int noProcessed = 0;
    private int noRequest = 0;
    private int noError = 0;
    private Session m_session = null;
    private Store m_store = null;
    private static final int ERROR = 0;
    private static final int REQUEST = 1;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("p_IMAPHost")) {
                    this.p_IMAPHost = (String)para[i].getParameter();
                } else if (name.equals("p_IMAPUser")) {
                    this.p_IMAPUser = (String)para[i].getParameter();
                } else if (name.equals("p_IMAPPwd")) {
                    this.p_IMAPPwd = (String)para[i].getParameter();
                } else if (name.equals("p_RequestFolder")) {
                    this.p_RequestFolder = (String)para[i].getParameter();
                } else if (name.equals("p_InboxFolder")) {
                    this.p_InboxFolder = (String)para[i].getParameter();
                } else if (name.equals("p_ErrorFolder")) {
                    this.p_ErrorFolder = (String)para[i].getParameter();
                } else if (name.equals("C_BPartner_ID")) {
                    this.C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("AD_User_ID")) {
                    this.AD_User_ID = para[i].getParameterAsInt();
                } else if (name.equals("AD_Role_ID")) {
                    this.AD_Role_ID = para[i].getParameterAsInt();
                } else if (name.equals("SalesRep_ID")) {
                    this.SalesRep_ID = para[i].getParameterAsInt();
                } else if (name.equals("R_RequestType_ID")) {
                    this.R_RequestType_ID = para[i].getParameterAsInt();
                } else if (name.equals("p_DefaultPriority")) {
                    this.p_DefaultPriority = (String)para[i].getParameter();
                } else if (name.equals("p_DefaultConfidentiality")) {
                    this.p_DefaultConfidentiality = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("doIt - IMAPHost=" + this.p_IMAPHost + " IMAPUser=" + this.p_IMAPUser + " RequestFolder=" + this.p_RequestFolder + " InboxFolder=" + this.p_InboxFolder + " ErrorFolder=" + this.p_ErrorFolder);
        try {
            this.getSession();
            this.getStore();
            this.processInBox();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "processInBox", (Throwable)e);
        }
        try {
            if (this.m_store.isConnected()) {
                this.m_store.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "processInBox - Total=" + this.noProcessed + " - Requests=" + this.noRequest + " - Errors=" + this.noError;
    }

    private Session getSession() throws Exception {
        if (this.m_session != null) {
            return this.m_session;
        }
        Properties props = System.getProperties();
        props.put("mail.store.protocol", "smtp");
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.host", this.p_IMAPHost);
        props.put("mail.smtp.auth", "true");
        EMailAuthenticator auth = new EMailAuthenticator(this.p_IMAPUser, this.p_IMAPPwd);
        this.m_session = Session.getDefaultInstance((Properties)props, (Authenticator)auth);
        this.m_session.setDebug(CLogMgt.isLevelFinest());
        this.log.fine("getSession - " + this.m_session);
        return this.m_session;
    }

    private Store getStore() throws Exception {
        if (this.m_store != null) {
            return this.m_store;
        }
        if (this.getSession() == null) {
            throw new IllegalStateException("No Session");
        }
        this.m_store = this.m_session.getStore("imap");
        this.m_store.connect();
        this.log.fine("getStore - " + this.m_store);
        return this.m_store;
    }

    private void processInBox() throws Exception {
        Folder folder = this.m_store.getDefaultFolder();
        if (folder == null) {
            throw new IllegalStateException("No default folder");
        }
        Folder inbox = folder.getFolder(this.p_InboxFolder);
        if (!inbox.exists()) {
            throw new IllegalStateException("No Inbox");
        }
        inbox.open(2);
        this.log.fine("processInBox - " + inbox.getName() + "; Messages Total=" + inbox.getMessageCount() + "; New=" + inbox.getNewMessageCount());
        Folder requestFolder = folder.getFolder(this.p_RequestFolder);
        if (!requestFolder.exists() && !requestFolder.create(1)) {
            throw new IllegalStateException("Cannot create Request Folder");
        }
        requestFolder.open(2);
        Folder errorFolder = folder.getFolder(this.p_ErrorFolder);
        if (!errorFolder.exists() && !errorFolder.create(1)) {
            throw new IllegalStateException("Cannot create Error Folder");
        }
        errorFolder.open(2);
        Message[] messages = inbox.getMessages();
        int i = 0;
        while (i < messages.length) {
            String[] hdrs;
            Message msg = messages[i];
            int result = this.processMessage(msg);
            if (result == 1) {
                hdrs = msg.getHeader("Message-ID");
                try {
                    if (this.createRequest(msg)) {
                        msg.setFlag(Flags.Flag.SEEN, true);
                        msg.setFlag(Flags.Flag.ANSWERED, true);
                        requestFolder.appendMessages(new Message[]{msg});
                        this.log.info("message " + hdrs[0] + " moved to " + this.p_RequestFolder + " folder");
                        this.log.info("message info: Sent -> " + msg.getSentDate() + " From -> " + msg.getFrom()[0].toString());
                        msg.setFlag(Flags.Flag.DELETED, true);
                        Message[] deleted = inbox.expunge();
                        ++this.noRequest;
                    }
                }
                catch (Exception e) {
                    this.log.info("message " + hdrs[0] + " threw error");
                    e.printStackTrace();
                }
            } else {
                errorFolder.appendMessages(new Message[]{msg});
                hdrs = msg.getHeader("Message-ID");
                this.log.warning("message " + hdrs[0] + " moved to " + this.p_ErrorFolder + " folder");
                this.log.warning("message info: Sent -> " + msg.getSentDate() + " From -> " + msg.getFrom()[0].toString());
                ++this.noError;
            }
            ++this.noProcessed;
            ++i;
        }
        this.log.info("processInBox - Total=" + this.noProcessed + " - Requests=" + this.noRequest + " - Errors=" + this.noError);
        errorFolder.close(false);
        requestFolder.close(false);
        inbox.close(true);
    }

    private boolean createRequest(Message msg) throws MessagingException, SQLException {
        MUser us;
        String fromAddress;
        Address[] from = msg.getFrom();
        if (from[0].toString().indexOf(60) != -1 && from[0].toString().indexOf(62) != -1) {
            fromAddress = from[0].toString().substring(from[0].toString().indexOf(60) + 1, from[0].toString().indexOf(62));
            this.log.info("fromAddress stripped: " + fromAddress);
        } else {
            fromAddress = from[0].toString();
        }
        String sMessageID = msg.getHeader("Message-ID")[0];
        if (sMessageID.length() > 30) {
            sMessageID = sMessageID.substring(0, 30);
        }
        int retValuedup = 0;
        String sqldup = "select r_request_id from r_request where ad_client_id = ? and documentno = ? and startdate = ?";
        CPreparedStatement pstmtdup = null;
        pstmtdup = DB.prepareStatement((String)sqldup, null);
        pstmtdup.setInt(1, this.getAD_Client_ID());
        pstmtdup.setString(2, sMessageID);
        pstmtdup.setTimestamp(3, new Timestamp(msg.getSentDate().getTime()));
        ResultSet rsdup = pstmtdup.executeQuery();
        if (rsdup.next()) {
            retValuedup = rsdup.getInt(1);
        }
        rsdup.close();
        pstmtdup.close();
        pstmtdup = null;
        if (retValuedup > 0) {
            this.log.info("request already existed for msg -> " + sMessageID);
            return true;
        }
        int request_upd = 0;
        String sqlupd = "SELECT r_request_id   FROM r_request  WHERE ad_client_id = ?    AND summary LIKE 'FROM: ' || ? || '%'    AND (   documentno =               SUBSTR                  (?,                   INSTR                       (?,                        '<'                       )                  )         OR (    ? LIKE 'Re: %'             AND summary =                       'FROM: '                    || ?                    || CHR (10)                    || SUBSTR (?, 5)            )        ) ";
        CPreparedStatement pstmtupd = null;
        pstmtupd = DB.prepareStatement((String)sqlupd, null);
        pstmtupd.setInt(1, this.getAD_Client_ID());
        pstmtupd.setString(2, fromAddress);
        pstmtupd.setString(3, msg.getSubject());
        pstmtupd.setString(4, msg.getSubject());
        pstmtupd.setString(5, msg.getSubject());
        pstmtupd.setString(6, fromAddress);
        pstmtupd.setString(7, msg.getSubject());
        ResultSet rsupd = pstmtupd.executeQuery();
        if (rsupd.next()) {
            request_upd = rsupd.getInt(1);
        }
        rsupd.close();
        pstmtupd.close();
        pstmtupd = null;
        if (request_upd > 0) {
            this.log.info("msg -> " + sMessageID + " is an answer for req " + request_upd);
            return this.updateRequest(request_upd, msg);
        }
        MRequest req = new MRequest(this.getCtx(), 0, this.get_TrxName());
        req.setSummary("FROM: " + fromAddress + "\n" + msg.getSubject());
        req.setResult("FROM: " + from[0].toString() + "\n" + this.getMessage((Part)msg));
        if (sMessageID != null) {
            req.setDocumentNo(sMessageID);
        }
        if (this.R_RequestType_ID > 0) {
            req.setR_RequestType_ID(this.R_RequestType_ID);
        } else {
            req.setR_RequestType_ID();
        }
        if (this.SalesRep_ID > 0) {
            req.setSalesRep_ID(this.SalesRep_ID);
        }
        if (this.AD_Role_ID > 0) {
            req.setAD_Role_ID(this.AD_Role_ID);
        }
        if (from != null) {
            int retValueu = -1;
            String sqlu = "SELECT ad_user_id   FROM ad_user  WHERE UPPER (email) = UPPER (?)    AND ad_client_id = ?";
            CPreparedStatement pstmtu = null;
            pstmtu = DB.prepareStatement((String)sqlu, null);
            pstmtu.setString(1, fromAddress);
            pstmtu.setInt(2, this.getAD_Client_ID());
            ResultSet rsu = pstmtu.executeQuery();
            if (rsu.next()) {
                retValueu = rsu.getInt(1);
            }
            rsu.close();
            pstmtu.close();
            pstmtu = null;
            if (retValueu > 0) {
                req.setAD_User_ID(retValueu);
            } else if (this.AD_User_ID > 0) {
                req.setAD_User_ID(this.AD_User_ID);
            }
        }
        if (req.getAD_User_ID() > 0 && (us = new MUser(this.getCtx(), req.getAD_User_ID(), this.get_TrxName())).getC_BPartner_ID() > 0) {
            req.setC_BPartner_ID(us.getC_BPartner_ID());
        }
        if (req.getC_BPartner_ID() <= 0 && this.C_BPartner_ID > 0) {
            req.setC_BPartner_ID(this.C_BPartner_ID);
        }
        req.setStartDate(new Timestamp(msg.getSentDate().getTime()));
        if (this.p_DefaultConfidentiality != null) {
            req.setConfidentialType(this.p_DefaultConfidentiality);
            req.setConfidentialTypeEntry(this.p_DefaultConfidentiality);
        }
        if (this.p_DefaultPriority != null) {
            req.setPriority(this.p_DefaultPriority);
            req.setPriorityUser(this.p_DefaultPriority);
        }
        if (req.save(this.get_TrxName())) {
            this.log.info("created request " + req.getR_Request_ID() + " from msg -> " + sMessageID);
            if (msg.isMimeType("multipart/*")) {
                try {
                    Multipart mp = (Multipart)msg.getContent();
                    int i = 0;
                    int n = mp.getCount();
                    while (i < n) {
                        BodyPart part = mp.getBodyPart(i);
                        String disposition = part.getDisposition();
                        if (disposition != null && (disposition.equals("attachment") || disposition.equals("inline"))) {
                            MAttachment attach = req.createAttachment();
                            InputStream in = part.getInputStream();
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            int BUF_SIZE = 256;
                            byte[] buffer = new byte[256];
                            int bytesRead = -1;
                            while ((bytesRead = in.read(buffer)) > -1) {
                                out.write(buffer, 0, bytesRead);
                            }
                            in.close();
                            byte[] bytes = out.toByteArray();
                            attach.addEntry(part.getFileName(), bytes);
                            attach.saveEx(this.get_TrxName());
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                    this.log.log(Level.FINE, "Error extracting attachments", (Throwable)e);
                }
            }
            return true;
        }
        return false;
    }

    private boolean updateRequest(int request_upd, Message msg) throws MessagingException, SQLException {
        MRequest requp = new MRequest(this.getCtx(), request_upd, this.get_TrxName());
        Address[] from = msg.getFrom();
        requp.setResult("FROM: " + from[0].toString() + "\n" + this.getMessage((Part)msg));
        return requp.save();
    }

    private int processMessage(Message msg) throws Exception {
        this.dumpEnvelope(msg);
        this.dumpBody((Part)msg);
        this.printOut(":::::::::::::::");
        this.printOut(this.getSubject(msg));
        this.printOut(":::::::::::::::");
        this.printOut(this.getMessage((Part)msg));
        this.printOut(":::::::::::::::");
        String delivery = this.getDeliveryReport((Part)msg);
        this.printOut(delivery);
        this.printOut(":::::::::::::::");
        Address[] from = msg.getFrom();
        if (from != null) {
            if (from[0].toString().equalsIgnoreCase("postmaster@CONSULTDESK")) {
                return 0;
            }
        } else {
            return 0;
        }
        return 1;
    }

    private String getSubject(Message msg) {
        try {
            String str = msg.getSubject();
            if (str != null) {
                return str.trim();
            }
        }
        catch (MessagingException e) {
            this.log.log(Level.SEVERE, "getSubject", (Throwable)e);
        }
        return "";
    }

    private String getMessage(Part msg) {
        StringBuffer sb = new StringBuffer();
        try {
            if (msg.isMimeType("text/plain")) {
                sb.append(msg.getContent());
            } else if (msg.isMimeType("text/*")) {
                sb.append(msg.getContent());
            } else if (msg.isMimeType("message/rfc822")) {
                sb.append(msg.getContent());
            } else if (msg.isMimeType("multipart/alternative")) {
                String plainText = null;
                String otherStuff = null;
                Multipart mp = (Multipart)msg.getContent();
                int count = mp.getCount();
                int i = 0;
                while (i < count) {
                    BodyPart part = mp.getBodyPart(i);
                    Object content = part.getContent();
                    if (content != null && content.toString().trim().length() != 0) {
                        if (part.isMimeType("text/plain")) {
                            plainText = content.toString();
                        } else {
                            otherStuff = content.toString();
                        }
                    }
                    ++i;
                }
                if (plainText != null) {
                    sb.append(plainText);
                } else if (otherStuff != null) {
                    sb.append(otherStuff);
                }
            } else if (msg.isMimeType("multipart/*")) {
                Multipart mp = (Multipart)msg.getContent();
                int count = mp.getCount();
                int i = 0;
                while (i < count) {
                    String str = this.getMessage((Part)mp.getBodyPart(i));
                    if (str.length() > 0) {
                        if (sb.length() > 0) {
                            sb.append("\n-----\n");
                        }
                        sb.append(str);
                    }
                    ++i;
                }
            } else {
                Object o = msg.getContent();
                if (o instanceof String) {
                    sb.append(o);
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getMessage", (Throwable)e);
        }
        return sb.toString().trim();
    }

    private String getDeliveryReport(Part msg) {
        try {
            if (msg.isMimeType("multipart/report")) {
                String deliveryMessage = null;
                String otherStuff = null;
                Multipart mp = (Multipart)msg.getContent();
                int count = mp.getCount();
                int i = 0;
                while (i < count) {
                    BodyPart part = mp.getBodyPart(i);
                    Object content = part.getContent();
                    if (content != null) {
                        if (part.isMimeType("message/*")) {
                            deliveryMessage = this.getDeliveredReportDetail((Part)part);
                        } else {
                            otherStuff = content.toString().trim();
                        }
                    }
                    ++i;
                }
                if (deliveryMessage != null) {
                    return deliveryMessage;
                }
                return otherStuff;
            }
            if (msg.isMimeType("message/*")) {
                return this.getDeliveredReportDetail(msg);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getDeliveryReport", (Throwable)e);
        }
        return null;
    }

    private String getDeliveredReportDetail(Part part) throws Exception {
        String finalRecipient;
        int atIndex;
        Object content = part.getContent();
        if (content == null) {
            return null;
        }
        String deliveryMessage = null;
        if (content instanceof InputStream) {
            int c;
            StringBuffer sb = new StringBuffer();
            InputStream is = (InputStream)content;
            while ((c = is.read()) != -1) {
                sb.append((char)c);
            }
            deliveryMessage = sb.toString().trim();
        } else {
            deliveryMessage = content.toString().trim();
        }
        if (deliveryMessage == null) {
            return null;
        }
        int index = deliveryMessage.indexOf("Final-Recipient:");
        if (index != -1 && (atIndex = (finalRecipient = deliveryMessage.substring(index)).indexOf("@")) != -1) {
            index = finalRecipient.lastIndexOf(32, atIndex);
            if (index != -1) {
                finalRecipient = finalRecipient.substring(index + 1);
            }
            if ((atIndex = finalRecipient.indexOf("@")) != -1) {
                index = finalRecipient.indexOf(32, atIndex);
            }
            if (index != -1) {
                finalRecipient = finalRecipient.substring(0, index);
            }
            if ((index = finalRecipient.indexOf(10)) != -1) {
                finalRecipient = finalRecipient.substring(0, index);
            }
            return finalRecipient.trim();
        }
        return deliveryMessage;
    }

    private void dumpEnvelope(Message m) throws Exception {
        int i;
        StringBuffer sb1;
        int j;
        this.printOut("-----------------------------------------------------------------");
        Address[] a = m.getFrom();
        if (a != null) {
            j = 0;
            while (j < a.length) {
                this.printOut("FROM: " + a[j].toString());
                ++j;
            }
        }
        if ((a = m.getRecipients(Message.RecipientType.TO)) != null) {
            j = 0;
            while (j < a.length) {
                this.printOut("TO: " + a[j].toString());
                ++j;
            }
        }
        this.printOut("SUBJECT: " + m.getSubject());
        Date d = m.getSentDate();
        this.printOut("SendDate: " + (d != null ? d.toString() : "UNKNOWN"));
        Flags flags = m.getFlags();
        StringBuffer sb = new StringBuffer();
        Flags.Flag[] sf = flags.getSystemFlags();
        boolean first = true;
        int i2 = 0;
        while (i2 < sf.length) {
            block26: {
                String s;
                block21: {
                    Flags.Flag f;
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    block20: {
                                        f = sf[i2];
                                        if (f != Flags.Flag.ANSWERED) break block20;
                                        s = "\\Answered";
                                        break block21;
                                    }
                                    if (f != Flags.Flag.DELETED) break block22;
                                    s = "\\Deleted";
                                    break block21;
                                }
                                if (f != Flags.Flag.DRAFT) break block23;
                                s = "\\Draft";
                                break block21;
                            }
                            if (f != Flags.Flag.FLAGGED) break block24;
                            s = "\\Flagged";
                            break block21;
                        }
                        if (f != Flags.Flag.RECENT) break block25;
                        s = "\\Recent";
                        break block21;
                    }
                    if (f != Flags.Flag.SEEN) break block26;
                    s = "\\Seen";
                }
                if (first) {
                    first = false;
                } else {
                    sb.append(' ');
                }
                sb.append(s);
            }
            ++i2;
        }
        String[] uf = flags.getUserFlags();
        int i3 = 0;
        while (i3 < uf.length) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(uf[i3]);
            ++i3;
        }
        this.printOut("FLAGS: " + sb.toString());
        String[] hdrs = m.getHeader("X-Mailer");
        if (hdrs != null) {
            sb1 = new StringBuffer("X-Mailer: ");
            i = 0;
            while (i < hdrs.length) {
                sb1.append(hdrs[i]).append("  ");
                ++i;
            }
            this.printOut(sb1.toString());
        } else {
            this.printOut("X-Mailer NOT available");
        }
        hdrs = m.getHeader("Message-ID");
        if (hdrs != null) {
            sb1 = new StringBuffer("Message-ID: ");
            i = 0;
            while (i < hdrs.length) {
                sb1.append(hdrs[i]).append("  ");
                ++i;
            }
            this.printOut(sb1.toString());
        } else {
            this.printOut("Message-ID NOT available");
        }
        this.printOut("ALL HEADERs:");
        Enumeration en = m.getAllHeaders();
        while (en.hasMoreElements()) {
            Header hdr = (Header)en.nextElement();
            this.printOut("  " + hdr.getName() + " = " + hdr.getValue());
        }
        this.printOut("-----------------------------------------------------------------");
    }

    private void dumpBody(Part p) throws Exception {
        this.printOut("=================================================================");
        this.printOut("CONTENT-TYPE: " + p.getContentType());
        if (p.isMimeType("text/plain")) {
            this.printOut("Plain text ---------------------------");
            this.printOut((String)p.getContent());
        } else if (p.getContentType().toUpperCase().startsWith("TEXT")) {
            this.printOut("Other text ---------------------------");
            this.printOut((String)p.getContent());
        } else if (p.isMimeType("multipart/*")) {
            this.printOut("Multipart ---------------------------");
            Multipart mp = (Multipart)p.getContent();
            int count = mp.getCount();
            int i = 0;
            while (i < count) {
                this.dumpBody((Part)mp.getBodyPart(i));
                ++i;
            }
        } else if (p.isMimeType("message/rfc822")) {
            this.printOut("Nested ---------------------------");
            this.dumpBody((Part)p.getContent());
        } else {
            Object o = p.getContent();
            if (o instanceof String) {
                this.printOut("This is a string ---------------------------");
                this.printOut((String)o);
            } else if (o instanceof InputStream) {
                this.printOut("This is just an input stream ---------------------------");
            } else {
                this.printOut("This is an unknown type ---------------------------");
                this.printOut(o.toString());
            }
        }
        this.printOut("=================================================================");
    }

    private void printOut(String s) {
        this.log.finer(s);
    }
}

