/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProject;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectTask;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.ProjectGenOrder;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class ProjectPhaseGenOrder
extends SvrProcess {
    private int m_C_ProjectPhase_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.m_C_ProjectPhase_ID = this.getRecord_ID();
        this.log.info("doIt - C_ProjectPhase_ID=" + this.m_C_ProjectPhase_ID);
        if (this.m_C_ProjectPhase_ID == 0) {
            throw new IllegalArgumentException("C_ProjectPhase_ID == 0");
        }
        MProjectPhase fromPhase = new MProjectPhase(this.getCtx(), this.m_C_ProjectPhase_ID, this.get_TrxName());
        MProject fromProject = ProjectGenOrder.getProject((Properties)this.getCtx(), (int)fromPhase.getC_Project_ID(), (String)this.get_TrxName());
        MOrder order = new MOrder(fromProject, true, "ON");
        order.setDescription(String.valueOf(order.getDescription()) + " - " + fromPhase.getName());
        if (!order.save()) {
            throw new Exception("Could not create Order");
        }
        if (fromPhase.getM_Product_ID() != 0) {
            MOrderLine ol = new MOrderLine(order);
            ol.setLine(fromPhase.getSeqNo());
            StringBuffer sb = new StringBuffer(fromPhase.getName());
            if (fromPhase.getDescription() != null && fromPhase.getDescription().length() > 0) {
                sb.append(" - ").append(fromPhase.getDescription());
            }
            ol.setDescription(sb.toString());
            ol.setM_Product_ID(fromPhase.getM_Product_ID(), true);
            ol.setQty(fromPhase.getQty());
            ol.setPrice();
            if (fromPhase.getPriceActual() != null && fromPhase.getPriceActual().compareTo(Env.ZERO) != 0) {
                ol.setPrice(fromPhase.getPriceActual());
            }
            ol.setTax();
            if (!ol.save()) {
                this.log.log(Level.SEVERE, "doIt - Lines not generated");
            }
            return "@C_Order_ID@ " + order.getDocumentNo() + " (1)";
        }
        int count = 0;
        MProjectTask[] tasks = fromPhase.getTasks();
        int i = 0;
        while (i < tasks.length) {
            MOrderLine ol = new MOrderLine(order);
            ol.setLine(tasks[i].getSeqNo());
            StringBuffer sb = new StringBuffer(tasks[i].getName());
            if (tasks[i].getDescription() != null && tasks[i].getDescription().length() > 0) {
                sb.append(" - ").append(tasks[i].getDescription());
            }
            ol.setDescription(sb.toString());
            ol.setM_Product_ID(tasks[i].getM_Product_ID(), true);
            ol.setQty(tasks[i].getQty());
            ol.setPrice();
            ol.setTax();
            if (ol.save()) {
                ++count;
            }
            ++i;
        }
        if (tasks.length != count) {
            this.log.log(Level.SEVERE, "doIt - Lines difference - ProjectTasks=" + tasks.length + " <> Saved=" + count);
        }
        return "@C_Order_ID@ " + order.getDocumentNo() + " (" + count + ")";
    }
}

