/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLocation;
import org.compiere.model.MUser;
import org.compiere.model.X_C_BPartner;
import org.compiere.model.X_I_Invoice;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ImportInvoice
extends SvrProcess {
    private int m_AD_Client_ID = 0;
    private int m_AD_Org_ID = 0;
    private boolean m_deleteOldImported = false;
    private String m_docAction = "PR";
    private Timestamp m_DateValue = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Client_ID")) {
                    this.m_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("AD_Org_ID")) {
                    this.m_AD_Org_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("DeleteOldImported")) {
                    this.m_deleteOldImported = "Y".equals(para[i].getParameter());
                } else if (name.equals("DocAction")) {
                    this.m_docAction = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        if (this.m_DateValue == null) {
            this.m_DateValue = new Timestamp(System.currentTimeMillis());
        }
    }

    @Override
    protected String doIt() throws Exception {
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = " AND AD_Client_ID=" + this.m_AD_Client_ID;
        if (this.m_deleteOldImported) {
            sql = new StringBuffer("DELETE I_Invoice WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            this.log.fine("Delete Old Impored =" + no);
        }
        sql = new StringBuffer("UPDATE I_Invoice SET AD_Client_ID = COALESCE (AD_Client_ID,").append(this.m_AD_Client_ID).append("), AD_Org_ID = COALESCE (AD_Org_ID,").append(this.m_AD_Org_ID).append("), IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = ' ', I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.info("Reset=" + no);
        sql = new StringBuffer("UPDATE I_Invoice o SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Org, 'WHERE (AD_Org_ID IS NULL OR AD_Org_ID=0 OR EXISTS (SELECT * FROM AD_Org oo WHERE o.AD_Org_ID=oo.AD_Org_ID AND (oo.IsSummary='Y' OR oo.IsActive='N'))) AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Org=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuffer("UPDATE I_Invoice o SET C_DocType_ID=(SELECT C_DocType_ID FROM C_DocType d WHERE d.Name=o.DocTypeName AND d.DocBaseType IN ('API','APC') AND o.AD_Client_ID=d.AD_Client_ID) WHERE C_DocType_ID IS NULL AND IsSOTrx='N' AND DocTypeName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.fine("Set PO DocType=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuffer("UPDATE I_Invoice o SET C_DocType_ID=(SELECT C_DocType_ID FROM C_DocType d WHERE d.Name=o.DocTypeName AND d.DocBaseType IN ('ARI','ARC') AND o.AD_Client_ID=d.AD_Client_ID) WHERE C_DocType_ID IS NULL AND IsSOTrx='Y' AND DocTypeName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.fine("Set SO DocType=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuffer("UPDATE I_Invoice o SET C_DocType_ID=(SELECT C_DocType_ID FROM C_DocType d WHERE d.Name=o.DocTypeName AND d.DocBaseType IN ('API','ARI','APC','ARC') AND o.AD_Client_ID=d.AD_Client_ID) WHERE C_DocType_ID IS NULL AND DocTypeName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.fine("Set DocType=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuffer("UPDATE I_Invoice SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid DocTypeName, ' WHERE C_DocType_ID IS NULL AND DocTypeName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("Invalid DocTypeName=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuffer("UPDATE I_Invoice o SET C_DocType_ID=(SELECT MAX(C_DocType_ID) FROM C_DocType d WHERE d.IsDefault='Y' AND d.DocBaseType='API' AND o.AD_Client_ID=d.AD_Client_ID) WHERE C_DocType_ID IS NULL AND IsSOTrx='N' AND I_IsImported<>'Y'").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.fine("Set PO Default DocType=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuffer("UPDATE I_Invoice o SET C_DocType_ID=(SELECT MAX(C_DocType_ID) FROM C_DocType d WHERE d.IsDefault='Y' AND d.DocBaseType='ARI' AND o.AD_Client_ID=d.AD_Client_ID) WHERE C_DocType_ID IS NULL AND IsSOTrx='Y' AND I_IsImported<>'Y'").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.fine("Set SO Default DocType=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuffer("UPDATE I_Invoice o SET C_DocType_ID=(SELECT MAX(C_DocType_ID) FROM C_DocType d WHERE d.IsDefault='Y' AND d.DocBaseType IN('ARI','API') AND o.AD_Client_ID=d.AD_Client_ID) WHERE C_DocType_ID IS NULL AND IsSOTrx IS NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.fine("Set Default DocType=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuffer("UPDATE I_Invoice SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No DocType, ' WHERE C_DocType_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("No DocType=" + no);
        }
        sql = new StringBuffer("UPDATE I_Invoice o SET IsSOTrx='Y' WHERE EXISTS (SELECT * FROM C_DocType d WHERE o.C_DocType_ID=d.C_DocType_ID AND d.DocBaseType='ARI' AND o.AD_Client_ID=d.AD_Client_ID) AND C_DocType_ID IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set IsSOTrx=Y=" + no);
        sql = new StringBuffer("UPDATE I_Invoice o SET IsSOTrx='N' WHERE EXISTS (SELECT * FROM C_DocType d WHERE o.C_DocType_ID=d.C_DocType_ID AND d.DocBaseType='API' AND o.AD_Client_ID=d.AD_Client_ID) AND C_DocType_ID IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set IsSOTrx=N=" + no);
        sql = new StringBuffer("UPDATE I_Invoice o SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p WHERE p.IsDefault='Y' AND p.C_Currency_ID=o.C_Currency_ID AND p.IsSOPriceList=o.IsSOTrx AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_PriceList_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Default Currency PriceList=" + no);
        sql = new StringBuffer("UPDATE I_Invoice o SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p WHERE p.IsDefault='Y' AND p.IsSOPriceList=o.IsSOTrx AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_PriceList_ID IS NULL AND C_Currency_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Default PriceList=" + no);
        sql = new StringBuffer("UPDATE I_Invoice o SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p  WHERE p.C_Currency_ID=o.C_Currency_ID AND p.IsSOPriceList=o.IsSOTrx AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_PriceList_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Currency PriceList=" + no);
        sql = new StringBuffer("UPDATE I_Invoice o SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p  WHERE p.IsSOPriceList=o.IsSOTrx AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_PriceList_ID IS NULL AND C_Currency_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set PriceList=" + no);
        sql = new StringBuffer("UPDATE I_Invoice SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No PriceList, ' WHERE M_PriceList_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("No PriceList=" + no);
        }
        sql = new StringBuffer("UPDATE I_Invoice o SET C_Project_ID=(SELECT C_Project_ID FROM C_Project p WHERE o.ProjectValue=p.Value AND o.AD_Client_ID=p.AD_Client_ID) WHERE C_Project_ID IS NULL AND ProjectValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Project=" + no);
        sql = new StringBuffer("UPDATE I_Invoice SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Project, ' WHERE C_Project_ID IS NULL AND (ProjectValue IS NOT NULL) AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Project=" + no);
        }
        sql = new StringBuffer("UPDATE I_Invoice o SET C_Activity_ID=(SELECT C_Activity_ID FROM C_Activity p WHERE o.ActivityValue=p.Value AND o.AD_Client_ID=p.AD_Client_ID) WHERE C_Activity_ID IS NULL AND ActivityValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Activity=" + no);
        sql = new StringBuffer("UPDATE I_Invoice SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Activity, ' WHERE C_Activity_ID IS NULL AND (ActivityValue IS NOT NULL) AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Activity=" + no);
        }
        sql = new StringBuffer("UPDATE I_Invoice o SET C_Charge_ID=(SELECT C_Charge_ID FROM C_Charge p WHERE o.ChargeName=p.Name AND o.AD_Client_ID=p.AD_Client_ID) WHERE C_Charge_ID IS NULL AND ChargeName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Charge=" + no);
        sql = new StringBuffer("UPDATE I_Invoice SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Charge, ' WHERE C_Charge_ID IS NULL AND (ChargeName IS NOT NULL) AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Charge=" + no);
        }
        sql = new StringBuffer("UPDATE I_Invoice o SET (C_BPartner_ID,AD_User_ID)=(SELECT C_BPartner_ID,AD_User_ID FROM AD_User u WHERE o.EMail=u.EMail AND o.AD_Client_ID=u.AD_Client_ID AND u.C_BPartner_ID IS NOT NULL) WHERE C_BPartner_ID IS NULL AND EMail IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set BP from EMail=" + no);
        sql = new StringBuffer("UPDATE I_Invoice o SET (C_BPartner_ID,AD_User_ID)=(SELECT C_BPartner_ID,AD_User_ID FROM AD_User u WHERE o.ContactName=u.Name AND o.AD_Client_ID=u.AD_Client_ID AND u.C_BPartner_ID IS NOT NULL) WHERE C_BPartner_ID IS NULL AND ContactName IS NOT NULL AND EXISTS (SELECT Name FROM AD_User u WHERE o.ContactName=u.Name AND o.AD_Client_ID=u.AD_Client_ID AND u.C_BPartner_ID IS NOT NULL GROUP BY Name HAVING COUNT(*)=1) AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set BP from ContactName=" + no);
        sql = new StringBuffer("UPDATE I_Invoice o SET C_BPartner_ID=(SELECT MAX(C_BPartner_ID) FROM C_BPartner bp WHERE o.BPartnerValue=bp.Value AND o.AD_Client_ID=bp.AD_Client_ID) WHERE C_BPartner_ID IS NULL AND BPartnerValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set BP from Value=" + no);
        sql = new StringBuffer("UPDATE I_Invoice o SET C_BPartner_ID=(SELECT C_BPartnerCashTrx_ID FROM AD_ClientInfo c WHERE o.AD_Client_ID=c.AD_Client_ID) WHERE C_BPartner_ID IS NULL AND BPartnerValue IS NULL AND Name IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Default BP=" + no);
        sql = new StringBuffer("UPDATE I_Invoice o SET C_PaymentTerm_ID=(SELECT C_PaymentTerm_ID FROM C_PaymentTerm p WHERE o.PaymentTermValue=p.Value AND o.AD_Client_ID=p.AD_Client_ID) WHERE C_PaymentTerm_ID IS NULL AND PaymentTermValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set PaymentTerm=" + no);
        sql = new StringBuffer("UPDATE I_Invoice o SET C_PaymentTerm_ID=(SELECT C_PaymentTerm_ID FROM C_BPartner bp WHERE o.C_BPartner_ID=bp.C_BPartner_ID AND o.AD_Client_ID=bp.AD_Client_ID) WHERE C_PaymentTerm_ID IS NULL AND C_BPartner_ID IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set PaymentTerm from BPartner=" + no);
        sql = new StringBuffer("UPDATE I_Invoice o SET C_PaymentTerm_ID=(SELECT MAX(C_PaymentTerm_ID) FROM C_PaymentTerm p WHERE p.IsDefault='Y' AND o.AD_Client_ID=p.AD_Client_ID) WHERE C_PaymentTerm_ID IS NULL AND o.PaymentTermValue IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Default PaymentTerm=" + no);
        sql = new StringBuffer("UPDATE I_Invoice SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No PaymentTerm, ' WHERE C_PaymentTerm_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("No PaymentTerm=" + no);
        }
        sql = new StringBuffer("UPDATE I_Invoice o SET C_BPartner_Location_ID=(SELECT C_BPartner_Location_ID FROM C_BPartner_Location bpl INNER JOIN C_Location l ON (bpl.C_Location_ID=l.C_Location_ID) WHERE o.C_BPartner_ID=bpl.C_BPartner_ID AND bpl.AD_Client_ID=o.AD_Client_ID AND DUMP(o.Address1)=DUMP(l.Address1) AND DUMP(o.Address2)=DUMP(l.Address2) AND DUMP(o.City)=DUMP(l.City) AND DUMP(o.Postal)=DUMP(l.Postal) AND o.C_Region_ID=l.C_Region_ID AND o.C_Country_ID=l.C_Country_ID) WHERE C_BPartner_ID IS NOT NULL AND C_BPartner_Location_ID IS NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Found Location=" + no);
        sql = new StringBuffer("UPDATE I_Invoice o SET C_BPartner_Location_ID=(SELECT MAX(C_BPartner_Location_ID) FROM C_BPartner_Location l WHERE l.C_BPartner_ID=o.C_BPartner_ID AND o.AD_Client_ID=l.AD_Client_ID AND ((l.IsBillTo='Y' AND o.IsSOTrx='Y') OR o.IsSOTrx='N')) WHERE C_BPartner_ID IS NOT NULL AND C_BPartner_Location_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set BP Location from BP=" + no);
        sql = new StringBuffer("UPDATE I_Invoice SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No BP Location, ' WHERE C_BPartner_ID IS NOT NULL AND C_BPartner_Location_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("No BP Location=" + no);
        }
        sql = new StringBuffer("UPDATE I_Invoice o SET C_Country_ID=(SELECT C_Country_ID FROM C_Country c WHERE o.CountryCode=c.CountryCode AND c.AD_Client_ID IN (0, o.AD_Client_ID)) WHERE C_BPartner_ID IS NULL AND C_Country_ID IS NULL AND CountryCode IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Country=" + no);
        sql = new StringBuffer("UPDATE I_Invoice SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Country, ' WHERE C_BPartner_ID IS NULL AND C_Country_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Country=" + no);
        }
        sql = new StringBuffer("UPDATE I_Invoice o Set RegionName=(SELECT MAX(Name) FROM C_Region r WHERE r.IsDefault='Y' AND r.C_Country_ID=o.C_Country_ID AND r.AD_Client_ID IN (0, o.AD_Client_ID)) WHERE C_BPartner_ID IS NULL AND C_Region_ID IS NULL AND RegionName IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Region Default=" + no);
        sql = new StringBuffer("UPDATE I_Invoice o Set C_Region_ID=(SELECT C_Region_ID FROM C_Region r WHERE r.Name=o.RegionName AND r.C_Country_ID=o.C_Country_ID AND r.AD_Client_ID IN (0, o.AD_Client_ID)) WHERE C_BPartner_ID IS NULL AND C_Region_ID IS NULL AND RegionName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Region=" + no);
        sql = new StringBuffer("UPDATE I_Invoice o SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Region, ' WHERE C_BPartner_ID IS NULL AND C_Region_ID IS NULL  AND EXISTS (SELECT * FROM C_Country c WHERE c.C_Country_ID=o.C_Country_ID AND c.HasRegion='Y') AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Region=" + no);
        }
        sql = new StringBuffer("UPDATE I_Invoice o SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p WHERE o.ProductValue=p.Value AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_Product_ID IS NULL AND ProductValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Product from Value=" + no);
        sql = new StringBuffer("UPDATE I_Invoice o SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p WHERE o.UPC=p.UPC AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_Product_ID IS NULL AND UPC IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Product from UPC=" + no);
        sql = new StringBuffer("UPDATE I_Invoice o SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p WHERE o.SKU=p.SKU AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_Product_ID IS NULL AND SKU IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Product fom SKU=" + no);
        sql = new StringBuffer("UPDATE I_Invoice SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Product, ' WHERE M_Product_ID IS NULL AND (ProductValue IS NOT NULL OR UPC IS NOT NULL OR SKU IS NOT NULL) AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Product=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuffer("UPDATE I_Invoice SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Product and Charge, ' WHERE M_Product_ID IS NOT NULL AND C_Charge_ID IS NOT NULL  AND I_IsImported<>'Y'").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("Invalid Product and Charge exclusive=" + no);
        }
        sql = new StringBuffer("UPDATE I_Invoice o SET C_Tax_ID=(SELECT MAX(C_Tax_ID) FROM C_Tax t WHERE o.TaxIndicator=t.TaxIndicator AND o.AD_Client_ID=t.AD_Client_ID) WHERE C_Tax_ID IS NULL AND TaxIndicator IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Tax=" + no);
        sql = new StringBuffer("UPDATE I_Invoice SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Tax, ' WHERE C_Tax_ID IS NULL AND TaxIndicator IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Tax=" + no);
        }
        this.commitEx();
        sql = new StringBuffer("SELECT * FROM I_Invoice WHERE I_IsImported='N' AND C_BPartner_ID IS NULL").append(clientCheck);
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MBPartner bp;
                X_I_Invoice imp = new X_I_Invoice(this.getCtx(), rs, this.get_TrxName());
                if (imp.getBPartnerValue() == null) {
                    if (imp.getEMail() != null) {
                        imp.setBPartnerValue(imp.getEMail());
                    } else {
                        if (imp.getName() == null) continue;
                        imp.setBPartnerValue(imp.getName());
                    }
                }
                if (imp.getName() == null) {
                    if (imp.getContactName() != null) {
                        imp.setName(imp.getContactName());
                    } else {
                        imp.setName(imp.getBPartnerValue());
                    }
                }
                if ((bp = MBPartner.get((Properties)this.getCtx(), (String)imp.getBPartnerValue())) == null) {
                    bp = new MBPartner(this.getCtx(), -1, this.get_TrxName());
                    bp.setClientOrg(imp.getAD_Client_ID(), imp.getAD_Org_ID());
                    bp.setValue(imp.getBPartnerValue());
                    bp.setName(imp.getName());
                    if (!bp.save()) continue;
                }
                imp.setC_BPartner_ID(bp.getC_BPartner_ID());
                MBPartnerLocation bpl = null;
                MBPartnerLocation[] bpls = bp.getLocations(true);
                int i = 0;
                while (bpl == null && i < bpls.length) {
                    MLocation loc;
                    if (imp.getC_BPartner_Location_ID() == bpls[i].getC_BPartner_Location_ID()) {
                        bpl = bpls[i];
                    } else if (imp.getC_Location_ID() == bpls[i].getC_Location_ID()) {
                        bpl = bpls[i];
                    } else if (imp.getC_Location_ID() == 0 && (loc = bpl.getLocation(false)).equals(imp.getC_Country_ID(), imp.getC_Region_ID(), imp.getPostal(), "", imp.getCity(), imp.getAddress1(), imp.getAddress2())) {
                        bpl = bpls[i];
                    }
                    ++i;
                }
                if (bpl == null) {
                    MLocation loc = new MLocation(this.getCtx(), 0, this.get_TrxName());
                    loc.setAddress1(imp.getAddress1());
                    loc.setAddress2(imp.getAddress2());
                    loc.setCity(imp.getCity());
                    loc.setPostal(imp.getPostal());
                    if (imp.getC_Region_ID() != 0) {
                        loc.setC_Region_ID(imp.getC_Region_ID());
                    }
                    loc.setC_Country_ID(imp.getC_Country_ID());
                    if (!loc.save()) continue;
                    bpl = new MBPartnerLocation(bp);
                    bpl.setC_Location_ID(imp.getC_Location_ID() > 0 ? imp.getC_Location_ID() : loc.getC_Location_ID());
                    if (!bpl.save()) continue;
                }
                imp.setC_Location_ID(bpl.getC_Location_ID());
                imp.setC_BPartner_Location_ID(bpl.getC_BPartner_Location_ID());
                if (imp.getContactName() != null || imp.getEMail() != null || imp.getPhone() != null) {
                    MUser[] users = bp.getContacts(true);
                    MUser user = null;
                    int i2 = 0;
                    while (user == null && i2 < users.length) {
                        String name = users[i2].getName();
                        if (name.equals(imp.getContactName()) || name.equals(imp.getName())) {
                            user = users[i2];
                            imp.setAD_User_ID(user.getAD_User_ID());
                        }
                        ++i2;
                    }
                    if (user == null) {
                        user = new MUser((X_C_BPartner)bp);
                        if (imp.getContactName() == null) {
                            user.setName(imp.getName());
                        } else {
                            user.setName(imp.getContactName());
                        }
                        user.setEMail(imp.getEMail());
                        user.setPhone(imp.getPhone());
                        if (user.save()) {
                            imp.setAD_User_ID(user.getAD_User_ID());
                        }
                    }
                }
                imp.save();
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "CreateBP", (Throwable)e);
        }
        sql = new StringBuffer("UPDATE I_Invoice SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No BPartner, ' WHERE C_BPartner_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("No BPartner=" + no);
        }
        this.commitEx();
        int noInsert = 0;
        int noInsertLine = 0;
        sql = new StringBuffer("SELECT * FROM I_Invoice WHERE I_IsImported='N'").append(clientCheck).append(" ORDER BY C_BPartner_ID, C_BPartner_Location_ID, DateInvoiced, DocumentNo, I_Invoice_ID");
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            int oldC_BPartner_ID = 0;
            int oldC_BPartner_Location_ID = 0;
            String oldDocumentNo = "";
            MInvoice invoice = null;
            int lineNo = 0;
            while (rs.next()) {
                X_I_Invoice imp = new X_I_Invoice(this.getCtx(), rs, null);
                String cmpDocumentNo = imp.getDocumentNo();
                if (cmpDocumentNo == null) {
                    cmpDocumentNo = "";
                }
                if (oldC_BPartner_ID != imp.getC_BPartner_ID() || oldC_BPartner_Location_ID != imp.getC_BPartner_Location_ID() || !oldDocumentNo.equals(cmpDocumentNo)) {
                    if (invoice != null) {
                        invoice.processIt(this.m_docAction);
                        invoice.save();
                    }
                    oldC_BPartner_ID = imp.getC_BPartner_ID();
                    oldC_BPartner_Location_ID = imp.getC_BPartner_Location_ID();
                    oldDocumentNo = imp.getDocumentNo();
                    if (oldDocumentNo == null) {
                        oldDocumentNo = "";
                    }
                    invoice = new MInvoice(this.getCtx(), 0, null);
                    invoice.setClientOrg(imp.getAD_Client_ID(), imp.getAD_Org_ID());
                    invoice.setC_DocTypeTarget_ID(imp.getC_DocType_ID());
                    invoice.setIsSOTrx(imp.isSOTrx());
                    if (imp.getDocumentNo() != null) {
                        invoice.setDocumentNo(imp.getDocumentNo());
                    }
                    invoice.setC_BPartner_ID(imp.getC_BPartner_ID());
                    invoice.setC_BPartner_Location_ID(imp.getC_BPartner_Location_ID());
                    if (imp.getAD_User_ID() != 0) {
                        invoice.setAD_User_ID(imp.getAD_User_ID());
                    }
                    if (imp.getDescription() != null) {
                        invoice.setDescription(imp.getDescription());
                    }
                    invoice.setC_PaymentTerm_ID(imp.getC_PaymentTerm_ID());
                    invoice.setM_PriceList_ID(imp.getM_PriceList_ID());
                    if (imp.getSalesRep_ID() != 0) {
                        invoice.setSalesRep_ID(imp.getSalesRep_ID());
                    }
                    if (invoice.getSalesRep_ID() == 0) {
                        invoice.setSalesRep_ID(this.getAD_User_ID());
                    }
                    if (imp.getAD_OrgTrx_ID() != 0) {
                        invoice.setAD_OrgTrx_ID(imp.getAD_OrgTrx_ID());
                    }
                    if (imp.getC_Activity_ID() != 0) {
                        invoice.setC_Activity_ID(imp.getC_Activity_ID());
                    }
                    if (imp.getC_Campaign_ID() != 0) {
                        invoice.setC_Campaign_ID(imp.getC_Campaign_ID());
                    }
                    if (imp.getC_Project_ID() != 0) {
                        invoice.setC_Project_ID(imp.getC_Project_ID());
                    }
                    if (imp.getDateInvoiced() != null) {
                        invoice.setDateInvoiced(imp.getDateInvoiced());
                    }
                    if (imp.getDateAcct() != null) {
                        invoice.setDateAcct(imp.getDateAcct());
                    }
                    invoice.set_CustomColumn("VATLedgerNo", imp.get_Value("VATLedgerNo"));
                    invoice.set_CustomColumn("VATLedgerDate", imp.get_Value("VATLedgerDate"));
                    invoice.save();
                    ++noInsert;
                    lineNo = 10;
                }
                imp.setC_Invoice_ID(invoice.getC_Invoice_ID());
                MInvoiceLine line = new MInvoiceLine(invoice);
                if (imp.getLineDescription() != null) {
                    line.setDescription(imp.getLineDescription());
                }
                line.setLine(lineNo);
                lineNo += 10;
                if (imp.getM_Product_ID() != 0) {
                    line.setM_Product_ID(imp.getM_Product_ID(), true);
                }
                if (imp.getC_Charge_ID() != 0) {
                    line.setC_Charge_ID(imp.getC_Charge_ID());
                }
                if (imp.getC_Activity_ID() != 0) {
                    line.setC_Activity_ID(imp.getC_Activity_ID());
                }
                if (imp.getC_Campaign_ID() != 0) {
                    line.setC_Campaign_ID(imp.getC_Campaign_ID());
                }
                if (imp.getC_Project_ID() != 0) {
                    line.setC_Project_ID(imp.getC_Project_ID());
                }
                line.setQty(imp.getQtyOrdered());
                line.setPrice();
                BigDecimal price = imp.getPriceActual();
                if (price != null && Env.ZERO.compareTo(price) != 0) {
                    line.setPrice(price);
                }
                if (imp.getC_Tax_ID() != 0) {
                    line.setC_Tax_ID(imp.getC_Tax_ID());
                } else {
                    line.setTax();
                    imp.setC_Tax_ID(line.getC_Tax_ID());
                }
                BigDecimal taxAmt = imp.getTaxAmt();
                if (taxAmt != null && Env.ZERO.compareTo(taxAmt) != 0) {
                    line.setTaxAmt(taxAmt);
                }
                line.save();
                imp.setC_InvoiceLine_ID(line.getC_InvoiceLine_ID());
                imp.setI_IsImported(true);
                imp.setProcessed(true);
                if (!imp.save()) continue;
                ++noInsertLine;
            }
            if (invoice != null) {
                invoice.processIt(this.m_docAction);
                invoice.save();
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "CreateInvoice", (Throwable)e);
        }
        sql = new StringBuffer("UPDATE I_Invoice SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@C_Invoice_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noInsertLine), "@C_InvoiceLine_ID@: @Inserted@");
        return "";
    }
}

