/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.output.OutputException;
import org.compiere.model.MQuery;
import org.compiere.print.MPrintTableFormat;
import org.compiere.print.layout.BarcodeElement;
import org.compiere.print.layout.Dimension2DImpl;
import org.compiere.print.layout.HTMLElement;
import org.compiere.print.layout.HTMLRenderer;
import org.compiere.print.layout.ImageElement;
import org.compiere.print.layout.LayoutEngine;
import org.compiere.print.layout.PrintElement;
import org.compiere.util.KeyNamePair;
import org.compiere.util.NamePair;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public class TableElement
extends PrintElement {
    private ValueNamePair[] m_columnHeader;
    private int[] m_columnMaxWidth;
    private int[] m_columnMaxHeight;
    private String[] m_columnJustification;
    private boolean[] m_fixedWidth;
    private boolean m_multiLineHeader;
    private ArrayList<Integer> m_functionRows;
    private Object[][] m_data;
    private KeyNamePair[] m_pk;
    private String m_pkColumnName;
    private int m_pageNoStart;
    private Rectangle m_firstPage;
    private Rectangle m_nextPages;
    private boolean[] m_colSuppressRepeats;
    private int m_repeatedColumns;
    private Font m_baseFont;
    private HashMap<Point, Font> m_rowColFont;
    private Color m_baseColor;
    private HashMap<Point, Color> m_rowColColor;
    private Color m_baseBackground;
    private HashMap<Point, Color> m_rowColBackground;
    private MPrintTableFormat m_tFormat;
    private ArrayList<Integer> m_pageBreak;
    private ArrayList<Float> m_columnWidths = new ArrayList();
    private ArrayList<Float> m_rowHeights = new ArrayList();
    private int m_headerHeight = 0;
    private ArrayList<Integer> m_firstRowOnPage = new ArrayList();
    private ArrayList<Integer> m_firstColumnOnPage = new ArrayList();
    private ArrayList<Float> m_pageHeight = new ArrayList();
    private HashMap<Point, NamePair> m_rowColDrillDown = new HashMap();
    private HashMap<Integer, Integer> m_additionalLines;
    public static final int HEADER_ROW = -2;
    public static final int ALL = -1;
    private static final int H_GAP = 2;
    private static final int V_GAP = 2;
    private static final boolean DEBUG_PRINT = false;
    private ArrayList<ArrayList<ArrayList<Object>>> m_printRows = new ArrayList();

    public TableElement(ValueNamePair[] columnHeader, int[] columnMaxWidth, int[] columnMaxHeight, String[] columnJustification, boolean[] fixedWidth, ArrayList<Integer> functionRows, boolean multiLineHeader, Object[][] data, KeyNamePair[] pk, String pkColumnName, int pageNoStart, Rectangle firstPage, Rectangle nextPages, int repeatedColumns, HashMap<Integer, Integer> additionalLines, HashMap<Point, Font> rowColFont, HashMap<Point, Color> rowColColor, HashMap<Point, Color> rowColBackground, MPrintTableFormat tFormat, ArrayList<Integer> pageBreak, boolean[] colSuppressRepeats) {
        this.log.fine("Cols=" + columnHeader.length + ", Rows=" + data.length);
        this.m_colSuppressRepeats = colSuppressRepeats;
        this.m_columnHeader = columnHeader;
        this.m_columnMaxWidth = columnMaxWidth;
        this.m_columnMaxHeight = columnMaxHeight;
        this.m_columnJustification = columnJustification;
        this.m_functionRows = functionRows;
        this.m_fixedWidth = fixedWidth;
        this.m_multiLineHeader = multiLineHeader;
        this.m_data = data;
        this.m_pk = pk;
        this.m_pkColumnName = pkColumnName;
        this.m_pageNoStart = pageNoStart;
        this.m_firstPage = firstPage;
        this.m_nextPages = nextPages;
        this.m_repeatedColumns = repeatedColumns;
        this.m_additionalLines = additionalLines;
        Point pAll = new Point(-1, -1);
        this.m_rowColFont = rowColFont;
        this.m_baseFont = this.m_rowColFont.get(pAll);
        if (this.m_baseFont == null) {
            this.m_baseFont = new Font(null);
        }
        this.m_rowColColor = rowColColor;
        this.m_baseColor = this.m_rowColColor.get(pAll);
        if (this.m_baseColor == null) {
            this.m_baseColor = Color.black;
        }
        this.m_rowColBackground = rowColBackground;
        this.m_baseBackground = this.m_rowColBackground.get(pAll);
        if (this.m_baseBackground == null) {
            this.m_baseBackground = Color.white;
        }
        this.m_tFormat = tFormat;
        this.m_pageBreak = pageBreak;
        int i = 0;
        while (i < this.m_pageBreak.size()) {
            Integer row = this.m_pageBreak.get(i);
            while (i + 1 < this.m_pageBreak.size()) {
                Integer nextRow = this.m_pageBreak.get(i + 1);
                if (row + 1 != nextRow) break;
                this.log.fine("- removing PageBreak row=" + row);
                this.m_pageBreak.remove(i);
                row = nextRow;
            }
            ++i;
        }
        this.waitForLoad(LayoutEngine.IMAGE_TRUE);
        this.waitForLoad(LayoutEngine.IMAGE_FALSE);
    }

    protected boolean calculateSize() {
        if (this.p_sizeCalculated) {
            return true;
        }
        this.p_width = 0.0f;
        this.m_printRows = new ArrayList(this.m_data.length);
        float dynMxColumnWidth = this.m_firstPage.width / 2;
        int rows = this.m_data.length;
        int cols = this.m_columnHeader.length;
        Dimension2DImpl[][] dataSizes = new Dimension2DImpl[rows][cols];
        Dimension2DImpl[] headerSizes = new Dimension2DImpl[cols];
        FontRenderContext frc = new FontRenderContext(null, true, true);
        int dataCol = 0;
        while (dataCol < cols) {
            int col = dataCol;
            if (this.m_additionalLines.containsKey(new Integer(dataCol))) {
                col = this.m_additionalLines.get(new Integer(dataCol));
                this.log.finest("DataColumn=" + dataCol + ", BelowColumn=" + col);
            }
            float colWidth = 0.0f;
            int row = 0;
            while (row < rows) {
                Object dataItem = this.m_data[row][dataCol];
                if (dataItem == null) {
                    dataSizes[row][dataCol] = new Dimension2DImpl();
                } else {
                    String string = dataItem.toString();
                    if (string.length() == 0) {
                        dataSizes[row][dataCol] = new Dimension2DImpl();
                    } else {
                        Font font = this.getFont(row, dataCol);
                        this.addPrintLines(row, col, dataItem);
                        dataSizes[row][dataCol] = new Dimension2DImpl();
                        if (dataItem instanceof Boolean) {
                            dataSizes[row][col].addBelow(LayoutEngine.IMAGE_SIZE);
                        } else if (dataItem instanceof ImageElement) {
                            dataSizes[row][col].addBelow(new Dimension((int)((ImageElement)dataItem).getWidth(), (int)((ImageElement)dataItem).getHeight()));
                            float width = (float)Math.ceil(dataSizes[row][col].getWidth());
                            if (colWidth < width) {
                                colWidth = width;
                            }
                        } else if (dataItem instanceof BarcodeElement) {
                            float width;
                            dataSizes[row][col].addBelow(new Dimension((int)((BarcodeElement)dataItem).getWidth(), (int)((BarcodeElement)dataItem).getHeight()));
                            if (!((BarcodeElement)dataItem).isAllowOverflow() && colWidth < (width = (float)Math.ceil(dataSizes[row][col].getWidth()))) {
                                colWidth = width;
                            }
                        } else {
                            if (this.m_columnMaxWidth[col] == 0 || this.m_columnMaxWidth[col] == -1) {
                                TextLayout layout = new TextLayout(string, font, frc);
                                float width = layout.getAdvance() + 2.0f;
                                float height = layout.getAscent() + layout.getDescent() + layout.getLeading();
                                if (width > dynMxColumnWidth) {
                                    this.m_columnMaxWidth[col] = (int)Math.ceil(dynMxColumnWidth);
                                } else if (colWidth < width) {
                                    colWidth = width;
                                }
                                if (dataSizes[row][col] == null) {
                                    dataSizes[row][col] = new Dimension2DImpl();
                                    this.log.log(Level.WARNING, "No Size for r=" + row + ",c=" + col);
                                }
                                dataSizes[row][col].addBelow((double)width, (double)height);
                            }
                            if (this.m_columnMaxWidth[col] != 0 && this.m_columnMaxWidth[col] != -1) {
                                float height = 0.0f;
                                if (HTMLElement.isHTML((Object)string)) {
                                    HTMLRenderer renderer = HTMLRenderer.get((String)string);
                                    colWidth = renderer.getWidth();
                                    height = this.m_columnMaxHeight[col] == -1 ? renderer.getHeightOneLine() : renderer.getHeight();
                                    renderer.setAllocation((int)colWidth, (int)height);
                                    this.m_data[row][dataCol] = renderer;
                                } else {
                                    String[] lines = Pattern.compile("$", 8).split(string);
                                    int lineNo = 0;
                                    while (lineNo < lines.length) {
                                        AttributedString aString = new AttributedString(lines[lineNo]);
                                        aString.addAttribute(TextAttribute.FONT, font);
                                        AttributedCharacterIterator iter = aString.getIterator();
                                        LineBreakMeasurer measurer = new LineBreakMeasurer(iter, frc);
                                        while (measurer.getPosition() < iter.getEndIndex()) {
                                            TextLayout layout = measurer.nextLayout(Math.abs(this.m_columnMaxWidth[col]));
                                            float width = layout.getAdvance();
                                            if (colWidth < width) {
                                                colWidth = width;
                                            }
                                            float lineHeight = layout.getAscent() + layout.getDescent() + layout.getLeading();
                                            if (this.m_columnMaxHeight[col] == -1) {
                                                height = lineHeight;
                                                break;
                                            }
                                            if (this.m_columnMaxHeight[col] != 0 && !(height + lineHeight <= (float)this.m_columnMaxHeight[col])) continue;
                                            height += lineHeight;
                                        }
                                        ++lineNo;
                                    }
                                }
                                if (this.m_fixedWidth[col]) {
                                    colWidth = Math.abs(this.m_columnMaxWidth[col]);
                                }
                                dataSizes[row][col].addBelow((double)colWidth, (double)height);
                            }
                            dataSizes[row][col].roundUp();
                            if (dataItem instanceof NamePair) {
                                this.m_rowColDrillDown.put(new Point(row, col), (NamePair)dataItem);
                            }
                            this.log.finest("Col=" + col + ", row=" + row + " => " + dataSizes[row][col] + " - ColWidth=" + colWidth);
                        }
                    }
                }
                ++row;
            }
            String string = "";
            if (this.m_columnHeader[dataCol] != null) {
                string = this.m_columnHeader[dataCol].toString();
            }
            if (col != dataCol) {
                headerSizes[dataCol] = new Dimension2DImpl();
            } else if (colWidth == 0.0f && this.m_columnMaxWidth[dataCol] < 0 || string.length() == 0) {
                headerSizes[dataCol] = new Dimension2DImpl();
            } else {
                Font font = this.getFont(-2, dataCol);
                if (!font.isBold()) {
                    font = new Font(font.getName(), 1, font.getSize());
                }
                if (this.m_columnMaxWidth[dataCol] == 0 || this.m_columnMaxWidth[dataCol] == -1 || !this.m_multiLineHeader) {
                    TextLayout layout = new TextLayout(string, font, frc);
                    float width = layout.getAdvance() + 3.0f;
                    float height = layout.getAscent() + layout.getDescent() + layout.getLeading();
                    if (width > dynMxColumnWidth) {
                        this.m_columnMaxWidth[dataCol] = (int)Math.ceil(dynMxColumnWidth);
                    } else if (colWidth < width) {
                        colWidth = width;
                    }
                    headerSizes[dataCol] = new Dimension2DImpl((double)width, (double)height);
                }
                if (this.m_columnMaxWidth[dataCol] != 0 && this.m_columnMaxWidth[dataCol] != -1) {
                    float height = 0.0f;
                    String[] lines = Pattern.compile("$", 8).split(string);
                    int lineNo = 0;
                    while (lineNo < lines.length) {
                        AttributedString aString = new AttributedString(lines[lineNo]);
                        aString.addAttribute(TextAttribute.FONT, font);
                        AttributedCharacterIterator iter = aString.getIterator();
                        LineBreakMeasurer measurer = new LineBreakMeasurer(iter, frc);
                        colWidth = Math.abs(this.m_columnMaxWidth[dataCol]);
                        while (measurer.getPosition() < iter.getEndIndex()) {
                            TextLayout layout = measurer.nextLayout(colWidth);
                            float lineHeight = layout.getAscent() + layout.getDescent() + layout.getLeading();
                            if (!this.m_multiLineHeader) {
                                height = lineHeight;
                                break;
                            }
                            height += lineHeight;
                        }
                        ++lineNo;
                    }
                    headerSizes[dataCol] = new Dimension2DImpl((double)colWidth, (double)height);
                }
            }
            headerSizes[dataCol].roundUp();
            colWidth = (float)Math.ceil(colWidth);
            if (dataCol == 0) {
                colWidth += this.m_tFormat.getVLineStroke().floatValue();
            }
            if (colWidth != 0.0f) {
                colWidth += 4.0f + this.m_tFormat.getVLineStroke().floatValue();
            }
            if (col != dataCol) {
                this.m_columnWidths.add(new Float(0.0));
                Float origWidth = this.m_columnWidths.get(col);
                if (origWidth == null) {
                    this.log.log(Level.SEVERE, "Column " + dataCol + " below " + col + " - no value for orig width");
                } else if (origWidth.compareTo(new Float(colWidth)) >= 0) {
                    this.log.finest("Same Width - Col=" + col + " - OrigWidth=" + origWidth + " - Width=" + colWidth + " - Total=" + this.p_width);
                } else {
                    this.m_columnWidths.set(col, new Float(colWidth));
                    this.p_width += colWidth - origWidth.floatValue();
                    this.log.finest("New Width - Col=" + col + " - OrigWidth=" + origWidth + " - Width=" + colWidth + " - Total=" + this.p_width);
                }
            } else {
                this.m_columnWidths.add(new Float(colWidth));
                this.p_width += colWidth;
                this.log.finest("Width - Col=" + dataCol + " - Width=" + colWidth + " - Total=" + this.p_width);
            }
            ++dataCol;
        }
        this.p_height = 0.0f;
        int row = 0;
        while (row < rows) {
            float rowHeight = 0.0f;
            int col = 0;
            while (col < cols) {
                if (dataSizes[row][col].height > (double)rowHeight) {
                    rowHeight = (float)dataSizes[row][col].height;
                }
                ++col;
            }
            this.m_rowHeights.add(new Float(rowHeight += this.m_tFormat.getLineStroke().floatValue() + 4.0f));
            this.p_height += rowHeight;
            ++row;
        }
        this.m_headerHeight = 0;
        int col = 0;
        while (col < cols) {
            if (headerSizes[col].height > (double)this.m_headerHeight) {
                this.m_headerHeight = (int)headerSizes[col].height;
            }
            ++col;
        }
        this.m_headerHeight = (int)((float)this.m_headerHeight + (4.0f * this.m_tFormat.getLineStroke().floatValue() + 4.0f));
        this.p_height += (float)this.m_headerHeight;
        this.p_height += this.m_tFormat.getLineStroke().floatValue();
        this.log.fine("FirstPage=" + this.m_firstPage + ", NextPages=" + this.m_nextPages);
        if ((float)this.m_firstPage.height >= this.p_height && this.m_pageBreak.size() == 0) {
            this.log.finest("Page Y=1 - PageHeight=" + this.m_firstPage.height + " - TableHeight=" + this.p_height);
            this.m_firstRowOnPage.add(new Integer(0));
            this.m_pageHeight.add(new Float(this.p_height));
        } else {
            float availableHeight = 0.0f;
            float usedHeight = 0.0f;
            boolean firstPage = true;
            int addlRows = 0;
            int dataRow = 0;
            while (dataRow < this.m_rowHeights.size()) {
                float rowHeight = this.m_rowHeights.get(dataRow).floatValue();
                boolean pageBreak = this.isPageBreak(dataRow);
                if (dataRow + 1 == this.m_rowHeights.size()) {
                    availableHeight -= this.m_tFormat.getLineStroke().floatValue();
                }
                if (!pageBreak && availableHeight < rowHeight) {
                    if (availableHeight > 40.0f && rowHeight > 40.0f) {
                        this.log.finest("- Split (leave on current) Row=" + dataRow + " - Available=" + availableHeight + ", RowHeight=" + rowHeight);
                    }
                    pageBreak = true;
                }
                if (pageBreak) {
                    availableHeight = firstPage ? this.m_firstPage.height : this.m_nextPages.height;
                    this.m_firstRowOnPage.add(new Integer(dataRow + addlRows));
                    if (!firstPage) {
                        this.m_pageHeight.add(new Float(usedHeight));
                        this.log.finest("Page Y=" + this.m_pageHeight.size() + " - PageHeight=" + usedHeight);
                    }
                    this.log.finest("Page Y=" + this.m_firstRowOnPage.size() + " - Row=" + dataRow + " - force=" + this.isPageBreak(dataRow));
                    firstPage = false;
                    availableHeight -= (float)this.m_headerHeight;
                    usedHeight += (float)this.m_headerHeight;
                }
                availableHeight -= rowHeight;
                usedHeight += rowHeight;
                if (availableHeight < 0.0f) {
                    this.log.finest("- Split (move to next) Row=" + dataRow + " - Available=" + availableHeight + ", RowHeight=" + rowHeight);
                }
                this.log.finest("Page Y=" + this.m_pageHeight.size() + ", Row=" + dataRow + ",AddlRows=" + addlRows + ", Height=" + rowHeight + " - Available=" + availableHeight + ", Used=" + usedHeight);
                ++dataRow;
            }
            this.m_pageHeight.add(new Float(usedHeight));
            this.log.finest("Page Y=" + this.m_pageHeight.size() + " - PageHeight=" + usedHeight);
        }
        if ((float)this.m_firstPage.width >= this.p_width) {
            this.log.finest("Page X=1 - PageWidth=" + this.m_firstPage.width + " - TableWidth=" + this.p_width);
            this.m_firstColumnOnPage.add(new Integer(0));
            this.distributeColumns(this.m_firstPage.width - (int)this.p_width, 0, this.m_columnWidths.size());
        } else {
            int availableWidth = 0;
            int lastStart = 0;
            int col2 = 0;
            while (col2 < this.m_columnWidths.size()) {
                int columnWidth = this.m_columnWidths.get(col2).intValue();
                if (availableWidth < columnWidth) {
                    if (col2 != 0) {
                        this.distributeColumns(availableWidth, lastStart, col2);
                    }
                    this.m_firstColumnOnPage.add(new Integer(col2));
                    this.log.finest("Page X=" + this.m_firstColumnOnPage.size() + " - Col=" + col2);
                    lastStart = col2;
                    availableWidth = this.m_firstPage.width;
                    int repCol = 0;
                    while (repCol < this.m_repeatedColumns && col2 > repCol) {
                        float repColumnWidth = this.m_columnWidths.get(repCol).floatValue();
                        if ((double)availableWidth < (double)this.m_firstPage.width * 0.5) break;
                        availableWidth = (int)((float)availableWidth - repColumnWidth);
                        ++repCol;
                    }
                }
                availableWidth -= columnWidth;
                ++col2;
            }
        }
        this.log.fine("Pages=" + this.getPageCount() + " X=" + this.m_firstColumnOnPage.size() + "/Y=" + this.m_firstRowOnPage.size() + " - Width=" + this.p_width + ", Height=" + this.p_height);
        return true;
    }

    private void distributeColumns(int availableWidth, int fromCol, int toCol) {
        this.log.finest("Available=" + availableWidth + ", Columns " + fromCol + "->" + toCol);
        int start = fromCol;
        if (fromCol == 0 && this.m_repeatedColumns > 0) {
            start = this.m_repeatedColumns;
        }
        int totalWidth = availableWidth;
        int col = start;
        while (col < toCol) {
            totalWidth = (int)((float)totalWidth + this.m_columnWidths.get(col).floatValue());
            ++col;
        }
        int remainingWidth = availableWidth;
        int x = 0;
        while (remainingWidth > 0 && x < 5) {
            this.log.finest("TotalWidth=" + totalWidth + ", Remaining=" + remainingWidth);
            int col2 = start;
            while (col2 < toCol && remainingWidth != 0) {
                int columnWidth = this.m_columnWidths.get(col2).intValue();
                if (columnWidth != 0) {
                    int additionalPart = columnWidth * availableWidth / totalWidth;
                    if (remainingWidth < additionalPart) {
                        this.m_columnWidths.set(col2, new Float(columnWidth + remainingWidth));
                        remainingWidth = 0;
                    } else {
                        this.m_columnWidths.set(col2, new Float(columnWidth + additionalPart));
                        remainingWidth -= additionalPart;
                    }
                    this.log.finest("  col=" + col2 + " - From " + columnWidth + " to " + this.m_columnWidths.get(col2));
                }
                ++col2;
            }
            ++x;
        }
        int c = toCol - 1;
        while (remainingWidth != 0 && c >= 0) {
            int columnWidth = this.m_columnWidths.get(c).intValue();
            if (columnWidth > 0) {
                this.m_columnWidths.set(c, new Float(columnWidth + remainingWidth));
                this.log.finest("Final col=" + c + " - From " + columnWidth + " to " + this.m_columnWidths.get(c));
                remainingWidth = 0;
            }
            --c;
        }
    }

    private boolean isPageBreak(int row) {
        int i = 0;
        while (i < this.m_pageBreak.size()) {
            Integer rr = this.m_pageBreak.get(i);
            if (rr + 1 == row) {
                return true;
            }
            if (rr > row) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public void setHeightToLastPage() {
        int lastLayoutPage = this.getPageCount() + this.m_pageNoStart - 1;
        this.log.fine("PageCount - Table=" + this.getPageCount() + "(Start=" + this.m_pageNoStart + ") Layout=" + lastLayoutPage + " - Old Height=" + this.p_height);
        this.p_height = this.getHeight(lastLayoutPage);
        this.log.fine("New Height=" + this.p_height);
    }

    private Font getFont(int row, int col) {
        Font font = this.m_rowColFont.get(new Point(row, col));
        if (font != null) {
            return font;
        }
        font = this.m_rowColFont.get(new Point(row, -1));
        if (font != null) {
            return font;
        }
        font = this.m_rowColFont.get(new Point(-1, col));
        if (font != null) {
            return font;
        }
        return this.m_baseFont;
    }

    private Color getColor(int row, int col) {
        Color color = this.m_rowColColor.get(new Point(row, col));
        if (color != null) {
            return color;
        }
        color = this.m_rowColColor.get(new Point(row, -1));
        if (color != null) {
            return color;
        }
        color = this.m_rowColColor.get(new Point(-1, col));
        if (color != null) {
            return color;
        }
        return this.m_baseColor;
    }

    private Color getBackground(int row, int col) {
        Color color = this.m_rowColBackground.get(new Point(row, col));
        if (color != null) {
            return color;
        }
        color = this.m_rowColBackground.get(new Point(row, -1));
        if (color != null) {
            return color;
        }
        color = this.m_rowColBackground.get(new Point(-1, col));
        if (color != null) {
            return color;
        }
        return this.m_baseBackground;
    }

    public float getHeight(int pageNo) {
        int pageIndex = this.getPageIndex(pageNo);
        int pageYindex = this.getPageYIndex(pageIndex);
        this.log.fine("Page=" + pageNo + " - PageIndex=" + pageIndex + ", PageYindex=" + pageYindex);
        float pageHeight = this.m_pageHeight.get(pageYindex).floatValue();
        float pageHeightPrevious = 0.0f;
        if (pageYindex > 0) {
            pageHeightPrevious = this.m_pageHeight.get(pageYindex - 1).floatValue();
        }
        float retValue = pageHeight - pageHeightPrevious;
        this.log.fine("Page=" + pageNo + " - PageIndex=" + pageIndex + ", PageYindex=" + pageYindex + ", Height=" + String.valueOf(retValue));
        return retValue;
    }

    public float getWidth(int pageNo) {
        int pageIndex = this.getPageIndex(pageNo);
        if (pageIndex == 0) {
            return this.m_firstPage.width;
        }
        return this.m_nextPages.width;
    }

    public int getPageCount() {
        return this.m_firstRowOnPage.size() * this.m_firstColumnOnPage.size();
    }

    protected int getPageIndex(int pageNo) {
        int index = pageNo - this.m_pageNoStart;
        if (index < 0) {
            this.log.log(Level.SEVERE, "index=" + index, (Throwable)new Exception());
        }
        return index;
    }

    private int getPageNo(int pageIndex) {
        return pageIndex + this.m_pageNoStart;
    }

    protected int getPageXIndex(int pageIndex) {
        int noXpages = this.m_firstColumnOnPage.size();
        int x = pageIndex % noXpages;
        return x;
    }

    protected int getPageXCount() {
        return this.m_firstColumnOnPage.size();
    }

    protected int getPageYIndex(int pageIndex) {
        int noXpages = this.m_firstColumnOnPage.size();
        int y = (pageIndex - pageIndex % noXpages) / noXpages;
        return y;
    }

    protected int getPageYCount() {
        return this.m_firstRowOnPage.size();
    }

    public MQuery getDrillDown(Point relativePoint, int pageNo) {
        if (this.m_rowColDrillDown.size() == 0) {
            return null;
        }
        if (!this.getBounds(pageNo).contains(relativePoint)) {
            return null;
        }
        int row = this.getRow(relativePoint.y, pageNo);
        if (row == -1) {
            return null;
        }
        int col = this.getCol(relativePoint.x, pageNo);
        if (col == -1) {
            return null;
        }
        this.log.fine("Row=" + row + ", Col=" + col + ", PageNo=" + pageNo);
        NamePair pp = this.m_rowColDrillDown.get(new Point(row, col));
        if (pp == null) {
            return null;
        }
        String columnName = MQuery.getZoomColumnName((String)this.m_columnHeader[col].getID());
        String tableName = MQuery.getZoomTableName((String)columnName);
        Object code = pp.getID();
        if (pp instanceof KeyNamePair) {
            code = new Integer(((KeyNamePair)pp).getKey());
        }
        MQuery query = new MQuery(tableName);
        query.addRestriction(columnName, "=", code, null, pp.toString());
        return query;
    }

    public MQuery getDrillAcross(Point relativePoint, int pageNo) {
        if (!this.getBounds(pageNo).contains(relativePoint)) {
            return null;
        }
        int row = this.getRow(relativePoint.y, pageNo);
        if (row == -1) {
            return null;
        }
        this.log.fine("Row=" + row + ", PageNo=" + pageNo);
        if (this.m_pk[row] == null) {
            return null;
        }
        return MQuery.getEqualQuery((String)this.m_pkColumnName, (int)this.m_pk[row].getKey());
    }

    public Rectangle getBounds(int pageNo) {
        int pageIndex = this.getPageIndex(pageNo);
        int pageYindex = this.getPageYIndex(pageIndex);
        if (pageYindex == 0) {
            return this.m_firstPage;
        }
        return this.m_nextPages;
    }

    private int getRow(int yPos, int pageNo) {
        int pageIndex = this.getPageIndex(pageNo);
        int pageYindex = this.getPageYIndex(pageIndex);
        int curY = (pageYindex == 0 ? this.m_firstPage.y : this.m_nextPages.y) + this.m_headerHeight;
        if (yPos < curY) {
            return -1;
        }
        int firstRow = this.m_firstRowOnPage.get(pageYindex);
        int nextPageRow = this.m_data.length;
        if (pageYindex + 1 < this.m_firstRowOnPage.size()) {
            nextPageRow = this.m_firstRowOnPage.get(pageYindex + 1);
        }
        int row = firstRow;
        while (row < nextPageRow) {
            int rowHeight = this.m_rowHeights.get(row).intValue();
            if (yPos >= curY && yPos < curY + rowHeight) {
                return row;
            }
            curY += rowHeight;
            ++row;
        }
        return -1;
    }

    private int getCol(int xPos, int pageNo) {
        int colWidth;
        int curX;
        int pageIndex = this.getPageIndex(pageNo);
        int pageXindex = this.getPageXIndex(pageIndex);
        int n = curX = pageXindex == 0 ? this.m_firstPage.x : this.m_nextPages.x;
        if (xPos < curX) {
            return -1;
        }
        int firstColumn = this.m_firstColumnOnPage.get(pageXindex);
        int nextPageColumn = this.m_columnHeader.length;
        if (pageXindex + 1 < this.m_firstColumnOnPage.size()) {
            nextPageColumn = this.m_firstColumnOnPage.get(pageXindex + 1);
        }
        int regularColumnStart = firstColumn;
        int col = 0;
        while (col < this.m_repeatedColumns) {
            colWidth = this.m_columnWidths.get(col).intValue();
            if (xPos >= curX && xPos < curX + colWidth) {
                return col;
            }
            curX += colWidth;
            if (regularColumnStart == col) {
                ++regularColumnStart;
            }
            ++col;
        }
        col = regularColumnStart;
        while (col < nextPageColumn) {
            colWidth = this.m_columnWidths.get(col).intValue();
            if (xPos >= curX && xPos < curX + colWidth) {
                return col;
            }
            curX += colWidth;
            ++col;
        }
        return -1;
    }

    public void paint(Graphics2D g2D, int pageNo, Point2D pageStart, Properties ctx, boolean isView) {
        int colWidth;
        int pageIndex = this.getPageIndex(pageNo);
        int pageXindex = this.getPageXIndex(pageIndex);
        int pageYindex = this.getPageYIndex(pageIndex);
        int firstColumn = this.m_firstColumnOnPage.get(pageXindex);
        int nextPageColumn = this.m_columnHeader.length;
        if (pageXindex + 1 < this.m_firstColumnOnPage.size()) {
            nextPageColumn = this.m_firstColumnOnPage.get(pageXindex + 1);
        }
        int firstRow = this.m_firstRowOnPage.get(pageYindex);
        int nextPageRow = this.m_data.length;
        if (pageYindex + 1 < this.m_firstRowOnPage.size()) {
            nextPageRow = this.m_firstRowOnPage.get(pageYindex + 1);
        }
        int startX = (int)pageStart.getX();
        int startY = (int)pageStart.getY();
        startX += pageXindex == 0 ? this.m_firstPage.x : this.m_nextPages.x;
        startY += pageYindex == 0 ? this.m_firstPage.y : this.m_nextPages.y;
        boolean firstColumnPrint = true;
        int regularColumnStart = firstColumn;
        int col = 0;
        while (col < this.m_repeatedColumns && col < this.m_columnWidths.size()) {
            colWidth = this.m_columnWidths.get(col).intValue();
            if (colWidth != 0) {
                this.printColumn(g2D, col, startX, startY, firstColumnPrint, firstRow, nextPageRow, isView);
                startX += colWidth;
                firstColumnPrint = false;
            }
            if (regularColumnStart == col) {
                ++regularColumnStart;
            }
            ++col;
        }
        col = regularColumnStart;
        while (col < nextPageColumn) {
            colWidth = this.m_columnWidths.get(col).intValue();
            if (colWidth != 0) {
                this.printColumn(g2D, col, startX, startY, firstColumnPrint, firstRow, nextPageRow, isView);
                startX += colWidth;
                firstColumnPrint = false;
            }
            ++col;
        }
    }

    private void printColumn(Graphics2D g2D, int col, int origX, int origY, boolean leftVline, int firstRow, int nextPageRow, boolean isView) {
        int curX = origX;
        int curY = origY;
        float colWidth = this.m_columnWidths.get(col).floatValue();
        float netWidth = colWidth - 4.0f - this.m_tFormat.getVLineStroke().floatValue();
        if (leftVline) {
            netWidth -= this.m_tFormat.getVLineStroke().floatValue();
        }
        int rowHeight = this.m_headerHeight;
        float netHeight = (float)rowHeight - 4.0f * this.m_tFormat.getLineStroke().floatValue() + 4.0f;
        String alignment = this.m_columnJustification[col];
        if (leftVline) {
            g2D.setPaint(this.m_tFormat.getVLine_Color());
            g2D.setStroke(this.m_tFormat.getVLine_Stroke());
            if (this.m_tFormat.isPaintBoundaryLines()) {
                g2D.drawLine(origX, (int)((float)origY + this.m_tFormat.getLineStroke().floatValue()), origX, (int)((float)(origY + rowHeight) - 4.0f * this.m_tFormat.getLineStroke().floatValue()));
            }
            curX = (int)((float)curX + this.m_tFormat.getVLineStroke().floatValue());
        }
        if (this.m_tFormat.isPaintHeaderLines()) {
            g2D.setPaint(this.m_tFormat.getHeaderLine_Color());
            g2D.setStroke(this.m_tFormat.getHeader_Stroke());
            g2D.drawLine(origX, origY, (int)((float)origX + colWidth - this.m_tFormat.getVLineStroke().floatValue()), origY);
        }
        curY = (int)((float)curY + 2.0f * this.m_tFormat.getLineStroke().floatValue());
        Color bg = this.getBackground(-2, col);
        if (!bg.equals(Color.white)) {
            g2D.setPaint(bg);
            g2D.fillRect(curX, (int)((float)curY - this.m_tFormat.getLineStroke().floatValue()), (int)(colWidth - this.m_tFormat.getVLineStroke().floatValue()), (int)((float)rowHeight - 4.0f * this.m_tFormat.getLineStroke().floatValue()));
        }
        int tempCurY = curY;
        curX += 2;
        curY += 2;
        AttributedString aString = null;
        AttributedCharacterIterator iter = null;
        LineBreakMeasurer measurer = null;
        float usedHeight = 0.0f;
        String headerString = this.m_columnHeader[col].toString();
        if (headerString.length() == 0) {
            headerString = " ";
        }
        aString = new AttributedString(headerString);
        aString.addAttribute(TextAttribute.FONT, this.getFont(-2, col));
        aString.addAttribute(TextAttribute.FOREGROUND, this.getColor(-2, col));
        boolean fastDraw = LayoutEngine.s_FASTDRAW;
        if (fastDraw && !isView && !Util.is8Bit((String)headerString)) {
            fastDraw = false;
        }
        iter = aString.getIterator();
        measurer = new LineBreakMeasurer(iter, g2D.getFontRenderContext());
        while (measurer.getPosition() < iter.getEndIndex()) {
            TextLayout layout = measurer.nextLayout(netWidth + 2.0f);
            if (iter.getEndIndex() != measurer.getPosition()) {
                fastDraw = false;
            }
            float lineHeight = layout.getAscent() + layout.getDescent() + layout.getLeading();
            if (alignment.equals("B")) {
                layout = layout.getJustifiedLayout(netWidth + 2.0f);
                fastDraw = false;
            }
            curY = (int)((float)curY + layout.getAscent());
            float penX = curX;
            if (alignment.equals("C")) {
                penX += (netWidth - layout.getAdvance()) / 2.0f;
            } else if (alignment.equals("T") && layout.isLeftToRight() || alignment.equals("L") && !layout.isLeftToRight()) {
                penX += netWidth - layout.getAdvance();
            }
            if (fastDraw) {
                g2D.setFont(this.getFont(-2, col));
                g2D.setColor(this.getColor(-2, col));
                g2D.drawString(iter, penX, (float)curY);
            } else {
                layout.draw(g2D, penX, curY);
            }
            curY = (int)((float)curY + (layout.getDescent() + layout.getLeading()));
            usedHeight += layout.getAscent() + layout.getDescent();
            if (!this.m_multiLineHeader) break;
        }
        curX = (int)((float)curX + (netWidth + 2.0f));
        curY = tempCurY + (int)((float)rowHeight - 4.0f * this.m_tFormat.getLineStroke().floatValue());
        g2D.setPaint(this.m_tFormat.getVLine_Color());
        g2D.setStroke(this.m_tFormat.getVLine_Stroke());
        if (this.m_tFormat.isPaintVLines()) {
            g2D.drawLine(curX, (int)((float)origY + this.m_tFormat.getLineStroke().floatValue()), curX, (int)((float)(origY + rowHeight) - 4.0f * this.m_tFormat.getLineStroke().floatValue()));
        }
        curX = (int)((float)curX + this.m_tFormat.getVLineStroke().floatValue());
        if (this.m_tFormat.isPaintHeaderLines()) {
            g2D.setPaint(this.m_tFormat.getHeaderLine_Color());
            g2D.setStroke(this.m_tFormat.getHeader_Stroke());
            g2D.drawLine(origX, curY, (int)((float)origX + colWidth - this.m_tFormat.getVLineStroke().floatValue()), curY);
        }
        curY = (int)((float)curY + 2.0f * this.m_tFormat.getLineStroke().floatValue());
        int row = firstRow;
        while (row < nextPageRow) {
            rowHeight = this.m_rowHeights.get(row).intValue();
            netHeight = (float)(rowHeight - 4) - this.m_tFormat.getLineStroke().floatValue();
            int rowYstart = curY;
            curX = origX;
            if (leftVline) {
                g2D.setPaint(this.m_tFormat.getVLine_Color());
                g2D.setStroke(this.m_tFormat.getVLine_Stroke());
                if (this.m_tFormat.isPaintBoundaryLines()) {
                    g2D.drawLine(curX, rowYstart, curX, (int)((float)(rowYstart + rowHeight) - this.m_tFormat.getLineStroke().floatValue()));
                }
                curX = (int)((float)curX + this.m_tFormat.getVLineStroke().floatValue());
            }
            if (!(bg = this.getBackground(row, col)).equals(Color.white)) {
                g2D.setPaint(bg);
                g2D.fillRect(curX, curY, (int)(colWidth - this.m_tFormat.getVLineStroke().floatValue()), (int)((float)rowHeight - this.m_tFormat.getLineStroke().floatValue()));
            }
            curX += 2;
            Object[] printItems = this.getPrintItems(row, col);
            float penY = curY += 2;
            boolean suppress = false;
            if (this.m_colSuppressRepeats[col] && row > 0 && row != firstRow) {
                Object[] lastItems = new Object[]{};
                lastItems = this.getPrintItems(row - 1, col);
                if (Arrays.equals(lastItems, printItems)) {
                    suppress = true;
                }
            }
            if (!suppress) {
                int index = 0;
                while (index < printItems.length) {
                    block66: {
                        if (printItems[index] != null) {
                            if (printItems[index] instanceof ImageElement) {
                                Image imageToDraw = ((ImageElement)printItems[index]).getImage();
                                if (imageToDraw != null) {
                                    double scale = ((ImageElement)printItems[index]).getScaleFactor();
                                    if (scale != 1.0) {
                                        AffineTransform transform = new AffineTransform();
                                        transform.translate(curX, penY);
                                        transform.scale(scale, scale);
                                        g2D.drawImage(imageToDraw, transform, (ImageObserver)((Object)this));
                                    } else {
                                        g2D.drawImage(imageToDraw, curX, (int)penY, (ImageObserver)((Object)this));
                                    }
                                }
                            } else if (printItems[index] instanceof BarcodeElement) {
                                try {
                                    Barcode barcode = ((BarcodeElement)printItems[index]).getBarcode();
                                    if (barcode == null) break block66;
                                    double scale = ((BarcodeElement)printItems[index]).getScaleFactor();
                                    if (scale != 1.0) {
                                        int w = barcode.getWidth();
                                        int h = barcode.getHeight();
                                        BufferedImage image = new BufferedImage(w, h, 2);
                                        Graphics2D temp = (Graphics2D)image.getGraphics();
                                        barcode.draw(temp, 0, 0);
                                        AffineTransform transform = new AffineTransform();
                                        transform.translate(curX, penY);
                                        transform.scale(scale, scale);
                                        g2D.drawImage(image, transform, (ImageObserver)((Object)this));
                                        break block66;
                                    }
                                    barcode.draw(g2D, curX, (int)penY);
                                }
                                catch (OutputException barcode) {}
                            } else if (printItems[index] instanceof Boolean) {
                                int penX = curX + (int)((netWidth - (float)LayoutEngine.IMAGE_SIZE.width) / 2.0f);
                                if (((Boolean)printItems[index]).booleanValue()) {
                                    g2D.drawImage(LayoutEngine.IMAGE_TRUE, penX, (int)penY, (ImageObserver)((Object)this));
                                } else {
                                    g2D.drawImage(LayoutEngine.IMAGE_FALSE, penX, (int)penY, (ImageObserver)((Object)this));
                                }
                                penY += (float)LayoutEngine.IMAGE_SIZE.height;
                            } else if (printItems[index] instanceof HTMLRenderer) {
                                HTMLRenderer renderer = (HTMLRenderer)printItems[index];
                                Rectangle allocation = new Rectangle((int)colWidth, (int)netHeight);
                                g2D.translate((double)curX, penY);
                                renderer.paint((Graphics)g2D, (Shape)allocation);
                                g2D.translate((double)(-curX), -penY);
                                penY = (float)((double)penY + allocation.getHeight());
                            } else {
                                String str = printItems[index].toString();
                                if (str.length() > 0) {
                                    usedHeight = 0.0f;
                                    String[] lines = Pattern.compile("$", 8).split(str);
                                    int lineNo = 0;
                                    while (lineNo < lines.length) {
                                        aString = new AttributedString(lines[lineNo]);
                                        aString.addAttribute(TextAttribute.FONT, this.getFont(row, col));
                                        if (isView && printItems[index] instanceof NamePair) {
                                            aString.addAttribute(TextAttribute.FOREGROUND, LINK_COLOR);
                                            aString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL, 0, lines[lineNo].length());
                                        } else {
                                            aString.addAttribute(TextAttribute.FOREGROUND, this.getColor(row, col));
                                        }
                                        iter = aString.getIterator();
                                        boolean fastDraw2 = LayoutEngine.s_FASTDRAW;
                                        if (fastDraw2 && !isView && !Util.is8Bit((String)lines[lineNo])) {
                                            fastDraw2 = false;
                                        }
                                        measurer = new LineBreakMeasurer(iter, g2D.getFontRenderContext());
                                        while (measurer.getPosition() < iter.getEndIndex()) {
                                            TextLayout layout = measurer.nextLayout(netWidth + 2.0f);
                                            if (iter.getEndIndex() != measurer.getPosition()) {
                                                fastDraw2 = false;
                                            }
                                            float lineHeight = layout.getAscent() + layout.getDescent() + layout.getLeading();
                                            if (this.m_columnMaxHeight[col] > 0 && !(usedHeight + lineHeight <= (float)this.m_columnMaxHeight[col]) || !(usedHeight + lineHeight <= netHeight)) continue;
                                            if (alignment.equals("B") && measurer.getPosition() < iter.getEndIndex()) {
                                                layout = layout.getJustifiedLayout(netWidth + 2.0f);
                                                fastDraw2 = false;
                                            }
                                            penY += layout.getAscent();
                                            float penX = curX;
                                            if (alignment.equals("C")) {
                                                penX += (netWidth - layout.getAdvance()) / 2.0f;
                                            } else if (alignment.equals("T") && layout.isLeftToRight() || alignment.equals("L") && !layout.isLeftToRight()) {
                                                penX += netWidth - layout.getAdvance();
                                            }
                                            if (fastDraw2) {
                                                g2D.setFont(this.getFont(row, col));
                                                if (isView && printItems[index] instanceof NamePair) {
                                                    g2D.setColor(LINK_COLOR);
                                                } else {
                                                    g2D.setColor(this.getColor(row, col));
                                                }
                                                g2D.drawString(iter, penX, penY);
                                            } else {
                                                layout.draw(g2D, penX, penY);
                                            }
                                            penY += layout.getDescent() + layout.getLeading();
                                            usedHeight += lineHeight;
                                            if (this.m_columnMaxHeight[col] == -1) break;
                                        }
                                        ++lineNo;
                                    }
                                }
                            }
                        }
                    }
                    ++index;
                }
            }
            curY = (int)((float)curY + (netHeight + 2.0f));
            curX = (int)((float)curX + (netWidth + 2.0f));
            g2D.setPaint(this.m_tFormat.getVLine_Color());
            g2D.setStroke(this.m_tFormat.getVLine_Stroke());
            if (this.m_tFormat.isPaintVLines()) {
                g2D.drawLine(curX, rowYstart, curX, (int)((float)(rowYstart + rowHeight) - this.m_tFormat.getLineStroke().floatValue()));
            }
            curX = (int)((float)curX + this.m_tFormat.getVLineStroke().floatValue());
            if (row == this.m_data.length - 1) {
                if (this.m_tFormat.isPaintHeaderLines()) {
                    g2D.setPaint(this.m_tFormat.getHeaderLine_Color());
                    g2D.setStroke(this.m_tFormat.getHeader_Stroke());
                    g2D.drawLine(origX, curY, (int)((float)origX + colWidth - this.m_tFormat.getVLineStroke().floatValue()), curY);
                    curY = (int)((float)curY + 2.0f * this.m_tFormat.getLineStroke().floatValue());
                } else {
                    curY = (int)((float)curY + this.m_tFormat.getLineStroke().floatValue());
                }
            } else {
                boolean nextIsFunction = this.m_functionRows.contains(new Integer(row + 1));
                if (nextIsFunction && this.m_functionRows.contains(new Integer(row))) {
                    nextIsFunction = false;
                }
                if (nextIsFunction) {
                    g2D.setPaint(this.m_tFormat.getFunctFG_Color());
                    g2D.setStroke(this.m_tFormat.getHLine_Stroke());
                    g2D.drawLine(origX, curY, (int)((float)origX + colWidth - this.m_tFormat.getVLineStroke().floatValue()), curY);
                } else if (this.m_tFormat.isPaintHLines()) {
                    g2D.setPaint(this.m_tFormat.getHLine_Color());
                    g2D.setStroke(this.m_tFormat.getHLine_Stroke());
                    g2D.drawLine(origX, curY, (int)((float)origX + colWidth - this.m_tFormat.getVLineStroke().floatValue()), curY);
                }
                curY = (int)((float)curY + this.m_tFormat.getLineStroke().floatValue());
            }
            ++row;
        }
    }

    private void addPrintLines(int row, int col, Object data) {
        while (this.m_printRows.size() <= row) {
            this.m_printRows.add(null);
        }
        ArrayList<ArrayList<Object>> columns = this.m_printRows.get(row);
        if (columns == null) {
            columns = new ArrayList(this.m_columnHeader.length);
        }
        while (columns.size() <= col) {
            columns.add(null);
        }
        ArrayList<Object> coordinate = columns.get(col);
        if (coordinate == null) {
            coordinate = new ArrayList();
        }
        coordinate.add(data);
        columns.set(col, coordinate);
        this.m_printRows.set(row, columns);
        this.log.finest("row=" + row + ", col=" + col + " - Rows=" + this.m_printRows.size() + ", Cols=" + columns.size() + " - " + data);
    }

    private void insertRow(int currentRow) {
    }

    private Object[] getPrintItems(int row, int col) {
        ArrayList<ArrayList<Object>> columns = null;
        if (this.m_printRows.size() > row) {
            columns = this.m_printRows.get(row);
        }
        if (columns == null) {
            return new Object[0];
        }
        ArrayList<Object> coordinate = null;
        if (columns.size() > col) {
            coordinate = columns.get(col);
        }
        if (coordinate == null) {
            return new Object[0];
        }
        return coordinate.toArray();
    }
}

