/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.awt.Point;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MProduct;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUOM;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_UOM_Conversion;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;

public class MUOMConversion
extends X_C_UOM_Conversion {
    private static final long serialVersionUID = -8449239579085422641L;
    private static final CLogger s_log = CLogger.getCLogger(MUOMConversion.class);
    private static CCache<Point, BigDecimal> s_conversions = null;
    private static final CCache<Integer, MUOMConversion[]> s_conversionProduct = new CCache("C_UOMConversion", 20);

    public static BigDecimal convert(Properties ctx, int C_UOM_ID, int C_UOM_To_ID, BigDecimal qty, boolean bRound) {
        if (qty == null || qty.compareTo(Env.ZERO) == 0 || C_UOM_ID == C_UOM_To_ID) {
            return qty;
        }
        BigDecimal retValue = MUOMConversion.getRate(ctx, C_UOM_ID, C_UOM_To_ID);
        if (retValue != null) {
            MUOM uom;
            retValue = retValue.multiply(qty);
            if (bRound && (uom = MUOM.get((Properties)ctx, (int)C_UOM_To_ID)) != null) {
                retValue = uom.round(retValue, true);
            }
        }
        return retValue;
    }

    public static BigDecimal convert(Properties ctx, int C_UOM_ID, int C_UOM_To_ID, BigDecimal qty) {
        return MUOMConversion.convert(ctx, C_UOM_ID, C_UOM_To_ID, qty, true);
    }

    public static BigDecimal getRate(Properties ctx, int C_UOM_ID, int C_UOM_To_ID) {
        if (C_UOM_ID == C_UOM_To_ID) {
            return Env.ONE;
        }
        Point p = new Point(C_UOM_ID, C_UOM_To_ID);
        BigDecimal retValue = MUOMConversion.getRate(ctx, p);
        return retValue;
    }

    public static int convertToMinutes(Properties ctx, int C_UOM_ID, BigDecimal qty) {
        if (qty == null) {
            return 0;
        }
        int C_UOM_To_ID = MUOM.getMinute_UOM_ID((Properties)ctx);
        if (C_UOM_ID == C_UOM_To_ID) {
            return qty.intValue();
        }
        BigDecimal result = MUOMConversion.convert(ctx, C_UOM_ID, C_UOM_To_ID, qty);
        if (result == null) {
            return 0;
        }
        return result.intValue();
    }

    public static Timestamp getEndDate(Properties ctx, Timestamp startDate, int C_UOM_ID, BigDecimal qty) {
        GregorianCalendar endDate = new GregorianCalendar();
        endDate.setTime(startDate);
        int minutes = MUOMConversion.convertToMinutes(ctx, C_UOM_ID, qty);
        endDate.add(12, minutes);
        Timestamp retValue = new Timestamp(endDate.getTimeInMillis());
        return retValue;
    }

    private static BigDecimal getRate(Properties ctx, Point p) {
        BigDecimal retValue = null;
        if (Ini.isClient()) {
            if (s_conversions == null) {
                MUOMConversion.createRates(ctx);
            }
            retValue = (BigDecimal)s_conversions.get((Object)p);
        } else {
            retValue = MUOMConversion.getRate(p.x, p.y);
        }
        if (retValue != null) {
            return retValue;
        }
        return MUOMConversion.deriveRate(ctx, p.x, p.y);
    }

    private static void createRates(Properties ctx) {
        block8: {
            s_conversions = new CCache("C_UOMConversion", 20);
            String sql = MRole.getDefault(ctx, false).addAccessSQL("SELECT C_UOM_ID, C_UOM_To_ID, MultiplyRate, DivideRate FROM C_UOM_Conversion WHERE IsActive='Y' AND M_Product_ID IS NULL", "C_UOM_Conversion", false, false);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Point p = new Point(rs.getInt(1), rs.getInt(2));
                        BigDecimal mr = rs.getBigDecimal(3);
                        BigDecimal dr = rs.getBigDecimal(4);
                        if (mr != null) {
                            s_conversions.put((Object)p, (Object)mr);
                        }
                        if (dr == null && mr != null) {
                            dr = Env.ONE.divide(mr, 4);
                        }
                        if (dr == null) continue;
                        s_conversions.put((Object)new Point(p.y, p.x), (Object)dr);
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    public static BigDecimal deriveRate(Properties ctx, int C_UOM_ID, int C_UOM_To_ID) {
        if (C_UOM_ID == C_UOM_To_ID) {
            return Env.ONE;
        }
        MUOM from = MUOM.get((Properties)ctx, (int)C_UOM_ID);
        MUOM to = MUOM.get((Properties)ctx, (int)C_UOM_To_ID);
        if (from == null || to == null) {
            return null;
        }
        if (from.isMinute()) {
            if (to.isHour()) {
                return new BigDecimal(0.016666666666666666);
            }
            if (to.isDay()) {
                return new BigDecimal(6.944444444444445E-4);
            }
            if (to.isWorkDay()) {
                return new BigDecimal(0.0020833333333333333);
            }
            if (to.isWeek()) {
                return new BigDecimal(9.92063492063492E-5);
            }
            if (to.isMonth()) {
                return new BigDecimal(2.3148148148148147E-5);
            }
            if (to.isWorkMonth()) {
                return new BigDecimal(1.0416666666666667E-4);
            }
            if (to.isYear()) {
                return new BigDecimal(1.902587519025875E-6);
            }
        }
        if (from.isHour()) {
            if (to.isMinute()) {
                return new BigDecimal(60.0);
            }
            if (to.isDay()) {
                return new BigDecimal(0.041666666666666664);
            }
            if (to.isWorkDay()) {
                return new BigDecimal(0.125);
            }
            if (to.isWeek()) {
                return new BigDecimal(0.005952380952380952);
            }
            if (to.isMonth()) {
                return new BigDecimal(0.001388888888888889);
            }
            if (to.isWorkMonth()) {
                return new BigDecimal(0.00625);
            }
            if (to.isYear()) {
                return new BigDecimal(1.1415525114155251E-4);
            }
        }
        if (from.isDay()) {
            if (to.isMinute()) {
                return new BigDecimal(1440.0);
            }
            if (to.isHour()) {
                return new BigDecimal(24.0);
            }
            if (to.isWorkDay()) {
                return new BigDecimal(3.0);
            }
            if (to.isWeek()) {
                return new BigDecimal(0.14285714285714285);
            }
            if (to.isMonth()) {
                return new BigDecimal(0.03333333333333333);
            }
            if (to.isWorkMonth()) {
                return new BigDecimal(0.05);
            }
            if (to.isYear()) {
                return new BigDecimal(0.0027397260273972603);
            }
        }
        if (from.isWorkDay()) {
            if (to.isMinute()) {
                return new BigDecimal(480.0);
            }
            if (to.isHour()) {
                return new BigDecimal(8.0);
            }
            if (to.isDay()) {
                return new BigDecimal(0.3333333333333333);
            }
            if (to.isWeek()) {
                return new BigDecimal(0.2);
            }
            if (to.isMonth()) {
                return new BigDecimal(0.05);
            }
            if (to.isWorkMonth()) {
                return new BigDecimal(0.05);
            }
            if (to.isYear()) {
                return new BigDecimal(0.004166666666666667);
            }
        }
        if (from.isWeek()) {
            if (to.isMinute()) {
                return new BigDecimal(10080.0);
            }
            if (to.isHour()) {
                return new BigDecimal(168.0);
            }
            if (to.isDay()) {
                return new BigDecimal(7.0);
            }
            if (to.isWorkDay()) {
                return new BigDecimal(5.0);
            }
            if (to.isMonth()) {
                return new BigDecimal(0.25);
            }
            if (to.isWorkMonth()) {
                return new BigDecimal(0.25);
            }
            if (to.isYear()) {
                return new BigDecimal(0.02);
            }
        }
        if (from.isMonth()) {
            if (to.isMinute()) {
                return new BigDecimal(43200.0);
            }
            if (to.isHour()) {
                return new BigDecimal(720.0);
            }
            if (to.isDay()) {
                return new BigDecimal(30.0);
            }
            if (to.isWorkDay()) {
                return new BigDecimal(20.0);
            }
            if (to.isWeek()) {
                return new BigDecimal(4.0);
            }
            if (to.isWorkMonth()) {
                return new BigDecimal(1.5);
            }
            if (to.isYear()) {
                return new BigDecimal(0.08333333333333333);
            }
        }
        if (from.isWorkMonth()) {
            if (to.isMinute()) {
                return new BigDecimal(9600.0);
            }
            if (to.isHour()) {
                return new BigDecimal(160.0);
            }
            if (to.isDay()) {
                return new BigDecimal(20.0);
            }
            if (to.isWorkDay()) {
                return new BigDecimal(20.0);
            }
            if (to.isWeek()) {
                return new BigDecimal(4.0);
            }
            if (to.isMonth()) {
                return new BigDecimal(0.6666666666666666);
            }
            if (to.isYear()) {
                return new BigDecimal(0.08333333333333333);
            }
        }
        if (from.isYear()) {
            if (to.isMinute()) {
                return new BigDecimal(518400.0);
            }
            if (to.isHour()) {
                return new BigDecimal(8640.0);
            }
            if (to.isDay()) {
                return new BigDecimal(365.0);
            }
            if (to.isWorkDay()) {
                return new BigDecimal(240.0);
            }
            if (to.isWeek()) {
                return new BigDecimal(50.0);
            }
            if (to.isMonth()) {
                return new BigDecimal(12.0);
            }
            if (to.isWorkMonth()) {
                return new BigDecimal(12.0);
            }
        }
        return null;
    }

    public static BigDecimal getRate(int C_UOM_ID, int C_UOM_To_ID) {
        if (C_UOM_ID == C_UOM_To_ID) {
            return Env.ONE;
        }
        BigDecimal retValue = null;
        String sql = "SELECT c.MultiplyRate FROM\tC_UOM_Conversion c INNER JOIN C_UOM uomTo ON (c.C_UOM_TO_ID=uomTo.C_UOM_ID) WHERE c.IsActive='Y' AND c.C_UOM_ID=? AND c.C_UOM_TO_ID=?  AND c.M_Product_ID IS NULL ORDER BY c.AD_Client_ID DESC, c.AD_Org_ID DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_UOM_ID);
                pstmt.setInt(2, C_UOM_To_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    retValue = rs.getBigDecimal(1);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return retValue;
    }

    public static BigDecimal convert(int C_UOM_From_ID, int C_UOM_To_ID, BigDecimal qty, boolean StdPrecision) {
        if (qty == null || qty.compareTo(Env.ZERO) == 0 || C_UOM_From_ID == C_UOM_To_ID) {
            return qty;
        }
        BigDecimal retValue = null;
        int precision = 2;
        String sql = "SELECT c.MultiplyRate, uomTo.StdPrecision, uomTo.CostingPrecision FROM\tC_UOM_Conversion c INNER JOIN C_UOM uomTo ON (c.C_UOM_TO_ID=uomTo.C_UOM_ID) WHERE c.IsActive='Y' AND c.C_UOM_ID=? AND c.C_UOM_TO_ID=?  AND c.M_Product_ID IS NULL ORDER BY c.AD_Client_ID DESC, c.AD_Org_ID DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_UOM_From_ID);
                pstmt.setInt(2, C_UOM_To_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    retValue = rs.getBigDecimal(1);
                    precision = rs.getInt(StdPrecision ? 2 : 3);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        if (retValue == null) {
            s_log.info("NOT found - FromUOM=" + C_UOM_From_ID + ", ToUOM=" + C_UOM_To_ID);
            return null;
        }
        if ((retValue = retValue.multiply(qty)).scale() > precision) {
            retValue = retValue.setScale(precision, 4);
        }
        return retValue;
    }

    public static BigDecimal convertProductTo(Properties ctx, int M_Product_ID, int C_UOM_To_ID, BigDecimal qtyPrice, boolean bRound) {
        if (qtyPrice == null || qtyPrice.signum() == 0 || M_Product_ID == 0 || C_UOM_To_ID == 0) {
            return qtyPrice;
        }
        BigDecimal retValue = MUOMConversion.getProductRateTo(ctx, M_Product_ID, C_UOM_To_ID);
        if (retValue == null) {
            MProduct product = MProduct.get((Properties)ctx, (int)M_Product_ID);
            int C_UOM_ID = product.getC_UOM_ID();
            retValue = MUOMConversion.getRate(C_UOM_ID, C_UOM_To_ID);
        }
        if (retValue != null) {
            if (Env.ONE.compareTo(retValue) == 0) {
                retValue = qtyPrice;
            } else {
                MUOM uom;
                retValue = retValue.multiply(qtyPrice);
                if (bRound && (uom = MUOM.get((Properties)ctx, (int)C_UOM_To_ID)) != null) {
                    retValue = uom.round(retValue, true);
                }
            }
        }
        return retValue;
    }

    public static BigDecimal convertProductTo(Properties ctx, int M_Product_ID, int C_UOM_To_ID, BigDecimal qtyPrice) {
        return MUOMConversion.convertProductTo(ctx, M_Product_ID, C_UOM_To_ID, qtyPrice, true);
    }

    public static BigDecimal convertProductTo(Properties ctx, int M_Product_ID, int C_UOM_To_ID, BigDecimal qtyPrice, int precision) {
        if (qtyPrice == null || qtyPrice.signum() == 0 || M_Product_ID == 0 || C_UOM_To_ID == 0) {
            return qtyPrice;
        }
        BigDecimal retValue = MUOMConversion.convertProductTo(ctx, M_Product_ID, C_UOM_To_ID, qtyPrice, false);
        if (retValue != null) {
            retValue = retValue.setScale(precision, 4);
        }
        return retValue;
    }

    public static BigDecimal getProductRateTo(Properties ctx, int M_Product_ID, int C_UOM_To_ID) {
        if (M_Product_ID == 0) {
            return null;
        }
        MUOMConversion[] rates = MUOMConversion.getProductConversions(ctx, M_Product_ID);
        if (rates.length == 0) {
            s_log.fine("None found");
            return null;
        }
        int i = 0;
        while (i < rates.length) {
            MUOMConversion rate = rates[i];
            if (rate.getC_UOM_To_ID() == C_UOM_To_ID) {
                return rate.getMultiplyRate();
            }
            ++i;
        }
        s_log.fine("None applied");
        return null;
    }

    public static BigDecimal convertProductFrom(Properties ctx, int M_Product_ID, int C_UOM_To_ID, BigDecimal qtyPrice, boolean bRound) {
        if (qtyPrice == null || qtyPrice.compareTo(Env.ZERO) == 0 || C_UOM_To_ID == 0 || M_Product_ID == 0) {
            s_log.fine("No Conversion - QtyPrice=" + qtyPrice);
            return qtyPrice;
        }
        BigDecimal retValue = MUOMConversion.getProductRateFrom(ctx, M_Product_ID, C_UOM_To_ID);
        if (retValue == null) {
            MProduct product = MProduct.get((Properties)ctx, (int)M_Product_ID);
            int C_UOM_ID = product.getC_UOM_ID();
            retValue = MUOMConversion.getRate(C_UOM_To_ID, C_UOM_ID);
        }
        if (retValue != null) {
            if (Env.ONE.compareTo(retValue) == 0) {
                retValue = qtyPrice;
            } else {
                MUOM uom;
                retValue = retValue.multiply(qtyPrice);
                if (bRound && (uom = MUOM.get((Properties)ctx, (int)C_UOM_To_ID)) != null) {
                    uom.round(retValue, true);
                }
            }
        }
        s_log.fine("No specific Rate M_Product_ID=" + M_Product_ID);
        return retValue;
    }

    public static BigDecimal convertProductFrom(Properties ctx, int M_Product_ID, int C_UOM_To_ID, BigDecimal qtyPrice) {
        return MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, qtyPrice, true);
    }

    public static BigDecimal convertProductFrom(Properties ctx, int M_Product_ID, int C_UOM_To_ID, BigDecimal qtyPrice, int precision) {
        if (qtyPrice == null || qtyPrice.compareTo(Env.ZERO) == 0 || C_UOM_To_ID == 0 || M_Product_ID == 0) {
            s_log.fine("No Conversion - QtyPrice=" + qtyPrice);
            return qtyPrice;
        }
        BigDecimal retValue = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, qtyPrice, false);
        if (retValue != null) {
            retValue = retValue.setScale(precision, 4);
        }
        return retValue;
    }

    public static BigDecimal getProductRateFrom(Properties ctx, int M_Product_ID, int C_UOM_To_ID) {
        MUOMConversion[] rates = MUOMConversion.getProductConversions(ctx, M_Product_ID);
        if (rates.length == 0) {
            s_log.fine("getProductRateFrom - none found");
            return null;
        }
        int i = 0;
        while (i < rates.length) {
            MUOMConversion rate = rates[i];
            if (rate.getC_UOM_To_ID() == C_UOM_To_ID) {
                return rate.getDivideRate();
            }
            ++i;
        }
        s_log.fine("None applied");
        return null;
    }

    public static MUOMConversion[] getProductConversions(Properties ctx, int M_Product_ID) {
        if (M_Product_ID == 0) {
            return new MUOMConversion[0];
        }
        Integer key = new Integer(M_Product_ID);
        MUOMConversion[] result = (MUOMConversion[])s_conversionProduct.get((Object)key);
        if (result != null) {
            return result;
        }
        ArrayList<MUOMConversion> list = new ArrayList<MUOMConversion>();
        MUOMConversion defRate = new MUOMConversion(MProduct.get((Properties)ctx, (int)M_Product_ID));
        list.add(defRate);
        String whereClause = "M_Product_ID=? AND EXISTS (SELECT 1 FROM M_Product p WHERE C_UOM_Conversion.M_Product_ID=p.M_Product_ID AND C_UOM_Conversion.C_UOM_ID=p.C_UOM_ID)";
        List conversions = new Query(ctx, "C_UOM_Conversion", "M_Product_ID=? AND EXISTS (SELECT 1 FROM M_Product p WHERE C_UOM_Conversion.M_Product_ID=p.M_Product_ID AND C_UOM_Conversion.C_UOM_ID=p.C_UOM_ID)", null).setParameters(new Object[]{M_Product_ID}).setOnlyActiveRecords(true).list();
        list.addAll(conversions);
        result = new MUOMConversion[list.size()];
        list.toArray(result);
        s_conversionProduct.put((Object)key, (Object)result);
        s_log.fine("getProductConversions - M_Product_ID=" + M_Product_ID + " #" + result.length);
        return result;
    }

    public MUOMConversion(Properties ctx, int C_UOM_Conversion_ID, String trxName) {
        super(ctx, C_UOM_Conversion_ID, trxName);
    }

    public MUOMConversion(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MUOMConversion(MUOM parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg((PO)parent);
        this.setC_UOM_ID(parent.getC_UOM_ID());
        this.setM_Product_ID(0);
        this.setC_UOM_To_ID(parent.getC_UOM_ID());
        this.setMultiplyRate(Env.ONE);
        this.setDivideRate(Env.ONE);
    }

    public MUOMConversion(MProduct parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg((PO)parent);
        this.setC_UOM_ID(parent.getC_UOM_ID());
        this.setM_Product_ID(parent.getM_Product_ID());
        this.setC_UOM_To_ID(parent.getC_UOM_ID());
        this.setMultiplyRate(Env.ONE);
        this.setDivideRate(Env.ONE);
    }

    protected boolean beforeSave(boolean newRecord) {
        MProduct product;
        if (this.getC_UOM_ID() == this.getC_UOM_To_ID()) {
            this.log.saveError("Error", Msg.parseTranslation((Properties)this.getCtx(), (String)"@C_UOM_ID@ = @C_UOM_To_ID@"));
            return false;
        }
        if (this.getMultiplyRate().compareTo(Env.ZERO) <= 0) {
            this.log.saveError("Error", Msg.parseTranslation((Properties)this.getCtx(), (String)"@MultiplyRate@ <= 0"));
            return false;
        }
        if (MSysConfig.getBooleanValue((String)"ProductUOMConversionUOMValidate", (boolean)true) && this.getM_Product_ID() != 0 && (newRecord || this.is_ValueChanged("M_Product_ID")) && (product = MProduct.get((Properties)this.getCtx(), (int)this.getM_Product_ID())).getC_UOM_ID() != this.getC_UOM_ID()) {
            MUOM uom = MUOM.get((Properties)this.getCtx(), (int)product.getC_UOM_ID());
            this.log.saveError("ProductUOMConversionUOMError", uom.getName());
            return false;
        }
        if (MSysConfig.getBooleanValue((String)"ProductUOMConversionRateValidate", (boolean)true) && this.getM_Product_ID() != 0 && this.getDivideRate().compareTo(Env.ONE) < 0) {
            this.log.saveError("ProductUOMConversionRateError", "");
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MUOMConversion[");
        sb.append(this.get_ID()).append("-C_UOM_ID=").append(this.getC_UOM_ID()).append(",C_UOM_To_ID=").append(this.getC_UOM_To_ID()).append(",M_Product_ID=").append(this.getM_Product_ID()).append("-Multiply=").append(this.getMultiplyRate()).append("/Divide=").append(this.getDivideRate()).append("]");
        return sb.toString();
    }
}

