/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.script.ScriptEngine;
import org.adempiere.apps.graph.GraphColumn;
import org.adempiere.util.MeasureInterface;
import org.compiere.model.MAchievement;
import org.compiere.model.MGoal;
import org.compiere.model.MMeasureCalc;
import org.compiere.model.MProjectType;
import org.compiere.model.MRequestType;
import org.compiere.model.MRole;
import org.compiere.model.MRule;
import org.compiere.model.MStatus;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.X_PA_Measure;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class MMeasure
extends X_PA_Measure {
    private static final long serialVersionUID = 6274990637485210675L;
    private static CCache<Integer, MMeasure> s_cache = new CCache("PA_Measure", 10);

    public static MMeasure get(Properties ctx, int PA_Measure_ID) {
        Integer key = new Integer(PA_Measure_ID);
        MMeasure retValue = (MMeasure)((Object)s_cache.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MMeasure(ctx, PA_Measure_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public MMeasure(Properties ctx, int PA_Measure_ID, String trxName) {
        super(ctx, PA_Measure_ID, trxName);
    }

    public MMeasure(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public ArrayList<GraphColumn> getGraphColumnList(MGoal goal) {
        ArrayList<GraphColumn> list;
        block43: {
            list = new ArrayList<GraphColumn>();
            if ("C".equals(this.getMeasureType())) {
                MMeasureCalc mc = MMeasureCalc.get(this.getCtx(), this.getPA_MeasureCalc_ID());
                String sql = mc.getSqlBarChart(goal.getRestrictions(false), goal.getMeasureDisplay(), this.getMeasureDataType(), goal.getDateFrom(), MRole.getDefault());
                sql = Env.parseContext(this.getCtx(), -1, sql, false);
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, null);
                        rs = pstmt.executeQuery();
                        ArrayList<Timestamp> dataList = new ArrayList<Timestamp>();
                        while (rs.next()) {
                            if (!this.getMeasureDataType().equals("X")) {
                                BigDecimal data = rs.getBigDecimal(1);
                                Timestamp date = rs.getTimestamp(2);
                                GraphColumn bgc = new GraphColumn(mc, data);
                                bgc.setLabel(date, goal.getMeasureDisplay());
                                int pos = 0;
                                int i = 0;
                                while (i < dataList.size()) {
                                    if (((Timestamp)dataList.get(i)).before(date)) {
                                        ++pos;
                                    }
                                    ++i;
                                }
                                dataList.add(date);
                                list.add(pos, bgc);
                                continue;
                            }
                            BigDecimal value = rs.getBigDecimal("VALUE");
                            String series = rs.getString("SERIES");
                            String category = rs.getString("CATEGORY");
                            Timestamp date = rs.getTimestamp("DATEPERIOD");
                            GraphColumn bgc = new GraphColumn(mc, value, series, category);
                            String label = "[" + series + ":" + category + "]";
                            bgc.setLabel(label);
                            list.add(bgc);
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, (Throwable)e);
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block43;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            } else if ("A".equals(this.getMeasureType())) {
                if ("S".equals(this.getMeasureDataType())) {
                    MAchievement[] achievements = MAchievement.get((MMeasure)this);
                    int i = 0;
                    while (i < achievements.length) {
                        MAchievement achievement = achievements[i];
                        GraphColumn bgc = new GraphColumn(achievement);
                        list.add(bgc);
                        ++i;
                    }
                } else {
                    String MeasureDisplay = goal.getMeasureDisplay();
                    String trunc = "D";
                    if ("1".equals(MeasureDisplay)) {
                        trunc = "Y";
                    } else if ("3".equals(MeasureDisplay)) {
                        trunc = "Q";
                    } else if ("5".equals(MeasureDisplay)) {
                        trunc = "MM";
                    } else if ("7".equals(MeasureDisplay)) {
                        trunc = "W";
                    }
                    trunc = "TRUNC(DateDoc,'" + trunc + "')";
                    StringBuffer sql = new StringBuffer("SELECT SUM(ManualActual), ").append(trunc).append(" FROM PA_Achievement WHERE PA_Measure_ID=? AND IsAchieved='Y' ").append("GROUP BY ").append(trunc).append(" ORDER BY ").append(trunc);
                    CPreparedStatement pstmt = null;
                    ResultSet rs = null;
                    try {
                        try {
                            pstmt = DB.prepareStatement((String)sql.toString(), null);
                            pstmt.setInt(1, this.getPA_Measure_ID());
                            rs = pstmt.executeQuery();
                            while (rs.next()) {
                                BigDecimal data = rs.getBigDecimal(1);
                                Timestamp date = rs.getTimestamp(2);
                                GraphColumn bgc = new GraphColumn(goal, data);
                                bgc.setLabel(date, goal.getMeasureDisplay());
                                list.add(bgc);
                            }
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                            DB.close(rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                            break block43;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                }
            } else if ("Q".equals(this.getMeasureType())) {
                MRequestType rt = MRequestType.get((Properties)Env.getCtx(), (int)this.getR_RequestType_ID());
                String sql = rt.getSqlBarChart(goal.getRestrictions(false), goal.getMeasureDisplay(), this.getMeasureDataType(), goal.getDateFrom(), MRole.getDefault());
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, null);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            BigDecimal data = rs.getBigDecimal(1);
                            int R_Status_ID = rs.getInt(3);
                            GraphColumn bgc = new GraphColumn(rt, data, R_Status_ID);
                            if (R_Status_ID == 0) {
                                Timestamp date = rs.getTimestamp(2);
                                bgc.setLabel(date, goal.getMeasureDisplay());
                            } else {
                                MStatus status = MStatus.get((Properties)Env.getCtx(), (int)R_Status_ID);
                                bgc.setLabel(status.getName());
                            }
                            list.add(bgc);
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, (Throwable)e);
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block43;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            } else if ("P".equals(this.getMeasureType())) {
                MProjectType pt = MProjectType.get((Properties)Env.getCtx(), (int)this.getC_ProjectType_ID());
                String sql = pt.getSqlBarChart(goal.getRestrictions(false), goal.getMeasureDisplay(), this.getMeasureDataType(), goal.getDateFrom(), MRole.getDefault());
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, null);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            BigDecimal data = rs.getBigDecimal(1);
                            Timestamp date = rs.getTimestamp(2);
                            int id = rs.getInt(3);
                            GraphColumn bgc = new GraphColumn(pt, data, id);
                            bgc.setLabel(date, goal.getMeasureDisplay());
                            list.add(bgc);
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, (Throwable)e);
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block43;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
        }
        return list;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MMeasure[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    protected boolean beforeSave(boolean newRecord) {
        if ("C".equals(this.getMeasureType()) && this.getPA_MeasureCalc_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement((Properties)this.getCtx(), (String)"PA_MeasureCalc_ID"));
            return false;
        }
        if ("R".equals(this.getMeasureType()) && this.getPA_Ratio_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement((Properties)this.getCtx(), (String)"PA_Ratio_ID"));
            return false;
        }
        if ("U".equals(this.getMeasureType()) && (this.getCalculationClass() == null || this.getCalculationClass().length() == 0)) {
            this.log.saveError("FillMandatory", Msg.getElement((Properties)this.getCtx(), (String)"CalculationClass"));
            return false;
        }
        if ("Q".equals(this.getMeasureType()) && this.getR_RequestType_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement((Properties)this.getCtx(), (String)"R_RequestType_ID"));
            return false;
        }
        if ("P".equals(this.getMeasureType()) && this.getC_ProjectType_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement((Properties)this.getCtx(), (String)"C_ProjectType_ID"));
            return false;
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (success && "M".equals(this.getMeasureType())) {
            this.updateManualGoals();
        }
        return success;
    }

    public boolean updateGoals() {
        String mt = this.getMeasureType();
        try {
            if ("M".equals(mt)) {
                return this.updateManualGoals();
            }
            if ("A".equals(mt)) {
                return this.updateAchievementGoals();
            }
            if ("C".equals(mt)) {
                return this.updateCalculatedGoals();
            }
            if ("R".equals(mt)) {
                return this.updateRatios();
            }
            if ("Q".equals(mt)) {
                return this.updateRequests();
            }
            if ("P".equals(mt)) {
                return this.updateProjects();
            }
            if ("U".equals(mt)) {
                return this.updateUserDefined();
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "MeasureType=" + mt, (Throwable)e);
        }
        return false;
    }

    private boolean updateManualGoals() {
        if (!"M".equals(this.getMeasureType())) {
            return false;
        }
        MGoal[] goals = MGoal.getMeasureGoals(this.getCtx(), this.getPA_Measure_ID());
        int i = 0;
        while (i < goals.length) {
            MGoal goal = goals[i];
            goal.setMeasureActual(this.getManualActual());
            goal.save(this.get_TrxName());
            ++i;
        }
        return true;
    }

    private boolean updateAchievementGoals() {
        if (!"A".equals(this.getMeasureType())) {
            return false;
        }
        Timestamp today = new Timestamp(System.currentTimeMillis());
        MGoal[] goals = MGoal.getMeasureGoals(this.getCtx(), this.getPA_Measure_ID());
        int i = 0;
        while (i < goals.length) {
            MGoal goal = goals[i];
            String MeasureScope = goal.getMeasureScope();
            String trunc = "D";
            if ("1".equals(MeasureScope)) {
                trunc = "Y";
            } else if ("3".equals(MeasureScope)) {
                trunc = "Q";
            } else if ("5".equals(MeasureScope)) {
                trunc = "MM";
            } else if ("7".equals(MeasureScope)) {
                trunc = "W";
            }
            Timestamp compare = TimeUtil.trunc((Timestamp)today, (String)trunc);
            MAchievement[] achievements = MAchievement.getOfMeasure((Properties)this.getCtx(), (int)this.getPA_Measure_ID());
            BigDecimal ManualActual = Env.ZERO;
            int j = 0;
            while (j < achievements.length) {
                Timestamp ach;
                MAchievement achievement = achievements[j];
                if (achievement.isAchieved() && achievement.getDateDoc() != null && compare.equals(ach = TimeUtil.trunc((Timestamp)achievement.getDateDoc(), (String)trunc))) {
                    ManualActual = ManualActual.add(achievement.getManualActual());
                }
                ++j;
            }
            goal.setMeasureActual(ManualActual);
            goal.save(this.get_TrxName());
            ++i;
        }
        return true;
    }

    private boolean updateCalculatedGoals() {
        if (!"C".equals(this.getMeasureType())) {
            return false;
        }
        MGoal[] goals = MGoal.getMeasureGoals(this.getCtx(), this.getPA_Measure_ID());
        int i = 0;
        while (i < goals.length) {
            MMeasureCalc mc;
            MUser user;
            MRole[] roles;
            MGoal goal = goals[i];
            MRole role = null;
            if (goal.getAD_Role_ID() != 0) {
                role = MRole.get(this.getCtx(), goal.getAD_Role_ID());
            } else if (goal.getAD_User_ID() != 0 && (roles = (user = MUser.get((Properties)this.getCtx(), (int)goal.getAD_User_ID())).getRoles(goal.getAD_Org_ID())).length > 0) {
                role = roles[0];
            }
            if (role == null) {
                role = MRole.getDefault(this.getCtx(), false);
            }
            if ((mc = MMeasureCalc.get(this.getCtx(), this.getPA_MeasureCalc_ID())) == null || mc.get_ID() == 0 || mc.get_ID() != this.getPA_MeasureCalc_ID()) {
                this.log.log(Level.SEVERE, "Not found PA_MeasureCalc_ID=" + this.getPA_MeasureCalc_ID());
                return false;
            }
            String sql = mc.getSqlPI(goal.getRestrictions(false), goal.getMeasureScope(), this.getMeasureDataType(), null, role);
            BigDecimal ManualActual = DB.getSQLValueBD(null, (String)sql, (Object[])new Object[0]);
            if (ManualActual == null) {
                ManualActual = Env.ZERO;
                this.log.fine("No Value = " + sql);
            }
            goal.setMeasureActual(ManualActual);
            goal.save(this.get_TrxName());
            ++i;
        }
        return true;
    }

    private boolean updateRatios() {
        if (!"R".equals(this.getMeasureType())) {
            return false;
        }
        return false;
    }

    private boolean updateRequests() {
        if (!"Q".equals(this.getMeasureType()) || this.getR_RequestType_ID() == 0) {
            return false;
        }
        MGoal[] goals = MGoal.getMeasureGoals(this.getCtx(), this.getPA_Measure_ID());
        int i = 0;
        while (i < goals.length) {
            MRequestType rt;
            String sql;
            BigDecimal ManualActual;
            MUser user;
            MRole[] roles;
            MGoal goal = goals[i];
            MRole role = null;
            if (goal.getAD_Role_ID() != 0) {
                role = MRole.get(this.getCtx(), goal.getAD_Role_ID());
            } else if (goal.getAD_User_ID() != 0 && (roles = (user = MUser.get((Properties)this.getCtx(), (int)goal.getAD_User_ID())).getRoles(goal.getAD_Org_ID())).length > 0) {
                role = roles[0];
            }
            if (role == null) {
                role = MRole.getDefault(this.getCtx(), false);
            }
            if ((ManualActual = DB.getSQLValueBD(null, (String)(sql = (rt = MRequestType.get((Properties)this.getCtx(), (int)this.getR_RequestType_ID())).getSqlPI(goal.getRestrictions(false), goal.getMeasureScope(), this.getMeasureDataType(), null, role)), (Object[])new Object[0])) == null) {
                ManualActual = Env.ZERO;
                this.log.fine("No Value = " + sql);
            }
            goal.setMeasureActual(ManualActual);
            goal.save(this.get_TrxName());
            ++i;
        }
        return true;
    }

    private boolean updateProjects() {
        if (!"P".equals(this.getMeasureType()) || this.getC_ProjectType_ID() == 0) {
            return false;
        }
        MGoal[] goals = MGoal.getMeasureGoals(this.getCtx(), this.getPA_Measure_ID());
        int i = 0;
        while (i < goals.length) {
            MProjectType pt;
            String sql;
            BigDecimal ManualActual;
            MUser user;
            MRole[] roles;
            MGoal goal = goals[i];
            MRole role = null;
            if (goal.getAD_Role_ID() != 0) {
                role = MRole.get(this.getCtx(), goal.getAD_Role_ID());
            } else if (goal.getAD_User_ID() != 0 && (roles = (user = MUser.get((Properties)this.getCtx(), (int)goal.getAD_User_ID())).getRoles(goal.getAD_Org_ID())).length > 0) {
                role = roles[0];
            }
            if (role == null) {
                role = MRole.getDefault(this.getCtx(), false);
            }
            if ((ManualActual = DB.getSQLValueBD(null, (String)(sql = (pt = MProjectType.get((Properties)this.getCtx(), (int)this.getC_ProjectType_ID())).getSqlPI(goal.getRestrictions(false), goal.getMeasureScope(), this.getMeasureDataType(), null, role)), (Object[])new Object[0])) == null) {
                ManualActual = Env.ZERO;
                this.log.fine("No Value = " + sql);
            }
            goal.setMeasureActual(ManualActual);
            goal.save(this.get_TrxName());
            ++i;
        }
        return true;
    }

    private boolean updateUserDefined() {
        MGoal[] goals;
        MGoal[] mGoalArray = goals = MGoal.getMeasureGoals(this.getCtx(), this.getPA_Measure_ID());
        int n = goals.length;
        int n2 = 0;
        while (n2 < n) {
            MGoal goal = mGoalArray[n2];
            BigDecimal amt = Env.ZERO;
            PO po = new MTable(this.getCtx(), this.get_Table_ID(), this.get_TrxName()).getPO(this.get_ID(), this.get_TrxName());
            StringTokenizer st = new StringTokenizer(this.getCalculationClass(), ";,", false);
            while (st.hasMoreTokens()) {
                String cmd = st.nextToken().trim();
                String retValue = "";
                if (cmd.toLowerCase().startsWith("@script:")) {
                    MRule rule = MRule.get(this.getCtx(), cmd.substring("@script:".length()));
                    if (rule == null) {
                        retValue = "Script " + cmd + " not found";
                        this.log.log(Level.SEVERE, retValue);
                        break;
                    }
                    if (!rule.getEventType().equals("M") || !rule.getRuleType().equals("S")) {
                        retValue = "Script " + cmd + " must be of type JSR 223 and event measure";
                        this.log.log(Level.SEVERE, retValue);
                        break;
                    }
                    ScriptEngine engine = rule.getScriptEngine();
                    MRule.setContext(engine, po.getCtx(), 0);
                    engine.put("A_Ctx", po.getCtx());
                    engine.put("A_PO", po);
                    try {
                        Object value = engine.eval(rule.getScript());
                        amt = (BigDecimal)value;
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "", (Throwable)e);
                        retValue = "Script Invalid: " + e.toString();
                        return false;
                    }
                }
                MeasureInterface custom = null;
                try {
                    Class<?> clazz = Class.forName(cmd);
                    custom = (MeasureInterface)clazz.newInstance();
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "No custom measure class " + cmd + " - " + e.toString(), (Throwable)e);
                    return false;
                }
                try {
                    amt = custom.getValue();
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, custom.toString(), (Throwable)e);
                    return false;
                }
                if (Util.isEmpty((String)retValue)) continue;
                this.log.severe(retValue);
                return false;
            }
            goal.setMeasureActual(amt);
            goal.save(this.get_TrxName());
            ++n2;
        }
        return true;
    }
}

