/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MInvoiceBatchLine;
import org.compiere.model.MTax;
import org.compiere.model.Tax;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class CalloutInvoiceBatch
extends CalloutEngine {
    public String date(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        mTab.setValue("DateAcct", value);
        this.setDocumentNo(ctx, WindowNo, mTab);
        return "";
    }

    public String bPartner(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_BPartner_ID = (Integer)value;
        if (C_BPartner_ID == null || C_BPartner_ID == 0) {
            return "";
        }
        String sql = "SELECT p.AD_Language,p.C_PaymentTerm_ID, COALESCE(p.M_PriceList_ID,g.M_PriceList_ID) AS M_PriceList_ID, p.PaymentRule,p.POReference, p.SO_Description,p.IsDiscountPrinted, p.SO_CreditLimit, p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable, l.C_BPartner_Location_ID,c.AD_User_ID, COALESCE(p.PO_PriceList_ID,g.PO_PriceList_ID) AS PO_PriceList_ID, p.PaymentRulePO,p.PO_PaymentTerm_ID FROM C_BPartner p INNER JOIN C_BP_Group g ON (p.C_BP_Group_ID=g.C_BP_Group_ID) LEFT OUTER JOIN C_BPartner_Location l ON (p.C_BPartner_ID=l.C_BPartner_ID AND l.IsBillTo='Y' AND l.IsActive='Y') LEFT OUTER JOIN AD_User c ON (p.C_BPartner_ID=c.C_BPartner_ID) WHERE p.C_BPartner_ID=? AND p.IsActive='Y'";
        boolean IsSOTrx = Env.getContext(ctx, WindowNo, "IsSOTrx").equals("Y");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_BPartner_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    double CreditLimit;
                    String cont;
                    String loc;
                    String s = rs.getString(IsSOTrx ? "PaymentRule" : "PaymentRulePO");
                    if (s != null && s.length() != 0) {
                        if (Env.getContext(ctx, WindowNo, "DocBaseType").endsWith("C")) {
                            s = "P";
                        } else if (IsSOTrx && (s.equals("S") || s.equals("U"))) {
                            s = "P";
                        }
                    }
                    Integer ii = new Integer(rs.getInt(IsSOTrx ? "C_PaymentTerm_ID" : "PO_PaymentTerm_ID"));
                    if (!rs.wasNull()) {
                        mTab.setValue("C_PaymentTerm_ID", (Object)ii);
                    }
                    int locID = rs.getInt("C_BPartner_Location_ID");
                    if (C_BPartner_ID.toString().equals(Env.getContext(ctx, WindowNo, 1113, "C_BPartner_ID")) && (loc = Env.getContext(ctx, WindowNo, 1113, "C_BPartner_Location_ID")).length() > 0) {
                        locID = Integer.parseInt(loc);
                    }
                    if (locID == 0) {
                        mTab.setValue("C_BPartner_Location_ID", null);
                    } else {
                        mTab.setValue("C_BPartner_Location_ID", (Object)new Integer(locID));
                    }
                    int contID = rs.getInt("AD_User_ID");
                    if (C_BPartner_ID.toString().equals(Env.getContext(ctx, WindowNo, 1113, "C_BPartner_ID")) && (cont = Env.getContext(ctx, WindowNo, 1113, "AD_User_ID")).length() > 0) {
                        contID = Integer.parseInt(cont);
                    }
                    if (contID == 0) {
                        mTab.setValue("AD_User_ID", null);
                    } else {
                        mTab.setValue("AD_User_ID", (Object)new Integer(contID));
                    }
                    if (IsSOTrx && (CreditLimit = rs.getDouble("SO_CreditLimit")) != 0.0) {
                        double CreditAvailable = rs.getDouble("CreditAvailable");
                        if (!rs.wasNull() && CreditAvailable < 0.0) {
                            mTab.fireDataStatusEEvent("CreditLimitOver", DisplayType.getNumberFormat((int)12).format(CreditAvailable), false);
                        }
                    }
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close((ResultSet)rs, (Statement)pstmt);
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        this.setDocumentNo(ctx, WindowNo, mTab);
        return this.tax(ctx, WindowNo, mTab, mField, value);
    }

    public String docType(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        this.setDocumentNo(ctx, WindowNo, mTab);
        return "";
    }

    private void setDocumentNo(Properties ctx, int WindowNo, GridTab mTab) {
        String sql = "SELECT COALESCE(MAX(C_InvoiceBatchLine_ID),0) FROM C_InvoiceBatchLine WHERE C_InvoiceBatch_ID=?";
        int C_InvoiceBatch_ID = Env.getContextAsInt(ctx, WindowNo, "C_InvoiceBatch_ID");
        int C_InvoiceBatchLine_ID = DB.getSQLValue(null, (String)sql, (int)C_InvoiceBatch_ID);
        if (C_InvoiceBatchLine_ID == 0) {
            return;
        }
        MInvoiceBatchLine last = new MInvoiceBatchLine(Env.getCtx(), C_InvoiceBatchLine_ID, null);
        int C_DocType_ID = Env.getContextAsInt(ctx, WindowNo, "C_DocType_ID");
        int C_BPartner_ID = Env.getContextAsInt(ctx, WindowNo, "C_BPartner_ID");
        if (C_DocType_ID == last.getC_DocType_ID() && C_BPartner_ID == last.getC_BPartner_ID()) {
            return;
        }
        String oldDocNo = last.getDocumentNo();
        if (oldDocNo == null) {
            return;
        }
        int docNo = 0;
        try {
            docNo = Integer.parseInt(oldDocNo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (docNo == 0) {
            return;
        }
        String newDocNo = String.valueOf(docNo + 1);
        mTab.setValue("DocumentNo", (Object)newDocNo);
    }

    public String charge(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Charge_ID = (Integer)value;
        if (C_Charge_ID == null || C_Charge_ID == 0) {
            return "";
        }
        String sql = "SELECT ChargeAmt FROM C_Charge WHERE C_Charge_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_Charge_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    mTab.setValue("PriceEntered", (Object)rs.getBigDecimal(1));
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return this.tax(ctx, WindowNo, mTab, mField, value);
    }

    public String tax(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String column = mField.getColumnName();
        if (value == null) {
            return "";
        }
        int C_Charge_ID = 0;
        C_Charge_ID = column.equals("C_Charge_ID") ? (Integer)value : Env.getContextAsInt(ctx, WindowNo, "C_Charge_ID");
        this.log.fine("C_Charge_ID=" + C_Charge_ID);
        if (C_Charge_ID == 0) {
            return this.amt(ctx, WindowNo, mTab, mField, value);
        }
        int C_BPartner_Location_ID = Env.getContextAsInt(ctx, WindowNo, "C_BPartner_Location_ID");
        if (C_BPartner_Location_ID == 0) {
            return this.amt(ctx, WindowNo, mTab, mField, value);
        }
        this.log.fine("BP_Location=" + C_BPartner_Location_ID);
        Timestamp billDate = Env.getContextAsDate(ctx, WindowNo, "DateInvoiced");
        this.log.fine("Bill Date=" + billDate);
        Timestamp shipDate = billDate;
        this.log.fine("Ship Date=" + shipDate);
        int AD_Org_ID = Env.getContextAsInt(ctx, WindowNo, "AD_Org_ID");
        this.log.fine("Org=" + AD_Org_ID);
        int M_Warehouse_ID = Env.getContextAsInt(ctx, "#M_Warehouse_ID");
        this.log.fine("Warehouse=" + M_Warehouse_ID);
        int C_Tax_ID = Tax.get((Properties)ctx, (int)0, (int)C_Charge_ID, (Timestamp)billDate, (Timestamp)shipDate, (int)AD_Org_ID, (int)M_Warehouse_ID, (int)C_BPartner_Location_ID, (int)C_BPartner_Location_ID, (boolean)Env.getContext(ctx, WindowNo, "IsSOTrx").equals("Y"));
        this.log.info("Tax ID=" + C_Tax_ID);
        if (C_Tax_ID == 0) {
            mTab.fireDataStatusEEvent(CLogger.retrieveError());
        } else {
            mTab.setValue("C_Tax_ID", (Object)new Integer(C_Tax_ID));
        }
        return this.amt(ctx, WindowNo, mTab, mField, value);
    }

    public String amt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal LineNetAmt;
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int StdPrecision = 2;
        BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
        BigDecimal PriceEntered = (BigDecimal)mTab.getValue("PriceEntered");
        this.log.fine("QtyEntered=" + QtyEntered + ", PriceEntered=" + PriceEntered);
        if (QtyEntered == null) {
            QtyEntered = Env.ZERO;
        }
        if (PriceEntered == null) {
            PriceEntered = Env.ZERO;
        }
        if ((LineNetAmt = QtyEntered.multiply(PriceEntered)).scale() > StdPrecision) {
            LineNetAmt = LineNetAmt.setScale(StdPrecision, 4);
        }
        boolean IsSOTrx = "Y".equals(Env.getContext(Env.getCtx(), WindowNo, "IsSOTrx"));
        boolean IsTaxIncluded = "Y".equals(Env.getContext(Env.getCtx(), WindowNo, "IsTaxIncluded"));
        BigDecimal TaxAmt = null;
        if (mField.getColumnName().equals("TaxAmt")) {
            TaxAmt = (BigDecimal)mTab.getValue("TaxAmt");
        } else {
            Integer taxID = (Integer)mTab.getValue("C_Tax_ID");
            if (taxID != null) {
                int C_Tax_ID = taxID;
                MTax tax = new MTax(ctx, C_Tax_ID, null);
                TaxAmt = tax.calculateTax(LineNetAmt, IsTaxIncluded, StdPrecision);
                mTab.setValue("TaxAmt", (Object)TaxAmt);
            }
        }
        if (TaxAmt == null) {
            TaxAmt = Env.ZERO;
        }
        if (IsTaxIncluded) {
            mTab.setValue("LineTotalAmt", (Object)LineNetAmt);
            mTab.setValue("LineNetAmt", (Object)LineNetAmt.subtract(TaxAmt));
        } else {
            mTab.setValue("LineNetAmt", (Object)LineNetAmt);
            mTab.setValue("LineTotalAmt", (Object)LineNetAmt.add(TaxAmt));
        }
        return "";
    }
}

