/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MInOut;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MSequence;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class CalloutInOut
extends CalloutEngine {
    public String order(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Order_ID = (Integer)value;
        if (C_Order_ID == null || C_Order_ID == 0) {
            return "";
        }
        if (this.isCalloutActive()) {
            return "";
        }
        MOrder order = new MOrder(ctx, C_Order_ID, null);
        if (order.get_ID() != 0) {
            mTab.setValue("DateOrdered", (Object)order.getDateOrdered());
            mTab.setValue("POReference", (Object)order.getPOReference());
            if (order.getAD_Org_ID() > 0) {
                mTab.setValue("AD_Org_ID", (Object)new Integer(order.getAD_Org_ID()));
            } else {
                mTab.setValue("AD_Org_ID", null);
            }
            if (order.getAD_OrgTrx_ID() > 0) {
                mTab.setValue("AD_OrgTrx_ID", (Object)new Integer(order.getAD_OrgTrx_ID()));
            } else {
                mTab.setValue("AD_OrgTrx_ID", null);
            }
            if (order.getC_Activity_ID() > 0) {
                mTab.setValue("C_Activity_ID", (Object)new Integer(order.getC_Activity_ID()));
            } else {
                mTab.setValue("C_Activity_ID", null);
            }
            if (order.getC_Campaign_ID() > 0) {
                mTab.setValue("C_Campaign_ID", (Object)new Integer(order.getC_Campaign_ID()));
            } else {
                mTab.setValue("C_Campaign_ID", null);
            }
            if (order.getC_Project_ID() > 0) {
                mTab.setValue("C_Project_ID", (Object)new Integer(order.getC_Project_ID()));
            } else {
                mTab.setValue("C_Project_ID", null);
            }
            if (order.getUser1_ID() > 0) {
                mTab.setValue("User1_ID", (Object)new Integer(order.getUser1_ID()));
            } else {
                mTab.setValue("User1_ID", null);
            }
            if (order.getUser2_ID() > 0) {
                mTab.setValue("User2_ID", (Object)new Integer(order.getUser2_ID()));
            } else {
                mTab.setValue("User2_ID", null);
            }
            if (order.getM_Warehouse_ID() > 0) {
                mTab.setValue("M_Warehouse_ID", (Object)new Integer(order.getM_Warehouse_ID()));
            } else {
                mTab.setValue("M_Warehouse_ID", null);
            }
            mTab.setValue("DeliveryRule", (Object)order.getDeliveryRule());
            mTab.setValue("DeliveryViaRule", (Object)order.getDeliveryViaRule());
            if (order.getM_Shipper_ID() > 0) {
                mTab.setValue("M_Shipper_ID", (Object)new Integer(order.getM_Shipper_ID()));
            } else {
                mTab.setValue("M_Shipper_ID", null);
            }
            mTab.setValue("FreightCostRule", (Object)order.getFreightCostRule());
            mTab.setValue("FreightAmt", (Object)order.getFreightAmt());
            if (order.getC_BPartner_ID() > 0) {
                mTab.setValue("C_BPartner_ID", (Object)new Integer(order.getC_BPartner_ID()));
            } else {
                mTab.setValue("C_BPartner_ID", null);
            }
            if (order.getC_BPartner_Location_ID() > 0) {
                mTab.setValue("C_BPartner_Location_ID", (Object)new Integer(order.getC_BPartner_Location_ID()));
            } else {
                mTab.setValue("C_BPartner_Location_ID", null);
            }
            if (order.getAD_User_ID() > 0) {
                mTab.setValue("AD_User_ID", (Object)new Integer(order.getAD_User_ID()));
            } else {
                mTab.setValue("AD_User_ID", null);
            }
        }
        return "";
    }

    public String rma(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer M_RMA_ID = (Integer)value;
        if (M_RMA_ID == null || M_RMA_ID == 0) {
            return "";
        }
        if (this.isCalloutActive()) {
            return "";
        }
        MRMA rma = new MRMA(ctx, M_RMA_ID.intValue(), null);
        MInOut originalReceipt = rma.getShipment();
        if (rma.get_ID() != 0) {
            mTab.setValue("DateOrdered", (Object)originalReceipt.getDateOrdered());
            mTab.setValue("POReference", (Object)originalReceipt.getPOReference());
            if (originalReceipt.getAD_Org_ID() > 0) {
                mTab.setValue("AD_Org_ID", (Object)new Integer(originalReceipt.getAD_Org_ID()));
            } else {
                mTab.setValue("AD_Org_ID", null);
            }
            if (originalReceipt.getAD_OrgTrx_ID() > 0) {
                mTab.setValue("AD_OrgTrx_ID", (Object)new Integer(originalReceipt.getAD_OrgTrx_ID()));
            } else {
                mTab.setValue("AD_OrgTrx_ID", null);
            }
            if (originalReceipt.getC_Activity_ID() > 0) {
                mTab.setValue("C_Activity_ID", (Object)new Integer(originalReceipt.getC_Activity_ID()));
            } else {
                mTab.setValue("C_Activity_ID", null);
            }
            if (originalReceipt.getC_Campaign_ID() > 0) {
                mTab.setValue("C_Campaign_ID", (Object)new Integer(originalReceipt.getC_Campaign_ID()));
            } else {
                mTab.setValue("C_Campaign_ID", null);
            }
            if (originalReceipt.getC_Project_ID() > 0) {
                mTab.setValue("C_Project_ID", (Object)new Integer(originalReceipt.getC_Project_ID()));
            } else {
                mTab.setValue("C_Project_ID", null);
            }
            if (originalReceipt.getUser1_ID() > 0) {
                mTab.setValue("User1_ID", (Object)new Integer(originalReceipt.getUser1_ID()));
            } else {
                mTab.setValue("User1_ID", null);
            }
            if (originalReceipt.getUser2_ID() > 0) {
                mTab.setValue("User2_ID", (Object)new Integer(originalReceipt.getUser2_ID()));
            } else {
                mTab.setValue("User2_ID", null);
            }
            if (originalReceipt.getM_Warehouse_ID() > 0) {
                mTab.setValue("M_Warehouse_ID", (Object)new Integer(originalReceipt.getM_Warehouse_ID()));
            } else {
                mTab.setValue("M_Warehouse_ID", null);
            }
            mTab.setValue("DeliveryRule", (Object)originalReceipt.getDeliveryRule());
            mTab.setValue("DeliveryViaRule", (Object)originalReceipt.getDeliveryViaRule());
            if (originalReceipt.getM_Shipper_ID() > 0) {
                mTab.setValue("M_Shipper_ID", (Object)new Integer(originalReceipt.getM_Shipper_ID()));
            } else {
                mTab.setValue("M_Shipper_ID", null);
            }
            mTab.setValue("FreightCostRule", (Object)originalReceipt.getFreightCostRule());
            mTab.setValue("FreightAmt", (Object)originalReceipt.getFreightAmt());
            if (originalReceipt.getC_BPartner_ID() > 0) {
                mTab.setValue("C_BPartner_ID", (Object)new Integer(originalReceipt.getC_BPartner_ID()));
            } else {
                mTab.setValue("C_BPartner_ID", null);
            }
            if (originalReceipt.getC_BPartner_Location_ID() > 0) {
                mTab.setValue("C_BPartner_Location_ID", (Object)new Integer(originalReceipt.getC_BPartner_Location_ID()));
            } else {
                mTab.setValue("C_BPartner_Location_ID", null);
            }
            if (originalReceipt.getAD_User_ID() > 0) {
                mTab.setValue("AD_User_ID", (Object)new Integer(originalReceipt.getAD_User_ID()));
            } else {
                mTab.setValue("AD_User_ID", null);
            }
        }
        return "";
    }

    public String docType(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_DocType_ID = (Integer)value;
        if (C_DocType_ID == null || C_DocType_ID == 0) {
            return "";
        }
        String sql = "SELECT d.DocBaseType, d.IsDocNoControlled, s.CurrentNext, s.AD_Sequence_ID, s.StartNewYear, s.DateColumn, d.IsSOTrx FROM C_DocType d LEFT OUTER JOIN AD_Sequence s ON (d.DocNoSequence_ID=s.AD_Sequence_ID) WHERE C_DocType_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                Env.setContext(ctx, WindowNo, "C_DocTypeTarget_ID", C_DocType_ID);
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_DocType_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    boolean IsSOTrx;
                    String DocBaseType = rs.getString("DocBaseType");
                    String trxFlag = rs.getString(7);
                    if (DocBaseType.equals("MMS")) {
                        IsSOTrx = "Y".equals(trxFlag);
                        if (IsSOTrx) {
                            mTab.setValue("MovementType", (Object)"C-");
                        } else {
                            mTab.setValue("MovementType", (Object)"V-");
                        }
                    } else if (DocBaseType.equals("MMR")) {
                        IsSOTrx = "Y".equals(trxFlag);
                        if (IsSOTrx) {
                            mTab.setValue("MovementType", (Object)"C+");
                        } else {
                            mTab.setValue("MovementType", (Object)"V+");
                        }
                    }
                    if (!trxFlag.equals(mTab.getValue("IsSOTrx"))) {
                        mTab.setValue("IsSOTrx", (Object)trxFlag);
                    }
                    if (rs.getString("IsDocNoControlled").equals("Y")) {
                        if ("Y".equals(rs.getString(5))) {
                            String dateColumn = rs.getString(6);
                            int AD_Sequence_ID = rs.getInt(4);
                            mTab.setValue("DocumentNo", (Object)("<" + MSequence.getPreliminaryNoByYear((GridTab)mTab, (int)AD_Sequence_ID, (String)dateColumn, null) + ">"));
                        } else {
                            mTab.setValue("DocumentNo", (Object)("<" + rs.getString("CurrentNext") + ">"));
                        }
                    }
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    public String bpartner(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_BPartner_ID = (Integer)value;
        if (C_BPartner_ID == null || C_BPartner_ID == 0) {
            return "";
        }
        String sql = "SELECT p.AD_Language,p.C_PaymentTerm_ID,p.M_PriceList_ID,p.PaymentRule,p.POReference,p.SO_Description,p.IsDiscountPrinted,p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable,l.C_BPartner_Location_ID,c.AD_User_ID FROM C_BPartner p, C_BPartner_Location l, AD_User c WHERE l.IsActive='Y' AND p.C_BPartner_ID=l.C_BPartner_ID(+) AND p.C_BPartner_ID=c.C_BPartner_ID(+) AND p.C_BPartner_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_BPartner_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    boolean IsSOTrx = "Y".equals(Env.getContext(ctx, WindowNo, "IsSOTrx"));
                    if (!IsSOTrx) {
                        Integer ii = new Integer(rs.getInt("C_BPartner_Location_ID"));
                        if (rs.wasNull()) {
                            mTab.setValue("C_BPartner_Location_ID", null);
                        } else {
                            mTab.setValue("C_BPartner_Location_ID", (Object)ii);
                        }
                        ii = new Integer(rs.getInt("AD_User_ID"));
                        if (rs.wasNull()) {
                            mTab.setValue("AD_User_ID", null);
                        } else {
                            mTab.setValue("AD_User_ID", (Object)ii);
                        }
                    }
                    if (IsSOTrx) {
                        double CreditAvailable = rs.getDouble("CreditAvailable");
                        if (!rs.wasNull() && CreditAvailable < 0.0) {
                            mTab.fireDataStatusEEvent("CreditLimitOver", DisplayType.getNumberFormat((int)12).format(CreditAvailable), false);
                        }
                    }
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close((ResultSet)rs, (Statement)pstmt);
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        return "";
    }

    public String warehouse(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive()) {
            return "";
        }
        Integer M_Warehouse_ID = (Integer)value;
        if (M_Warehouse_ID == null || M_Warehouse_ID == 0) {
            return "";
        }
        String sql = "SELECT w.AD_Org_ID, l.M_Locator_ID FROM M_Warehouse w LEFT OUTER JOIN M_Locator l ON (l.M_Warehouse_ID=w.M_Warehouse_ID AND l.IsDefault='Y') WHERE w.M_Warehouse_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, M_Warehouse_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    Integer ii = new Integer(rs.getInt(1));
                    int AD_Org_ID = Env.getContextAsInt(ctx, WindowNo, "AD_Org_ID");
                    if (AD_Org_ID != ii) {
                        mTab.setValue("AD_Org_ID", (Object)ii);
                    }
                    ii = new Integer(rs.getInt(2));
                    if (rs.wasNull()) {
                        Env.setContext(ctx, WindowNo, 0, "M_Locator_ID", null);
                    } else {
                        this.log.config("M_Locator_ID=" + ii);
                        Env.setContext(ctx, WindowNo, "M_Locator_ID", ii);
                    }
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close((ResultSet)rs, (Statement)pstmt);
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        return "";
    }

    public String orderLine(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_OrderLine_ID = (Integer)value;
        if (C_OrderLine_ID == null || C_OrderLine_ID == 0) {
            return "";
        }
        MOrderLine ol = new MOrderLine(ctx, C_OrderLine_ID, null);
        if (ol.get_ID() != 0) {
            if (ol.getC_Charge_ID() > 0 && ol.getM_Product_ID() <= 0) {
                mTab.setValue("C_Charge_ID", (Object)new Integer(ol.getC_Charge_ID()));
            } else {
                if (ol.getM_Product_ID() > 0) {
                    mTab.setValue("M_Product_ID", (Object)new Integer(ol.getM_Product_ID()));
                } else {
                    mTab.setValue("M_Product_ID", null);
                }
                if (ol.getM_AttributeSetInstance_ID() > 0) {
                    mTab.setValue("M_AttributeSetInstance_ID", (Object)new Integer(ol.getM_AttributeSetInstance_ID()));
                } else {
                    mTab.setValue("M_AttributeSetInstance_ID", null);
                }
            }
            mTab.setValue("C_UOM_ID", (Object)new Integer(ol.getC_UOM_ID()));
            BigDecimal MovementQty = ol.getQtyOrdered().subtract(ol.getQtyDelivered());
            mTab.setValue("MovementQty", (Object)MovementQty);
            BigDecimal QtyEntered = MovementQty;
            if (ol.getQtyEntered().compareTo(ol.getQtyOrdered()) != 0) {
                QtyEntered = QtyEntered.multiply(ol.getQtyEntered()).divide(ol.getQtyOrdered(), 12, 4);
            }
            mTab.setValue("QtyEntered", (Object)QtyEntered);
            if (ol.getC_Activity_ID() > 0) {
                mTab.setValue("C_Activity_ID", (Object)new Integer(ol.getC_Activity_ID()));
            } else {
                mTab.setValue("C_Activity_ID", null);
            }
            if (ol.getC_Campaign_ID() > 0) {
                mTab.setValue("C_Campaign_ID", (Object)new Integer(ol.getC_Campaign_ID()));
            } else {
                mTab.setValue("C_Campaign_ID", null);
            }
            if (ol.getC_Project_ID() > 0) {
                mTab.setValue("C_Project_ID", (Object)new Integer(ol.getC_Project_ID()));
            } else {
                mTab.setValue("C_Project_ID", null);
            }
            if (ol.getC_ProjectPhase_ID() > 0) {
                mTab.setValue("C_ProjectPhase_ID", (Object)new Integer(ol.getC_ProjectPhase_ID()));
            } else {
                mTab.setValue("C_ProjectPhase_ID", null);
            }
            if (ol.getC_ProjectTask_ID() > 0) {
                mTab.setValue("C_ProjectTask_ID", (Object)new Integer(ol.getC_ProjectTask_ID()));
            } else {
                mTab.setValue("C_ProjectTask_ID", null);
            }
            if (ol.getAD_OrgTrx_ID() > 0) {
                mTab.setValue("AD_OrgTrx_ID", (Object)new Integer(ol.getAD_OrgTrx_ID()));
            } else {
                mTab.setValue("AD_OrgTrx_ID", null);
            }
            if (ol.getUser1_ID() > 0) {
                mTab.setValue("User1_ID", (Object)new Integer(ol.getUser1_ID()));
            } else {
                mTab.setValue("User1_ID", null);
            }
            if (ol.getUser2_ID() > 0) {
                mTab.setValue("User2_ID", (Object)new Integer(ol.getUser2_ID()));
            } else {
                mTab.setValue("User2_ID", null);
            }
        }
        return "";
    }

    public String rmaLine(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer M_RMALine_id = (Integer)value;
        if (M_RMALine_id == null || M_RMALine_id == 0) {
            return "";
        }
        MRMALine rl = new MRMALine(ctx, M_RMALine_id.intValue(), null);
        if (rl.get_ID() != 0) {
            if (rl.getC_Charge_ID() > 0 && rl.getM_Product_ID() <= 0) {
                mTab.setValue("C_Charge_ID", (Object)new Integer(rl.getC_Charge_ID()));
            } else {
                if (rl.getM_Product_ID() > 0) {
                    mTab.setValue("M_Product_ID", (Object)new Integer(rl.getM_Product_ID()));
                } else {
                    mTab.setValue("M_Product_ID", null);
                }
                if (rl.getM_AttributeSetInstance_ID() > 0) {
                    mTab.setValue("M_AttributeSetInstance_ID", (Object)new Integer(rl.getM_AttributeSetInstance_ID()));
                } else {
                    mTab.setValue("M_AttributeSetInstance_ID", null);
                }
            }
            mTab.setValue("C_UOM_ID", (Object)new Integer(rl.getC_UOM_ID()));
            BigDecimal MovementQty = rl.getQty().subtract(rl.getQtyDelivered());
            mTab.setValue("MovementQty", (Object)MovementQty);
            BigDecimal QtyEntered = MovementQty;
            mTab.setValue("QtyEntered", (Object)QtyEntered);
            if (rl.getC_Activity_ID() > 0) {
                mTab.setValue("C_Activity_ID", (Object)new Integer(rl.getC_Activity_ID()));
            } else {
                mTab.setValue("C_Activity_ID", null);
            }
            if (rl.getC_Campaign_ID() > 0) {
                mTab.setValue("C_Campaign_ID", (Object)new Integer(rl.getC_Campaign_ID()));
            } else {
                mTab.setValue("C_Campaign_ID", null);
            }
            if (rl.getC_Project_ID() > 0) {
                mTab.setValue("C_Project_ID", (Object)new Integer(rl.getC_Project_ID()));
            } else {
                mTab.setValue("C_Project_ID", null);
            }
            if (rl.getC_ProjectPhase_ID() > 0) {
                mTab.setValue("C_ProjectPhase_ID", (Object)new Integer(rl.getC_ProjectPhase_ID()));
            } else {
                mTab.setValue("C_ProjectPhase_ID", null);
            }
            if (rl.getC_ProjectTask_ID() > 0) {
                mTab.setValue("C_ProjectTask_ID", (Object)new Integer(rl.getC_ProjectTask_ID()));
            } else {
                mTab.setValue("C_ProjectTask_ID", null);
            }
            if (rl.getAD_OrgTrx_ID() > 0) {
                mTab.setValue("AD_OrgTrx_ID", (Object)new Integer(rl.getAD_OrgTrx_ID()));
            } else {
                mTab.setValue("AD_OrgTrx_ID", null);
            }
            if (rl.getUser1_ID() > 0) {
                mTab.setValue("User1_ID", (Object)new Integer(rl.getUser1_ID()));
            } else {
                mTab.setValue("User1_ID", null);
            }
            if (rl.getUser2_ID() > 0) {
                mTab.setValue("User2_ID", (Object)new Integer(rl.getUser2_ID()));
            } else {
                mTab.setValue("User2_ID", null);
            }
        }
        return "";
    }

    public String product(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive()) {
            return "";
        }
        Integer M_Product_ID = (Integer)value;
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        int M_Locator_ID = 0;
        if (Env.getContextAsInt(ctx, WindowNo, 1113, "M_Product_ID") == M_Product_ID && Env.getContextAsInt(ctx, WindowNo, 1113, "M_AttributeSetInstance_ID") != 0) {
            mTab.setValue("M_AttributeSetInstance_ID", (Object)new Integer(Env.getContextAsInt(ctx, WindowNo, 1113, "M_AttributeSetInstance_ID")));
            M_Locator_ID = Env.getContextAsInt(ctx, WindowNo, 1113, "M_Locator_ID");
            if (M_Locator_ID != 0) {
                mTab.setValue("M_Locator_ID", (Object)new Integer(M_Locator_ID));
            }
        } else {
            mTab.setValue("M_AttributeSetInstance_ID", null);
        }
        int M_Warehouse_ID = Env.getContextAsInt(ctx, WindowNo, "M_Warehouse_ID");
        boolean IsSOTrx = "Y".equals(Env.getContext(ctx, WindowNo, "IsSOTrx"));
        if (IsSOTrx) {
            return "";
        }
        MProduct product = MProduct.get((Properties)ctx, (int)M_Product_ID);
        mTab.setValue("C_UOM_ID", (Object)new Integer(product.getC_UOM_ID()));
        BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
        mTab.setValue("MovementQty", (Object)QtyEntered);
        if (M_Locator_ID == 0) {
            if (product.getM_Locator_ID() != 0) {
                MLocator loc = MLocator.get((Properties)ctx, (int)product.getM_Locator_ID());
                if (M_Warehouse_ID == loc.getM_Warehouse_ID()) {
                    mTab.setValue("M_Locator_ID", (Object)new Integer(product.getM_Locator_ID()));
                } else {
                    this.log.fine("No Locator for M_Product_ID=" + M_Product_ID + " and M_Warehouse_ID=" + M_Warehouse_ID);
                }
            } else {
                this.log.fine("No Locator for M_Product_ID=" + M_Product_ID);
            }
        }
        return "";
    }

    public String qty(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int M_Product_ID = Env.getContextAsInt(ctx, WindowNo, "M_Product_ID");
        if (M_Product_ID == 0) {
            BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            mTab.setValue("MovementQty", (Object)QtyEntered);
            return "";
        }
        MProduct prod = new MProduct(ctx, M_Product_ID, null);
        int Prod_UOM_ID = prod.getC_UOM_ID();
        int C_UOM_To_ID = Env.getContextAsInt(ctx, WindowNo, "C_UOM_ID");
        if (mField.getColumnName().equals("C_UOM_ID")) {
            BigDecimal MovementQty;
            BigDecimal QtyEntered1;
            C_UOM_To_ID = (Integer)value;
            BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            if (QtyEntered.compareTo(QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision((Properties)ctx, (int)C_UOM_To_ID), 4)) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((MovementQty = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                MovementQty = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(MovementQty) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered=" + QtyEntered + " -> " + conversion + " MovementQty=" + MovementQty);
            Env.setContext(ctx, WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("MovementQty", (Object)MovementQty);
        } else if (C_UOM_To_ID == 0 || C_UOM_To_ID == Prod_UOM_ID) {
            BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            mTab.setValue("MovementQty", (Object)QtyEntered);
        } else if (mField.getColumnName().equals("QtyEntered")) {
            BigDecimal MovementQty;
            BigDecimal QtyEntered = (BigDecimal)value;
            BigDecimal QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision((Properties)ctx, (int)C_UOM_To_ID), 4);
            if (QtyEntered.compareTo(QtyEntered1) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((MovementQty = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                MovementQty = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(MovementQty) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered=" + QtyEntered + " -> " + conversion + " MovementQty=" + MovementQty);
            Env.setContext(ctx, WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("MovementQty", (Object)MovementQty);
        } else if (mField.getColumnName().equals("MovementQty")) {
            BigDecimal QtyEntered;
            BigDecimal MovementQty = (BigDecimal)value;
            int precision = MProduct.get((Properties)ctx, (int)M_Product_ID).getUOMPrecision();
            BigDecimal MovementQty1 = MovementQty.setScale(precision, 4);
            if (MovementQty.compareTo(MovementQty1) != 0) {
                this.log.fine("Corrected MovementQty " + MovementQty + "->" + MovementQty1);
                MovementQty = MovementQty1;
                mTab.setValue("MovementQty", (Object)MovementQty);
            }
            if ((QtyEntered = MUOMConversion.convertProductTo(ctx, M_Product_ID, C_UOM_To_ID, MovementQty)) == null) {
                QtyEntered = MovementQty;
            }
            boolean conversion = MovementQty.compareTo(QtyEntered) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", MovementQty=" + MovementQty + " -> " + conversion + " QtyEntered=" + QtyEntered);
            Env.setContext(ctx, WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("QtyEntered", (Object)QtyEntered);
        }
        return "";
    }

    public String asi(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        int selectedM_Locator_ID;
        if (this.isCalloutActive()) {
            return "";
        }
        Integer M_ASI_ID = (Integer)value;
        if (M_ASI_ID == null || M_ASI_ID == 0) {
            return "";
        }
        int M_Product_ID = Env.getContextAsInt(ctx, WindowNo, "M_Product_ID");
        int M_Warehouse_ID = Env.getContextAsInt(ctx, WindowNo, "M_Warehouse_ID");
        int M_Locator_ID = Env.getContextAsInt(ctx, WindowNo, "M_Locator_ID");
        this.log.fine("M_Product_ID=" + M_Product_ID + ", M_ASI_ID=" + M_ASI_ID + " - M_Warehouse_ID=" + M_Warehouse_ID + ", M_Locator_ID=" + M_Locator_ID);
        int M_AttributeSetInstance_ID = Env.getContextAsInt(Env.getCtx(), WindowNo, 1113, "M_AttributeSetInstance_ID");
        if (M_ASI_ID == M_AttributeSetInstance_ID && (selectedM_Locator_ID = Env.getContextAsInt(Env.getCtx(), WindowNo, 1113, "M_Locator_ID")) != 0) {
            this.log.fine("Selected M_Locator_ID=" + selectedM_Locator_ID);
            mTab.setValue("M_Locator_ID", (Object)new Integer(selectedM_Locator_ID));
        }
        return "";
    }
}

