/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.FieldRecordInfo;
import org.compiere.apps.ScriptEditor;
import org.compiere.grid.ed.Editor;
import org.compiere.grid.ed.VEditor;
import org.compiere.model.GridField;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CTextArea;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VText
extends CTextArea
implements VEditor,
KeyListener,
ActionListener,
FocusListener {
    private static final long serialVersionUID = -2873467246871800195L;
    JPopupMenu popupMenu = new JPopupMenu();
    private CMenuItem menuEditor;
    private int m_fieldLength;
    private String m_columnName;
    private String m_oldText;
    private String m_initialText;
    private volatile boolean m_setting = false;
    private GridField m_mField;

    public VText(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, int displayLength, int fieldLength) {
        super((JTextArea)new VLimitableTextArea(fieldLength, fieldLength < 300 ? 2 : 3, 50));
        super.setName(columnName);
        LookAndFeel.installBorder((JComponent)((Object)this), "TextField.border");
        this.setColumns(displayLength > 60 ? 60 : displayLength);
        this.setForeground(AdempierePLAF.getTextColor_Normal());
        this.setBackground(AdempierePLAF.getFieldBackground_Normal());
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setMandatory(mandatory);
        this.m_columnName = columnName;
        this.m_fieldLength = fieldLength;
        if (isReadOnly || !isUpdateable) {
            this.setReadWrite(false);
        }
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.addMouseListener(new VText_mouseAdapter(this));
        this.menuEditor = columnName.equals("Script") ? new CMenuItem(Msg.getMsg((Properties)Env.getCtx(), (String)"Script"), (Icon)Env.getImageIcon("Script16.gif")) : new CMenuItem(Msg.getMsg((Properties)Env.getCtx(), (String)"Editor"), (Icon)Env.getImageIcon("Editor16.gif"));
        this.menuEditor.addActionListener((ActionListener)this);
        this.popupMenu.add((JMenuItem)this.menuEditor);
    }

    public void dispose() {
    }

    public void setValue(Object value) {
        this.m_oldText = value == null ? "" : value.toString();
        if (this.m_setting) {
            return;
        }
        super.setValue((Object)this.m_oldText);
        this.m_initialText = this.m_oldText;
        this.setCaretPosition(0);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.menuEditor) {
            this.menuEditor.setEnabled(false);
            String s = null;
            s = this.m_columnName.equals("Script") || this.m_columnName.endsWith("_Script") ? ScriptEditor.start((Frame)Env.getFrame(this.getParent()), (String)Msg.translate((Properties)Env.getCtx(), (String)this.m_columnName), (String)this.getText(), (boolean)this.isEditable(), (int)this.findWindowNo()) : Editor.startEditor((Container)((Object)this), (String)Msg.translate((Properties)Env.getCtx(), (String)this.m_columnName), (String)this.getText(), (boolean)this.isEditable(), (int)this.m_fieldLength);
            this.menuEditor.setEnabled(true);
            try {
                this.fireVetoableChange(this.m_columnName, this.m_oldText, s);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else if (e.getActionCommand().equals("ChangeLog")) {
            FieldRecordInfo.start((GridField)this.m_mField);
            return;
        }
    }

    private int findWindowNo() {
        Container c = this.getParent();
        return c != null ? Env.getWindowNo(c) : 0;
    }

    public void addActionListener(ActionListener listener) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.setText(this.m_initialText);
        }
    }

    public void setField(GridField mField) {
        this.m_mField = mField;
        if (this.m_mField != null) {
            FieldRecordInfo.addMenu((ActionListener)this, (JPopupMenu)this.popupMenu);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.m_setting = true;
        try {
            this.fireVetoableChange(this.m_columnName, this.m_oldText, this.getText());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.m_setting = false;
    }

    protected static class LimitableDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        private int m_iLimit;

        protected LimitableDocument(int iLimit) {
            this.m_iLimit = iLimit;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.getLength() + str.length() <= this.m_iLimit) {
                super.insertString(offset, str, attr);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public static class VLimitableTextArea
    extends JTextArea {
        private static final long serialVersionUID = 1L;

        public VLimitableTextArea(int iLimit, int iRows, int iColumns) {
            super(iRows, iColumns);
            this.setDocument(new LimitableDocument(iLimit));
        }
    }

    final class VText_mouseAdapter
    extends MouseAdapter {
        private VText adaptee;

        VText_mouseAdapter(VText adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                this.adaptee.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }
}

