/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.grid.ed.VButton;
import org.compiere.model.GridTab;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CDialog;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.wf.MWFActivity;

public class VDocAction
extends CDialog
implements ActionListener {
    private static final long serialVersionUID = -7800828832602048052L;
    private int m_WindowNo = 0;
    private int m_AD_Table_ID;
    private boolean m_OKpressed = false;
    private boolean m_batch = false;
    private GridTab m_mTab;
    private static String[] s_value = null;
    private static String[] s_name;
    private static String[] s_description;
    private static CLogger log;
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel northPanel = new CPanel();
    private CComboBox actionCombo = new CComboBox();
    private JLabel actionLabel = new JLabel();
    private JScrollPane centerPane = new JScrollPane();
    private JTextArea message = new JTextArea();
    private FlowLayout northLayout = new FlowLayout();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private JButton batchButton = ConfirmPanel.createProcessButton((String)Msg.getMsg((Properties)Env.getCtx(), (String)"StartBackground"));

    static {
        log = CLogger.getCLogger(VDocAction.class);
    }

    public VDocAction(int WindowNo, GridTab mTab, VButton button, int Record_ID) {
        super((Frame)Env.getWindow(WindowNo), Msg.translate((Properties)Env.getCtx(), (String)"DocAction"), true);
        log.config("");
        this.m_WindowNo = WindowNo;
        this.m_mTab = mTab;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", (Throwable)ex);
        }
        this.m_AD_Table_ID = Env.getContextAsInt(Env.getCtx(), WindowNo, "BaseTable_ID");
        if (s_value == null) {
            this.readReference();
        }
        this.dynInit(Record_ID);
        AEnv.positionCenterWindow((Window)Env.getWindow(WindowNo), (Window)((Object)this));
    }

    void jbInit() throws Exception {
        this.mainPanel.setLayout((LayoutManager)this.mainLayout);
        this.actionLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"DocAction"));
        this.actionCombo.addActionListener((ActionListener)this);
        this.message.setLineWrap(true);
        this.message.setPreferredSize(new Dimension(350, 35));
        this.message.setWrapStyleWord(true);
        this.message.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.message.setEditable(false);
        this.northPanel.setLayout((LayoutManager)this.northLayout);
        this.northLayout.setAlignment(2);
        this.getContentPane().add((Component)this.mainPanel);
        this.mainPanel.add((Component)this.northPanel, (Object)"North");
        this.northPanel.add((Component)this.actionLabel, null);
        this.northPanel.add((Component)this.actionCombo, null);
        this.mainPanel.add((Component)this.centerPane, (Object)"Center");
        this.centerPane.getViewport().add((Component)this.message, null);
        this.mainPanel.add((Component)this.confirmPanel, (Object)"South");
        this.confirmPanel.addButton(this.batchButton);
        this.confirmPanel.addActionListener((ActionListener)this);
        this.batchButton.addActionListener(this);
    }

    private void dynInit(int Record_ID) {
        Integer doctypeId;
        String DocStatus = (String)this.m_mTab.getValue("DocStatus");
        String DocAction2 = (String)this.m_mTab.getValue("DocAction");
        Object Processing = this.m_mTab.getValue("Processing");
        String OrderType = Env.getContext(Env.getCtx(), this.m_WindowNo, "OrderType");
        String IsSOTrx = Env.getContext(Env.getCtx(), this.m_WindowNo, "IsSOTrx");
        if (DocStatus == null) {
            this.message.setText("*** ERROR ***");
            return;
        }
        log.fine("DocStatus=" + DocStatus + ", DocAction=" + DocAction2 + ", OrderType=" + OrderType + ", IsSOTrx=" + IsSOTrx + ", Processing=" + Processing + ", AD_Table_ID=" + this.m_AD_Table_ID + ", Record_ID=" + Record_ID);
        String[] options = new String[s_value.length];
        int index = 0;
        String wfStatus = MWFActivity.getActiveInfo((Properties)Env.getCtx(), (int)this.m_AD_Table_ID, (int)Record_ID);
        if (wfStatus != null) {
            ADialog.error((int)this.m_WindowNo, (Container)((Object)this), (String)"WFActiveForRecord", (String)wfStatus);
            return;
        }
        if (!this.checkStatus(this.m_mTab.getTableName(), Record_ID, DocStatus)) {
            ADialog.error((int)this.m_WindowNo, (Container)((Object)this), (String)"DocumentStatusChanged");
            return;
        }
        String[] docActionHolder = new String[]{DocAction2};
        index = DocumentEngine.getValidActions((String)DocStatus, (Object)Processing, (String)OrderType, (String)IsSOTrx, (int)this.m_AD_Table_ID, (String[])docActionHolder, (String[])options);
        MTable table = MTable.get((Properties)Env.getCtx(), (int)this.m_AD_Table_ID);
        PO po = table.getPO(Record_ID, null);
        if (po instanceof DocOptions) {
            index = ((DocOptions)po).customizeValidActions(DocStatus, Processing, OrderType, IsSOTrx, this.m_AD_Table_ID, docActionHolder, options, index);
        }
        if ((doctypeId = (Integer)this.m_mTab.getValue("C_DocType_ID")) == null || doctypeId == 0) {
            doctypeId = (Integer)this.m_mTab.getValue("C_DocTypeTarget_ID");
        }
        log.fine("get doctype: " + doctypeId);
        if (doctypeId != null) {
            index = DocumentEngine.checkActionAccess((int)Env.getAD_Client_ID(Env.getCtx()), (int)Env.getAD_Role_ID(Env.getCtx()), (int)doctypeId, (String[])options, (int)index);
        }
        DocAction2 = docActionHolder[0];
        ArrayList<String> lstAdded = new ArrayList<String>();
        if (index > options.length) {
            index = options.length;
        }
        int i = 0;
        while (i < index) {
            boolean added = false;
            int j = 0;
            while (j < s_value.length && !added) {
                if (options[i] != null && options[i].equals(s_value[j]) && !lstAdded.contains(s_name[j])) {
                    this.actionCombo.addItem((Object)s_name[j]);
                    added = true;
                    lstAdded.add(s_name[j]);
                }
                ++j;
            }
            ++i;
        }
        if (DocAction2.equals("--")) {
            DocAction2 = "CL";
        }
        String defaultV = "";
        int i2 = 0;
        while (i2 < s_value.length && defaultV.equals("")) {
            if (DocAction2.equals(s_value[i2])) {
                defaultV = s_name[i2];
            }
            ++i2;
        }
        if (!defaultV.equals("")) {
            this.actionCombo.setSelectedItem((Object)defaultV);
        }
    }

    private boolean checkStatus(String TableName, int Record_ID, String DocStatus) {
        String sql = "SELECT 2 FROM " + TableName + " WHERE " + TableName + "_ID=" + Record_ID + " AND DocStatus='" + DocStatus + "'";
        int result = DB.getSQLValue(null, (String)sql);
        return result == 2;
    }

    public int getNumberOfOptions() {
        return this.actionCombo.getItemCount();
    }

    public boolean isStartProcess() {
        return this.m_OKpressed;
    }

    public boolean isBatch() {
        return this.m_batch;
    }

    private void readReference() {
        ArrayList v_value = new ArrayList();
        ArrayList v_name = new ArrayList();
        ArrayList v_description = new ArrayList();
        DocumentEngine.readReferenceList(v_value, v_name, v_description);
        int size = v_value.size();
        s_value = new String[size];
        s_name = new String[size];
        s_description = new String[size];
        int i = 0;
        while (i < size) {
            VDocAction.s_value[i] = (String)v_value.get(i);
            VDocAction.s_name[i] = (String)v_name.get(i);
            VDocAction.s_description[i] = (String)v_description.get(i);
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index;
        boolean bl = this.m_batch = e.getSource() == this.batchButton;
        if (this.m_batch || e.getActionCommand().equals("Ok")) {
            if (this.save()) {
                this.dispose();
                this.m_OKpressed = true;
                return;
            }
        } else {
            if (e.getActionCommand().equals("Cancel")) {
                this.dispose();
                return;
            }
            if (e.getSource() != this.actionCombo) {
                return;
            }
        }
        if ((index = this.getSelectedIndex()) != -1) {
            this.message.setText(s_description[index]);
        }
    }

    private int getSelectedIndex() {
        int index = -1;
        String sel = (String)this.actionCombo.getSelectedItem();
        if (sel == null) {
            return index;
        }
        int i = 0;
        while (i < s_name.length && index == -1) {
            if (sel.equals(s_name[i])) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    private boolean save() {
        int index = this.getSelectedIndex();
        if (index == -1) {
            return false;
        }
        log.config("DocAction=" + s_value[index]);
        this.m_mTab.setValue("DocAction", (Object)s_value[index]);
        return true;
    }
}

