/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JButton;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.search.InfoSchedule;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VNumber;
import org.compiere.model.MResourceAssignment;
import org.compiere.model.MRole;
import org.compiere.model.MUOMConversion;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class VAssignmentDialog
extends CDialog
implements ActionListener {
    private static final long serialVersionUID = 4130085811212412204L;
    private MResourceAssignment m_mAssignment;
    private Frame m_frame;
    private boolean m_setting = false;
    private static CLogger log = CLogger.getCLogger(VAssignmentDialog.class);
    private HashMap<KeyNamePair, KeyNamePair> m_lookup = new HashMap();
    private CPanel mainPanel = new CPanel();
    private GridBagLayout mainLayout = new GridBagLayout();
    private CLabel lResource = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"S_Resource_ID"));
    private VComboBox fResource = new VComboBox((Object[])this.getResources());
    private CLabel lDate = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"DateFrom"));
    private VDate fDateFrom = new VDate(16);
    private CLabel lQty = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"Qty"));
    private VNumber fQty = new VNumber();
    private CLabel lUOM = new CLabel();
    private CLabel lName = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"Name"));
    private CLabel lDescription = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"Description"));
    private CTextField fName = new CTextField(30);
    private CTextField fDescription = new CTextField(30);
    private ConfirmPanel confirmPanel = new ConfirmPanel(true, false, false, false, false, true, true);
    private JButton delete = ConfirmPanel.createDeleteButton((boolean)true);

    public VAssignmentDialog(Frame frame, MResourceAssignment mAssignment, boolean allowZoom, boolean allowDelete) {
        super(frame, Msg.getMsg((Properties)Env.getCtx(), (String)"VAssignmentDialog"), true);
        log.config(mAssignment.toString());
        this.m_mAssignment = mAssignment;
        this.m_frame = frame;
        try {
            this.jbInit();
            if (!allowZoom) {
                this.confirmPanel.getZoomButton().setVisible(false);
            }
            this.delete.setVisible(allowDelete);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
        this.setDisplay();
        AEnv.showCenterScreen((Window)((Object)this));
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(2);
        this.fResource.addActionListener((ActionListener)this);
        this.delete.addActionListener(this);
        this.confirmPanel.addButton(this.delete);
        this.confirmPanel.addActionListener((ActionListener)this);
        this.mainPanel.setLayout((LayoutManager)this.mainLayout);
        this.mainPanel.add((Component)this.lResource, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(8, 8, 4, 4), 0, 0));
        this.mainPanel.add((Component)this.fResource, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 0, 4, 4), 0, 0));
        this.mainPanel.add((Component)this.lDate, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 8, 4, 4), 0, 0));
        this.mainPanel.add((Component)this.fDateFrom, (Object)new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 4, 8), 100, 0));
        this.mainPanel.add((Component)this.lQty, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 8, 4, 4), 0, 0));
        this.mainPanel.add((Component)this.fQty, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 4, 4), 0, 0));
        this.mainPanel.add((Component)this.lUOM, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 4, 4, 8), 0, 0));
        this.mainPanel.add((Component)this.lName, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 8, 4, 4), 0, 0));
        this.mainPanel.add((Component)this.lDescription, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 8, 8, 4), 0, 0));
        this.mainPanel.add((Component)this.fName, (Object)new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 4, 8), 0, 0));
        this.mainPanel.add((Component)this.fDescription, (Object)new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 8, 8), 0, 0));
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)this.confirmPanel, "South");
    }

    private void setDisplay() {
        this.m_setting = true;
        int S_Resource_ID = this.m_mAssignment.getS_Resource_ID();
        KeyNamePair[] resources = new KeyNamePair[this.m_lookup.size()];
        this.m_lookup.keySet().toArray(resources);
        int i = 0;
        while (i < resources.length) {
            if (resources[i].getKey() == S_Resource_ID) {
                this.fResource.setSelectedItem((Object)resources[i]);
                break;
            }
            ++i;
        }
        KeyNamePair check = (KeyNamePair)this.fResource.getSelectedItem();
        if (check == null || check.getKey() != S_Resource_ID) {
            if (this.m_mAssignment.getS_ResourceAssignment_ID() == 0) {
                this.fResource.setSelectedItem(this.fResource.getSelectedItem());
            } else {
                log.log(Level.SEVERE, "Resource not found ID=" + S_Resource_ID);
            }
        }
        this.fDateFrom.setValue((Object)this.m_mAssignment.getAssignDateFrom());
        this.fQty.setValue((Object)this.m_mAssignment.getQty());
        this.fName.setValue((Object)this.m_mAssignment.getName());
        this.fDescription.setValue((Object)this.m_mAssignment.getDescription());
        boolean readWrite = true;
        if (this.m_mAssignment.isConfirmed()) {
            readWrite = false;
        }
        this.confirmPanel.getCancelButton().setVisible(readWrite);
        this.fResource.setReadWrite(readWrite);
        this.fDateFrom.setReadWrite(readWrite);
        this.fQty.setReadWrite(readWrite);
        this.m_setting = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BigDecimal qty;
        Timestamp assignDateFrom;
        if (this.m_setting) {
            return;
        }
        KeyNamePair resource = (KeyNamePair)this.fResource.getSelectedItem();
        if (resource != null) {
            int S_Resource_ID = resource.getKey();
            this.m_mAssignment.setS_Resource_ID(S_Resource_ID);
        }
        if ((assignDateFrom = this.fDateFrom.getTimestamp()) != null) {
            this.m_mAssignment.setAssignDateFrom(assignDateFrom);
        }
        if ((qty = (BigDecimal)this.fQty.getValue()) != null) {
            this.m_mAssignment.setQty(qty);
        }
        this.m_mAssignment.setName((String)this.fName.getValue());
        this.m_mAssignment.setDescription((String)this.fDescription.getValue());
        if (e.getSource() == this.fResource) {
            KeyNamePair o = this.m_lookup.get(this.fResource.getSelectedItem());
            if (o == null) {
                this.lUOM.setText(" ? ");
            } else {
                this.lUOM.setText(o.toString());
            }
        } else if (e.getActionCommand().equals("Zoom")) {
            InfoSchedule is = new InfoSchedule(this.m_frame, this.m_mAssignment, true);
            if (is.getMResourceAssignment() != null) {
                this.m_mAssignment = is.getMResourceAssignment();
                this.dispose();
            }
            is = null;
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (e.getActionCommand().equals("Delete")) {
            if (this.m_mAssignment.delete(true)) {
                this.m_mAssignment = null;
                this.dispose();
            } else {
                ADialog.error((int)0, (Container)((Object)this), (String)"ResourceAssignmentNotDeleted");
            }
        } else if (e.getActionCommand().equals("Ok") && this.cmd_save()) {
            this.dispose();
        }
    }

    public MResourceAssignment getMResourceAssignment() {
        return this.m_mAssignment;
    }

    private boolean cmd_save() {
        log.config("");
        Timestamp assignDateFrom = this.fDateFrom.getTimestamp();
        BigDecimal qty = (BigDecimal)this.fQty.getValue();
        KeyNamePair uom = this.m_lookup.get(this.fResource.getSelectedItem());
        int minutes = MUOMConversion.convertToMinutes(Env.getCtx(), uom.getKey(), qty);
        Timestamp assignDateTo = TimeUtil.addMinutess((Timestamp)assignDateFrom, (int)minutes);
        this.m_mAssignment.setAssignDateTo(assignDateTo);
        boolean bRes = true;
        try {
            this.m_mAssignment.saveEx();
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            ADialog.error((int)0, (Container)((Object)this), (String)e.getMessage());
            bRes = false;
        }
        return bRes;
    }

    private KeyNamePair[] getResources() {
        if (this.m_lookup.size() == 0) {
            String sql = MRole.getDefault().addAccessSQL("SELECT r.S_Resource_ID, r.Name, r.IsActive,uom.C_UOM_ID,uom.UOMSymbol FROM S_Resource r, S_ResourceType rt, C_UOM uom WHERE r.S_ResourceType_ID=rt.S_ResourceType_ID AND rt.C_UOM_ID=uom.C_UOM_ID", "r", true, false);
            try {
                CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    StringBuffer sb = new StringBuffer(rs.getString(2));
                    if (!"Y".equals(rs.getString(3))) {
                        sb.insert(0, '~').append('~');
                    }
                    KeyNamePair key = new KeyNamePair(rs.getInt(1), sb.toString());
                    KeyNamePair value = new KeyNamePair(rs.getInt(4), rs.getString(5).trim());
                    this.m_lookup.put(key, value);
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, sql, (Throwable)e);
            }
        }
        Object[] retValue = new KeyNamePair[this.m_lookup.size()];
        this.m_lookup.keySet().toArray(retValue);
        Arrays.sort(retValue);
        return retValue;
    }
}

