/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import com.f3p.adempiere.search.SysConfigInfoSettings;
import com.f3p.adempiere.search.TableIdentifierParser;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.table.DefaultTableModel;
import org.adempiere.plaf.AdempierePLAF;
import org.adempiere.plaf.AdempiereTaskPaneUI;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.InfoPAttribute;
import org.compiere.apps.search.Info_Column;
import org.compiere.apps.search.InvoiceHistory;
import org.compiere.apps.search.PAttributeInstance;
import org.compiere.grid.ed.VComboBox;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTabbedPane;
import org.compiere.swing.CTextArea;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogMgt;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.plaf.TaskPaneUI;

public class InfoProduct
extends Info
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 2076229793041196087L;
    private static final String s_productFrom = "M_Product p LEFT OUTER JOIN M_ProductPrice pr ON (p.M_Product_ID=pr.M_Product_ID AND pr.IsActive='Y') LEFT OUTER JOIN M_PriceList_Version pv ON (pr.M_PriceList_Version_ID = pv.M_PriceList_Version_ID) LEFT OUTER JOIN M_AttributeSet pa ON (p.M_AttributeSet_ID=pa.M_AttributeSet_ID) LEFT OUTER JOIN M_Product_PO ppo ON (p.M_Product_ID=ppo.M_Product_ID and ppo.IsCurrentVendor='Y' and ppo.IsActive='Y') LEFT OUTER JOIN C_BPartner bp ON (ppo.C_BPartner_ID=bp.C_BPartner_ID) LEFT OUTER JOIN M_Product_Trl ptrl ON (ptrl.M_PRODUCT_ID = p.M_Product_ID AND ptrl.AD_LANGUAGE = ?)";
    private static Info_Column[] s_productLayout = null;
    private static int INDEX_NAME = 0;
    private static int INDEX_PATTRIBUTE = 0;
    private CLabel labelValue = new CLabel();
    private CTextField fieldValue = new CTextField(10);
    private CLabel labelName = new CLabel();
    private CTextField fieldName = new CTextField(10);
    private CLabel labelUPC = new CLabel();
    private CTextField fieldUPC = new CTextField(10);
    private CLabel labelSKU = new CLabel();
    private CTextField fieldSKU = new CTextField(10);
    private CLabel labelPriceList = new CLabel();
    private VComboBox pickPriceList = new VComboBox();
    private CLabel labelWarehouse = new CLabel();
    private VComboBox pickWarehouse = new VComboBox();
    private CLabel labelVendor = new CLabel();
    private CTextField fieldVendor = new CTextField(10);
    private CLabel labelProductCategory = new CLabel();
    private VComboBox pickProductCategory = new VComboBox();
    private CLabel labelAS = new CLabel();
    private VComboBox pickAS = new VComboBox();
    private CTextArea fieldDescription = new CTextArea();
    JXTaskPane warehouseStockPanel = new JXTaskPane();
    CPanel tablePanel = new CPanel();
    MiniTable warehouseTbl = new MiniTable();
    String m_sqlWarehouse;
    MiniTable substituteTbl = new MiniTable();
    String m_sqlSubstitute;
    MiniTable relatedTbl = new MiniTable();
    String m_sqlRelated;
    private MiniTable m_tableAtp = new MiniTable();
    private DefaultTableModel m_modelAtp = null;
    private MiniTable m_tableLocator = new MiniTable();
    private DefaultTableModel m_modelLocator = null;
    private int m_M_Product_ID = 0;
    int mWindowNo = 0;
    private CButton m_InfoPAttributeButton = new CButton(Env.getImageIcon("PAttribute16.gif"));
    private CButton m_PAttributeButton = null;
    private int m_M_AttributeSetInstance_ID = -1;
    private int m_M_Locator_ID = 0;
    private String m_pAttributeWhere = null;
    private int m_C_BPartner_ID = 0;

    public InfoProduct(Frame frame, boolean modal, int WindowNo, int M_Warehouse_ID, int M_PriceList_ID, String value, boolean multiSelection, String whereClause) {
        super(frame, modal, WindowNo, "p", "M_Product_ID", multiSelection, whereClause);
        this.log.info(String.valueOf(value) + ", Wh=" + M_Warehouse_ID + ", PL=" + M_PriceList_ID + ", WHERE=" + whereClause);
        this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"InfoProduct"));
        this.statInit();
        this.initInfo(value, M_Warehouse_ID, M_PriceList_ID);
        this.m_C_BPartner_ID = Env.getContextAsInt(Env.getCtx(), WindowNo, "C_BPartner_ID");
        int no = this.p_table.getRowCount();
        this.setStatusLine(String.valueOf(Integer.toString(no)) + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"SearchRows_EnterQuery"), false);
        this.setStatusDB(Integer.toString(no));
        if (value != null && value.length() > 0) {
            this.executeQuery();
        }
        this.p_loadedOK = true;
        this.fieldValue.requestFocus();
        this.mWindowNo = WindowNo;
        AEnv.positionCenterWindow((Window)frame, (Window)((Object)this));
    }

    private void statInit() {
        this.labelValue.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Value"));
        this.fieldValue.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldValue.addActionListener((ActionListener)this);
        this.labelName.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Name"));
        this.fieldName.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldName.addActionListener((ActionListener)this);
        this.labelUPC.setText(Msg.translate((Properties)Env.getCtx(), (String)"UPC"));
        this.fieldUPC.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldUPC.addActionListener((ActionListener)this);
        this.labelSKU.setText(Msg.translate((Properties)Env.getCtx(), (String)"SKU"));
        this.fieldSKU.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldSKU.addActionListener((ActionListener)this);
        this.labelWarehouse.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Warehouse"));
        this.pickWarehouse.setBackground(AdempierePLAF.getInfoBackground());
        this.labelPriceList.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"PriceListVersion"));
        this.pickPriceList.setBackground(AdempierePLAF.getInfoBackground());
        this.labelProductCategory.setText(Msg.translate((Properties)Env.getCtx(), (String)"M_Product_Category_ID"));
        this.pickProductCategory.setBackground(AdempierePLAF.getInfoBackground());
        this.labelAS.setText(Msg.translate((Properties)Env.getCtx(), (String)"M_AttributeSet_ID"));
        this.pickAS.setBackground(AdempierePLAF.getInfoBackground());
        this.m_InfoPAttributeButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_InfoPAttributeButton.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"InfoPAttribute"));
        this.m_InfoPAttributeButton.addActionListener(this);
        this.labelVendor.setText(Msg.translate((Properties)Env.getCtx(), (String)"Vendor"));
        this.fieldVendor.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldVendor.addActionListener((ActionListener)this);
        this.parameterPanel.setLayout((LayoutManager)new ALayout());
        this.parameterPanel.add((Component)this.labelValue, (Object)new ALayoutConstraint(0, 0));
        this.parameterPanel.add((Component)this.fieldValue, null);
        this.parameterPanel.add((Component)this.labelUPC, null);
        this.parameterPanel.add((Component)this.fieldUPC, null);
        this.parameterPanel.add((Component)this.labelWarehouse, null);
        this.parameterPanel.add((Component)this.pickWarehouse, null);
        this.parameterPanel.add((Component)this.m_InfoPAttributeButton);
        this.parameterPanel.add((Component)this.labelName, (Object)new ALayoutConstraint(1, 0));
        this.parameterPanel.add((Component)this.fieldName, null);
        this.parameterPanel.add((Component)this.labelSKU, null);
        this.parameterPanel.add((Component)this.fieldSKU, null);
        this.parameterPanel.add((Component)this.labelVendor, null);
        this.parameterPanel.add((Component)this.fieldVendor, null);
        this.parameterPanel.add((Component)this.labelPriceList, (Object)new ALayoutConstraint(2, 0));
        this.parameterPanel.add((Component)this.pickPriceList, null);
        this.parameterPanel.add((Component)this.labelProductCategory, null);
        this.parameterPanel.add((Component)this.pickProductCategory, null);
        this.parameterPanel.add((Component)this.labelAS, null);
        this.parameterPanel.add((Component)this.pickAS, null);
        this.m_PAttributeButton = ConfirmPanel.createPAttributeButton((boolean)true);
        this.confirmPanel.addButton((JButton)this.m_PAttributeButton);
        this.m_PAttributeButton.addActionListener(this);
        this.m_PAttributeButton.setEnabled(false);
        this.fieldDescription.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldDescription.setEditable(false);
        this.fieldDescription.setPreferredSize(new Dimension(this.INFO_WIDTH - 100, 100));
        this.warehouseStockPanel.setTitle(Msg.translate((Properties)Env.getCtx(), (String)"WarehouseStock"));
        this.warehouseStockPanel.setUI((TaskPaneUI)new AdempiereTaskPaneUI());
        this.warehouseStockPanel.getContentPane().setBackground(new ColorUIResource(251, 248, 241));
        this.warehouseStockPanel.getContentPane().setForeground(new ColorUIResource(251, 0, 0));
        ColumnInfo[] s_layoutWarehouse = new ColumnInfo[]{new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Warehouse"), "Warehouse", String.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"QtyAvailable"), "sum(QtyAvailable)", Double.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"QtyOnHand"), "sum(QtyOnHand)", Double.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"QtyReserved"), "sum(QtyReserved)", Double.class)};
        String s_sqlFrom = " M_PRODUCT_STOCK_V ";
        String s_sqlWhere = "Value = ?";
        this.m_sqlWarehouse = this.warehouseTbl.prepareTable(s_layoutWarehouse, s_sqlFrom, s_sqlWhere, false, "M_PRODUCT_STOCK_V");
        this.m_sqlWarehouse = String.valueOf(this.m_sqlWarehouse) + " Group By Warehouse, documentnote ";
        this.warehouseTbl.setRowSelectionAllowed(true);
        this.warehouseTbl.setMultiSelection(false);
        this.warehouseTbl.addMouseListener((MouseListener)((Object)this));
        this.warehouseTbl.getSelectionModel().addListSelectionListener(this);
        this.warehouseTbl.setShowTotals(true);
        this.warehouseTbl.autoSize();
        ColumnInfo[] s_layoutSubstitute = new ColumnInfo[]{new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Warehouse"), "orgname", String.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Value"), "(Select Value from M_Product p where p.M_Product_ID=M_PRODUCT_SUBSTITUTERELATED_V.Substitute_ID)", String.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Name"), "Name", String.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"QtyAvailable"), "QtyAvailable", Double.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"QtyOnHand"), "QtyOnHand", Double.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"QtyReserved"), "QtyReserved", Double.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"PriceStd"), "PriceStd", Double.class)};
        s_sqlFrom = "M_PRODUCT_SUBSTITUTERELATED_V";
        s_sqlWhere = "M_Product_ID = ? AND M_PriceList_Version_ID = ? and RowType = 'S'";
        this.m_sqlSubstitute = this.substituteTbl.prepareTable(s_layoutSubstitute, s_sqlFrom, s_sqlWhere, false, "M_PRODUCT_SUBSTITUTERELATED_V");
        this.substituteTbl.setRowSelectionAllowed(false);
        this.substituteTbl.setMultiSelection(false);
        this.substituteTbl.addMouseListener((MouseListener)((Object)this));
        this.substituteTbl.getSelectionModel().addListSelectionListener(this);
        this.substituteTbl.autoSize();
        ColumnInfo[] s_layoutRelated = new ColumnInfo[]{new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Warehouse"), "orgname", String.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Value"), "(Select Value from M_Product p where p.M_Product_ID=M_PRODUCT_SUBSTITUTERELATED_V.Substitute_ID)", String.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Name"), "Name", String.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"QtyAvailable"), "QtyAvailable", Double.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"QtyOnHand"), "QtyOnHand", Double.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"QtyReserved"), "QtyReserved", Double.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"PriceStd"), "PriceStd", Double.class)};
        s_sqlFrom = "M_PRODUCT_SUBSTITUTERELATED_V";
        s_sqlWhere = "M_Product_ID = ? AND M_PriceList_Version_ID = ? and RowType = 'R'";
        this.m_sqlRelated = this.relatedTbl.prepareTable(s_layoutRelated, s_sqlFrom, s_sqlWhere, false, "M_PRODUCT_SUBSTITUTERELATED_V");
        this.relatedTbl.setRowSelectionAllowed(false);
        this.relatedTbl.setMultiSelection(false);
        this.relatedTbl.addMouseListener((MouseListener)((Object)this));
        this.relatedTbl.getSelectionModel().addListSelectionListener(this);
        this.relatedTbl.autoSize();
        this.m_tableAtp.setRowSelectionAllowed(false);
        this.m_tableAtp.setMultiSelection(false);
        this.m_tableLocator.setRowSelectionAllowed(false);
        this.m_tableLocator.setMultiSelection(false);
        CTabbedPane jTab = new CTabbedPane();
        jTab.addTab(Msg.translate((Properties)Env.getCtx(), (String)"Warehouse"), (Component)new JScrollPane((Component)((Object)this.warehouseTbl)));
        jTab.setPreferredSize(new Dimension(this.INFO_WIDTH, this.SCREEN_HEIGHT > 600 ? 250 : 105));
        jTab.addTab(Msg.translate((Properties)Env.getCtx(), (String)"Description"), (Component)new JScrollPane((Component)this.fieldDescription));
        jTab.addTab(Msg.translate((Properties)Env.getCtx(), (String)"Substitute_ID"), (Component)new JScrollPane((Component)((Object)this.substituteTbl)));
        jTab.addTab(Msg.translate((Properties)Env.getCtx(), (String)"RelatedProduct_ID"), (Component)new JScrollPane((Component)((Object)this.relatedTbl)));
        jTab.addTab(Msg.getMsg((Properties)Env.getCtx(), (String)"ATP"), (Component)new JScrollPane((Component)((Object)this.m_tableAtp)));
        jTab.addTab(Msg.getElement((Properties)Env.getCtx(), (String)"M_Locator_ID"), (Component)new JScrollPane((Component)((Object)this.m_tableLocator)));
        jTab.addChangeListener((ChangeListener)this);
        this.tablePanel.setPreferredSize(new Dimension(this.INFO_WIDTH, this.SCREEN_HEIGHT > 600 ? 255 : 110));
        this.tablePanel.add((Component)jTab);
        this.warehouseStockPanel.setCollapsed(true);
        this.warehouseStockPanel.add((Component)this.tablePanel);
        this.addonPanel.add((Component)this.warehouseStockPanel);
        this.p_table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                int row = ((MiniTable)((Object)ke.getSource())).getSelectedRow();
                InfoProduct.this.refresh(((MiniTable)((Object)ke.getSource())).getValueAt(row, 2), new BigDecimal(InfoProduct.this.pickWarehouse.getValue().toString()).intValue(), new BigDecimal(InfoProduct.this.pickPriceList.getValue().toString()).intValue());
                InfoProduct.this.warehouseStockPanel.setCollapsed(false);
            }
        });
        this.p_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                int row = ((MiniTable)((Object)me.getSource())).getSelectedRow();
                InfoProduct.this.refresh(((MiniTable)((Object)me.getSource())).getValueAt(row, 2), new BigDecimal(InfoProduct.this.pickWarehouse.getValue().toString()).intValue(), new BigDecimal(InfoProduct.this.pickPriceList.getValue().toString()).intValue());
                InfoProduct.this.warehouseStockPanel.setCollapsed(false);
            }
        });
    }

    private void refresh(Object obj, int M_Warehouse_ID, int M_PriceList_Version_ID) {
        block18: {
            ResultSet rs;
            CPreparedStatement pstmt;
            String sql;
            block16: {
                block14: {
                    sql = this.m_sqlWarehouse;
                    sql = sql.replace(" FROM", ", DocumentNote FROM");
                    this.log.finest(sql);
                    pstmt = null;
                    rs = null;
                    try {
                        try {
                            pstmt = DB.prepareStatement((String)sql, null);
                            pstmt.setString(1, (String)obj);
                            rs = pstmt.executeQuery();
                            this.fieldDescription.setText("");
                            this.warehouseTbl.loadTable(rs);
                            rs = pstmt.executeQuery();
                            if (rs.next() && rs.getString("DocumentNote") != null) {
                                this.fieldDescription.setText(rs.getString("DocumentNote"));
                            }
                        }
                        catch (Exception e) {
                            this.log.log(Level.WARNING, sql, (Throwable)e);
                            DB.close(rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                }
                this.m_M_Product_ID = this.getSelectedRowKey();
                sql = this.m_sqlSubstitute;
                this.log.finest(sql);
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, null);
                        pstmt.setInt(1, this.m_M_Product_ID);
                        pstmt.setInt(2, M_PriceList_Version_ID);
                        rs = pstmt.executeQuery();
                        this.substituteTbl.loadTable(rs);
                        rs.close();
                    }
                    catch (Exception e) {
                        this.log.log(Level.WARNING, sql, (Throwable)e);
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            sql = this.m_sqlRelated;
            this.log.finest(sql);
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.m_M_Product_ID);
                    pstmt.setInt(2, M_PriceList_Version_ID);
                    rs = pstmt.executeQuery();
                    this.relatedTbl.loadTable(rs);
                    rs.close();
                }
                catch (Exception e) {
                    this.log.log(Level.WARNING, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block18;
                }
            }
            catch (Throwable throwable) {
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.initAtpTab(M_Warehouse_ID);
        this.initLocatorTab(M_Warehouse_ID);
    }

    private void initInfo(String value, int M_Warehouse_ID, int M_PriceList_ID) {
        this.fillPicks(M_PriceList_ID);
        int M_PriceList_Version_ID = this.findPLV(M_PriceList_ID);
        String sField = SysConfigInfoSettings.getFilterToFill(this.getClass(), Env.getAD_Client_ID(Env.getCtx()), Env.getAD_Org_ID(Env.getCtx()));
        boolean bFillName = false;
        boolean bFillValue = false;
        boolean bPrevBehaviour = false;
        if (sField != null) {
            if (sField.equalsIgnoreCase("Name")) {
                bFillName = true;
            } else if (sField.equalsIgnoreCase("Value")) {
                bFillValue = true;
            }
        } else {
            bPrevBehaviour = true;
        }
        if (value.startsWith("@") && value.endsWith("@")) {
            String sVal = value.substring(1, value.length() - 1);
            if (TableIdentifierParser.isParsable(sVal)) {
                TableIdentifierParser parser = new TableIdentifierParser("M_Product");
                parser.parseString(sVal);
                String sName = parser.getValue("Name");
                String sValue = parser.getValue("Value");
                if (sName != null && (bFillName || bPrevBehaviour)) {
                    this.fieldName.setText(sName);
                }
                if (sValue != null && (bFillValue || bPrevBehaviour)) {
                    this.fieldValue.setText(sValue);
                }
            } else {
                if (bFillName || bPrevBehaviour) {
                    this.fieldName.setText(sVal);
                }
                if (bFillValue) {
                    this.fieldValue.setText(sVal);
                }
            }
        } else {
            boolean bReverse;
            if (sField != null && (bReverse = value.startsWith("?"))) {
                bFillName = !bFillName;
                bFillValue = !bFillValue;
                value = value.substring(1);
            }
            if (bFillName) {
                this.fieldName.setText(value);
            }
            if (bFillValue || bPrevBehaviour) {
                this.fieldValue.setText(value);
            }
        }
        if (M_Warehouse_ID == 0) {
            M_Warehouse_ID = Env.getContextAsInt(Env.getCtx(), "#M_Warehouse_ID");
        }
        if (M_Warehouse_ID != 0) {
            this.setWarehouse(M_Warehouse_ID);
        }
        if (M_PriceList_Version_ID != 0) {
            this.setPriceListVersion(M_PriceList_Version_ID);
        }
        StringBuffer where = new StringBuffer();
        where.append("p.IsActive='Y'");
        if (M_Warehouse_ID != 0) {
            where.append(" AND p.IsSummary='N'");
        }
        if (this.p_whereClause != null && this.p_whereClause.length() > 0) {
            where.append(" AND ").append(Util.replace((String)this.p_whereClause, (String)"M_Product.", (String)"p."));
        }
        this.prepareTable(this.getProductLayout(), s_productFrom, where.toString(), "QtyAvailable DESC, Margin DESC");
        this.p_table.setShowTotals(false);
        this.pickWarehouse.addActionListener((ActionListener)this);
        this.pickPriceList.addActionListener((ActionListener)this);
        this.pickProductCategory.addActionListener((ActionListener)this);
        this.pickAS.addActionListener((ActionListener)this);
    }

    private void fillPicks(int M_PriceList_ID) {
        block10: {
            String SQL = "SELECT M_PriceList_Version.M_PriceList_Version_ID, M_PriceList_Version.Name || ' (' || c.Iso_Code || ')' AS ValueName FROM M_PriceList_Version, M_PriceList pl, C_Currency c WHERE M_PriceList_Version.M_PriceList_ID=pl.M_PriceList_ID AND pl.C_Currency_ID=c.C_Currency_ID AND M_PriceList_Version.IsActive='Y' AND pl.IsActive='Y'";
            if (M_PriceList_ID != 0) {
                SQL = String.valueOf(SQL) + " AND EXISTS (SELECT * FROM M_PriceList xp WHERE xp.M_PriceList_ID=" + M_PriceList_ID + " AND pl.C_Currency_ID=xp.C_Currency_ID)";
            }
            SQL = String.valueOf(MRole.getDefault().addAccessSQL(SQL, "M_PriceList_Version", true, false)) + " ORDER BY M_PriceList_Version.Name";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    KeyNamePair kn;
                    this.pickPriceList.addItem((Object)new KeyNamePair(0, ""));
                    pstmt = DB.prepareStatement((String)SQL, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        kn = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        this.pickPriceList.addItem((Object)kn);
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    SQL = String.valueOf(MRole.getDefault().addAccessSQL("SELECT M_Warehouse_ID, Value || ' - ' || Name AS ValueName FROM M_Warehouse WHERE IsActive='Y'", "M_Warehouse", false, false)) + " ORDER BY Value";
                    this.pickWarehouse.addItem((Object)new KeyNamePair(0, ""));
                    pstmt = DB.prepareStatement((String)SQL, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        kn = new KeyNamePair(rs.getInt("M_Warehouse_ID"), rs.getString("ValueName"));
                        this.pickWarehouse.addItem((Object)kn);
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    SQL = String.valueOf(MRole.getDefault().addAccessSQL("SELECT M_Product_Category_ID, Value || ' - ' || Name FROM M_Product_Category WHERE IsActive='Y'", "M_Product_Category", false, false)) + " ORDER BY Value";
                    KeyNamePair[] keyNamePairArray = DB.getKeyNamePairs((String)SQL, (boolean)true);
                    int n = keyNamePairArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        kn = keyNamePairArray[n2];
                        this.pickProductCategory.addItem((Object)kn);
                        ++n2;
                    }
                    SQL = String.valueOf(MRole.getDefault().addAccessSQL("SELECT M_AttributeSet_ID, Name FROM M_AttributeSet WHERE IsActive='Y'", "M_AttributeSet", false, false)) + " ORDER BY Name";
                    keyNamePairArray = DB.getKeyNamePairs((String)SQL, (boolean)true);
                    n = keyNamePairArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        kn = keyNamePairArray[n2];
                        this.pickAS.addItem((Object)kn);
                        ++n2;
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, SQL, (Throwable)e);
                    this.setStatusLine(e.getLocalizedMessage(), true);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    private void setWarehouse(int M_Warehouse_ID) {
        int i = 0;
        while (i < this.pickWarehouse.getItemCount()) {
            KeyNamePair kn = (KeyNamePair)this.pickWarehouse.getItemAt(i);
            if (kn.getKey() == M_Warehouse_ID) {
                this.pickWarehouse.setSelectedIndex(i);
                return;
            }
            ++i;
        }
    }

    private void setPriceListVersion(int M_PriceList_Version_ID) {
        this.log.config("M_PriceList_Version_ID=" + M_PriceList_Version_ID);
        int i = 0;
        while (i < this.pickPriceList.getItemCount()) {
            KeyNamePair kn = (KeyNamePair)this.pickPriceList.getItemAt(i);
            if (kn.getKey() == M_PriceList_Version_ID) {
                this.pickPriceList.setSelectedIndex(i);
                return;
            }
            ++i;
        }
        this.log.fine("NOT found");
    }

    private int findPLV(int M_PriceList_ID) {
        int retValue;
        block10: {
            Timestamp priceDate = null;
            String dateStr = Env.getContext(Env.getCtx(), this.p_WindowNo, "DateOrdered");
            if (dateStr != null && dateStr.length() > 0) {
                priceDate = Env.getContextAsDate(Env.getCtx(), this.p_WindowNo, "DateOrdered");
            } else {
                dateStr = Env.getContext(Env.getCtx(), this.p_WindowNo, "DateInvoiced");
                if (dateStr != null && dateStr.length() > 0) {
                    priceDate = Env.getContextAsDate(Env.getCtx(), this.p_WindowNo, "DateInvoiced");
                }
            }
            if (priceDate == null) {
                priceDate = new Timestamp(System.currentTimeMillis());
            }
            this.log.config("M_PriceList_ID=" + M_PriceList_ID + " - " + priceDate);
            retValue = 0;
            String sql = "SELECT plv.M_PriceList_Version_ID, plv.ValidFrom FROM M_PriceList pl, M_PriceList_Version plv WHERE pl.M_PriceList_ID=plv.M_PriceList_ID AND plv.IsActive='Y' AND pl.M_PriceList_ID=? ORDER BY plv.ValidFrom DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, M_PriceList_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next() && retValue == 0) {
                        Timestamp plDate = rs.getTimestamp(2);
                        if (priceDate.before(plDate)) continue;
                        retValue = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        Env.setContext(Env.getCtx(), this.p_WindowNo, "M_PriceList_Version_ID", retValue);
        return retValue;
    }

    @Override
    protected String getSQLWhere() {
        String vendor;
        String sku;
        String upc;
        String name;
        StringBuffer where = new StringBuffer();
        int M_PriceList_Version_ID = 0;
        KeyNamePair pl = (KeyNamePair)this.pickPriceList.getSelectedItem();
        if (pl != null) {
            M_PriceList_Version_ID = pl.getKey();
        }
        if (M_PriceList_Version_ID != 0) {
            where.append(" AND pr.M_PriceList_Version_ID=?");
        }
        if (this.getM_Product_Category_ID() > 0) {
            where.append(" AND p.M_Product_Category_ID=?");
        }
        if (this.getM_AttributeSet_ID() > 0) {
            where.append(" AND p.M_AttributeSet_ID=?");
        }
        if (this.m_pAttributeWhere != null) {
            where.append(this.m_pAttributeWhere);
            return where.toString();
        }
        String value = this.fieldValue.getText().toUpperCase();
        if (!value.equals("") && !value.equals("%")) {
            where.append(" AND UPPER(p.Value) LIKE ?");
        }
        if (!(name = this.fieldName.getText().toUpperCase()).equals("") && !name.equals("%")) {
            where.append(" AND UPPER(COALESCE(ptrl.Name,p.Name)) LIKE ?");
        }
        if (!(upc = this.fieldUPC.getText().toUpperCase()).equals("") && !upc.equals("%")) {
            where.append(" AND UPPER(p.UPC) LIKE ?");
        }
        if (!(sku = this.fieldSKU.getText().toUpperCase()).equals("") && !sku.equals("%")) {
            where.append(" AND UPPER(p.SKU) LIKE ?");
        }
        if (!(vendor = this.fieldVendor.getText().toUpperCase()).equals("") && !vendor.equals("%")) {
            where.append(" AND UPPER(bp.Name) LIKE ? AND ppo.IsCurrentVendor='Y'");
        }
        return where.toString();
    }

    @Override
    protected void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        String vendor;
        String sku;
        String upc;
        String name;
        int M_AttributeSet_ID;
        int M_Product_Category_ID;
        int index = 1;
        int M_Warehouse_ID = 0;
        KeyNamePair wh = (KeyNamePair)this.pickWarehouse.getSelectedItem();
        if (wh != null) {
            M_Warehouse_ID = wh.getKey();
        }
        if (!forCount) {
            int i = 0;
            while (i < this.p_layout.length) {
                if (this.p_layout[i].getColSQL().indexOf(63) != -1) {
                    pstmt.setInt(index++, M_Warehouse_ID);
                }
                ++i;
            }
        }
        this.log.fine("M_Warehouse_ID=" + M_Warehouse_ID + " (" + (index - 1) + "*)");
        pstmt.setString(index++, Env.getAD_Language(Env.getCtx()));
        int M_PriceList_Version_ID = 0;
        KeyNamePair pl = (KeyNamePair)this.pickPriceList.getSelectedItem();
        if (pl != null) {
            M_PriceList_Version_ID = pl.getKey();
        }
        if (M_PriceList_Version_ID != 0) {
            pstmt.setInt(index++, M_PriceList_Version_ID);
            this.log.fine("M_PriceList_Version_ID=" + M_PriceList_Version_ID);
        }
        if ((M_Product_Category_ID = this.getM_Product_Category_ID()) > 0) {
            pstmt.setInt(index++, M_Product_Category_ID);
            this.log.fine("M_Product_Category_ID=" + M_Product_Category_ID);
        }
        if ((M_AttributeSet_ID = this.getM_AttributeSet_ID()) > 0) {
            pstmt.setInt(index++, M_AttributeSet_ID);
            this.log.fine("M_AttributeSet_ID=" + M_AttributeSet_ID);
        }
        if (this.m_pAttributeWhere != null) {
            return;
        }
        String value = this.fieldValue.getText().toUpperCase();
        if (!value.equals("") && !value.equals("%")) {
            if (!value.endsWith("%")) {
                value = String.valueOf(value) + "%";
            }
            pstmt.setString(index++, value);
            this.log.fine("Value: " + value);
        }
        if (!(name = this.fieldName.getText().toUpperCase()).equals("") && !name.equals("%")) {
            if (!name.endsWith("%")) {
                name = String.valueOf(name) + "%";
            }
            pstmt.setString(index++, name);
            this.log.fine("Name: " + name);
        }
        if (!(upc = this.fieldUPC.getText().toUpperCase()).equals("") && !upc.equals("%")) {
            if (!upc.endsWith("%")) {
                upc = String.valueOf(upc) + "%";
            }
            pstmt.setString(index++, upc);
            this.log.fine("UPC: " + upc);
        }
        if (!(sku = this.fieldSKU.getText().toUpperCase()).equals("") && !sku.equals("%")) {
            if (!sku.endsWith("%")) {
                sku = String.valueOf(sku) + "%";
            }
            pstmt.setString(index++, sku);
            this.log.fine("SKU: " + sku);
        }
        if (!(vendor = this.fieldVendor.getText().toUpperCase()).equals("") && !vendor.equals("%")) {
            if (!vendor.endsWith("%")) {
                vendor = String.valueOf(vendor) + "%";
            }
            pstmt.setString(index++, vendor);
            this.log.fine("Vendor: " + vendor);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ((e.getSource() == this.pickWarehouse || e.getSource() == this.pickPriceList) && this.fieldValue.getText().length() == 0 && this.fieldName.getText().length() == 0) {
            return;
        }
        if (e.getSource().equals(this.m_InfoPAttributeButton)) {
            this.cmd_InfoPAttribute();
            return;
        }
        this.m_pAttributeWhere = null;
        int row = this.p_table.getSelectedRow();
        if (e.getSource().equals(this.m_PAttributeButton) && row != -1) {
            Integer productInteger = this.getSelectedRowKey();
            String productName = (String)this.p_table.getValueAt(row, INDEX_NAME);
            KeyNamePair warehouse = (KeyNamePair)this.pickWarehouse.getSelectedItem();
            if (productInteger == null || productInteger == 0 || warehouse == null) {
                return;
            }
            String title = String.valueOf(warehouse.getName()) + " - " + productName;
            PAttributeInstance pai = new PAttributeInstance((JDialog)((Object)this), title, warehouse.getKey(), 0, productInteger.intValue(), this.m_C_BPartner_ID);
            this.m_M_AttributeSetInstance_ID = pai.getM_AttributeSetInstance_ID();
            this.m_M_Locator_ID = pai.getM_Locator_ID();
            if (this.m_M_AttributeSetInstance_ID != -1) {
                this.dispose(true);
            }
            return;
        }
        super.actionPerformed(e);
    }

    @Override
    protected void enableButtons() {
        this.m_M_AttributeSetInstance_ID = -1;
        if (this.m_PAttributeButton != null) {
            int row = this.p_table.getSelectedRow();
            boolean enabled = false;
            if (row >= 0) {
                Object value = this.p_table.getValueAt(row, INDEX_PATTRIBUTE);
                enabled = Boolean.TRUE.equals(value);
            }
            this.m_PAttributeButton.setEnabled(enabled);
        }
        super.enableButtons();
    }

    private void cmd_InfoPAttribute() {
        InfoPAttribute ia = new InfoPAttribute((JDialog)((Object)this));
        this.m_pAttributeWhere = ia.getWhereClause();
        if (this.m_pAttributeWhere != null) {
            this.executeQuery();
        }
    }

    @Override
    protected void showHistory() {
        this.log.info("");
        Integer M_Product_ID = this.getSelectedRowKey();
        if (M_Product_ID == null) {
            return;
        }
        KeyNamePair kn = (KeyNamePair)this.pickWarehouse.getSelectedItem();
        int M_Warehouse_ID = kn.getKey();
        int M_AttributeSetInstance_ID = this.m_M_AttributeSetInstance_ID;
        if (this.m_M_AttributeSetInstance_ID < -1) {
            M_AttributeSetInstance_ID = 0;
        }
        InvoiceHistory ih = new InvoiceHistory((Dialog)((Object)this), 0, M_Product_ID, M_Warehouse_ID, M_AttributeSetInstance_ID);
        ih.setVisible(true);
        ih = null;
    }

    @Override
    protected boolean hasHistory() {
        return true;
    }

    @Override
    protected void zoom() {
        this.log.info("");
        Integer M_Product_ID = this.getSelectedRowKey();
        if (M_Product_ID == null) {
            return;
        }
        MQuery query = new MQuery("M_Product");
        query.addRestriction("M_Product_ID", "=", (Object)M_Product_ID);
        query.setRecordCount(1);
        int AD_WindowNo = this.getAD_Window_ID("M_Product", true);
        this.zoom(AD_WindowNo, query);
    }

    @Override
    protected boolean hasZoom() {
        return true;
    }

    @Override
    protected void customize() {
        this.log.info("");
    }

    @Override
    protected boolean hasCustomize() {
        return false;
    }

    @Override
    protected void saveSelectionDetail() {
        Integer ID = this.getSelectedRowKey();
        Env.setContext(Env.getCtx(), this.p_WindowNo, 1113, "M_Product_ID", ID == null ? "0" : ID.toString());
        KeyNamePair kn = (KeyNamePair)this.pickPriceList.getSelectedItem();
        Env.setContext(Env.getCtx(), this.p_WindowNo, 1113, "M_PriceList_Version_ID", kn.getID());
        kn = (KeyNamePair)this.pickWarehouse.getSelectedItem();
        Env.setContext(Env.getCtx(), this.p_WindowNo, 1113, "M_Warehouse_ID", kn.getID());
        if (this.m_M_AttributeSetInstance_ID == -1) {
            Env.setContext(Env.getCtx(), this.p_WindowNo, 1113, "M_AttributeSetInstance_ID", "0");
            Env.setContext(Env.getCtx(), this.p_WindowNo, 1113, "M_Locator_ID", "0");
        } else {
            Env.setContext(Env.getCtx(), this.p_WindowNo, 1113, "M_AttributeSetInstance_ID", String.valueOf(this.m_M_AttributeSetInstance_ID));
            Env.setContext(Env.getCtx(), this.p_WindowNo, 1113, "M_Locator_ID", String.valueOf(this.m_M_Locator_ID));
        }
    }

    protected Info_Column[] getProductLayout() {
        if (s_productLayout != null) {
            return s_productLayout;
        }
        if (s_productLayout == null) {
            ArrayList<Info_Column> list = new ArrayList<Info_Column>();
            list.add(new Info_Column(" ", "p.M_Product_ID", IDColumn.class, !this.p_multiSelection));
            list.add(new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"Discontinued").substring(0, 1), "p.Discontinued", Boolean.class));
            list.add(new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"Value"), "p.Value", String.class));
            list.add(new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"Name"), "COALESCE(ptrl.Name, p.Name) as Name", String.class));
            list.add(new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"QtyAvailable"), "case when p.IsBOM='N' and (p.ProductType!='I' OR p.IsStocked='N') then to_number(get_Sysconfig('QTY_TO_SHOW_FOR_SERVICES', '99999', p.ad_client_id, 0), '99999999999') else bomQtyAvailable(p.M_Product_ID,?,0) end AS QtyAvailable", Double.class, true, true, null));
            list.add(new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"PriceList"), "bomPriceList(p.M_Product_ID, pr.M_PriceList_Version_ID) AS PriceList", BigDecimal.class));
            list.add(new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"PriceStd"), "bomPriceStd(p.M_Product_ID, pr.M_PriceList_Version_ID) AS PriceStd", BigDecimal.class));
            list.add(new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"QtyOnHand"), "case when p.IsBOM='N' and (p.ProductType!='I' OR p.IsStocked='N') then to_number(get_Sysconfig('QTY_TO_SHOW_FOR_SERVICES', '99999', p.ad_client_id, 0), '99999999999') else bomQtyOnHand(p.M_Product_ID,?,0) end AS QtyOnHand", Double.class));
            list.add(new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"QtyReserved"), "bomQtyReserved(p.M_Product_ID,?,0) AS QtyReserved", Double.class));
            list.add(new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"QtyOrdered"), "bomQtyOrdered(p.M_Product_ID,?,0) AS QtyOrdered", Double.class));
            if (this.isUnconfirmed()) {
                list.add(new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"QtyUnconfirmed"), "(SELECT SUM(c.TargetQty) FROM M_InOutLineConfirm c INNER JOIN M_InOutLine il ON (c.M_InOutLine_ID=il.M_InOutLine_ID) INNER JOIN M_InOut i ON (il.M_InOut_ID=i.M_InOut_ID) WHERE c.Processed='N' AND i.M_Warehouse_ID=? AND il.M_Product_ID=p.M_Product_ID) AS QtyUnconfirmed", Double.class));
                list.add(new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"QtyUnconfirmedMove"), "(SELECT SUM(c.TargetQty) FROM M_MovementLineConfirm c INNER JOIN M_MovementLine ml ON (c.M_MovementLine_ID=ml.M_MovementLine_ID) INNER JOIN M_Locator l ON (ml.M_LocatorTo_ID=l.M_Locator_ID) WHERE c.Processed='N' AND l.M_Warehouse_ID=? AND ml.M_Product_ID=p.M_Product_ID) AS QtyUnconfirmedMove", Double.class));
            }
            list.add(new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"Margin"), "bomPriceStd(p.M_Product_ID, pr.M_PriceList_Version_ID)-bomPriceLimit(p.M_Product_ID, pr.M_PriceList_Version_ID) AS Margin", BigDecimal.class));
            list.add(new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"Vendor"), "bp.Name", String.class));
            list.add(new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"PriceLimit"), "bomPriceLimit(p.M_Product_ID, pr.M_PriceList_Version_ID) AS PriceLimit", BigDecimal.class));
            list.add(new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"IsInstanceAttribute"), "pa.IsInstanceAttribute", Boolean.class));
            list.add(new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)"M_PriceList_Version_ID"), "pv.Name", String.class));
            s_productLayout = new Info_Column[list.size()];
            list.toArray(s_productLayout);
            INDEX_NAME = 3;
            INDEX_PATTRIBUTE = s_productLayout.length - 2;
        }
        return s_productLayout;
    }

    private boolean isUnconfirmed() {
        int no = DB.getSQLValue(null, (String)"SELECT COUNT(*) FROM M_InOutLineConfirm WHERE AD_Client_ID=?", (int)Env.getAD_Client_ID(Env.getCtx()));
        if (no > 0) {
            return true;
        }
        no = DB.getSQLValue(null, (String)"SELECT COUNT(*) FROM M_MovementLineConfirm WHERE AD_Client_ID=?", (int)Env.getAD_Client_ID(Env.getCtx()));
        return no > 0;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        CTabbedPane tab;
        if (e.getSource() instanceof CTabbedPane && (tab = (CTabbedPane)e.getSource()).getSelectedIndex() >= 4 && this.warehouseTbl.getRowCount() > 0) {
            int M_Warehouse_ID = 0;
            if (this.warehouseTbl.getSelectedRow() >= 0) {
                String value = (String)this.warehouseTbl.getValueAt(this.warehouseTbl.getSelectedRow(), 0);
                M_Warehouse_ID = DB.getSQLValue(null, (String)"SELECT M_Warehouse_ID FROM M_Warehouse WHERE UPPER(Name) = UPPER(?) AND AD_Client_ID=?", (Object[])new Object[]{value, Env.getAD_Client_ID(Env.getCtx())});
            }
            if (tab.getSelectedIndex() == 4) {
                this.initAtpTab(M_Warehouse_ID);
            }
            if (tab.getSelectedIndex() == 5) {
                this.initLocatorTab(M_Warehouse_ID);
            }
        }
    }

    private void initAtpTab(int m_M_Warehouse_ID) {
        Vector data;
        Vector<String> columnNames;
        block32: {
            ResultSet rs;
            CPreparedStatement pstmt;
            double qty;
            String sql;
            boolean showDetail;
            block30: {
                columnNames = new Vector<String>();
                columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Date"));
                columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"QtyOnHand"));
                columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
                columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"QtyOrdered"));
                columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"QtyReserved"));
                columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"M_Locator_ID"));
                columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"M_AttributeSetInstance_ID"));
                columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"M_Lot_ID"));
                columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo"));
                columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"M_Warehouse_ID"));
                showDetail = CLogMgt.isLevelFine();
                sql = "SELECT s.QtyOnHand, s.QtyReserved, s.QtyOrdered, productAttribute(s.M_AttributeSetInstance_ID), s.M_AttributeSetInstance_ID,";
                if (!showDetail) {
                    sql = "SELECT SUM(s.QtyOnHand), SUM(s.QtyReserved), SUM(s.QtyOrdered), productAttribute(s.M_AttributeSetInstance_ID), 0,";
                }
                sql = String.valueOf(sql) + " w.Name, l.Value, lot.description as lot FROM M_Storage s INNER JOIN M_Locator l ON (s.M_Locator_ID=l.M_Locator_ID) INNER JOIN M_Warehouse w ON (l.M_Warehouse_ID=w.M_Warehouse_ID)  LEFT JOIN M_AttributeSetInstance asi ON (asi.M_AttributeSetInstance_ID=s.M_AttributeSetInstance_ID)  LEFT JOIN M_Lot lot ON (lot.M_Lot_ID=asi.M_Lot_ID) WHERE s.M_Product_ID=?";
                if (m_M_Warehouse_ID != 0) {
                    sql = String.valueOf(sql) + " AND l.M_Warehouse_ID=?";
                }
                if (this.m_M_AttributeSetInstance_ID > 0) {
                    sql = String.valueOf(sql) + " AND s.M_AttributeSetInstance_ID=?";
                }
                sql = String.valueOf(sql) + " AND (s.QtyOnHand<>0 OR s.QtyReserved<>0 OR s.QtyOrdered<>0)";
                if (!showDetail) {
                    sql = String.valueOf(sql) + " GROUP BY productAttribute(s.M_AttributeSetInstance_ID), w.Name, l.Value, lot.description";
                }
                sql = String.valueOf(sql) + " ORDER BY l.Value";
                data = new Vector();
                qty = 0.0;
                pstmt = null;
                rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, null);
                        pstmt.setInt(1, this.m_M_Product_ID);
                        if (m_M_Warehouse_ID != 0) {
                            pstmt.setInt(2, m_M_Warehouse_ID);
                        }
                        if (this.m_M_AttributeSetInstance_ID > 0) {
                            pstmt.setInt(3, this.m_M_AttributeSetInstance_ID);
                        }
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            Vector<Object> line = new Vector<Object>(10);
                            line.add(null);
                            double qtyOnHand = rs.getDouble(1);
                            qty += qtyOnHand;
                            line.add(new Double(qtyOnHand));
                            line.add(null);
                            line.add(new Double(rs.getDouble(3)));
                            line.add(new Double(rs.getDouble(2)));
                            line.add(rs.getString(7));
                            String asi = rs.getString(4);
                            if (showDetail && (asi == null || asi.length() == 0)) {
                                asi = "{" + rs.getInt(5) + "}";
                            }
                            line.add(asi);
                            line.add(rs.getString(8));
                            line.add(null);
                            line.add(rs.getString(6));
                            data.add(line);
                        }
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, sql, (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block30;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            sql = "SELECT o.DatePromised, ol.QtyReserved, productAttribute(ol.M_AttributeSetInstance_ID), ol.M_AttributeSetInstance_ID, dt.DocBaseType, bp.Name, dt.PrintName || ' ' || o.DocumentNo As DocumentNo, w.Name , lot.description as lot FROM C_Order o INNER JOIN C_OrderLine ol ON (o.C_Order_ID=ol.C_Order_ID) INNER JOIN C_DocType dt ON (o.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Warehouse w ON (ol.M_Warehouse_ID=w.M_Warehouse_ID) INNER JOIN C_BPartner bp  ON (o.C_BPartner_ID=bp.C_BPartner_ID)  LEFT JOIN M_AttributeSetInstance asi ON (asi.M_AttributeSetInstance_ID=ol.M_AttributeSetInstance_ID)  LEFT JOIN M_Lot lot ON (lot.M_Lot_ID=asi.M_Lot_ID) WHERE ol.QtyReserved<>0 AND ol.M_Product_ID=?";
            if (m_M_Warehouse_ID != 0) {
                sql = String.valueOf(sql) + " AND ol.M_Warehouse_ID=?";
            }
            if (this.m_M_AttributeSetInstance_ID > 0) {
                sql = String.valueOf(sql) + " AND ol.M_AttributeSetInstance_ID=?";
            }
            String sqlPPOrderBOM = " UNION ALL SELECT ppo.DatePromised, ppol.QtyReserved, productAttribute(ppol.M_AttributeSetInstance_ID), ppol.M_AttributeSetInstance_ID, 'SOO' as DocBaseType, null as Name, dt.PrintName || ' ' || ppo.DocumentNo As DocumentNo, w.Name , lot.description as lot FROM PP_Order ppo INNER JOIN PP_Order_BOMLine ppol ON (ppo.PP_Order_ID=ppol.PP_Order_ID) INNER JOIN C_DocType dt ON (ppo.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Warehouse w ON (ppol.M_Warehouse_ID=w.M_Warehouse_ID) LEFT JOIN M_AttributeSetInstance asi ON (asi.M_AttributeSetInstance_ID=ppol.M_AttributeSetInstance_ID)  LEFT JOIN M_Lot lot ON (lot.M_Lot_ID=asi.M_Lot_ID) WHERE ppol.QtyReserved<>0 AND ppol.M_Product_ID=?";
            if (m_M_Warehouse_ID != 0) {
                sqlPPOrderBOM = String.valueOf(sqlPPOrderBOM) + " AND ppol.M_Warehouse_ID=?";
            }
            if (this.m_M_AttributeSetInstance_ID > 0) {
                sqlPPOrderBOM = String.valueOf(sqlPPOrderBOM) + " AND ppol.M_AttributeSetInstance_ID=?";
            }
            String sqlPPOrderHdr = " UNION ALL SELECT ppo.DatePromised, ppo.QtyReserved, productAttribute(ppo.M_AttributeSetInstance_ID), ppo.M_AttributeSetInstance_ID, 'POO' as DocBaseType, null as Name, dt.PrintName || ' ' || ppo.DocumentNo As DocumentNo, w.Name , lot.description as lot FROM PP_Order ppo INNER JOIN C_DocType dt ON (ppo.C_DocType_ID=dt.C_DocType_ID) INNER JOIN M_Warehouse w ON (ppo.M_Warehouse_ID=w.M_Warehouse_ID) LEFT JOIN M_AttributeSetInstance asi ON (asi.M_AttributeSetInstance_ID=ppo.M_AttributeSetInstance_ID)  LEFT JOIN M_Lot lot ON (lot.M_Lot_ID=asi.M_Lot_ID) WHERE ppo.QtyReserved<>0 AND ppo.M_Product_ID=?";
            if (m_M_Warehouse_ID != 0) {
                sqlPPOrderHdr = String.valueOf(sqlPPOrderHdr) + " AND ppo.M_Warehouse_ID=?";
            }
            if (this.m_M_AttributeSetInstance_ID > 0) {
                sqlPPOrderHdr = String.valueOf(sqlPPOrderHdr) + " AND ppo.M_AttributeSetInstance_ID=?";
            }
            sql = String.valueOf(sql) + sqlPPOrderBOM + sqlPPOrderHdr + " ORDER BY DatePromised";
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    int idx = 1;
                    int i = 0;
                    while (i < 3) {
                        pstmt.setInt(idx++, this.m_M_Product_ID);
                        if (m_M_Warehouse_ID != 0) {
                            pstmt.setInt(idx++, m_M_Warehouse_ID);
                        }
                        if (this.m_M_AttributeSetInstance_ID > 0) {
                            pstmt.setInt(idx++, this.m_M_AttributeSetInstance_ID);
                        }
                        ++i;
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>(10);
                        line.add(rs.getTimestamp(1));
                        double oq = rs.getDouble(2);
                        String DocBaseType = rs.getString(5);
                        Double qtyReserved = null;
                        Double qtyOrdered = null;
                        if ("POO".equals(DocBaseType)) {
                            qtyOrdered = new Double(oq);
                            qty += oq;
                        } else {
                            qtyReserved = new Double(oq);
                            qty -= oq;
                        }
                        line.add(new Double(qty));
                        line.add(rs.getString(6));
                        line.add(qtyOrdered);
                        line.add(qtyReserved);
                        line.add(null);
                        String asi = rs.getString(3);
                        if (showDetail && (asi == null || asi.length() == 0)) {
                            asi = "{" + rs.getInt(4) + "}";
                        }
                        line.add(asi);
                        line.add(rs.getString(9));
                        line.add(rs.getString(7));
                        line.add(rs.getString(8));
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block32;
                }
            }
            catch (Throwable throwable) {
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MiniTable table = null;
        this.m_modelAtp = new DefaultTableModel(data, columnNames);
        this.m_tableAtp.setModel(this.m_modelAtp);
        table = this.m_tableAtp;
        table.setColumnClass(0, Timestamp.class, true);
        table.setColumnClass(1, Double.class, true);
        table.setColumnClass(2, String.class, true);
        table.setColumnClass(3, Double.class, true);
        table.setColumnClass(4, Double.class, true);
        table.setColumnClass(5, String.class, true);
        table.setColumnClass(6, String.class, true);
        table.setColumnClass(7, String.class, true);
        table.setColumnClass(8, String.class, true);
        table.autoSize();
    }

    private void initLocatorTab(int m_M_Warehouse_ID) {
        Vector data;
        Vector<String> columnNames;
        boolean showWarehouse;
        block11: {
            showWarehouse = m_M_Warehouse_ID == 0;
            columnNames = new Vector<String>();
            if (showWarehouse) {
                columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"M_Warehouse_ID"));
            }
            columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"M_Locator_ID"));
            columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"QtyOnHand"));
            columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"QtyOrdered"));
            columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"QtyReserved"));
            String sql = "SELECT SUM(s.QtyOnHand), SUM(s.QtyReserved), SUM(s.QtyOrdered), w.Name, l.Value FROM M_Storage s INNER JOIN M_Locator l ON (s.M_Locator_ID=l.M_Locator_ID) INNER JOIN M_Warehouse w ON (l.M_Warehouse_ID=w.M_Warehouse_ID) WHERE M_Product_ID=?";
            if (m_M_Warehouse_ID != 0) {
                sql = String.valueOf(sql) + " AND l.M_Warehouse_ID=?";
            }
            sql = String.valueOf(sql) + " AND (s.QtyOnHand<>0 OR s.QtyReserved<>0 OR s.QtyOrdered<>0)";
            sql = String.valueOf(sql) + " GROUP BY w.Name, l.Value";
            sql = String.valueOf(sql) + " ORDER BY w.Name, l.Value";
            data = new Vector();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.m_M_Product_ID);
                    if (m_M_Warehouse_ID != 0) {
                        pstmt.setInt(2, m_M_Warehouse_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>(9);
                        if (showWarehouse) {
                            line.add(rs.getString(4));
                        }
                        line.add(rs.getString(5));
                        line.add(new Double(rs.getDouble(1)));
                        line.add(new Double(rs.getDouble(3)));
                        line.add(new Double(rs.getDouble(2)));
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MiniTable table = null;
        this.m_modelLocator = new DefaultTableModel(data, columnNames);
        this.m_tableLocator.setModel(this.m_modelLocator);
        table = this.m_tableLocator;
        int col = 0;
        if (showWarehouse) {
            table.setColumnClass(col++, String.class, true);
        }
        table.setColumnClass(col++, String.class, true);
        table.setColumnClass(col++, Double.class, true);
        table.setColumnClass(col++, Double.class, true);
        table.setColumnClass(col++, Double.class, true);
        table.autoSize();
    }

    public int getM_Product_Category_ID() {
        int M_Product_Category_ID = 0;
        KeyNamePair pc = (KeyNamePair)this.pickProductCategory.getSelectedItem();
        if (pc != null) {
            M_Product_Category_ID = pc.getKey();
        }
        return M_Product_Category_ID;
    }

    public int getM_AttributeSet_ID() {
        int M_AttributeSet_ID = 0;
        KeyNamePair as = (KeyNamePair)this.pickAS.getSelectedItem();
        if (as != null) {
            M_AttributeSet_ID = as.getKey();
        }
        return M_AttributeSet_ID;
    }
}

