/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import com.f3p.adempiere.search.SysConfigInfoSettings;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.Info_Column;
import org.compiere.minigrid.IDColumn;
import org.compiere.swing.CLabel;
import org.compiere.swing.CTextField;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class InfoGeneral
extends Info {
    private static final long serialVersionUID = -7588425490485071820L;
    private Info_Column[] m_generalLayout;
    private ArrayList<String> m_queryColumns = new ArrayList();
    private ArrayList<String> m_queryColumnsSql = new ArrayList();
    private CLabel label1 = new CLabel();
    private CTextField textField1 = new CTextField(10);
    private CLabel label2 = new CLabel();
    private CTextField textField2 = new CTextField(10);
    private CLabel label3 = new CLabel();
    private CTextField textField3 = new CTextField(10);
    private CLabel label4 = new CLabel();
    private CTextField textField4 = new CTextField(10);

    protected InfoGeneral(Frame frame, boolean modal, int WindowNo, String value, String tableName, String keyColumn, boolean multiSelection, String whereClause) {
        super(frame, modal, WindowNo, tableName, keyColumn, multiSelection, whereClause);
        this.log.info(String.valueOf(tableName) + " - " + keyColumn + " - " + whereClause);
        this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"Info"));
        this.statInit();
        this.p_loadedOK = this.initInfo();
        int no = this.p_table.getRowCount();
        this.setStatusLine(String.valueOf(Integer.toString(no)) + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"SearchRows_EnterQuery"), false);
        this.setStatusDB(Integer.toString(no));
        if (value != null && value.length() > 0) {
            boolean bFill = false;
            if (!value.startsWith("?")) {
                String sField = SysConfigInfoSettings.getFilterToFill(this.getClass(), Env.getAD_Client_ID(Env.getCtx()), Env.getAD_Org_ID(Env.getCtx()));
                if (sField != null && !bFill) {
                    if (this.m_queryColumns.get(0).toString().equalsIgnoreCase(sField)) {
                        this.textField1.setValue((Object)value);
                        this.textField1.requestFocus();
                        bFill = true;
                    } else if (this.textField2.isVisible() && this.m_queryColumns.get(1).toString().equalsIgnoreCase(sField)) {
                        this.textField2.setValue((Object)value);
                        this.textField2.requestFocus();
                        bFill = true;
                    } else if (this.textField3.isVisible() && this.m_queryColumns.get(2).toString().equalsIgnoreCase(sField)) {
                        this.textField3.setValue((Object)value);
                        this.textField3.requestFocus();
                        bFill = true;
                    } else if (this.textField4.isVisible() && this.m_queryColumns.get(3).toString().equalsIgnoreCase(sField)) {
                        this.textField4.setValue((Object)value);
                        this.textField4.requestFocus();
                        bFill = true;
                    }
                }
            } else {
                value = value.substring(1);
            }
            if (!bFill) {
                this.textField1.setValue((Object)value);
                this.textField1.requestFocus();
            }
        } else {
            this.textField1.requestFocus();
        }
        if (value != null && value.length() > 0) {
            this.executeQuery();
        }
    }

    private void statInit() {
        this.label1.setLabelFor((Component)this.textField1);
        this.label1.setText("Label1");
        this.label1.setHorizontalAlignment(10);
        this.textField1.setBackground(AdempierePLAF.getInfoBackground());
        this.label2.setLabelFor((Component)this.textField2);
        this.label2.setText("Label2");
        this.label2.setHorizontalAlignment(10);
        this.textField2.setBackground(AdempierePLAF.getInfoBackground());
        this.label3.setLabelFor((Component)this.textField3);
        this.label3.setText("Label3");
        this.label3.setHorizontalAlignment(10);
        this.textField3.setBackground(AdempierePLAF.getInfoBackground());
        this.label4.setLabelFor((Component)this.textField4);
        this.label4.setText("Label4");
        this.label4.setHorizontalAlignment(10);
        this.textField4.setBackground(AdempierePLAF.getInfoBackground());
        this.parameterPanel.setLayout((LayoutManager)new ALayout());
        this.parameterPanel.add((Component)this.label1, (Object)new ALayoutConstraint(0, 0));
        this.parameterPanel.add((Component)this.label2, null);
        this.parameterPanel.add((Component)this.label3, null);
        this.parameterPanel.add((Component)this.label4, null);
        this.parameterPanel.add((Component)this.textField1, (Object)new ALayoutConstraint(1, 0));
        this.parameterPanel.add((Component)this.textField2, null);
        this.parameterPanel.add((Component)this.textField3, null);
        this.parameterPanel.add((Component)this.textField4, null);
    }

    private boolean initInfo() {
        if (!this.initInfoTable()) {
            return false;
        }
        StringBuffer where = new StringBuffer("IsActive='Y'");
        if (this.p_whereClause.length() > 0) {
            where.append(" AND ").append(this.p_whereClause);
        }
        this.prepareTable(this.m_generalLayout, this.p_tableName, where.toString(), "2");
        this.label1.setText(Msg.translate((Properties)Env.getCtx(), (String)this.m_queryColumns.get(0).toString()));
        this.textField1.addActionListener((ActionListener)((Object)this));
        if (this.m_queryColumns.size() > 1) {
            this.label2.setText(Msg.translate((Properties)Env.getCtx(), (String)this.m_queryColumns.get(1).toString()));
            this.textField2.addActionListener((ActionListener)((Object)this));
        } else {
            this.label2.setVisible(false);
            this.textField2.setVisible(false);
        }
        if (this.m_queryColumns.size() > 2) {
            this.label3.setText(Msg.translate((Properties)Env.getCtx(), (String)this.m_queryColumns.get(2).toString()));
            this.textField3.addActionListener((ActionListener)((Object)this));
        } else {
            this.label3.setVisible(false);
            this.textField3.setVisible(false);
        }
        if (this.m_queryColumns.size() > 3) {
            this.label4.setText(Msg.translate((Properties)Env.getCtx(), (String)this.m_queryColumns.get(3).toString()));
            this.textField4.addActionListener((ActionListener)((Object)this));
        } else {
            this.label4.setVisible(false);
            this.textField4.setVisible(false);
        }
        return true;
    }

    private boolean initInfoTable() {
        String sql = "SELECT c.ColumnName, t.AD_Table_ID, t.TableName, c.ColumnSql FROM AD_Table t INNER JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID)WHERE c.AD_Reference_ID=10 AND t.TableName=? AND EXISTS (SELECT * FROM AD_Field f WHERE f.AD_Column_ID=c.AD_Column_ID AND f.IsDisplayed='Y' AND f.IsEncrypted='N' AND f.ObscureType IS NULL) ORDER BY c.IsIdentifier DESC, c.SeqNo";
        int AD_Table_ID = 0;
        String tableName = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setString(1, this.p_tableName);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.m_queryColumns.add(rs.getString(1));
                    String columnSql = rs.getString(4);
                    if (columnSql != null && columnSql.length() > 0) {
                        this.m_queryColumnsSql.add(columnSql);
                    } else {
                        this.m_queryColumnsSql.add(rs.getString(1));
                    }
                    if (AD_Table_ID != 0) continue;
                    AD_Table_ID = rs.getInt(2);
                    tableName = rs.getString(3);
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return false;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        if (this.m_queryColumns.size() == 0) {
            this.log.log(Level.SEVERE, "No query columns found");
            return false;
        }
        this.log.finest("Table " + tableName + ", ID=" + AD_Table_ID + ", QueryColumns #" + this.m_queryColumns.size());
        while (this.m_queryColumns.size() > 4) {
            this.m_queryColumns.remove(this.m_queryColumns.size() - 1);
            this.m_queryColumnsSql.remove(this.m_queryColumnsSql.size() - 1);
        }
        String title = Msg.translate((Properties)Env.getCtx(), (String)(String.valueOf(tableName) + "_ID"));
        if (title.endsWith("_ID")) {
            title = Msg.translate((Properties)Env.getCtx(), (String)tableName);
        }
        this.setTitle(String.valueOf(this.getTitle()) + " " + title);
        ArrayList<Info_Column> list = new ArrayList<Info_Column>();
        sql = "SELECT c.ColumnName, c.AD_Reference_ID, c.IsKey, f.IsDisplayed, c.AD_Reference_Value_ID, c.ColumnSql FROM AD_Column c INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID) INNER JOIN AD_Tab tab ON (t.AD_Window_ID=tab.AD_Window_ID) INNER JOIN AD_Field f ON (tab.AD_Tab_ID=f.AD_Tab_ID AND f.AD_Column_ID=c.AD_Column_ID) WHERE t.AD_Table_ID=?  AND (c.IsKey='Y' OR  (f.IsEncrypted='N' AND f.ObscureType IS NULL)) ORDER BY c.IsKey DESC, f.SeqNo";
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, AD_Table_ID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String columnName = rs.getString(1);
                    int displayType = rs.getInt(2);
                    boolean isKey = rs.getString(3).equals("Y");
                    boolean isDisplayed = rs.getString(4).equals("Y");
                    int AD_Reference_Value_ID = rs.getInt(5);
                    String columnSql = rs.getString(6);
                    if (columnSql == null || columnSql.length() == 0) {
                        columnSql = columnName;
                    }
                    StringBuffer colSql = new StringBuffer(columnSql);
                    Class colClass = null;
                    if (isKey) {
                        colClass = IDColumn.class;
                    } else if (isDisplayed) {
                        if (displayType == 20) {
                            colClass = Boolean.class;
                        } else if (displayType == 12) {
                            colClass = BigDecimal.class;
                        } else if (displayType == 22 || displayType == 29) {
                            colClass = Double.class;
                        } else if (displayType == 11) {
                            colClass = Integer.class;
                        } else if (displayType == 10 || displayType == 14 || displayType == 34) {
                            colClass = String.class;
                        } else if (DisplayType.isDate((int)displayType)) {
                            colClass = Timestamp.class;
                        } else if (displayType == 17) {
                            colSql = Env.isBaseLanguage(Env.getCtx(), "AD_Ref_List") ? new StringBuffer("(SELECT l.Name FROM AD_Ref_List l WHERE l.AD_Reference_ID=").append(AD_Reference_Value_ID).append(" AND l.Value=").append(columnSql).append(") AS ").append(columnName) : new StringBuffer("(SELECT t.Name FROM AD_Ref_List l, AD_Ref_List_Trl t WHERE l.AD_Ref_List_ID=t.AD_Ref_List_ID AND l.AD_Reference_ID=").append(AD_Reference_Value_ID).append(" AND l.Value=").append(columnSql).append(" AND t.AD_Language='").append(Env.getAD_Language(Env.getCtx())).append("') AS ").append(columnName);
                            colClass = String.class;
                        }
                    }
                    if (colClass != null) {
                        list.add(new Info_Column(Msg.translate((Properties)Env.getCtx(), (String)columnName), colSql.toString(), colClass));
                        this.log.finest("Added Column=" + columnName);
                        continue;
                    }
                    this.log.finest("Not Added Column=" + columnName);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return false;
            }
        }
        finally {
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (list.size() == 0) {
            ADialog.error((int)this.p_WindowNo, (Container)((Object)this), (String)"Error", (String)"No Info Columns");
            this.log.log(Level.SEVERE, "No Info for AD_Table_ID=" + AD_Table_ID + " - " + sql);
            return false;
        }
        this.log.finest("InfoColumns #" + list.size());
        this.m_generalLayout = new Info_Column[list.size()];
        list.toArray(this.m_generalLayout);
        return true;
    }

    @Override
    protected String getSQLWhere() {
        StringBuffer sql = new StringBuffer();
        this.addSQLWhere(sql, 0, this.textField1.getText().toUpperCase());
        this.addSQLWhere(sql, 1, this.textField2.getText().toUpperCase());
        this.addSQLWhere(sql, 2, this.textField3.getText().toUpperCase());
        this.addSQLWhere(sql, 3, this.textField4.getText().toUpperCase());
        return sql.toString();
    }

    private void addSQLWhere(StringBuffer sql, int index, String value) {
        if (!value.equals("") && !value.equals("%") && index < this.m_queryColumns.size()) {
            sql.append(" AND UPPER(").append(this.m_queryColumnsSql.get(index).toString()).append(") LIKE ?");
        }
    }

    private String getSQLText(CTextField f) {
        String s = f.getText().toUpperCase();
        if (!s.endsWith("%")) {
            s = String.valueOf(s) + "%";
        }
        this.log.fine("String=" + s);
        return s;
    }

    @Override
    protected void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        int index = 1;
        if (this.textField1.getText().length() > 0) {
            pstmt.setString(index++, this.getSQLText(this.textField1));
        }
        if (this.textField2.getText().length() > 0) {
            pstmt.setString(index++, this.getSQLText(this.textField2));
        }
        if (this.textField3.getText().length() > 0) {
            pstmt.setString(index++, this.getSQLText(this.textField3));
        }
        if (this.textField4.getText().length() > 0) {
            pstmt.setString(index++, this.getSQLText(this.textField4));
        }
    }
}

