/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.Allocation;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;

public class VAllocation
extends Allocation
implements FormPanel,
ActionListener,
TableModelListener,
VetoableChangeListener {
    private CPanel panel = new CPanel();
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel parameterPanel = new CPanel();
    private CPanel allocationPanel = new CPanel();
    private GridBagLayout parameterLayout = new GridBagLayout();
    private JLabel bpartnerLabel = new JLabel();
    private VLookup bpartnerSearch = null;
    private MiniTable invoiceTable = new MiniTable();
    private MiniTable paymentTable = new MiniTable();
    private JSplitPane infoPanel = new JSplitPane();
    private CPanel paymentPanel = new CPanel();
    private CPanel invoicePanel = new CPanel();
    private JLabel paymentLabel = new JLabel();
    private JLabel invoiceLabel = new JLabel();
    private BorderLayout paymentLayout = new BorderLayout();
    private BorderLayout invoiceLayout = new BorderLayout();
    private JLabel paymentInfo = new JLabel();
    private JLabel invoiceInfo = new JLabel();
    private JScrollPane paymentScrollPane = new JScrollPane();
    private JScrollPane invoiceScrollPane = new JScrollPane();
    private GridBagLayout allocationLayout = new GridBagLayout();
    private JLabel differenceLabel = new JLabel();
    private CTextField differenceField = new CTextField();
    private JButton allocateButton = new JButton();
    private JLabel currencyLabel = new JLabel();
    private VLookup currencyPick = null;
    private JCheckBox multiCurrency = new JCheckBox();
    private JLabel allocCurrencyLabel = new JLabel();
    private StatusBar statusBar = new StatusBar();
    private JLabel dateLabel = new JLabel();
    private VDate dateField = new VDate();
    private JCheckBox autoWriteOff = new JCheckBox();
    private JLabel organizationLabel = new JLabel();
    private VLookup organizationPick = null;

    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        Env.setContext(Env.getCtx(), this.m_WindowNo, "IsSOTrx", "Y");
        try {
            super.dynInit();
            this.dynInit();
            this.jbInit();
            this.calculate();
            frame.getContentPane().add((Component)this.mainPanel, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground((JComponent)this.panel);
        this.mainPanel.setLayout((LayoutManager)this.mainLayout);
        this.dateLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Date"));
        this.dateLabel.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"AllocDate", (boolean)false));
        this.autoWriteOff.setSelected(false);
        this.autoWriteOff.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"AutoWriteOff", (boolean)true));
        this.autoWriteOff.setToolTipText(Msg.getMsg((Properties)Env.getCtx(), (String)"AutoWriteOff", (boolean)false));
        this.parameterPanel.setLayout((LayoutManager)this.parameterLayout);
        this.allocationPanel.setLayout((LayoutManager)this.allocationLayout);
        this.bpartnerLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        this.paymentLabel.setRequestFocusEnabled(false);
        this.paymentLabel.setText(" " + Msg.translate((Properties)Env.getCtx(), (String)"C_Payment_ID"));
        this.invoiceLabel.setRequestFocusEnabled(false);
        this.invoiceLabel.setText(" " + Msg.translate((Properties)Env.getCtx(), (String)"C_Invoice_ID"));
        this.paymentPanel.setLayout((LayoutManager)this.paymentLayout);
        this.invoicePanel.setLayout((LayoutManager)this.invoiceLayout);
        this.invoiceInfo.setHorizontalAlignment(4);
        this.invoiceInfo.setHorizontalTextPosition(4);
        this.invoiceInfo.setText(".");
        this.paymentInfo.setHorizontalAlignment(4);
        this.paymentInfo.setHorizontalTextPosition(4);
        this.paymentInfo.setText(".");
        this.differenceLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Difference"));
        this.differenceField.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.differenceField.setEditable(false);
        this.differenceField.setText("0");
        this.differenceField.setColumns(8);
        this.differenceField.setHorizontalAlignment(4);
        this.allocateButton.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Process"));
        this.allocateButton.addActionListener(this);
        this.currencyLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_Currency_ID"));
        this.multiCurrency.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"MultiCurrency"));
        this.multiCurrency.addActionListener(this);
        this.allocCurrencyLabel.setText(".");
        this.invoiceScrollPane.setPreferredSize(new Dimension(200, 200));
        this.paymentScrollPane.setPreferredSize(new Dimension(200, 200));
        this.mainPanel.add((Component)this.parameterPanel, (Object)"North");
        this.organizationLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"AD_Org_ID"));
        this.parameterPanel.add((Component)this.organizationLabel, (Object)new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.organizationPick, (Object)new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.bpartnerLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.bpartnerSearch, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateLabel, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateField, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.currencyLabel, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.currencyPick, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.multiCurrency, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.autoWriteOff, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.allocationPanel, (Object)"South");
        this.allocationPanel.add((Component)this.differenceLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.allocationPanel.add((Component)this.differenceField, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.allocationPanel.add((Component)this.allocateButton, (Object)new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.allocationPanel.add((Component)this.allocCurrencyLabel, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.paymentPanel.add((Component)this.paymentLabel, (Object)"North");
        this.paymentPanel.add((Component)this.paymentInfo, (Object)"South");
        this.paymentPanel.add((Component)this.paymentScrollPane, (Object)"Center");
        this.paymentScrollPane.getViewport().add((Component)((Object)this.paymentTable), null);
        this.invoicePanel.add((Component)this.invoiceLabel, (Object)"North");
        this.invoicePanel.add((Component)this.invoiceInfo, (Object)"South");
        this.invoicePanel.add((Component)this.invoiceScrollPane, (Object)"Center");
        this.invoiceScrollPane.getViewport().add((Component)((Object)this.invoiceTable), null);
        this.mainPanel.add((Component)this.infoPanel, (Object)"Center");
        this.infoPanel.setOrientation(0);
        this.infoPanel.setBorder(BorderFactory.createEtchedBorder());
        this.infoPanel.setTopComponent((Component)this.paymentPanel);
        this.infoPanel.setBottomComponent((Component)this.invoicePanel);
        this.infoPanel.add((Component)this.paymentPanel, "top");
        this.infoPanel.add((Component)this.invoicePanel, "bottom");
        this.infoPanel.setContinuousLayout(true);
        this.infoPanel.setPreferredSize(new Dimension(800, 250));
        this.infoPanel.setDividerLocation(110);
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void dynInit() throws Exception {
        int AD_Column_ID = 3505;
        MLookup lookupCur = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, AD_Column_ID, 19);
        this.currencyPick = new VLookup("C_Currency_ID", true, false, true, lookupCur);
        this.currencyPick.setValue(new Integer(this.m_C_Currency_ID));
        this.currencyPick.addVetoableChangeListener(this);
        AD_Column_ID = 839;
        MLookup lookupOrg = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, AD_Column_ID, 19);
        this.organizationPick = new VLookup("AD_Org_ID", true, false, true, lookupOrg);
        this.organizationPick.setValue(Env.getAD_Org_ID(Env.getCtx()));
        this.organizationPick.addVetoableChangeListener(this);
        AD_Column_ID = 3499;
        MLookup lookupBP = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, AD_Column_ID, 30);
        this.bpartnerSearch = new VLookup("C_BPartner_ID", true, false, true, lookupBP);
        this.bpartnerSearch.addVetoableChangeListener(this);
        this.statusBar.setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"AllocateStatus"));
        this.statusBar.setStatusDB("");
        this.dateField.setValue((Object)Env.getContextAsDate(Env.getCtx(), "#Date"));
        this.dateField.addVetoableChangeListener((VetoableChangeListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.config("");
        if (e.getSource().equals(this.multiCurrency)) {
            this.loadBPartner();
        } else if (e.getSource().equals(this.allocateButton)) {
            this.allocateButton.setEnabled(false);
            this.saveData();
            this.loadBPartner();
            this.allocateButton.setEnabled(true);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        boolean isAutoWriteOff;
        boolean isInvoice;
        int col;
        boolean isUpdate;
        boolean bl = isUpdate = e.getType() == 0;
        if (!isUpdate) {
            this.calculate();
            return;
        }
        int row = e.getFirstRow();
        String msg = this.writeOff(row, col = e.getColumn(), isInvoice = e.getSource().equals(this.invoiceTable.getModel()), this.paymentTable, this.invoiceTable, isAutoWriteOff = this.autoWriteOff.isSelected());
        if (msg != null && msg.length() > 0) {
            ADialog.warn((int)this.m_WindowNo, (Container)this.panel, (String)"AllocationWriteOffWarn");
        }
        this.calculate();
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        log.config(String.valueOf(name) + "=" + value);
        if (value == null) {
            return;
        }
        if (name.equals("AD_Org_ID")) {
            this.m_AD_Org_ID = value == null ? 0 : (Integer)value;
            this.loadBPartner();
        }
        if (name.equals("C_BPartner_ID")) {
            this.bpartnerSearch.setValue(value);
            this.m_C_BPartner_ID = (Integer)value;
            this.loadBPartner();
        } else if (name.equals("C_Currency_ID")) {
            this.m_C_Currency_ID = (Integer)value;
            this.loadBPartner();
        } else if (name.equals("Date") && this.multiCurrency.isSelected()) {
            this.loadBPartner();
        }
    }

    public void loadBPartner() {
        this.checkBPartner();
        Vector<Vector<Object>> data = this.getPaymentData(this.multiCurrency.isSelected(), this.dateField.getValue(), this.paymentTable);
        Vector<String> columnNames = this.getPaymentColumnNames(this.multiCurrency.isSelected());
        this.paymentTable.getModel().removeTableModelListener(this);
        DefaultTableModel modelP = new DefaultTableModel(data, columnNames);
        modelP.addTableModelListener(this);
        this.paymentTable.setModel(modelP);
        this.setPaymentColumnClass(this.paymentTable, this.multiCurrency.isSelected());
        data = this.getInvoiceData(this.multiCurrency.isSelected(), this.dateField.getValue(), this.invoiceTable);
        columnNames = this.getInvoiceColumnNames(this.multiCurrency.isSelected());
        this.invoiceTable.getModel().removeTableModelListener(this);
        DefaultTableModel modelI = new DefaultTableModel(data, columnNames);
        modelI.addTableModelListener(this);
        this.invoiceTable.setModel(modelI);
        this.setInvoiceColumnClass(this.invoiceTable, this.multiCurrency.isSelected());
        this.calculate(this.multiCurrency.isSelected());
        this.calculate();
    }

    public void calculate() {
        this.allocDate = null;
        this.paymentInfo.setText(this.calculatePayment(this.paymentTable, this.multiCurrency.isSelected()));
        this.invoiceInfo.setText(this.calculateInvoice(this.invoiceTable, this.multiCurrency.isSelected()));
        if (this.allocDate != null) {
            this.dateField.setValue((Object)this.allocDate);
        }
        this.allocCurrencyLabel.setText(this.currencyPick.getDisplay());
        this.totalDiff = this.totalPay.subtract(this.totalInv);
        this.differenceField.setText(this.format.format(this.totalDiff));
        if (this.totalDiff.compareTo(new BigDecimal(0.0)) == 0) {
            this.allocateButton.setEnabled(true);
        } else {
            this.allocateButton.setEnabled(false);
        }
    }

    public void saveData() {
        if (this.m_AD_Org_ID > 0) {
            Env.setContext(Env.getCtx(), this.m_WindowNo, "AD_Org_ID", this.m_AD_Org_ID);
        } else {
            Env.setContext(Env.getCtx(), this.m_WindowNo, "AD_Org_ID", "");
        }
        try {
            Trx.run((TrxRunnable)new TrxRunnable(){

                public void run(String trxName) {
                    VAllocation.this.statusBar.setStatusLine(VAllocation.this.saveData(VAllocation.this.m_WindowNo, VAllocation.this.dateField.getValue(), VAllocation.this.paymentTable, VAllocation.this.invoiceTable, trxName));
                }
            });
        }
        catch (Exception e) {
            ADialog.error((int)this.m_WindowNo, (Container)this.panel, (String)"Error", (String)e.getLocalizedMessage());
            return;
        }
    }
}

