/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MClient;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRole;
import org.compiere.model.MStorage;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class Match {
    private static CLogger log = CLogger.getCLogger(Match.class);
    private String[] m_matchOptions = new String[]{Msg.getElement((Properties)Env.getCtx(), (String)"C_Invoice_ID", (boolean)false), Msg.getElement((Properties)Env.getCtx(), (String)"M_InOut_ID", (boolean)false), Msg.getElement((Properties)Env.getCtx(), (String)"C_Order_ID", (boolean)false)};
    private static final int MATCH_INVOICE = 0;
    private static final int MATCH_SHIPMENT = 1;
    private static final int MATCH_ORDER = 2;
    private static final int MODE_NOTMATCHED = 0;
    private static final int MODE_MATCHED = 1;
    private static final int I_BPartner = 3;
    private static final int I_Line = 4;
    private static final int I_Product = 5;
    private static final int I_QTY = 6;
    private static final int I_MATCHED = 7;
    private static final int I_Org = 8;
    private StringBuffer m_sql = null;
    private String m_dateColumn = "";
    private String m_qtyColumn = "";
    private String m_groupBy = "";
    private StringBuffer m_linetype = null;

    protected Vector<String> cmd_matchFrom(String selection) {
        Vector<String> vector = new Vector<String>(2);
        if (selection.equals(this.m_matchOptions[0])) {
            vector.add(this.m_matchOptions[1]);
        } else if (selection.equals(this.m_matchOptions[2])) {
            vector.add(this.m_matchOptions[1]);
        } else {
            vector.add(this.m_matchOptions[0]);
            vector.add(this.m_matchOptions[2]);
        }
        return vector;
    }

    protected IMiniTable cmd_search(IMiniTable xMatchedTable, int display, String matchToString, Integer Product, Integer Vendor, Timestamp from, Timestamp to, boolean matched) {
        int matchToType = 0;
        if (matchToString.equals(this.m_matchOptions[1])) {
            matchToType = 1;
        } else if (matchToString.equals(this.m_matchOptions[2])) {
            matchToType = 2;
        }
        this.tableInit(display, matchToType, matched);
        if (Product != null) {
            this.m_sql.append(" AND lin.M_Product_ID=").append(Product);
        }
        if (Vendor != null) {
            this.m_sql.append(" AND hdr.C_BPartner_ID=").append(Vendor);
        }
        if (from != null && to != null) {
            this.m_sql.append(" AND ").append(this.m_dateColumn).append(" BETWEEN ").append(DB.TO_DATE((Timestamp)from)).append(" AND ").append(DB.TO_DATE((Timestamp)to));
        } else if (from != null) {
            this.m_sql.append(" AND ").append(this.m_dateColumn).append(" >= ").append(DB.TO_DATE((Timestamp)from));
        } else if (to != null) {
            this.m_sql.append(" AND ").append(this.m_dateColumn).append(" <= ").append(DB.TO_DATE((Timestamp)to));
        }
        this.tableLoad(xMatchedTable);
        return xMatchedTable;
    }

    protected void cmd_process(IMiniTable xMatchedTable, IMiniTable xMatchedToTable, int matchMode, int matchFrom, Object matchTo, BigDecimal m_xMatched) {
        log.config("");
        int matchedRow = xMatchedTable.getSelectedRow();
        if (matchedRow < 0) {
            return;
        }
        KeyNamePair lineMatched = (KeyNamePair)xMatchedTable.getValueAt(matchedRow, 4);
        KeyNamePair Product = (KeyNamePair)xMatchedTable.getValueAt(matchedRow, 5);
        double totalQty = m_xMatched.doubleValue();
        int row = 0;
        while (row < xMatchedToTable.getRowCount()) {
            IDColumn id = (IDColumn)xMatchedToTable.getValueAt(row, 0);
            if (id != null && id.isSelected()) {
                KeyNamePair ProductCompare = (KeyNamePair)xMatchedToTable.getValueAt(row, 5);
                if (Product.getKey() == ProductCompare.getKey()) {
                    KeyNamePair lineMatchedTo = (KeyNamePair)xMatchedToTable.getValueAt(row, 4);
                    double qty = 0.0;
                    if (matchMode == 0) {
                        qty = (Double)xMatchedToTable.getValueAt(row, 6);
                    }
                    if ((qty -= ((Double)xMatchedToTable.getValueAt(row, 7)).doubleValue()) > totalQty) {
                        qty = totalQty;
                    }
                    totalQty -= qty;
                    boolean invoice = true;
                    if (matchFrom == 2 || matchTo.equals(this.m_matchOptions[2])) {
                        invoice = false;
                    }
                    int M_InOutLine_ID = 0;
                    int Line_ID = 0;
                    if (matchFrom == 1) {
                        M_InOutLine_ID = lineMatched.getKey();
                        Line_ID = lineMatchedTo.getKey();
                    } else {
                        M_InOutLine_ID = lineMatchedTo.getKey();
                        Line_ID = lineMatched.getKey();
                    }
                    String innerTrxName = Trx.createTrxName((String)"Match");
                    Trx innerTrx = Trx.get((String)innerTrxName, (boolean)true);
                    if (this.createMatchRecord(invoice, M_InOutLine_ID, Line_ID, new BigDecimal(qty), innerTrxName)) {
                        innerTrx.commit();
                    } else {
                        innerTrx.rollback();
                    }
                    innerTrx.close();
                    innerTrx = null;
                }
            }
            ++row;
        }
    }

    protected IMiniTable cmd_searchTo(IMiniTable xMatchedTable, IMiniTable xMatchedToTable, String displayString, int matchToType, boolean sameBPartner, boolean sameProduct, boolean sameQty, boolean matched) {
        int row = xMatchedTable.getSelectedRow();
        log.config("Row=" + row);
        int display = 0;
        if (displayString.equals(this.m_matchOptions[1])) {
            display = 1;
        } else if (displayString.equals(this.m_matchOptions[2])) {
            display = 2;
        }
        this.tableInit(display, matchToType, matched);
        KeyNamePair BPartner = (KeyNamePair)xMatchedTable.getValueAt(row, 3);
        KeyNamePair Product = (KeyNamePair)xMatchedTable.getValueAt(row, 5);
        log.fine("BPartner=" + BPartner + " - Product=" + Product);
        if (sameBPartner) {
            this.m_sql.append(" AND hdr.C_BPartner_ID=").append(BPartner.getKey());
        }
        if (sameProduct) {
            this.m_sql.append(" AND lin.M_Product_ID=").append(Product.getKey());
        }
        double docQty = (Double)xMatchedTable.getValueAt(row, 6);
        if (sameQty) {
            this.m_sql.append(" AND ").append(this.m_qtyColumn).append("=").append(docQty);
        }
        this.tableLoad(xMatchedToTable);
        return xMatchedToTable;
    }

    protected void tableInit(int display, int matchToType, boolean matched) {
        log.config("Display=" + this.m_matchOptions[display] + ", MatchTo=" + this.m_matchOptions[matchToType] + ", Matched=" + matched);
        this.m_sql = new StringBuffer();
        if (display == 0) {
            this.m_dateColumn = "hdr.DateInvoiced";
            this.m_qtyColumn = "lin.QtyInvoiced";
            this.m_sql.append("SELECT hdr.C_Invoice_ID,hdr.DocumentNo, hdr.DateInvoiced, bp.Name,hdr.C_BPartner_ID, lin.Line,lin.C_InvoiceLine_ID, p.Name,lin.M_Product_ID, lin.QtyInvoiced,SUM(NVL(mi.Qty,0)), org.Name, hdr.AD_Org_ID FROM C_Invoice hdr INNER JOIN AD_Org org ON (hdr.AD_Org_ID=org.AD_Org_ID) INNER JOIN C_BPartner bp ON (hdr.C_BPartner_ID=bp.C_BPartner_ID) INNER JOIN C_InvoiceLine lin ON (hdr.C_Invoice_ID=lin.C_Invoice_ID) INNER JOIN M_Product p ON (lin.M_Product_ID=p.M_Product_ID) INNER JOIN C_DocType dt ON (hdr.C_DocType_ID=dt.C_DocType_ID AND dt.DocBaseType IN ('API','APC')) FULL JOIN M_MatchInv mi ON (lin.C_InvoiceLine_ID=mi.C_InvoiceLine_ID) WHERE hdr.DocStatus IN ('CO','CL')");
            this.m_groupBy = " GROUP BY hdr.C_Invoice_ID,hdr.DocumentNo,hdr.DateInvoiced,bp.Name,hdr.C_BPartner_ID, lin.Line,lin.C_InvoiceLine_ID,p.Name,lin.M_Product_ID,lin.QtyInvoiced, org.Name, hdr.AD_Org_ID HAVING " + (matched ? "0" : "lin.QtyInvoiced") + "<>SUM(NVL(mi.Qty,0))";
        } else if (display == 2) {
            this.m_dateColumn = "hdr.DateOrdered";
            this.m_qtyColumn = "lin.QtyOrdered";
            this.m_sql.append("SELECT hdr.C_Order_ID,hdr.DocumentNo, hdr.DateOrdered, bp.Name,hdr.C_BPartner_ID, lin.Line,lin.C_OrderLine_ID, p.Name,lin.M_Product_ID, lin.QtyOrdered,SUM(COALESCE(mo.Qty,0)), org.Name, hdr.AD_Org_ID FROM C_Order hdr INNER JOIN AD_Org org ON (hdr.AD_Org_ID=org.AD_Org_ID) INNER JOIN C_BPartner bp ON (hdr.C_BPartner_ID=bp.C_BPartner_ID) INNER JOIN C_OrderLine lin ON (hdr.C_Order_ID=lin.C_Order_ID) INNER JOIN M_Product p ON (lin.M_Product_ID=p.M_Product_ID) INNER JOIN C_DocType dt ON (hdr.C_DocType_ID=dt.C_DocType_ID AND dt.DocBaseType='POO') FULL JOIN M_MatchPO mo ON (lin.C_OrderLine_ID=mo.C_OrderLine_ID)  WHERE ");
            this.m_linetype = new StringBuffer();
            this.m_linetype.append(matchToType == 1 ? "M_InOutLine_ID" : "C_InvoiceLine_ID");
            if (matched) {
                this.m_sql.append(" mo." + this.m_linetype + " IS NOT NULL ");
            } else {
                this.m_sql.append(" ( mo." + this.m_linetype + " IS NULL OR " + " (lin.QtyOrdered <>  (SELECT sum(mo1.Qty) AS Qty" + " FROM m_matchpo mo1 WHERE " + " mo1.C_ORDERLINE_ID=lin.C_ORDERLINE_ID AND " + " hdr.C_ORDER_ID=lin.C_ORDER_ID AND " + " mo1." + this.m_linetype + " IS NOT NULL group by mo1.C_ORDERLINE_ID))) ");
            }
            this.m_sql.append(" AND hdr.DocStatus IN ('CO','CL')");
            this.m_groupBy = " GROUP BY hdr.C_Order_ID,hdr.DocumentNo,hdr.DateOrdered,bp.Name,hdr.C_BPartner_ID, lin.Line,lin.C_OrderLine_ID,p.Name,lin.M_Product_ID,lin.QtyOrdered, org.Name, hdr.AD_Org_ID HAVING " + (matched ? "0" : "lin.QtyOrdered") + "<>SUM(COALESCE(mo.Qty,0))";
        } else {
            this.m_dateColumn = "hdr.MovementDate";
            this.m_qtyColumn = "lin.MovementQty";
            this.m_sql.append("SELECT hdr.M_InOut_ID,hdr.DocumentNo, hdr.MovementDate, bp.Name,hdr.C_BPartner_ID, lin.Line,lin.M_InOutLine_ID, p.Name,lin.M_Product_ID, lin.MovementQty,SUM(NVL(m.Qty,0)),org.Name, hdr.AD_Org_ID FROM M_InOut hdr INNER JOIN AD_Org org ON (hdr.AD_Org_ID=org.AD_Org_ID) INNER JOIN C_BPartner bp ON (hdr.C_BPartner_ID=bp.C_BPartner_ID) INNER JOIN M_InOutLine lin ON (hdr.M_InOut_ID=lin.M_InOut_ID) INNER JOIN M_Product p ON (lin.M_Product_ID=p.M_Product_ID) INNER JOIN C_DocType dt ON (hdr.C_DocType_ID = dt.C_DocType_ID AND (dt.DocBaseType='MMR' or dt.IsSOTrx='N')) FULL JOIN ").append(matchToType == 2 ? "M_MatchPO" : "M_MatchInv").append(" m ON (lin.M_InOutLine_ID=m.M_InOutLine_ID) WHERE hdr.DocStatus IN ('CO','CL')");
            this.m_groupBy = " GROUP BY hdr.M_InOut_ID,hdr.DocumentNo,hdr.MovementDate,bp.Name,hdr.C_BPartner_ID, lin.Line,lin.M_InOutLine_ID,p.Name,lin.M_Product_ID,lin.MovementQty, org.Name, hdr.AD_Org_ID HAVING " + (matched ? "0" : "lin.MovementQty") + "<>SUM(NVL(m.Qty,0))";
        }
    }

    protected void tableLoad(IMiniTable table) {
        String sql = String.valueOf(MRole.getDefault().addAccessSQL(this.m_sql.toString(), "hdr", true, false)) + this.m_groupBy;
        log.finest(sql);
        try {
            Statement stmt = DB.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            table.loadTable(rs);
            stmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
        }
    }

    protected boolean createMatchRecord(boolean invoice, int M_InOutLine_ID, int Line_ID, BigDecimal qty, String trxName) {
        if (qty.compareTo(Env.ZERO) == 0) {
            return true;
        }
        log.fine("IsInvoice=" + invoice + ", M_InOutLine_ID=" + M_InOutLine_ID + ", Line_ID=" + Line_ID + ", Qty=" + qty);
        boolean success = false;
        MInOutLine sLine = new MInOutLine(Env.getCtx(), M_InOutLine_ID, trxName);
        if (invoice) {
            String string;
            MInvoiceLine iLine = new MInvoiceLine(Env.getCtx(), Line_ID, trxName);
            iLine.setM_InOutLine_ID(M_InOutLine_ID);
            if (sLine.getC_OrderLine_ID() != 0) {
                iLine.setC_OrderLine_ID(sLine.getC_OrderLine_ID());
            }
            iLine.save();
            if (iLine.getM_Product_ID() != 0) {
                MMatchInv match = new MMatchInv(iLine, null, qty);
                match.setM_InOutLine_ID(M_InOutLine_ID);
                if (match.save()) {
                    success = true;
                    if (MClient.isClientAccountingImmediate()) {
                        string = DocumentEngine.postImmediate((Properties)match.getCtx(), (int)match.getAD_Client_ID(), (int)match.get_Table_ID(), (int)match.get_ID(), (boolean)true, (String)match.get_TrxName());
                    }
                } else {
                    log.log(Level.SEVERE, "Inv Match not created: " + match);
                }
            } else {
                success = true;
            }
            if (iLine.getC_OrderLine_ID() != 0 && iLine.getM_Product_ID() != 0) {
                MMatchPO matchPO = MMatchPO.create((MInvoiceLine)iLine, (MInOutLine)sLine, null, (BigDecimal)qty);
                matchPO.setC_InvoiceLine_ID(iLine);
                matchPO.setM_InOutLine_ID(M_InOutLine_ID);
                if (!matchPO.save()) {
                    log.log(Level.SEVERE, "PO(Inv) Match not created: " + matchPO);
                }
                if (MClient.isClientAccountingImmediate()) {
                    string = DocumentEngine.postImmediate((Properties)matchPO.getCtx(), (int)matchPO.getAD_Client_ID(), (int)matchPO.get_Table_ID(), (int)matchPO.get_ID(), (boolean)true, (String)matchPO.get_TrxName());
                }
            }
        } else {
            sLine.setC_OrderLine_ID(Line_ID);
            sLine.save();
            MOrderLine oLine = new MOrderLine(Env.getCtx(), Line_ID, trxName);
            if (oLine.get_ID() != 0) {
                oLine.setQtyReserved(oLine.getQtyReserved().subtract(qty));
                if (!oLine.save()) {
                    log.severe("QtyReserved not updated - C_OrderLine_ID=" + Line_ID);
                }
            }
            if (sLine.getM_Product_ID() != 0) {
                MMatchPO match = new MMatchPO(sLine, null, qty);
                if (!match.save()) {
                    log.log(Level.SEVERE, "PO Match not created: " + match);
                } else {
                    success = true;
                    if (sLine.getProduct() != null && sLine.getProduct().isStocked()) {
                        success = MStorage.add((Properties)Env.getCtx(), (int)sLine.getM_Warehouse_ID(), (int)sLine.getM_Locator_ID(), (int)sLine.getM_Product_ID(), (int)sLine.getM_AttributeSetInstance_ID(), (int)oLine.getM_AttributeSetInstance_ID(), null, null, (BigDecimal)qty.negate(), (String)trxName);
                    }
                }
            } else {
                success = true;
            }
        }
        return success;
    }
}

