/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalLine;
import org.compiere.model.PO;
import org.compiere.util.Env;

public class Doc_GLJournal
extends Doc {
    private String m_PostingType = null;
    private int m_C_AcctSchema_ID = 0;

    public Doc_GLJournal(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MJournal.class, rs, null, trxName);
    }

    protected String loadDocumentDetails() {
        MJournal journal = (MJournal)((Object)this.getPO());
        this.m_PostingType = journal.getPostingType();
        this.m_C_AcctSchema_ID = journal.getC_AcctSchema_ID();
        this.p_lines = this.loadLines(journal);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(MJournal journal) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        MJournalLine[] lines = journal.getLines(false);
        int i = 0;
        while (i < lines.length) {
            MJournalLine line = lines[i];
            DocLine docLine = new DocLine((PO)line, this);
            docLine.setAmount(line.getAmtSourceDr(), line.getAmtSourceCr());
            docLine.setConvertedAmt(this.m_C_AcctSchema_ID, line.getAmtAcctDr(), line.getAmtAcctCr());
            MAccount account = line.getAccount();
            docLine.setAccount(account);
            docLine.setQty(line.getQty(), false);
            list.add(docLine);
            ++i;
        }
        int size = list.size();
        DocLine[] dls = new DocLine[size];
        list.toArray(dls);
        return dls;
    }

    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        StringBuffer sb = new StringBuffer(" [");
        int i = 0;
        while (i < this.p_lines.length) {
            retValue = retValue.add(this.p_lines[i].getAmtSource());
            sb.append("+").append(this.p_lines[i].getAmtSource());
            ++i;
        }
        sb.append("]");
        this.log.fine(String.valueOf(this.toString()) + " Balance=" + retValue + sb.toString());
        return retValue;
    }

    public ArrayList<Fact> createFacts(MAcctSchema as) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        if (as.getC_AcctSchema_ID() != this.m_C_AcctSchema_ID) {
            return facts;
        }
        Fact fact = new Fact((Doc)this, as, this.m_PostingType);
        if (this.getDocumentType().equals("GLJ")) {
            int i = 0;
            while (i < this.p_lines.length) {
                if (this.p_lines[i].getC_AcctSchema_ID() == as.getC_AcctSchema_ID()) {
                    FactLine factLine = fact.createLine(this.p_lines[i], this.p_lines[i].getAccount(), this.getC_Currency_ID(), this.p_lines[i].getAmtSourceDr(), this.p_lines[i].getAmtSourceCr());
                }
                ++i;
            }
        } else {
            this.p_Error = "DocumentType unknown: " + this.getDocumentType();
            this.log.log(Level.SEVERE, this.p_Error);
            fact = null;
        }
        facts.add(fact);
        return facts;
    }
}

