/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.compiere.model.PO;
import org.compiere.model.X_AD_WF_NextCondition;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.wf.MWFNextCondition;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class WorkflowNodeNextConditionElementHandler
extends AbstractElementHandler {
    /*
     * Enabled aggressive block sorting
     */
    public void startElement(Properties ctx, Element element) throws SAXException {
        Attributes atts = element.attributes;
        String entitytype = atts.getValue("EntityType");
        this.log.info("entitytype " + atts.getValue("EntityType"));
        if (!this.isProcessElement(ctx, entitytype)) {
            element.skip = true;
            return;
        }
        if (element.parent != null && element.parent.skip) {
            element.skip = true;
            return;
        }
        String workflowName = atts.getValue("ADWorkflowNameID");
        int workflowId = this.get_IDWithColumn(ctx, "AD_Workflow", "name", workflowName);
        if (workflowId <= 0) {
            element.defer = true;
            element.unresolved = "AD_Workflow: " + workflowName;
            return;
        }
        String workflowNodeName = atts.getValue("ADWorkflowNodeNameID");
        String workflowNodeNextName = atts.getValue("ADWorkflowNodeNextNameID");
        StringBuffer sqlB = new StringBuffer("SELECT ad_wf_node_id FROM AD_WF_Node WHERE AD_Workflow_ID=? and Name =?");
        int wfNodeId = DB.getSQLValue((String)this.getTrxName(ctx), (String)sqlB.toString(), (int)workflowId, (String)workflowNodeName);
        if (wfNodeId <= 0) {
            element.unresolved = "AD_WF_Node=" + workflowNodeName;
            element.defer = true;
            return;
        }
        int wfNodeNextId = DB.getSQLValue((String)this.getTrxName(ctx), (String)sqlB.toString(), (int)workflowId, (String)workflowNodeNextName);
        if (wfNodeNextId <= 0) {
            element.unresolved = "AD_WF_Node=" + workflowNodeNextName;
            element.defer = true;
            return;
        }
        sqlB = new StringBuffer("SELECT  ad_wf_nodenext_id FROM AD_WF_NodeNext  WHERE ad_wf_node_id =? and ad_wf_next_id =?");
        int wfNodeNextTablePKId = DB.getSQLValue((String)this.getTrxName(ctx), (String)sqlB.toString(), (int)wfNodeId, (int)wfNodeNextId);
        sqlB = new StringBuffer("SELECT  ad_wf_nextcondition_id FROM AD_WF_NextCondition  WHERE ad_wf_nodenext_id =?");
        int id = DB.getSQLValue((String)this.getTrxName(ctx), (String)sqlB.toString(), (int)wfNodeNextTablePKId);
        MWFNextCondition m_WFNodeNextCondition = new MWFNextCondition(ctx, id, this.getTrxName(ctx));
        int AD_Backup_ID = -1;
        String Object_Status = null;
        if (id <= 0 && atts.getValue("AD_WF_NextCondition_ID") != null && Integer.parseInt(atts.getValue("AD_WF_NextCondition_ID")) <= 999999) {
            m_WFNodeNextCondition.setAD_WF_NextCondition_ID(Integer.parseInt(atts.getValue("AD_WF_NextCondition_ID")));
        }
        if (id > 0) {
            AD_Backup_ID = this.copyRecord(ctx, "AD_WF_NextCondition", (PO)m_WFNodeNextCondition);
            Object_Status = "Update";
        } else {
            Object_Status = "New";
            AD_Backup_ID = 0;
        }
        sqlB = new StringBuffer("SELECT  AD_Column.ad_column_id FROM AD_Column, AD_Table WHERE AD_Column.ad_table_id = AD_Table.ad_table_id and AD_Table.tablename = '" + atts.getValue("ADTableNameID") + "' and AD_Column.columnname = ?");
        int columnId = DB.getSQLValue((String)this.getTrxName(ctx), (String)sqlB.toString(), (String)atts.getValue("ADColumnNameID"));
        m_WFNodeNextCondition.setAD_Column_ID(columnId);
        m_WFNodeNextCondition.setAD_WF_NodeNext_ID(wfNodeNextTablePKId);
        m_WFNodeNextCondition.setIsActive(atts.getValue("isActive") != null ? Boolean.valueOf(atts.getValue("isActive")) : true);
        m_WFNodeNextCondition.setAD_WF_NodeNext_ID(wfNodeNextTablePKId);
        m_WFNodeNextCondition.setSeqNo(Integer.valueOf(atts.getValue("SeqNo")).intValue());
        m_WFNodeNextCondition.setEntityType(atts.getValue("EntityType"));
        m_WFNodeNextCondition.setAndOr(atts.getValue("AndOr"));
        m_WFNodeNextCondition.setOperation(atts.getValue("Operation"));
        m_WFNodeNextCondition.setValue(atts.getValue("Value"));
        m_WFNodeNextCondition.setValue2(atts.getValue("Value2"));
        this.log.info("about to execute m_WFNodeNextCondition.save");
        if (m_WFNodeNextCondition.save(this.getTrxName(ctx))) {
            this.log.info("m_WFNodeNextCondition save success");
            this.record_log(ctx, 1, String.valueOf(m_WFNodeNextCondition.get_ID()), "WFNextCondition", m_WFNodeNextCondition.get_ID(), AD_Backup_ID, Object_Status, "AD_WF_NextCondition", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_WF_NextCondition"));
            return;
        }
        this.log.info("m_WFNodeNextCondition save failure");
        this.record_log(ctx, 0, String.valueOf(m_WFNodeNextCondition.get_ID()), "WFNextCondition", m_WFNodeNextCondition.get_ID(), AD_Backup_ID, Object_Status, "AD_WF_NextCondition", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_WF_NextCondition"));
        throw new POSaveFailedException("WorkflowNodeNextCondition");
    }

    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int ad_wf_nodenextcondition_id = Env.getContextAsInt(ctx, "AD_WF_NextCondition_ID");
        X_AD_WF_NextCondition m_WF_NodeNextCondition = new X_AD_WF_NextCondition(ctx, ad_wf_nodenextcondition_id, null);
        AttributesImpl atts = new AttributesImpl();
        this.createWorkflowNodeNextConditionBinding(atts, m_WF_NodeNextCondition);
        document.startElement("", "", "workflowNodeNextCondition", atts);
        document.endElement("", "", "workflowNodeNextCondition");
    }

    private AttributesImpl createWorkflowNodeNextConditionBinding(AttributesImpl atts, X_AD_WF_NextCondition m_WF_NodeNextCondition) {
        String sql = null;
        String name = null;
        atts.clear();
        if (m_WF_NodeNextCondition.getAD_WF_NextCondition_ID() <= 999999) {
            atts.addAttribute("", "", "AD_WF_NextCondition_ID", "CDATA", Integer.toString(m_WF_NodeNextCondition.getAD_WF_NextCondition_ID()));
        }
        if (m_WF_NodeNextCondition.getAD_WF_NodeNext_ID() > 0) {
            sql = "SELECT AD_Workflow.Name FROM AD_Workflow, AD_WF_Node, AD_WF_NodeNext WHERE  AD_Workflow.AD_Workflow_ID = AD_WF_Node.AD_Workflow_ID and AD_WF_Node.AD_WF_Node_ID = AD_WF_NodeNext.AD_WF_Node_ID and AD_WF_NodeNext.AD_WF_NodeNext_ID = ? group by AD_Workflow.Name";
            name = DB.getSQLValueString(null, (String)sql, (int)m_WF_NodeNextCondition.getAD_WF_NodeNext_ID());
            atts.addAttribute("", "", "ADWorkflowNameID", "CDATA", name);
            sql = "SELECT AD_WF_Node.Name FROM AD_WF_Node, AD_WF_NodeNext WHERE AD_WF_Node.AD_WF_Node_ID = AD_WF_NodeNext.AD_WF_Node_ID and AD_WF_NodeNext.AD_WF_NodeNext_ID =  ? group by AD_WF_Node.Name";
            name = DB.getSQLValueString(null, (String)sql, (int)m_WF_NodeNextCondition.getAD_WF_NodeNext_ID());
            atts.addAttribute("", "", "ADWorkflowNodeNameID", "CDATA", name);
            sql = "SELECT AD_WF_Node.Name FROM AD_WF_Node, AD_WF_NodeNext, AD_WF_NextCondition WHERE AD_WF_Node.AD_WF_Node_ID = AD_WF_NodeNext.AD_WF_Next_ID and AD_WF_NodeNext.AD_WF_NodeNext_ID =  ? group by AD_WF_Node.Name";
            name = DB.getSQLValueString(null, (String)sql, (int)m_WF_NodeNextCondition.getAD_WF_NodeNext_ID());
            atts.addAttribute("", "", "ADWorkflowNodeNextNameID", "CDATA", name);
        }
        if (m_WF_NodeNextCondition.getAD_Column_ID() > 0) {
            sql = "SELECT AD_Table.TableName FROM AD_Table, AD_Column, AD_WF_NextCondition  WHERE AD_Column.AD_Table_ID=AD_Table.AD_Table_ID and AD_Column.AD_Column_ID = ?";
            name = DB.getSQLValueString(null, (String)sql, (int)m_WF_NodeNextCondition.getAD_Column_ID());
            atts.addAttribute("", "", "ADTableNameID", "CDATA", name);
            sql = "SELECT ColumnName FROM AD_Column WHERE AD_Column_ID=?";
            name = DB.getSQLValueString(null, (String)sql, (int)m_WF_NodeNextCondition.getAD_Column_ID());
            atts.addAttribute("", "", "ADColumnNameID", "CDATA", name);
        } else {
            atts.addAttribute("", "", "ADTableNameID", "CDATA", name);
            atts.addAttribute("", "", "ADColumnNameID", "CDATA", "");
        }
        atts.addAttribute("", "", "isActive", "CDATA", m_WF_NodeNextCondition.isActive() ? "true" : "false");
        atts.addAttribute("", "", "EntityType", "CDATA", m_WF_NodeNextCondition.getEntityType() != null ? m_WF_NodeNextCondition.getEntityType() : "");
        atts.addAttribute("", "", "AndOr", "CDATA", m_WF_NodeNextCondition.getAndOr() != null ? m_WF_NodeNextCondition.getAndOr() : "");
        atts.addAttribute("", "", "Operation", "CDATA", m_WF_NodeNextCondition.getOperation() != null ? m_WF_NodeNextCondition.getOperation() : "");
        atts.addAttribute("", "", "Value", "CDATA", m_WF_NodeNextCondition.getValue() != null ? m_WF_NodeNextCondition.getValue() : "");
        atts.addAttribute("", "", "Value2", "CDATA", m_WF_NodeNextCondition.getValue2() != null ? m_WF_NodeNextCondition.getValue2() : "");
        atts.addAttribute("", "", "SeqNo", "CDATA", String.valueOf(m_WF_NodeNextCondition.getSeqNo()) != null ? String.valueOf(m_WF_NodeNextCondition.getSeqNo()) : "");
        return atts;
    }
}

