/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.adempiere.pipo.CreateZipFile;
import org.adempiere.pipo.IDFinder;
import org.adempiere.pipo.PackInHandler;
import org.compiere.Adempiere;
import org.compiere.db.CConnection;
import org.compiere.model.X_AD_Package_Imp_Proc;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Trx;
import org.xml.sax.helpers.DefaultHandler;

public class PackIn
extends SvrProcess {
    private CLogger log = CLogger.getCLogger((String)"PackIn");
    public static String m_UpdateMode = "true";
    public static String m_Database = "Oracle";
    public static String m_Package_Dir = null;
    public int p_PackIn_ID = 0;
    private Map<String, Integer> tableCache = new HashMap<String, Integer>();
    private Map<String, Integer> columnCache = new HashMap<String, Integer>();

    public void addTable(String tableName, int tableId) {
        this.tableCache.put(tableName, tableId);
    }

    public int getTableId(String tableName) {
        if (this.tableCache.containsKey(tableName)) {
            return this.tableCache.get(tableName);
        }
        return 0;
    }

    public void addColumn(String tableName, String columnName, int columnId) {
        this.columnCache.put(String.valueOf(tableName) + "." + columnName, columnId);
    }

    public int getColumnId(String tableName, String columnName) {
        String key = String.valueOf(tableName) + "." + columnName;
        if (this.columnCache.containsKey(key)) {
            return this.columnCache.get(key);
        }
        return 0;
    }

    @Override
    protected void prepare() {
        this.p_PackIn_ID = this.getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            ++i;
        }
    }

    public String importXML(String fileName, Properties ctx, String trxName) throws Exception {
        this.log.info("importXML:" + fileName);
        File in = new File(fileName);
        if (!in.exists()) {
            String msg = "File does not exist: " + fileName;
            this.log.info("importXML:" + msg);
            return msg;
        }
        PackInHandler handler = new PackInHandler();
        try {
            this.log.info("starting");
            System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
            handler.set_TrxName(trxName);
            handler.setCtx(ctx);
            handler.setProcess(this);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            String msg = "Start Parser";
            this.log.info(msg);
            parser.parse(in, (DefaultHandler)handler);
            msg = "End Parser";
            this.log.info(msg);
            return "OK.";
        }
        catch (Exception e) {
            handler.closeLog();
            this.log.log(Level.SEVERE, "importXML:", (Throwable)e);
            throw e;
        }
    }

    @Override
    protected String doIt() throws Exception {
        boolean success;
        File targetDir;
        X_AD_Package_Imp_Proc adPackageImp = new X_AD_Package_Imp_Proc(this.getCtx(), this.p_PackIn_ID, null);
        IDFinder.clearIDCache();
        String packageDirectory = adPackageImp.getAD_Package_Dir();
        if (packageDirectory == null || packageDirectory.trim().length() == 0) {
            packageDirectory = Adempiere.getAdempiereHome();
        }
        if (!(targetDir = new File(String.valueOf(packageDirectory) + File.separator + "packages")).exists() && !(success = new File(String.valueOf(packageDirectory) + File.separator + "packages").mkdirs())) {
            this.log.info("Target directory creation failed");
        }
        File zipFilepath = new File(adPackageImp.getAD_Package_Source());
        this.log.info("zipFilepath->" + zipFilepath);
        String PackageName = CreateZipFile.getParentDir((File)zipFilepath);
        CreateZipFile.unpackFile((File)zipFilepath, (File)targetDir);
        String dict_file = String.valueOf(packageDirectory) + File.separator + "packages" + File.separator + PackageName + File.separator + "dict" + File.separator + "PackOut.xml";
        this.log.info("dict file->" + dict_file);
        PackIn packIn = new PackIn();
        m_UpdateMode = adPackageImp.isAD_Override_Dict() ? "true" : "false";
        m_Package_Dir = String.valueOf(packageDirectory) + File.separator + "packages" + File.separator + PackageName + File.separator;
        if (DB.isOracle()) {
            m_Database = "Oracle";
        } else if (DB.isPostgreSQL()) {
            m_Database = "PostgreSQL";
        }
        String msg = packIn.importXML(dict_file, this.getCtx(), this.get_TrxName());
        return msg;
    }

    public static void main(String[] args) {
        block18: {
            if (args.length < 1) {
                System.out.println("Please give the file name to read as first parameter.");
                System.exit(1);
            }
            String file = args[0];
            Adempiere.startup((boolean)true);
            if (args.length > 8 && args[8].equals("AdempiereSys")) {
                System.out.println("**** WARNING: Working with system sequences AdempiereSys ****");
                Ini.setProperty((String)"AdempiereSys", (boolean)true);
            }
            PackIn packIn = new PackIn();
            if (args.length >= 6) {
                CConnection cc = CConnection.get();
                m_Database = cc.getType();
                DB.setDBTarget((CConnection)cc);
            }
            Level logLevel = Level.FINER;
            switch (Integer.parseInt(args[6])) {
                case 1: {
                    logLevel = Level.OFF;
                    break;
                }
                case 2: {
                    logLevel = Level.SEVERE;
                    break;
                }
                case 3: {
                    logLevel = Level.WARNING;
                    break;
                }
                case 4: {
                    logLevel = Level.INFO;
                    break;
                }
                case 5: {
                    logLevel = Level.CONFIG;
                    break;
                }
                case 6: {
                    logLevel = Level.FINE;
                    break;
                }
                case 7: {
                    logLevel = Level.FINER;
                    break;
                }
                case 8: {
                    logLevel = Level.FINEST;
                    break;
                }
                case 9: {
                    logLevel = Level.ALL;
                }
            }
            CLogMgt.setLevel(logLevel);
            CLogMgt.setLoggerLevel(logLevel, null);
            if (args.length >= 8) {
                m_UpdateMode = args[7];
            }
            String trxName = Trx.createTrxName((String)"PackIn");
            try {
                packIn.importXML(file, Env.getCtx(), trxName);
                Trx trx = Trx.get((String)trxName, (boolean)false);
                if (trx != null) {
                    trx.commit(true);
                }
            }
            catch (Exception e) {
                System.out.println("Import Failed: " + e.getLocalizedMessage());
                Trx trx = Trx.get((String)trxName, (boolean)false);
                if (trx == null) break block18;
                trx.rollback();
            }
        }
        System.exit(0);
    }
}

