/*
 * Decompiled with CFR 0.152.
 */
package com.f3p.adempiere.search;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.compiere.model.LookupDisplayColumn;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class TableIdentifierParser {
    private static String SEPARATOR = "_";
    private static CLogger s_log = CLogger.getCLogger(TableIdentifierParser.class);
    protected ArrayList<LookupDisplayColumn> m_lstColumns = null;
    protected HashMap<String, String> m_mapValues = new HashMap();

    public TableIdentifierParser(String sTableName) {
        this.loadFieldList(sTableName);
    }

    public static boolean isParsable(String sText) {
        return sText.indexOf(SEPARATOR) >= 0;
    }

    protected void loadFieldList(String sTableName) {
        block6: {
            String sql0 = "SELECT c.ColumnName,c.IsTranslated,c.AD_Reference_ID,c.AD_Reference_Value_ID,t.AD_Window_ID,t.PO_Window_ID FROM AD_Table t INNER JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID) WHERE TableName=? AND c.IsIdentifier='Y' ORDER BY c.SeqNo";
            this.m_lstColumns = new ArrayList();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql0, null);
                    pstmt.setString(1, sTableName);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        LookupDisplayColumn ldc = new LookupDisplayColumn(rs.getString(1), null, "Y".equals(rs.getString(2)), rs.getInt(3), rs.getInt(4));
                        this.m_lstColumns.add(ldc);
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, sql0, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    public void parseString(String sText) {
        this.m_mapValues.clear();
        StringTokenizer strTok = new StringTokenizer(sText, SEPARATOR);
        int idxCol = 0;
        while (strTok.hasMoreTokens()) {
            String sTok = strTok.nextToken();
            if (idxCol >= this.m_lstColumns.size()) continue;
            this.m_mapValues.put(this.m_lstColumns.get((int)idxCol++).ColumnName, sTok);
        }
    }

    public String getValue(String sColName) {
        return this.m_mapValues.get(sColName);
    }
}

