/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.web.WebReportContext;
import net.sf.jasperreports.web.servlets.AbstractServlet;
import net.sf.jasperreports.web.util.JacksonUtil;
import net.sf.jasperreports.web.util.VelocityUtil;
import net.sf.jasperreports.web.util.WebUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ViewerServlet
extends AbstractServlet {
    private static final long serialVersionUID = 10200L;
    private static final Log log = LogFactory.getLog(ViewerServlet.class);
    public static final String PROPERTY_TEMPLATE_HEADER = "net.sf.jasperreports.web.servlets.viewer.header.template";
    public static final String PROPERTY_TEMPLATE_BODY = "net.sf.jasperreports.web.servlets.viewer.body.template";
    public static final String PROPERTY_TEMPLATE_FOOTER = "net.sf.jasperreports.web.servlets.viewer.footer.template";
    public static final String PROPERTY_VIEWER_TOOLBAR_JS = "net.sf.jasperreports.web.servlets.viewer.toolbar.js";
    private String headerTemplate;
    private String bodyTemplate;
    private String footerTemplate;
    private String toolbarJavascript;

    public void init() throws ServletException {
        super.init();
        this.headerTemplate = this.getInitParameter(PROPERTY_TEMPLATE_HEADER);
        this.bodyTemplate = this.getInitParameter(PROPERTY_TEMPLATE_BODY);
        this.footerTemplate = this.getInitParameter(PROPERTY_TEMPLATE_FOOTER);
        this.toolbarJavascript = this.getInitParameter(PROPERTY_VIEWER_TOOLBAR_JS);
    }

    public String getHeaderTemplate() {
        if (this.headerTemplate == null) {
            return JRPropertiesUtil.getInstance(this.getJasperReportsContext()).getProperty(PROPERTY_TEMPLATE_HEADER);
        }
        return this.headerTemplate;
    }

    public String getBodyTemplate() {
        if (this.bodyTemplate == null) {
            return JRPropertiesUtil.getInstance(this.getJasperReportsContext()).getProperty(PROPERTY_TEMPLATE_BODY);
        }
        return this.bodyTemplate;
    }

    public String getFooterTemplate() {
        if (this.footerTemplate == null) {
            return JRPropertiesUtil.getInstance(this.getJasperReportsContext()).getProperty(PROPERTY_TEMPLATE_FOOTER);
        }
        return this.footerTemplate;
    }

    public String getToolbarJavascript() {
        if (this.toolbarJavascript == null) {
            return JRPropertiesUtil.getInstance(this.getJasperReportsContext()).getProperty(PROPERTY_VIEWER_TOOLBAR_JS);
        }
        return this.toolbarJavascript;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/html; charset=UTF-8");
        response.setHeader("Expires", "Sat, 6 May 1995 12:00:00 GMT");
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        PrintWriter out = response.getWriter();
        WebReportContext webReportContext = WebReportContext.getInstance(request);
        try {
            this.render(request, webReportContext, out);
        }
        catch (Exception e) {
            log.error("Error on report execution", e);
            out.println("<html>");
            out.println("<head>");
            out.println("<title>JasperReports - Web Application Sample</title>");
            out.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"../stylesheet.css\" title=\"Style\">");
            out.println("</head>");
            out.println("<body bgcolor=\"white\">");
            out.println("<span class=\"bnew\">JasperReports encountered this error :</span>");
            out.println("<pre>");
            e.printStackTrace(out);
            out.println("</pre>");
            out.println("</body>");
            out.println("</html>");
        }
    }

    public void render(HttpServletRequest request, WebReportContext webReportContext, PrintWriter writer) {
        String toolbarId = "toolbar_" + request.getSession().getId() + "_" + (int)(Math.random() * 99999.0);
        writer.write(this.getHeader(request, webReportContext, toolbarId));
        writer.write(this.getBody(request, webReportContext, toolbarId));
        writer.write(this.getFooter());
    }

    protected String getCurrentUrl(HttpServletRequest request, WebReportContext webReportContext) {
        String newQueryString = request.getQueryString();
        String reportUrl = WebUtil.getInstance(this.getJasperReportsContext()).getReportInteractionPath();
        return request.getContextPath() + reportUrl + "?" + newQueryString + "&" + "jr.ctxid" + "=" + webReportContext.getId();
    }

    protected String getHeader(HttpServletRequest request, WebReportContext webReportContext, String toolbarId) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        WebUtil webUtil = WebUtil.getInstance(this.getJasperReportsContext());
        String webResourcesBasePath = webUtil.getResourcesBasePath();
        contextMap.put("contextPath", request.getContextPath());
        contextMap.put("resourcesPath", request.getContextPath() + webResourcesBasePath);
        contextMap.put("jasperreports_global_js", request.getContextPath() + webUtil.getResourcePath(webResourcesBasePath, "net/sf/jasperreports/web/servlets/resources/jasperreports-global.js"));
        contextMap.put("jasperreports_reportViewerToolbar_js", request.getContextPath() + webUtil.getResourcePath(webResourcesBasePath, this.getToolbarJavascript()));
        contextMap.put("jasperreports_global_css", request.getContextPath() + webUtil.getResourcePath(webResourcesBasePath, "net/sf/jasperreports/web/servlets/resources/jasperreports-global.css"));
        contextMap.put("toolbarId", toolbarId);
        contextMap.put("currentUrl", this.getCurrentUrl(request, webReportContext));
        return VelocityUtil.processTemplate(this.getHeaderTemplate(), contextMap);
    }

    protected String getBody(HttpServletRequest request, WebReportContext webReportContext, String toolbarId) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        Enumeration paramsEnum = request.getParameterNames();
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        while (paramsEnum.hasMoreElements()) {
            String param = (String)paramsEnum.nextElement();
            paramsMap.put(param, request.getParameter(param));
        }
        paramsMap.put("jr.ctxid", String.valueOf(webReportContext.getId()));
        String reportUrl = WebUtil.getInstance(this.getJasperReportsContext()).getReportInteractionPath();
        contextMap.put("reportUrl", request.getContextPath() + reportUrl);
        contextMap.put("jsonParamsObject", JacksonUtil.getInstance(this.getJasperReportsContext()).getEscapedJsonString(paramsMap));
        contextMap.put("toolbarId", toolbarId);
        return VelocityUtil.processTemplate(this.getBodyTemplate(), contextMap);
    }

    protected String getFooter() {
        return VelocityUtil.processTemplate(this.getFooterTemplate(), new HashMap<String, Object>());
    }
}

