/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap;

import java.util.Map;
import mondrian.olap.Connection;
import mondrian.olap.Query;
import mondrian.olap.Result;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.olap.JRMondrianDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRMondrianQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog(JRMondrianQueryExecuter.class);
    private Connection connection = (Connection)this.getParameterValue("MONDRIAN_CONNECTION");
    private Result result;

    public JRMondrianQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(jasperReportsContext, dataset, parametersMap);
        if (this.connection == null) {
            log.warn("The supplied mondrian.olap.Connection object is null.");
        }
        this.parseQuery();
    }

    public JRMondrianQueryExecuter(JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        this(DefaultJasperReportsContext.getInstance(), dataset, parametersMap);
    }

    @Override
    protected String getParameterReplacement(String parameterName) {
        return String.valueOf(this.getParameterValue(parameterName));
    }

    @Override
    public JRDataSource createDatasource() throws JRException {
        JRMondrianDataSource dataSource = null;
        String queryStr = this.getQueryString();
        if (this.connection != null && queryStr != null) {
            if (log.isDebugEnabled()) {
                log.debug("MDX query: " + queryStr);
            }
            Query query = this.connection.parseQuery(queryStr);
            this.result = this.connection.execute(query);
            dataSource = new JRMondrianDataSource(this.dataset, this.result);
        }
        return dataSource;
    }

    @Override
    public void close() {
        if (this.result != null) {
            this.result.close();
            this.result = null;
        }
    }

    @Override
    public boolean cancelQuery() throws JRException {
        return false;
    }
}

