/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import net.sf.jasperreports.engine.type.EnumUtil;
import net.sf.jasperreports.engine.type.JREnum;
import net.sf.jasperreports.engine.xml.TransformedPropertyRule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XmlConstantPropertyRule
extends TransformedPropertyRule {
    private static final Log log = LogFactory.getLog(XmlConstantPropertyRule.class);
    private final JREnum[] values;

    public XmlConstantPropertyRule(String attributeName, JREnum[] values) {
        super(attributeName);
        this.values = values;
    }

    public XmlConstantPropertyRule(String attributeName, String propertyName, JREnum[] values) {
        super(attributeName, propertyName);
        this.values = values;
    }

    @Override
    protected Object toPropertyValue(String attributeValue) {
        JREnum value = EnumUtil.getByName(this.values, attributeValue);
        if (value == null) {
            log.warn("Unrecognized attribute value \"" + attributeValue + "\" for " + this.attributeName);
        }
        return value;
    }
}

