/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.xml.JRBaseFactory;
import org.xml.sax.Attributes;

public class JRPenFactory
extends JRBaseFactory {
    @Override
    public Object createObject(Attributes atts) {
        JRCommonGraphicElement graphicElement = (JRCommonGraphicElement)this.digester.peek();
        JRPenFactory.setPenAttributes(atts, graphicElement.getLinePen());
        return graphicElement;
    }

    protected static void setPenAttributes(Attributes atts, JRPen pen) {
        String lineColor;
        LineStyleEnum lineStyle;
        String lineWidth = atts.getValue("lineWidth");
        if (lineWidth != null && lineWidth.length() > 0) {
            pen.setLineWidth(Float.parseFloat(lineWidth));
        }
        if ((lineStyle = LineStyleEnum.getByName(atts.getValue("lineStyle"))) != null) {
            pen.setLineStyle(lineStyle);
        }
        if ((lineColor = atts.getValue("lineColor")) != null && lineColor.length() > 0) {
            pen.setLineColor(JRColorUtil.getColor(lineColor, null));
        }
    }

    public static class Right
    extends JRPenFactory {
        @Override
        public Object createObject(Attributes atts) {
            JRLineBox box = (JRLineBox)this.digester.peek();
            Right.setPenAttributes(atts, box.getRightPen());
            return box;
        }
    }

    public static class Bottom
    extends JRPenFactory {
        @Override
        public Object createObject(Attributes atts) {
            JRLineBox box = (JRLineBox)this.digester.peek();
            Bottom.setPenAttributes(atts, box.getBottomPen());
            return box;
        }
    }

    public static class Left
    extends JRPenFactory {
        @Override
        public Object createObject(Attributes atts) {
            JRLineBox box = (JRLineBox)this.digester.peek();
            Left.setPenAttributes(atts, box.getLeftPen());
            return box;
        }
    }

    public static class Top
    extends JRPenFactory {
        @Override
        public Object createObject(Attributes atts) {
            JRLineBox box = (JRLineBox)this.digester.peek();
            Top.setPenAttributes(atts, box.getTopPen());
            return box;
        }
    }

    public static class Box
    extends JRPenFactory {
        @Override
        public Object createObject(Attributes atts) {
            JRLineBox box = (JRLineBox)this.digester.peek();
            Box.setPenAttributes(atts, box.getPen());
            return box;
        }
    }

    public static class Style
    extends JRPenFactory {
        @Override
        public Object createObject(Attributes atts) {
            JRStyle style = (JRStyle)this.digester.peek();
            Style.setPenAttributes(atts, style.getLinePen());
            return style;
        }
    }
}

