/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JsonDataSource;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog(JsonQueryExecuter.class);
    private JsonDataSource datasource;

    public JsonQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(jasperReportsContext, dataset, parametersMap);
        this.parseQuery();
    }

    public JsonQueryExecuter(JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        this(DefaultJasperReportsContext.getInstance(), dataset, parametersMap);
    }

    @Override
    protected String getParameterReplacement(String parameterName) {
        return String.valueOf(this.getParameterValue(parameterName));
    }

    @Override
    public JRDataSource createDatasource() throws JRException {
        InputStream jsonInputStream = (InputStream)this.getParameterValue("JSON_INPUT_STREAM");
        if (jsonInputStream != null) {
            this.datasource = new JsonDataSource(jsonInputStream, this.getQueryString());
        } else {
            String jsonSource = this.getStringParameterOrProperty("net.sf.jasperreports.json.source");
            if (jsonSource != null) {
                this.datasource = new JsonDataSource(this.getJasperReportsContext(), jsonSource, this.getQueryString());
            } else if (log.isWarnEnabled()) {
                log.warn("No JSON source was provided.");
            }
        }
        if (this.datasource != null) {
            Locale jsonLocale;
            String numberFormatPattern;
            String dateFormatPattern = this.getStringParameterOrProperty("net.sf.jasperreports.json.date.pattern");
            if (dateFormatPattern != null) {
                this.datasource.setDatePattern(dateFormatPattern);
            }
            if ((numberFormatPattern = this.getStringParameterOrProperty("net.sf.jasperreports.json.number.pattern")) != null) {
                this.datasource.setNumberPattern(numberFormatPattern);
            }
            if ((jsonLocale = (Locale)this.getParameterValue("JSON_LOCALE", true)) != null) {
                this.datasource.setLocale(jsonLocale);
            } else {
                String jsonLocaleCode = this.getStringParameterOrProperty("net.sf.jasperreports.json.locale.code");
                if (jsonLocaleCode != null) {
                    this.datasource.setLocale(jsonLocaleCode);
                }
            }
            TimeZone jsonTimezone = (TimeZone)this.getParameterValue("JSON_TIME_ZONE", true);
            if (jsonTimezone != null) {
                this.datasource.setTimeZone(jsonTimezone);
            } else {
                String jsonTimezoneId = this.getStringParameterOrProperty("net.sf.jasperreports.json.timezone.id");
                if (jsonTimezoneId != null) {
                    this.datasource.setTimeZone(jsonTimezoneId);
                }
            }
        }
        return this.datasource;
    }

    @Override
    public void close() {
        if (this.datasource != null) {
            this.datasource.close();
        }
    }

    @Override
    public boolean cancelQuery() throws JRException {
        return false;
    }
}

