/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillTextElement;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplatePrintText;
import net.sf.jasperreports.engine.fill.JRTemplateText;

public class JRFillStaticText
extends JRFillTextElement
implements JRStaticText {
    protected JRFillStaticText(JRBaseFiller filler, JRStaticText staticText, JRFillObjectFactory factory) {
        super(filler, staticText, factory);
        String text = this.processMarkupText(staticText.getText());
        if (text == null) {
            text = "";
        }
        this.setRawText(text);
    }

    protected JRFillStaticText(JRFillStaticText staticText, JRFillCloneFactory factory) {
        super(staticText, factory);
        String text = this.processMarkupText(staticText.getText());
        if (text == null) {
            text = "";
        }
        this.setRawText(text);
    }

    @Override
    public void setText(String text) {
    }

    protected JRTemplateText getJRTemplateText() {
        return (JRTemplateText)this.getElementTemplate();
    }

    @Override
    protected JRTemplateElement createElementTemplate() {
        return new JRTemplateText(this.getElementOrigin(), this.filler.getJasperPrint().getDefaultStyleProvider(), this);
    }

    @Override
    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        this.evaluateProperties(evaluation);
        this.resetTextChunk();
        this.setValueRepeating(true);
    }

    @Override
    protected boolean prepare(int availableHeight, boolean isOverflow) throws JRException {
        boolean willOverflow = false;
        super.prepare(availableHeight, isOverflow);
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
            isToPrint = false;
        }
        if (!(!isToPrint || !this.isPrintWhenExpressionNull() || this.isPrintRepeatedValues() || this.isPrintInFirstWholeBand() && this.getBand().isFirstWholeOnPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()) || isOverflow && this.isPrintWhenDetailOverflows())) {
            isToPrint = false;
        }
        if (isToPrint && availableHeight < this.getRelativeY() + this.getHeight()) {
            isToPrint = false;
            willOverflow = true;
        }
        if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
            isReprinted = true;
        }
        this.resetTextChunk();
        if (isToPrint) {
            this.chopTextElement(0);
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }

    @Override
    protected JRPrintElement fill() {
        JRTemplatePrintText text = new JRTemplatePrintText(this.getJRTemplateText(), this.elementId);
        text.setUUID(this.getUUID());
        text.setX(this.getX());
        text.setY(this.getRelativeY());
        text.setWidth(this.getWidth());
        text.setHeight(this.getStretchHeight());
        text.setRunDirection(this.getRunDirectionValue());
        text.setLineSpacingFactor(this.getLineSpacingFactor());
        text.setLeadingOffset(this.getLeadingOffset());
        text.setTextHeight(this.getTextHeight());
        this.transferProperties(text);
        this.setPrintText(text);
        return text;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitStaticText(this);
    }

    @Override
    protected void resolveElement(JRPrintElement element, byte evaluation) {
    }

    @Override
    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillStaticText(this, factory);
    }

    @Override
    protected boolean canOverflow() {
        return false;
    }
}

