/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ElementGridCell;
import net.sf.jasperreports.engine.export.ExporterFilter;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxDocumentHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxParagraphHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxRelsHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxRunHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxSettingsHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxStyleHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxTableHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxZip;
import net.sf.jasperreports.engine.export.ooxml.GenericElementDocxHandler;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporterContext;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporterNature;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporterParameter;
import net.sf.jasperreports.engine.export.zip.FileBufferedZipEntry;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RenderableTypeEnum;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRDocxExporter
extends JRAbstractExporter {
    private static final Log log = LogFactory.getLog(JRDocxExporter.class);
    public static final String DOCX_EXPORTER_KEY = "net.sf.jasperreports.docx";
    protected static final String DOCX_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.docx.";
    public static final String PROPERTY_HIDDEN_TEXT = "net.sf.jasperreports.export.docx.hidden.text";
    public static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    public static final String IMAGE_NAME_PREFIX = "img_";
    protected static final int IMAGE_NAME_PREFIX_LEGTH = "img_".length();
    public static final String IMAGE_LINK_PREFIX = "link_img_";
    protected DocxDocumentHelper docHelper;
    protected Writer docWriter;
    protected JRExportProgressMonitor progressMonitor;
    protected Map<String, String> rendererToImagePathMap;
    protected List<JRPrintElementIndex> imagesToProcess;
    protected int reportIndex;
    protected int pageIndex;
    protected int tableIndex;
    protected boolean startPage;
    protected String invalidCharReplacement;
    protected LinkedList<Color> backcolorStack = new LinkedList();
    protected Color backcolor;
    protected DocxRunHelper runHelper;
    protected ExporterNature nature;
    protected boolean deepGrid;
    protected boolean flexibleRowHeight;
    protected long bookmarkIndex;
    protected String pageAnchor;
    protected JRDocxExporterContext mainExporterContext = new ExporterContext(null);
    protected DocxRelsHelper relsHelper;

    public JRDocxExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRDocxExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportReport() throws JRException {
        block21: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                this.setExportContext();
                this.setInput();
                if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.filter = this.createFilter(this.getExporterPropertiesPrefix());
                }
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.rendererToImagePathMap = new HashMap<String, String>();
                this.imagesToProcess = new ArrayList<JRPrintElementIndex>();
                this.setFontMap();
                this.setHyperlinkProducerFactory();
                this.nature = this.getExporterNature(this.filter);
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    try {
                        this.exportReportToStream(os);
                        break block21;
                    }
                    catch (IOException e) {
                        throw new JRException("Error trying to export to output stream : " + this.jasperPrint.getName(), e);
                    }
                }
                File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                try {
                    os = new FileOutputStream(destFile);
                    this.exportReportToStream(os);
                }
                catch (IOException e) {
                    throw new JRException("Error trying to export to file : " + destFile, e);
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    public JRPrintImage getImage(List<JasperPrint> jasperPrintList, String imageName) throws JRException {
        return this.getImage(jasperPrintList, JRDocxExporter.getPrintElementIndex(imageName));
    }

    public JRPrintImage getImage(List<JasperPrint> jasperPrintList, JRPrintElementIndex imageIndex) throws JRException {
        JasperPrint report = jasperPrintList.get(imageIndex.getReportIndex());
        JRPrintPage page = report.getPages().get(imageIndex.getPageIndex());
        Integer[] elementIndexes = imageIndex.getAddressArray();
        JRPrintElement element = page.getElements().get(elementIndexes[0]);
        for (int i = 1; i < elementIndexes.length; ++i) {
            JRPrintFrame frame = (JRPrintFrame)element;
            element = frame.getElements().get(elementIndexes[i]);
        }
        if (element instanceof JRGenericPrintElement) {
            JRGenericPrintElement genericPrintElement = (JRGenericPrintElement)element;
            return ((GenericElementDocxHandler)GenericElementHandlerEnviroment.getInstance(this.jasperReportsContext).getElementHandler(genericPrintElement.getGenericType(), DOCX_EXPORTER_KEY)).getImage(this.mainExporterContext, genericPrintElement);
        }
        return (JRPrintImage)element;
    }

    protected void exportReportToStream(OutputStream os) throws JRException, IOException {
        DocxZip docxZip = new DocxZip();
        this.docWriter = docxZip.getDocumentEntry().getWriter();
        this.docHelper = new DocxDocumentHelper(this.docWriter);
        this.docHelper.exportHeader();
        this.relsHelper = new DocxRelsHelper(docxZip.getRelsEntry().getWriter());
        this.relsHelper.exportHeader();
        DocxStyleHelper styleHelper = new DocxStyleHelper(docxZip.getStylesEntry().getWriter(), this.fontMap, this.getExporterKey());
        styleHelper.export(this.jasperPrintList);
        styleHelper.close();
        DocxSettingsHelper settingsHelper = new DocxSettingsHelper(docxZip.getSettingsEntry().getWriter());
        settingsHelper.export(this.jasperPrint);
        settingsHelper.close();
        this.runHelper = new DocxRunHelper(this.docWriter, this.fontMap, this.getExporterKey());
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.setJasperPrint((JasperPrint)this.jasperPrintList.get(this.reportIndex));
            this.setExporterHints();
            this.bookmarkIndex = 0L;
            List<JRPrintPage> pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = pages.size() - 1;
                }
                JRPrintPage page = null;
                this.pageIndex = this.startPageIndex;
                while (this.pageIndex <= this.endPageIndex) {
                    if (Thread.interrupted()) {
                        throw new JRException("Current thread interrupted.");
                    }
                    page = pages.get(this.pageIndex);
                    this.exportPage(page);
                    ++this.pageIndex;
                }
            }
            ++this.reportIndex;
        }
        this.docHelper.exportFooter(this.jasperPrint);
        this.docHelper.close();
        if (this.imagesToProcess != null && this.imagesToProcess.size() > 0) {
            for (JRPrintElementIndex imageIndex : this.imagesToProcess) {
                String mimeType;
                JRPrintImage image = this.getImage((List<JasperPrint>)this.jasperPrintList, imageIndex);
                Renderable renderer = image.getRenderable();
                if (renderer.getTypeValue() == RenderableTypeEnum.SVG) {
                    renderer = new JRWrappingSvgRenderer(renderer, (Dimension2D)new Dimension(image.getWidth(), image.getHeight()), ModeEnum.OPAQUE == image.getModeValue() ? image.getBackcolor() : null);
                }
                if ((mimeType = renderer.getImageTypeValue().getMimeType()) == null) {
                    mimeType = ImageTypeEnum.JPEG.getMimeType();
                }
                String extension = mimeType.substring(mimeType.lastIndexOf(47) + 1);
                String imageName = JRDocxExporter.getImageName(imageIndex);
                docxZip.addEntry(new FileBufferedZipEntry("word/media/" + imageName + "." + extension, renderer.getImageData(this.jasperReportsContext)));
                this.relsHelper.exportImage(imageName, extension);
            }
        }
        this.relsHelper.exportFooter();
        this.relsHelper.close();
        docxZip.zipEntries(os);
        docxZip.dispose();
    }

    protected void exportPage(JRPrintPage page) throws JRException {
        this.startPage = true;
        this.pageAnchor = JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + (this.pageIndex + 1);
        JRGridLayout layout = new JRGridLayout(this.nature, page.getElements(), this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight(), this.globalOffsetX, this.globalOffsetY, null);
        this.exportGrid(layout, null);
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportGrid(JRGridLayout gridLayout, JRPrintElementIndex frameIndex) throws JRException {
        CutsInfo xCuts = gridLayout.getXCuts();
        JRExporterGridCell[][] grid = gridLayout.getGrid();
        if (grid.length > 0 && grid[0].length > 63) {
            throw new JRException("The DOCX format does not support more than 63 columns in a table.");
        }
        DocxTableHelper tableHelper = new DocxTableHelper(this.docWriter, xCuts, frameIndex == null && (this.reportIndex != 0 || this.pageIndex != this.startPageIndex));
        tableHelper.exportHeader();
        JRPrintElement element = null;
        for (int row = 0; row < grid.length; ++row) {
            int emptyCellColSpan = 0;
            boolean allowRowResize = false;
            int maxBottomPadding = 0;
            for (int col = 0; col < grid[0].length; ++col) {
                JRExporterGridCell gridCell = grid[row][col];
                JRLineBox box = gridCell.getBox();
                if (box != null && box.getBottomPadding() != null && maxBottomPadding < box.getBottomPadding()) {
                    maxBottomPadding = box.getBottomPadding();
                }
                allowRowResize = this.flexibleRowHeight && (allowRowResize || gridCell.getElement() instanceof JRPrintText || gridCell.getType() == 2 && ((OccupiedGridCell)gridCell).getOccupier().getElement() instanceof JRPrintText);
            }
            int rowHeight = gridLayout.getRowHeight(row) - maxBottomPadding;
            tableHelper.exportRowHeader(rowHeight, allowRowResize);
            for (int col = 0; col < grid[0].length; ++col) {
                JRExporterGridCell gridCell = grid[row][col];
                if (gridCell.getType() == 2) {
                    if (emptyCellColSpan > 0) {
                        emptyCellColSpan = 0;
                    }
                    OccupiedGridCell occupiedGridCell = (OccupiedGridCell)gridCell;
                    ElementGridCell elementGridCell = (ElementGridCell)occupiedGridCell.getOccupier();
                    tableHelper.exportOccupiedCells(elementGridCell, this.startPage, this.bookmarkIndex, this.pageAnchor);
                    if (this.startPage) {
                        ++this.bookmarkIndex;
                    }
                    col += elementGridCell.getColSpan() - 1;
                } else if (gridCell.getWrapper() != null) {
                    if (emptyCellColSpan > 0) {
                        emptyCellColSpan = 0;
                    }
                    if ((element = gridCell.getWrapper().getElement()) instanceof JRPrintLine) {
                        this.exportLine(tableHelper, (JRPrintLine)element, gridCell);
                    } else if (element instanceof JRPrintRectangle) {
                        this.exportRectangle(tableHelper, (JRPrintRectangle)element, gridCell);
                    } else if (element instanceof JRPrintEllipse) {
                        this.exportEllipse(tableHelper, (JRPrintEllipse)element, gridCell);
                    } else if (element instanceof JRPrintImage) {
                        this.exportImage(tableHelper, (JRPrintImage)element, gridCell);
                    } else if (element instanceof JRPrintText) {
                        this.exportText(tableHelper, (JRPrintText)element, gridCell);
                    } else if (element instanceof JRPrintFrame) {
                        this.exportFrame(tableHelper, (JRPrintFrame)element, gridCell);
                    } else if (element instanceof JRGenericPrintElement) {
                        this.exportGenericElement(tableHelper, (JRGenericPrintElement)element, gridCell);
                    }
                    col += gridCell.getColSpan() - 1;
                } else {
                    ++emptyCellColSpan;
                    tableHelper.exportEmptyCell(gridCell, 1, this.startPage, this.bookmarkIndex, this.pageAnchor);
                    if (this.startPage) {
                        ++this.bookmarkIndex;
                    }
                }
                this.startPage = false;
            }
            tableHelper.exportRowFooter();
        }
        tableHelper.exportFooter(frameIndex == null && this.reportIndex != this.jasperPrintList.size() - 1 && this.pageIndex == this.endPageIndex, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
    }

    protected void exportLine(DocxTableHelper tableHelper, JRPrintLine line, JRExporterGridCell gridCell) {
        JRBaseLineBox box = new JRBaseLineBox(null);
        JRBoxPen pen = null;
        float ratio = line.getWidth() / line.getHeight();
        pen = ratio > 1.0f ? (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? box.getTopPen() : box.getBottomPen()) : (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? box.getLeftPen() : box.getRightPen());
        pen.setLineColor(line.getLinePen().getLineColor());
        pen.setLineStyle(line.getLinePen().getLineStyleValue());
        pen.setLineWidth(line.getLinePen().getLineWidth());
        gridCell.setBox(box);
        tableHelper.getCellHelper().exportHeader(line, gridCell);
        tableHelper.getParagraphHelper().exportEmptyParagraph(this.startPage, this.bookmarkIndex, this.pageAnchor);
        if (this.startPage) {
            ++this.bookmarkIndex;
        }
        tableHelper.getCellHelper().exportFooter();
    }

    protected void exportRectangle(DocxTableHelper tableHelper, JRPrintRectangle rectangle, JRExporterGridCell gridCell) {
        JRBaseLineBox box = new JRBaseLineBox(null);
        JRBoxPen pen = box.getPen();
        pen.setLineColor(rectangle.getLinePen().getLineColor());
        pen.setLineStyle(rectangle.getLinePen().getLineStyleValue());
        pen.setLineWidth(rectangle.getLinePen().getLineWidth());
        gridCell.setBox(box);
        tableHelper.getCellHelper().exportHeader(rectangle, gridCell);
        tableHelper.getParagraphHelper().exportEmptyParagraph(this.startPage, this.bookmarkIndex, this.pageAnchor);
        if (this.startPage) {
            ++this.bookmarkIndex;
        }
        tableHelper.getCellHelper().exportFooter();
    }

    protected void exportEllipse(DocxTableHelper tableHelper, JRPrintEllipse ellipse, JRExporterGridCell gridCell) {
        JRBaseLineBox box = new JRBaseLineBox(null);
        JRBoxPen pen = box.getPen();
        pen.setLineColor(ellipse.getLinePen().getLineColor());
        pen.setLineStyle(ellipse.getLinePen().getLineStyleValue());
        pen.setLineWidth(ellipse.getLinePen().getLineWidth());
        gridCell.setBox(box);
        tableHelper.getCellHelper().exportHeader(ellipse, gridCell);
        tableHelper.getParagraphHelper().exportEmptyParagraph(this.startPage, this.bookmarkIndex, this.pageAnchor);
        if (this.startPage) {
            ++this.bookmarkIndex;
        }
        tableHelper.getCellHelper().exportFooter();
    }

    public void exportText(DocxTableHelper tableHelper, JRPrintText text, JRExporterGridCell gridCell) {
        tableHelper.getCellHelper().exportHeader(text, gridCell);
        JRStyledText styledText = this.getStyledText(text);
        int textLength = 0;
        if (styledText != null) {
            textLength = styledText.length();
        }
        this.docHelper.write("     <w:p>\n");
        tableHelper.getParagraphHelper().exportProps(text);
        if (this.startPage) {
            this.insertBookmark(this.pageAnchor, this.docHelper);
        }
        if (text.getAnchorName() != null) {
            this.insertBookmark(text.getAnchorName(), this.docHelper);
        }
        boolean startedHyperlink = this.startHyperlink(text, true);
        if (textLength > 0) {
            this.exportStyledText(text.getStyle(), styledText, this.getTextLocale(text), this.getPropertiesUtil().getBooleanProperty(text, PROPERTY_HIDDEN_TEXT, false), startedHyperlink);
        }
        if (startedHyperlink) {
            this.endHyperlink(true);
        }
        this.docHelper.write("     </w:p>\n");
        this.docHelper.flush();
        tableHelper.getCellHelper().exportFooter();
    }

    protected void exportStyledText(JRStyle style, JRStyledText styledText, Locale locale, boolean hiddenText, boolean startedHyperlink) {
        String text = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            JRPrintHyperlink hyperlink;
            Map<AttributedCharacterIterator.Attribute, Object> attributes = iterator.getAttributes();
            boolean localHyperlink = false;
            if (!startedHyperlink && (hyperlink = (JRPrintHyperlink)attributes.get(JRTextAttribute.HYPERLINK)) != null) {
                localHyperlink = this.startHyperlink(hyperlink, true);
            }
            this.runHelper.export(style, iterator.getAttributes(), text.substring(iterator.getIndex(), runLimit), locale, hiddenText, this.invalidCharReplacement);
            if (localHyperlink) {
                this.endHyperlink(true);
            }
            iterator.setIndex(runLimit);
        }
    }

    public void exportImage(DocxTableHelper tableHelper, JRPrintImage image, JRExporterGridCell gridCell) throws JRException {
        int leftPadding = image.getLineBox().getLeftPadding();
        int topPadding = image.getLineBox().getTopPadding();
        int rightPadding = image.getLineBox().getRightPadding();
        int bottomPadding = image.getLineBox().getBottomPadding();
        int availableImageWidth = image.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = image.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        tableHelper.getCellHelper().exportHeader(image, gridCell);
        this.docHelper.write("<w:p>");
        Renderable renderer = image.getRenderable();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE) {
                renderer = RenderableUtil.getInstance(this.jasperReportsContext).getOnErrorRendererForImageData(renderer, image.getOnErrorTypeValue());
            }
        } else {
            renderer = null;
        }
        if (renderer != null) {
            Dimension2D dimension;
            int width = availableImageWidth;
            int height = availableImageHeight;
            double normalWidth = availableImageWidth;
            double normalHeight = availableImageHeight;
            Renderable tmpRenderer = RenderableUtil.getInstance(this.jasperReportsContext).getOnErrorRendererForDimension(renderer, image.getOnErrorTypeValue());
            Dimension2D dimension2D = dimension = tmpRenderer == null ? null : tmpRenderer.getDimension(this.jasperReportsContext);
            if (tmpRenderer == renderer && dimension != null) {
                normalWidth = dimension.getWidth();
                normalHeight = dimension.getHeight();
            }
            double cropTop = 0.0;
            double cropLeft = 0.0;
            double cropBottom = 0.0;
            double cropRight = 0.0;
            switch (image.getScaleImageValue()) {
                case FILL_FRAME: {
                    width = availableImageWidth;
                    height = availableImageHeight;
                    break;
                }
                case CLIP: {
                    if (normalWidth > (double)availableImageWidth) {
                        switch (image.getHorizontalAlignmentValue()) {
                            case RIGHT: {
                                cropLeft = 65536.0 * (normalWidth - (double)availableImageWidth) / normalWidth;
                                cropRight = 0.0;
                                break;
                            }
                            case CENTER: {
                                cropRight = cropLeft = 65536.0 * ((double)(-availableImageWidth) + normalWidth) / normalWidth / 2.0;
                                break;
                            }
                            default: {
                                cropLeft = 0.0;
                                cropRight = 65536.0 * (normalWidth - (double)availableImageWidth) / normalWidth;
                            }
                        }
                        width = availableImageWidth;
                        cropLeft /= 0.75;
                        cropRight /= 0.75;
                    } else {
                        width = (int)normalWidth;
                    }
                    if (normalHeight > (double)availableImageHeight) {
                        switch (image.getVerticalAlignmentValue()) {
                            case TOP: {
                                cropTop = 0.0;
                                cropBottom = 65536.0 * (normalHeight - (double)availableImageHeight) / normalHeight;
                                break;
                            }
                            case MIDDLE: {
                                cropBottom = cropTop = 65536.0 * (normalHeight - (double)availableImageHeight) / normalHeight / 2.0;
                                break;
                            }
                            default: {
                                cropTop = 65536.0 * (normalHeight - (double)availableImageHeight) / normalHeight;
                                cropBottom = 0.0;
                            }
                        }
                        height = availableImageHeight;
                        cropTop /= 0.75;
                        cropBottom /= 0.75;
                        break;
                    }
                    height = (int)normalHeight;
                    break;
                }
                default: {
                    if (availableImageHeight <= 0) break;
                    double ratio = normalWidth / normalHeight;
                    if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                        width = availableImageWidth;
                        height = (int)((double)width / ratio);
                        break;
                    }
                    height = availableImageHeight;
                    width = (int)(ratio * (double)height);
                }
            }
            if (this.startPage) {
                this.insertBookmark(this.pageAnchor, this.docHelper);
            }
            if (image.getAnchorName() != null) {
                this.insertBookmark(image.getAnchorName(), this.docHelper);
            }
            this.docHelper.write("<w:r>\n");
            this.docHelper.write("<w:drawing>\n");
            this.docHelper.write("<wp:anchor distT=\"0\" distB=\"0\" distL=\"0\" distR=\"0\" simplePos=\"0\" relativeHeight=\"0\" behindDoc=\"0\" locked=\"1\" layoutInCell=\"1\" allowOverlap=\"1\">");
            this.docHelper.write("<wp:simplePos x=\"0\" y=\"0\"/>");
            this.docHelper.write("<wp:positionH relativeFrom=\"column\"><wp:align>" + DocxParagraphHelper.getHorizontalAlignment(image.getHorizontalAlignmentValue()) + "</wp:align></wp:positionH>");
            this.docHelper.write("<wp:positionV relativeFrom=\"line\"><wp:posOffset>0</wp:posOffset></wp:positionV>");
            this.docHelper.write("<wp:extent cx=\"" + LengthUtil.emu(width) + "\" cy=\"" + LengthUtil.emu(height) + "\"/>\n");
            this.docHelper.write("<wp:wrapNone/>");
            int imageId = image.hashCode() > 0 ? image.hashCode() : -image.hashCode();
            String rId = IMAGE_LINK_PREFIX + this.getElementIndex(gridCell);
            this.docHelper.write("<wp:docPr id=\"" + imageId + "\" name=\"Picture\">\n");
            if (this.getHyperlinkURL(image) != null) {
                this.docHelper.write("<a:hlinkClick xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" r:id=\"" + rId + "\"/>\n");
            }
            this.docHelper.write("</wp:docPr>\n");
            this.docHelper.write("<a:graphic>\n");
            this.docHelper.write("<a:graphicData uri=\"http://schemas.openxmlformats.org/drawingml/2006/picture\">\n");
            this.docHelper.write("<pic:pic>\n");
            this.docHelper.write("<pic:nvPicPr><pic:cNvPr id=\"" + imageId + "\" name=\"Picture\"/><pic:cNvPicPr/></pic:nvPicPr>\n");
            this.docHelper.write("<pic:blipFill>\n");
            this.docHelper.write("<a:blip r:embed=\"" + this.getImagePath(renderer, image.isLazy(), gridCell) + "\"/>");
            this.docHelper.write("<a:srcRect");
            if (cropLeft > 0.0) {
                this.docHelper.write(" l=\"" + (int)cropLeft + "\"");
            }
            if (cropTop > 0.0) {
                this.docHelper.write(" t=\"" + (int)cropTop + "\"");
            }
            if (cropRight > 0.0) {
                this.docHelper.write(" r=\"" + (int)cropRight + "\"");
            }
            if (cropBottom > 0.0) {
                this.docHelper.write(" b=\"" + (int)cropBottom + "\"");
            }
            this.docHelper.write("/>");
            this.docHelper.write("<a:stretch><a:fillRect/></a:stretch>\n");
            this.docHelper.write("</pic:blipFill>\n");
            this.docHelper.write("<pic:spPr><a:xfrm><a:off x=\"0\" y=\"0\"/><a:ext cx=\"" + LengthUtil.emu(width) + "\" cy=\"" + LengthUtil.emu(height) + "\"/>");
            this.docHelper.write("</a:xfrm><a:prstGeom prst=\"rect\"></a:prstGeom></pic:spPr>\n");
            this.docHelper.write("</pic:pic>\n");
            this.docHelper.write("</a:graphicData>\n");
            this.docHelper.write("</a:graphic>\n");
            this.docHelper.write("</wp:anchor>\n");
            this.docHelper.write("</w:drawing>\n");
            this.docHelper.write("</w:r>");
            String url = this.getHyperlinkURL(image);
            if (url != null) {
                String targetMode = "";
                try {
                    switch (image.getHyperlinkTypeValue()) {
                        case LOCAL_PAGE: 
                        case LOCAL_ANCHOR: {
                            this.relsHelper.exportImageLink(rId, "#" + url, targetMode);
                            break;
                        }
                        case REMOTE_PAGE: 
                        case REMOTE_ANCHOR: 
                        case REFERENCE: {
                            targetMode = " TargetMode=\"External\"";
                            this.relsHelper.exportImageLink(rId, url, targetMode);
                            break;
                        }
                    }
                }
                catch (IOException e) {
                    throw new JRRuntimeException(e);
                }
            }
        }
        this.docHelper.write("</w:p>");
        tableHelper.getCellHelper().exportFooter();
    }

    public String getImagePath(Renderable renderer, boolean isLazy, JRExporterGridCell gridCell) {
        String imagePath = null;
        if (renderer != null) {
            if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE && this.rendererToImagePathMap.containsKey(renderer.getId())) {
                imagePath = this.rendererToImagePathMap.get(renderer.getId());
            } else {
                String imageName;
                JRPrintElementIndex imageIndex = this.getElementIndex(gridCell);
                this.imagesToProcess.add(imageIndex);
                imagePath = imageName = JRDocxExporter.getImageName(imageIndex);
                this.rendererToImagePathMap.put(renderer.getId(), imagePath);
            }
        }
        return imagePath;
    }

    protected JRPrintElementIndex getElementIndex(JRExporterGridCell gridCell) {
        JRPrintElementIndex imageIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, gridCell.getWrapper().getAddress());
        return imageIndex;
    }

    public static String getImageName(JRPrintElementIndex printElementIndex) {
        return IMAGE_NAME_PREFIX + printElementIndex.toString();
    }

    public static JRPrintElementIndex getPrintElementIndex(String imageName) {
        if (!imageName.startsWith(IMAGE_NAME_PREFIX)) {
            throw new JRRuntimeException("Invalid image name: " + imageName);
        }
        return JRPrintElementIndex.parsePrintElementIndex(imageName.substring(IMAGE_NAME_PREFIX_LEGTH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportFrame(DocxTableHelper tableHelper, JRPrintFrame frame, JRExporterGridCell gridCell) throws JRException {
        boolean appendBackcolor;
        tableHelper.getCellHelper().exportHeader(frame, gridCell);
        boolean bl = appendBackcolor = frame.getModeValue() == ModeEnum.OPAQUE && (this.backcolor == null || frame.getBackcolor().getRGB() != this.backcolor.getRGB());
        if (appendBackcolor) {
            this.setBackcolor(frame.getBackcolor());
        }
        try {
            JRGridLayout layout = gridCell.getLayout();
            JRPrintElementIndex frameIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, gridCell.getWrapper().getAddress());
            this.exportGrid(layout, frameIndex);
        }
        finally {
            if (appendBackcolor) {
                this.restoreBackcolor();
            }
        }
        tableHelper.getParagraphHelper().exportEmptyParagraph();
        tableHelper.getCellHelper().exportFooter();
    }

    protected void exportGenericElement(DocxTableHelper tableHelper, JRGenericPrintElement element, JRExporterGridCell gridCell) {
        GenericElementDocxHandler handler = (GenericElementDocxHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), DOCX_EXPORTER_KEY);
        if (handler != null) {
            ExporterContext exporterContext = new ExporterContext(tableHelper);
            handler.exportElement(exporterContext, element, gridCell);
        } else if (log.isDebugEnabled()) {
            log.debug("No DOCX generic element handler for " + element.getGenericType());
        }
    }

    protected void setBackcolor(Color color) {
        this.backcolorStack.addLast(this.backcolor);
        this.backcolor = color;
    }

    protected void restoreBackcolor() {
        this.backcolor = this.backcolorStack.removeLast();
    }

    protected boolean startHyperlink(JRPrintHyperlink link, boolean isText) {
        String href = this.getHyperlinkURL(link);
        if (href != null) {
            String tooltip;
            this.docHelper.write("<w:r><w:fldChar w:fldCharType=\"begin\"/></w:r>\n");
            String localType = HyperlinkTypeEnum.LOCAL_ANCHOR == link.getHyperlinkTypeValue() || HyperlinkTypeEnum.LOCAL_PAGE == link.getHyperlinkTypeValue() ? "\\l " : "";
            this.docHelper.write("<w:r><w:instrText xml:space=\"preserve\"> HYPERLINK " + localType + "\"" + JRStringUtil.xmlEncode(href, this.invalidCharReplacement) + "\"");
            String target = this.getHyperlinkTarget(link);
            if (target != null) {
                this.docHelper.write(" \\t \"" + target + "\"");
            }
            if ((tooltip = link.getHyperlinkTooltip()) != null) {
                this.docHelper.write(" \\o \"" + JRStringUtil.xmlEncode(tooltip, this.invalidCharReplacement) + "\"");
            }
            this.docHelper.write(" </w:instrText></w:r>\n");
            this.docHelper.write("<w:r><w:fldChar w:fldCharType=\"separate\"/></w:r>\n");
        }
        return href != null;
    }

    protected String getHyperlinkTarget(JRPrintHyperlink link) {
        String target = null;
        switch (link.getHyperlinkTargetValue()) {
            case SELF: {
                target = "_self";
                break;
            }
            default: {
                target = "_blank";
            }
        }
        return target;
    }

    protected String getHyperlinkURL(JRPrintHyperlink link) {
        String href;
        block13: {
            JRHyperlinkProducer customHandler;
            block12: {
                href = null;
                customHandler = this.getHyperlinkProducer(link);
                if (customHandler != null) break block12;
                switch (link.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        if (link.getHyperlinkReference() != null) {
                            href = link.getHyperlinkReference();
                            break;
                        }
                        break block13;
                    }
                    case LOCAL_ANCHOR: {
                        if (link.getHyperlinkAnchor() != null) {
                            href = link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case LOCAL_PAGE: {
                        if (link.getHyperlinkPage() != null) {
                            href = JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                    case REMOTE_ANCHOR: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkAnchor() != null) {
                            href = link.getHyperlinkReference() + "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case REMOTE_PAGE: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkPage() != null) {
                            href = link.getHyperlinkReference() + "#" + JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                }
                break block13;
            }
            href = customHandler.getHyperlink(link);
        }
        return href;
    }

    protected void endHyperlink(boolean isText) {
        this.docHelper.write("<w:r><w:fldChar w:fldCharType=\"end\"/></w:r>\n");
    }

    protected void insertBookmark(String bookmark, BaseHelper helper) {
        helper.write("<w:bookmarkStart w:id=\"" + this.bookmarkIndex);
        helper.write("\" w:name=\"" + bookmark);
        helper.write("\"/><w:bookmarkEnd w:id=\"" + this.bookmarkIndex++);
        helper.write("\"/>");
    }

    @Override
    protected void setInput() throws JRException {
        super.setInput();
        this.deepGrid = !this.getBooleanParameter(JRDocxExporterParameter.FRAMES_AS_NESTED_TABLES, "net.sf.jasperreports.export.docx.frames.as.nested.tables", true);
        this.flexibleRowHeight = this.getBooleanParameter(JRDocxExporterParameter.FLEXIBLE_ROW_HEIGHT, "net.sf.jasperreports.export.docx.flexible.row.height", false);
    }

    protected ExporterNature getExporterNature(ExporterFilter filter) {
        return new JRDocxExporterNature(this.jasperReportsContext, filter, this.deepGrid);
    }

    protected String getExporterPropertiesPrefix() {
        return DOCX_EXPORTER_PROPERTIES_PREFIX;
    }

    @Override
    protected String getExporterKey() {
        return DOCX_EXPORTER_KEY;
    }

    protected void setExporterHints() {
        this.invalidCharReplacement = this.jasperPrint.hasProperties() && this.jasperPrint.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xml.replace.invalid.chars") ? this.jasperPrint.getProperty("net.sf.jasperreports.export.xml.replace.invalid.chars") : this.getPropertiesUtil().getProperty("net.sf.jasperreports.export.xml.replace.invalid.chars", this.jasperPrint);
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRDocxExporterContext {
        DocxTableHelper tableHelper;

        public ExporterContext(DocxTableHelper tableHelper) {
            super(JRDocxExporter.this);
            this.tableHelper = null;
            this.tableHelper = tableHelper;
        }

        @Override
        public DocxTableHelper getTableHelper() {
            return this.tableHelper;
        }

        @Override
        public String getExportPropertiesPrefix() {
            return JRDocxExporter.DOCX_EXPORTER_PROPERTIES_PREFIX;
        }
    }
}

