/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.ImageMapRenderable;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintImageArea;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.DefaultHyperlinkTargetProducerFactory;
import net.sf.jasperreports.engine.export.ElementWrapper;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementHtmlHandler;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRHtmlExporterContext;
import net.sf.jasperreports.engine.export.JRHtmlExporterHelper;
import net.sf.jasperreports.engine.export.JRHtmlExporterNature;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkTargetProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkTargetProducerFactory;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RenderableTypeEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRHtmlExporter
extends JRAbstractExporter {
    private static final Log log = LogFactory.getLog(JRHtmlExporter.class);
    private static final String HTML_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.html.";
    public static final String HTML_EXPORTER_KEY = "net.sf.jasperreports.html";
    public static final String PROPERTY_HTML_CLASS = "net.sf.jasperreports.export.html.class";
    public static final String PROPERTY_HTML_POPUP_ID = "net.sf.jasperreports.export.html.popupid";
    public static final String PROPERTY_HTML_POPUP_COLUMN = "net.sf.jasperreports.export.html.popupcolumn";
    public static final String PROPERTY_HTML_UUID = "net.sf.jasperreports.export.html.uuid";
    public static final String PROPERTY_HTML_ID = "net.sf.jasperreports.export.html.id";
    public static final String PROPERTY_ACCESSIBLE = "net.sf.jasperreports.export.html.accessible";
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    protected static final float DEFAULT_ZOOM = 1.0f;
    protected static final String CSS_TEXT_ALIGN_LEFT = "left";
    protected static final String CSS_TEXT_ALIGN_RIGHT = "right";
    protected static final String CSS_TEXT_ALIGN_CENTER = "center";
    protected static final String CSS_TEXT_ALIGN_JUSTIFY = "justify";
    protected static final String HTML_VERTICAL_ALIGN_TOP = "top";
    protected static final String HTML_VERTICAL_ALIGN_MIDDLE = "middle";
    protected static final String HTML_VERTICAL_ALIGN_BOTTOM = "bottom";
    public static final String IMAGE_NAME_PREFIX = "img_";
    protected static final int IMAGE_NAME_PREFIX_LEGTH = "img_".length();
    protected Writer writer;
    protected JRExportProgressMonitor progressMonitor;
    protected Map<String, String> rendererToImagePathMap;
    protected Map<Pair<String, Rectangle>, String> imageMaps;
    protected Map<String, byte[]> imageNameToImageDataMap;
    protected List<JRPrintElementIndex> imagesToProcess;
    protected boolean isPxImageLoaded;
    protected int reportIndex;
    protected int pageIndex;
    protected File imagesDir;
    protected String imagesURI;
    protected boolean isOutputImagesToDir;
    protected boolean isRemoveEmptySpace;
    protected boolean isWhitePageBackground;
    protected String encoding;
    protected String sizeUnit;
    protected float zoom = 1.0f;
    protected boolean isUsingImagesToAlign;
    protected boolean isWrapBreakWord;
    protected boolean isIgnorePageMargins;
    protected boolean accessibleHtml;
    protected boolean flushOutput;
    protected String htmlHeader;
    protected String betweenPagesHtml;
    protected String htmlFooter;
    protected StringProvider emptyCellStringProvider;
    private LinkedList<Color> backcolorStack = new LinkedList();
    private Color backcolor;
    protected JRHyperlinkTargetProducerFactory targetProducerFactory;
    protected boolean hyperlinkStarted;
    protected int thDepth;
    protected ExporterNature nature;
    protected JRHtmlExporterContext exporterContext = new ExporterContext();

    public JRHtmlExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRHtmlExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.targetProducerFactory = new DefaultHyperlinkTargetProducerFactory(jasperReportsContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportReport() throws JRException {
        block73: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                String uri;
                String dir;
                this.setExportContext();
                this.setInput();
                if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.filter = this.createFilter(HTML_EXPORTER_PROPERTIES_PREFIX);
                }
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.htmlHeader = (String)this.parameters.get(JRHtmlExporterParameter.HTML_HEADER);
                this.betweenPagesHtml = (String)this.parameters.get(JRHtmlExporterParameter.BETWEEN_PAGES_HTML);
                this.htmlFooter = (String)this.parameters.get(JRHtmlExporterParameter.HTML_FOOTER);
                this.imagesDir = (File)this.parameters.get(JRHtmlExporterParameter.IMAGES_DIR);
                if (this.imagesDir == null && (dir = (String)this.parameters.get(JRHtmlExporterParameter.IMAGES_DIR_NAME)) != null) {
                    this.imagesDir = new File(dir);
                }
                this.isRemoveEmptySpace = this.getBooleanParameter(JRHtmlExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, "net.sf.jasperreports.export.html.remove.emtpy.space.between.rows", false);
                this.isWhitePageBackground = this.getBooleanParameter(JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND, "net.sf.jasperreports.export.xls.white.page.background", true);
                Boolean isOutputImagesToDirParameter = (Boolean)this.parameters.get(JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR);
                if (isOutputImagesToDirParameter != null) {
                    this.isOutputImagesToDir = isOutputImagesToDirParameter;
                }
                if ((uri = (String)this.parameters.get(JRHtmlExporterParameter.IMAGES_URI)) != null) {
                    this.imagesURI = uri;
                }
                this.encoding = this.getStringParameterOrDefault(JRExporterParameter.CHARACTER_ENCODING, "net.sf.jasperreports.export.character.encoding");
                this.rendererToImagePathMap = new HashMap<String, String>();
                this.imageMaps = new HashMap<Pair<String, Rectangle>, String>();
                this.imagesToProcess = new ArrayList<JRPrintElementIndex>();
                this.isPxImageLoaded = false;
                this.imageNameToImageDataMap = (Map)this.parameters.get(JRHtmlExporterParameter.IMAGES_MAP);
                this.isWrapBreakWord = this.getBooleanParameter(JRHtmlExporterParameter.IS_WRAP_BREAK_WORD, "net.sf.jasperreports.export.html.wrap.break.word", false);
                this.sizeUnit = this.getStringParameterOrDefault(JRHtmlExporterParameter.SIZE_UNIT, "net.sf.jasperreports.export.html.size.unit");
                Float zoomRatio = (Float)this.parameters.get(JRHtmlExporterParameter.ZOOM_RATIO);
                if (zoomRatio != null) {
                    this.zoom = zoomRatio.floatValue();
                    if (this.zoom <= 0.0f) {
                        throw new JRException("Invalid zoom ratio : " + this.zoom);
                    }
                } else {
                    this.zoom = 1.0f;
                }
                this.isUsingImagesToAlign = this.getBooleanParameter(JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, "net.sf.jasperreports.export.html.using.images.to.align", true);
                if (this.isUsingImagesToAlign) {
                    this.emptyCellStringProvider = new StringProvider(){

                        @Override
                        public String getStringForCollapsedTD(Object value, int width, int height) {
                            return "><img alt=\"\" src=\"" + value + "px\" style=\"width: " + JRHtmlExporter.this.toSizeUnit(width) + "; height: " + JRHtmlExporter.this.toSizeUnit(height) + ";\"/>";
                        }

                        @Override
                        public String getStringForEmptyTD(Object value) {
                            return "<img alt=\"\" src=\"" + value + "px\" border=\"0\"/>";
                        }

                        @Override
                        public String getReportTableStyle() {
                            return null;
                        }
                    };
                    this.loadPxImage();
                } else {
                    this.emptyCellStringProvider = new StringProvider(){

                        @Override
                        public String getStringForCollapsedTD(Object value, int width, int height) {
                            return " style=\"width: " + JRHtmlExporter.this.toSizeUnit(width) + "; height: " + JRHtmlExporter.this.toSizeUnit(height) + ";\">";
                        }

                        @Override
                        public String getStringForEmptyTD(Object value) {
                            return "";
                        }

                        @Override
                        public String getReportTableStyle() {
                            return "empty-cells: show";
                        }
                    };
                }
                this.isIgnorePageMargins = this.getBooleanParameter(JRExporterParameter.IGNORE_PAGE_MARGINS, "net.sf.jasperreports.export.ignore.page.margins", false);
                this.accessibleHtml = this.getPropertiesUtil().getBooleanProperty(this.jasperPrint, PROPERTY_ACCESSIBLE, false);
                this.setFontMap();
                this.setHyperlinkProducerFactory();
                boolean deepGrid = !this.getBooleanParameter(JRHtmlExporterParameter.FRAMES_AS_NESTED_TABLES, "net.sf.jasperreports.export.html.frames.as.nested.tables", true);
                this.nature = new JRHtmlExporterNature(this.jasperReportsContext, this.filter, deepGrid, this.isIgnorePageMargins);
                this.flushOutput = this.getBooleanParameter(JRHtmlExporterParameter.FLUSH_OUTPUT, "net.sf.jasperreports.export.html.flush.output", true);
                StringBuffer sb = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER);
                if (sb != null) {
                    try {
                        this.writer = new StringWriter();
                        this.exportReportToWriter();
                        sb.append(this.writer.toString());
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to StringBuffer writer : " + this.jasperPrint.getName(), e);
                    }
                    finally {
                        if (this.writer != null) {
                            try {
                                this.writer.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
                this.writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
                if (this.writer != null) {
                    try {
                        this.exportReportToWriter();
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), e);
                    }
                }
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    try {
                        this.writer = new OutputStreamWriter(os, this.encoding);
                        this.exportReportToWriter();
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to OutputStream writer : " + this.jasperPrint.getName(), e);
                    }
                }
                File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                try {
                    os = new FileOutputStream(destFile);
                    this.writer = new OutputStreamWriter(os, this.encoding);
                }
                catch (IOException e) {
                    throw new JRException("Error creating to file writer : " + this.jasperPrint.getName(), e);
                }
                if (this.imagesDir == null) {
                    this.imagesDir = new File(destFile.getParent(), destFile.getName() + "_files");
                }
                if (isOutputImagesToDirParameter == null) {
                    this.isOutputImagesToDir = true;
                }
                if (this.imagesURI == null) {
                    this.imagesURI = this.imagesDir.getName() + "/";
                }
                try {
                    this.exportReportToWriter();
                }
                catch (IOException e) {
                    throw new JRException("Error writing to file writer : " + this.jasperPrint.getName(), e);
                }
                finally {
                    if (this.writer != null) {
                        try {
                            this.writer.close();
                        }
                        catch (IOException e) {}
                    }
                }
                if (!this.isOutputImagesToDir) break block73;
                if (this.imagesDir == null) {
                    throw new JRException("The images directory was not specified for the exporter.");
                }
                if (!this.isPxImageLoaded && (this.imagesToProcess == null || this.imagesToProcess.size() <= 0)) break block73;
                if (!this.imagesDir.exists()) {
                    this.imagesDir.mkdir();
                }
                if (this.isPxImageLoaded) {
                    Renderable pxRenderer = RenderableUtil.getInstance(this.jasperReportsContext).getRenderable("net/sf/jasperreports/engine/images/pixel.GIF");
                    byte[] imageData = pxRenderer.getImageData(this.jasperReportsContext);
                    File imageFile = new File(this.imagesDir, "px");
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(imageFile);
                        fos.write(imageData, 0, imageData.length);
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to image file : " + imageFile, e);
                    }
                    finally {
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
                for (JRPrintElementIndex imageIndex : this.imagesToProcess) {
                    JRPrintImage image = JRHtmlExporter.getImage((List<JasperPrint>)this.jasperPrintList, imageIndex);
                    Renderable renderer = image.getRenderable();
                    if (renderer.getTypeValue() == RenderableTypeEnum.SVG) {
                        renderer = new JRWrappingSvgRenderer(renderer, (Dimension2D)new Dimension(image.getWidth(), image.getHeight()), ModeEnum.OPAQUE == image.getModeValue() ? image.getBackcolor() : null);
                    }
                    byte[] imageData = renderer.getImageData(this.jasperReportsContext);
                    File imageFile = new File(this.imagesDir, JRHtmlExporter.getImageName(imageIndex));
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(imageFile);
                        fos.write(imageData, 0, imageData.length);
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to image file : " + imageFile, e);
                    }
                    finally {
                        if (fos == null) continue;
                        try {
                            fos.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    public static JRPrintImage getImage(List<JasperPrint> jasperPrintList, String imageName) {
        return JRHtmlExporter.getImage(jasperPrintList, JRHtmlExporter.getPrintElementIndex(imageName));
    }

    public static JRPrintImage getImage(List<JasperPrint> jasperPrintList, JRPrintElementIndex imageIndex) {
        JasperPrint report = jasperPrintList.get(imageIndex.getReportIndex());
        JRPrintPage page = report.getPages().get(imageIndex.getPageIndex());
        Integer[] elementIndexes = imageIndex.getAddressArray();
        JRPrintElement element = page.getElements().get(elementIndexes[0]);
        for (int i = 1; i < elementIndexes.length; ++i) {
            JRPrintFrame frame = (JRPrintFrame)element;
            element = frame.getElements().get(elementIndexes[i]);
        }
        return (JRPrintImage)element;
    }

    protected void exportReportToWriter() throws JRException, IOException {
        if (this.htmlHeader == null) {
            this.writer.write("<html>\n");
            this.writer.write("<head>\n");
            this.writer.write("  <title></title>\n");
            this.writer.write("  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + this.encoding + "\"/>\n");
            this.writer.write("  <style type=\"text/css\">\n");
            this.writer.write("    a {text-decoration: none}\n");
            this.writer.write("  </style>\n");
            this.writer.write("</head>\n");
            this.writer.write("<body text=\"#000000\" link=\"#000000\" alink=\"#000000\" vlink=\"#000000\">\n");
            this.writer.write("<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n");
            this.writer.write("<tr><td width=\"50%\">&nbsp;</td><td align=\"center\">\n");
            this.writer.write("\n");
        } else {
            this.writer.write(this.htmlHeader);
        }
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.setJasperPrint((JasperPrint)this.jasperPrintList.get(this.reportIndex));
            List<JRPrintPage> pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = pages.size() - 1;
                }
                JRPrintPage page = null;
                this.pageIndex = this.startPageIndex;
                while (this.pageIndex <= this.endPageIndex) {
                    if (Thread.interrupted()) {
                        throw new JRException("Current thread interrupted.");
                    }
                    page = pages.get(this.pageIndex);
                    this.writer.write("<a name=\"JR_PAGE_ANCHOR_" + this.reportIndex + "_" + (this.pageIndex + 1) + "\"></a>\n");
                    this.exportPage(page);
                    if (this.reportIndex < this.jasperPrintList.size() - 1 || this.pageIndex < this.endPageIndex) {
                        if (this.betweenPagesHtml == null) {
                            this.writer.write("<br/>\n<br/>\n");
                        } else {
                            this.writer.write(this.betweenPagesHtml);
                        }
                    }
                    this.writer.write("\n");
                    ++this.pageIndex;
                }
            }
            ++this.reportIndex;
        }
        if (this.htmlFooter == null) {
            this.writer.write("</td><td width=\"50%\">&nbsp;</td></tr>\n");
            this.writer.write("</table>\n");
            this.writer.write("</body>\n");
            this.writer.write("</html>\n");
        } else {
            this.writer.write(this.htmlFooter);
        }
        if (this.flushOutput) {
            this.writer.flush();
        }
    }

    protected void exportPage(JRPrintPage page) throws JRException, IOException {
        List<JRPrintElement> elements = null;
        if (this.accessibleHtml) {
            JRBasePrintFrame frame = new JRBasePrintFrame(this.jasperPrint.getDefaultStyleProvider());
            new JRHtmlExporterHelper(this.jasperPrint).createNestedFrames(page.getElements().listIterator(), frame);
            elements = frame.getElements();
        } else {
            elements = page.getElements();
        }
        JRGridLayout layout = new JRGridLayout(this.nature, elements, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight(), this.globalOffsetX, this.globalOffsetY, null);
        this.exportGrid(layout, this.isWhitePageBackground);
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportGrid(JRGridLayout gridLayout, boolean whitePageBackground) throws IOException, JRException {
        CutsInfo xCuts = gridLayout.getXCuts();
        JRExporterGridCell[][] grid = gridLayout.getGrid();
        String tableStyle = "width: " + this.toSizeUnit(gridLayout.getWidth()) + "; border-collapse: collapse";
        String additionalTableStyle = this.emptyCellStringProvider.getReportTableStyle();
        if (additionalTableStyle != null) {
            tableStyle = tableStyle + "; " + additionalTableStyle;
        }
        this.writer.write("<table style=\"" + tableStyle + "\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"");
        if (whitePageBackground) {
            this.writer.write(" bgcolor=\"white\"");
        }
        this.writer.write(">\n");
        if (whitePageBackground) {
            this.setBackcolor(Color.white);
        }
        this.writer.write("<tr>\n");
        int width = 0;
        for (int i = 1; i < xCuts.size(); ++i) {
            width = xCuts.getCutOffset(i) - xCuts.getCutOffset(i - 1);
            this.writer.write("  <td" + this.emptyCellStringProvider.getStringForCollapsedTD(this.imagesURI, width, 1) + "</td>\n");
        }
        this.writer.write("</tr>\n");
        this.thDepth = 0;
        for (int y = 0; y < grid.length; ++y) {
            if (!gridLayout.getYCuts().isCutSpanned(y) && this.isRemoveEmptySpace) continue;
            JRExporterGridCell[] gridRow = grid[y];
            int rowHeight = JRGridLayout.getRowHeight(gridRow);
            boolean hasEmptyCell = this.hasEmptyCell(gridRow);
            this.writer.write("<tr valign=\"top\"");
            if (!hasEmptyCell) {
                this.writer.write(" style=\"height:" + this.toSizeUnit(rowHeight) + "\"");
            }
            this.writer.write(">\n");
            for (int x = 0; x < gridRow.length; ++x) {
                JRExporterGridCell gridCell = gridRow[x];
                if (gridCell.getWrapper() == null) {
                    this.writeEmptyCell(gridCell, rowHeight);
                } else {
                    JRPrintElement element = gridCell.getWrapper().getElement();
                    String thTag = null;
                    if (element != null && element.hasProperties()) {
                        thTag = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.pdf.tag.th");
                    }
                    if (thTag != null && ("start".equals(thTag) || "full".equals(thTag))) {
                        ++this.thDepth;
                    }
                    if (element instanceof JRPrintLine) {
                        this.exportLine((JRPrintLine)element, gridCell);
                    } else if (element instanceof JRPrintRectangle) {
                        this.exportRectangle((JRPrintRectangle)element, gridCell);
                    } else if (element instanceof JRPrintEllipse) {
                        this.exportRectangle((JRPrintEllipse)element, gridCell);
                    } else if (element instanceof JRPrintImage) {
                        this.exportImage((JRPrintImage)element, gridCell);
                    } else if (element instanceof JRPrintText) {
                        this.exportText((JRPrintText)element, gridCell);
                    } else if (element instanceof JRPrintFrame) {
                        this.exportFrame((JRPrintFrame)element, gridCell);
                    } else if (element instanceof JRGenericPrintElement) {
                        this.exportGenericElement((JRGenericPrintElement)element, gridCell, rowHeight);
                    }
                    if (thTag != null && ("end".equals(thTag) || "full".equals(thTag))) {
                        --this.thDepth;
                    }
                }
                x += gridCell.getColSpan() - 1;
            }
            this.writer.write("</tr>\n");
        }
        if (whitePageBackground) {
            this.restoreBackcolor();
        }
        this.writer.write("</table>\n");
    }

    private boolean hasEmptyCell(JRExporterGridCell[] gridRow) {
        if (gridRow[0].getWrapper() == null) {
            return true;
        }
        boolean hasEmptyCell = false;
        for (int x = 1; x < gridRow.length; ++x) {
            if (gridRow[x].getWrapper() != null) continue;
            hasEmptyCell = true;
            break;
        }
        return hasEmptyCell;
    }

    protected void writeEmptyCell(JRExporterGridCell cell, int rowHeight) throws IOException {
        String cellTag = this.getCellTag(cell);
        this.writer.write("  <" + cellTag);
        if (cell.getColSpan() > 1) {
            this.writer.write(" colspan=\"" + cell.getColSpan() + "\"");
        }
        StringBuffer styleBuffer = new StringBuffer();
        this.appendBackcolorStyle(cell, styleBuffer);
        this.appendBorderStyle(cell.getBox(), styleBuffer);
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(this.emptyCellStringProvider.getStringForCollapsedTD(this.imagesURI, cell.getWidth(), rowHeight));
        this.writer.write("</" + cellTag + ">\n");
    }

    protected void exportLine(JRPrintLine line, JRExporterGridCell gridCell) throws IOException {
        this.writeCellStart(gridCell);
        StringBuffer styleBuffer = new StringBuffer();
        this.appendBackcolorStyle(gridCell, styleBuffer);
        String side = null;
        float ratio = line.getWidth() / line.getHeight();
        side = ratio > 1.0f ? (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? HTML_VERTICAL_ALIGN_TOP : HTML_VERTICAL_ALIGN_BOTTOM) : (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? CSS_TEXT_ALIGN_LEFT : CSS_TEXT_ALIGN_RIGHT);
        this.appendPen(styleBuffer, line.getLinePen(), side);
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writer.write(this.emptyCellStringProvider.getStringForEmptyTD(this.imagesURI));
        this.writeCellEnd(gridCell);
    }

    protected void writeCellStart(JRExporterGridCell gridCell) throws IOException {
        JRPrintElement element;
        this.writer.write("  <" + this.getCellTag(gridCell));
        if (gridCell.getColSpan() > 1) {
            this.writer.write(" colspan=\"" + gridCell.getColSpan() + "\"");
        }
        if (gridCell.getRowSpan() > 1) {
            this.writer.write(" rowspan=\"" + gridCell.getRowSpan() + "\"");
        }
        if (gridCell.getWrapper() != null && (element = gridCell.getWrapper().getElement()) != null) {
            String clazz;
            String id = this.getPropertiesUtil().getProperty(element, PROPERTY_HTML_ID);
            if (id != null) {
                this.writer.write(" id=\"" + id + "\"");
            }
            if ((clazz = this.getPropertiesUtil().getProperty(element, PROPERTY_HTML_CLASS)) != null) {
                this.writer.write(" class=\"" + clazz + "\"");
            }
        }
    }

    protected void writeCellEnd(JRExporterGridCell gridCell) throws IOException {
        this.writer.write("</" + this.getCellTag(gridCell) + ">\n");
    }

    protected String getCellTag(JRExporterGridCell gridCell) {
        if (this.accessibleHtml) {
            String cellContentsType;
            OccupiedGridCell occupiedCell;
            if (this.thDepth > 0) {
                return "th";
            }
            ElementWrapper wrapper = gridCell.getWrapper();
            OccupiedGridCell occupiedGridCell = occupiedCell = gridCell instanceof OccupiedGridCell ? (OccupiedGridCell)gridCell : null;
            if (occupiedCell != null) {
                wrapper = occupiedCell.getOccupier().getWrapper();
            }
            if (wrapper != null && ("CrosstabHeader".equals(cellContentsType = wrapper.getProperty("net.sf.jasperreports.crosstab.cell.type")) || "ColumnHeader".equals(cellContentsType) || "RowHeader".equals(cellContentsType))) {
                return "th";
            }
        }
        return "td";
    }

    protected void exportRectangle(JRPrintGraphicElement element, JRExporterGridCell gridCell) throws IOException {
        this.writeCellStart(gridCell);
        StringBuffer styleBuffer = new StringBuffer();
        this.appendBackcolorStyle(gridCell, styleBuffer);
        this.appendPen(styleBuffer, element.getLinePen(), null);
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writer.write(this.emptyCellStringProvider.getStringForEmptyTD(this.imagesURI));
        this.writeCellEnd(gridCell);
    }

    protected void exportStyledText(JRStyledText styledText, Locale locale) throws IOException {
        this.exportStyledText(styledText, null, locale, null, null);
    }

    protected void exportStyledText(JRStyledText styledText, String tooltip, Locale locale, LineSpacingEnum lineSpacing, Float lineSpacingSize) throws IOException {
        String text = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        boolean first = true;
        boolean startedSpan = false;
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            if (first && runLimit < styledText.length() && tooltip != null) {
                startedSpan = true;
                this.writer.write("<span title=\"");
                this.writer.write(JRStringUtil.xmlEncode(tooltip));
                this.writer.write("\">");
                tooltip = null;
            }
            first = false;
            this.exportStyledTextRun(iterator.getAttributes(), text.substring(iterator.getIndex(), runLimit), tooltip, locale, lineSpacing, lineSpacingSize);
            iterator.setIndex(runLimit);
        }
        if (startedSpan) {
            this.writer.write("</span>");
        }
    }

    protected void exportStyledTextRun(Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, Locale locale) throws IOException {
        this.exportStyledTextRun(attributes, text, null, locale, null, null);
    }

    protected void exportStyledTextRun(Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, String tooltip, Locale locale, LineSpacingEnum lineSpacing, Float lineSpacingSize) throws IOException {
        Color runBackcolor;
        String fontFamilyAttr;
        String fontFamily = fontFamilyAttr = (String)attributes.get(TextAttribute.FAMILY);
        if (this.fontMap != null && this.fontMap.containsKey(fontFamilyAttr)) {
            fontFamily = (String)this.fontMap.get(fontFamilyAttr);
        } else {
            FontFamily family;
            String exportFont;
            FontInfo fontInfo = JRFontUtil.getFontInfo(fontFamilyAttr, locale);
            if (fontInfo != null && (exportFont = (family = fontInfo.getFontFamily()).getExportFont(this.getExporterKey())) != null) {
                fontFamily = exportFont;
            }
        }
        boolean localHyperlink = false;
        JRPrintHyperlink hyperlink = (JRPrintHyperlink)attributes.get(JRTextAttribute.HYPERLINK);
        if (!this.hyperlinkStarted && hyperlink != null) {
            this.startHyperlink(hyperlink);
            localHyperlink = true;
        }
        this.writer.write("<span style=\"font-family: ");
        this.writer.write(fontFamily);
        this.writer.write("; ");
        Color forecolor = (Color)attributes.get(TextAttribute.FOREGROUND);
        if (!this.hyperlinkStarted || !Color.black.equals(forecolor)) {
            this.writer.write("color: #");
            this.writer.write(JRColorUtil.getColorHexa(forecolor));
            this.writer.write("; ");
        }
        if ((runBackcolor = (Color)attributes.get(TextAttribute.BACKGROUND)) != null) {
            this.writer.write("background-color: #");
            this.writer.write(JRColorUtil.getColorHexa(runBackcolor));
            this.writer.write("; ");
        }
        this.writer.write("font-size: ");
        this.writer.write(this.toSizeUnit(((Float)attributes.get(TextAttribute.SIZE)).intValue()));
        this.writer.write(";");
        switch (lineSpacing) {
            default: {
                this.writer.write(" line-height: normal;");
                break;
            }
            case ONE_AND_HALF: {
                this.writer.write(" line-height: 1.5;");
                break;
            }
            case DOUBLE: {
                this.writer.write(" line-height: 2.0;");
                break;
            }
            case PROPORTIONAL: {
                if (lineSpacingSize == null) break;
                this.writer.write(" line-height: " + lineSpacingSize.floatValue() + ";");
                break;
            }
            case AT_LEAST: 
            case FIXED: {
                if (lineSpacingSize == null) break;
                this.writer.write(" line-height: " + lineSpacingSize.floatValue() + "px;");
            }
        }
        if (TextAttribute.WEIGHT_BOLD.equals(attributes.get(TextAttribute.WEIGHT))) {
            this.writer.write(" font-weight: bold;");
        }
        if (TextAttribute.POSTURE_OBLIQUE.equals(attributes.get(TextAttribute.POSTURE))) {
            this.writer.write(" font-style: italic;");
        }
        if (TextAttribute.UNDERLINE_ON.equals(attributes.get(TextAttribute.UNDERLINE))) {
            this.writer.write(" text-decoration: underline;");
        }
        if (TextAttribute.STRIKETHROUGH_ON.equals(attributes.get(TextAttribute.STRIKETHROUGH))) {
            this.writer.write(" text-decoration: line-through;");
        }
        if (TextAttribute.SUPERSCRIPT_SUPER.equals(attributes.get(TextAttribute.SUPERSCRIPT))) {
            this.writer.write(" vertical-align: super;");
        } else if (TextAttribute.SUPERSCRIPT_SUB.equals(attributes.get(TextAttribute.SUPERSCRIPT))) {
            this.writer.write(" vertical-align: sub;");
        }
        this.writer.write("\"");
        if (tooltip != null) {
            this.writer.write(" title=\"");
            this.writer.write(JRStringUtil.xmlEncode(tooltip));
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writer.write(JRStringUtil.htmlEncode(text));
        this.writer.write("</span>");
        if (localHyperlink) {
            this.endHyperlink();
        }
    }

    protected void exportText(JRPrintText text, JRExporterGridCell gridCell) throws IOException {
        JRStyledText styledText = this.getStyledText(text);
        int textLength = 0;
        if (styledText != null) {
            textLength = styledText.length();
        }
        this.writeCellStart(gridCell);
        if (text.getRunDirectionValue() == RunDirectionEnum.RTL) {
            this.writer.write(" dir=\"rtl\"");
        }
        StringBuffer styleBuffer = new StringBuffer();
        String verticalAlignment = HTML_VERTICAL_ALIGN_TOP;
        switch (text.getVerticalAlignmentValue()) {
            case BOTTOM: {
                verticalAlignment = HTML_VERTICAL_ALIGN_BOTTOM;
                break;
            }
            case MIDDLE: {
                verticalAlignment = HTML_VERTICAL_ALIGN_MIDDLE;
                break;
            }
            default: {
                verticalAlignment = HTML_VERTICAL_ALIGN_TOP;
            }
        }
        if (!verticalAlignment.equals(HTML_VERTICAL_ALIGN_TOP)) {
            styleBuffer.append(" vertical-align: ");
            styleBuffer.append(verticalAlignment);
            styleBuffer.append(";");
        }
        this.appendBackcolorStyle(gridCell, styleBuffer);
        this.appendBorderStyle(gridCell.getBox(), styleBuffer);
        this.appendPaddingStyle(text.getLineBox(), styleBuffer);
        String horizontalAlignment = CSS_TEXT_ALIGN_LEFT;
        if (textLength > 0) {
            switch (text.getHorizontalAlignmentValue()) {
                case RIGHT: {
                    horizontalAlignment = CSS_TEXT_ALIGN_RIGHT;
                    break;
                }
                case CENTER: {
                    horizontalAlignment = CSS_TEXT_ALIGN_CENTER;
                    break;
                }
                case JUSTIFIED: {
                    horizontalAlignment = CSS_TEXT_ALIGN_JUSTIFY;
                    break;
                }
                default: {
                    horizontalAlignment = CSS_TEXT_ALIGN_LEFT;
                }
            }
            if (text.getRunDirectionValue() == RunDirectionEnum.LTR && !horizontalAlignment.equals(CSS_TEXT_ALIGN_LEFT) || text.getRunDirectionValue() == RunDirectionEnum.RTL && !horizontalAlignment.equals(CSS_TEXT_ALIGN_RIGHT)) {
                styleBuffer.append("text-align: ");
                styleBuffer.append(horizontalAlignment);
                styleBuffer.append(";");
            }
        }
        if (this.isWrapBreakWord) {
            styleBuffer.append("width: " + this.toSizeUnit(gridCell.getWidth()) + "; ");
            styleBuffer.append("word-wrap: break-word; ");
        }
        if (text.getLineBreakOffsets() != null) {
            styleBuffer.append("white-space: nowrap; ");
        }
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writer.write("<p style=\"overflow: hidden; ");
        this.writer.write("text-indent: " + text.getParagraph().getFirstLineIndent() + "px; ");
        this.writer.write("\">");
        if (text.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(text.getAnchorName());
            this.writer.write("\"/>");
        }
        this.startHyperlink(text);
        if (textLength > 0) {
            String textTooltip = this.hyperlinkStarted ? null : text.getHyperlinkTooltip();
            this.exportStyledText(styledText, textTooltip, this.getTextLocale(text), text.getParagraph().getLineSpacing(), text.getParagraph().getLineSpacingSize());
        } else {
            this.writer.write(this.emptyCellStringProvider.getStringForEmptyTD(this.imagesURI));
        }
        this.endHyperlink();
        this.writer.write("</p>");
        this.writeCellEnd(gridCell);
    }

    protected boolean startHyperlink(JRPrintHyperlink link) throws IOException {
        String href = this.getHyperlinkURL(link);
        if (href != null) {
            this.writer.write("<a href=\"");
            this.writer.write(href);
            this.writer.write("\"");
            String target = this.getHyperlinkTarget(link);
            if (target != null) {
                this.writer.write(" target=\"");
                this.writer.write(target);
                this.writer.write("\"");
            }
            if (link.getHyperlinkTooltip() != null) {
                this.writer.write(" title=\"");
                this.writer.write(JRStringUtil.xmlEncode(link.getHyperlinkTooltip()));
                this.writer.write("\"");
            }
            this.writer.write(">");
        }
        this.hyperlinkStarted = href != null;
        return this.hyperlinkStarted;
    }

    protected String getHyperlinkTarget(JRPrintHyperlink link) {
        String target;
        block10: {
            JRHyperlinkTargetProducer producer;
            block9: {
                target = null;
                producer = this.targetProducerFactory.getHyperlinkTargetProducer(link.getLinkTarget());
                if (producer != null) break block9;
                switch (link.getHyperlinkTargetValue()) {
                    case BLANK: {
                        target = "_blank";
                        break;
                    }
                    case PARENT: {
                        target = "_parent";
                        break;
                    }
                    case TOP: {
                        target = "_top";
                        break;
                    }
                    case CUSTOM: {
                        List<JRPrintHyperlinkParameter> parameters;
                        boolean paramFound = false;
                        List<JRPrintHyperlinkParameter> list = parameters = link.getHyperlinkParameters() == null ? null : link.getHyperlinkParameters().getParameters();
                        if (parameters != null) {
                            for (JRPrintHyperlinkParameter parameter : parameters) {
                                if (!link.getLinkTarget().equals(parameter.getName())) continue;
                                target = parameter.getValue() == null ? null : parameter.getValue().toString();
                                paramFound = true;
                                break;
                            }
                        }
                        if (!paramFound) {
                            target = link.getLinkTarget();
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block10;
            }
            target = producer.getHyperlinkTarget(link);
        }
        return target;
    }

    protected String getHyperlinkURL(JRPrintHyperlink link) {
        String href;
        block13: {
            JRHyperlinkProducer customHandler;
            block12: {
                href = null;
                customHandler = this.getHyperlinkProducer(link);
                if (customHandler != null) break block12;
                switch (link.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        if (link.getHyperlinkReference() != null) {
                            href = link.getHyperlinkReference();
                            break;
                        }
                        break block13;
                    }
                    case LOCAL_ANCHOR: {
                        if (link.getHyperlinkAnchor() != null) {
                            href = "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case LOCAL_PAGE: {
                        if (link.getHyperlinkPage() != null) {
                            href = "#JR_PAGE_ANCHOR_" + this.reportIndex + "_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                    case REMOTE_ANCHOR: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkAnchor() != null) {
                            href = link.getHyperlinkReference() + "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case REMOTE_PAGE: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkPage() != null) {
                            href = link.getHyperlinkReference() + "#" + JR_PAGE_ANCHOR_PREFIX + "0_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                }
                break block13;
            }
            href = customHandler.getHyperlink(link);
        }
        return href;
    }

    protected void endHyperlink() throws IOException {
        if (this.hyperlinkStarted) {
            this.writer.write("</a>");
        }
        this.hyperlinkStarted = false;
    }

    protected boolean appendBorderStyle(JRLineBox box, StringBuffer styleBuffer) {
        boolean addedToStyle = false;
        if (box != null) {
            LineStyleEnum tps = box.getTopPen().getLineStyleValue();
            LineStyleEnum lps = box.getLeftPen().getLineStyleValue();
            LineStyleEnum bps = box.getBottomPen().getLineStyleValue();
            LineStyleEnum rps = box.getRightPen().getLineStyleValue();
            float tpw = box.getTopPen().getLineWidth().floatValue();
            float lpw = box.getLeftPen().getLineWidth().floatValue();
            float bpw = box.getBottomPen().getLineWidth().floatValue();
            float rpw = box.getRightPen().getLineWidth().floatValue();
            if (0.0f < tpw && tpw < 1.0f) {
                tpw = 1.0f;
            }
            if (0.0f < lpw && lpw < 1.0f) {
                lpw = 1.0f;
            }
            if (0.0f < bpw && bpw < 1.0f) {
                bpw = 1.0f;
            }
            if (0.0f < rpw && rpw < 1.0f) {
                rpw = 1.0f;
            }
            Color tpc = box.getTopPen().getLineColor();
            if (tps == lps && tps == bps && tps == rps && tpw == lpw && tpw == bpw && tpw == rpw && tpc.equals(box.getLeftPen().getLineColor()) && tpc.equals(box.getBottomPen().getLineColor()) && tpc.equals(box.getRightPen().getLineColor())) {
                addedToStyle |= this.appendPen(styleBuffer, box.getTopPen(), null);
            } else {
                addedToStyle |= this.appendPen(styleBuffer, box.getTopPen(), HTML_VERTICAL_ALIGN_TOP);
                addedToStyle |= this.appendPen(styleBuffer, box.getLeftPen(), CSS_TEXT_ALIGN_LEFT);
                addedToStyle |= this.appendPen(styleBuffer, box.getBottomPen(), HTML_VERTICAL_ALIGN_BOTTOM);
                addedToStyle |= this.appendPen(styleBuffer, box.getRightPen(), CSS_TEXT_ALIGN_RIGHT);
            }
        }
        return addedToStyle;
    }

    protected boolean appendPaddingStyle(JRLineBox box, StringBuffer styleBuffer) {
        boolean addedToStyle = false;
        if (box != null) {
            Integer tp = box.getTopPadding();
            Integer lp = box.getLeftPadding();
            Integer bp = box.getBottomPadding();
            Integer rp = box.getRightPadding();
            if (tp == lp && tp == bp && tp == rp) {
                addedToStyle |= this.appendPadding(styleBuffer, tp, null);
            } else {
                addedToStyle |= this.appendPadding(styleBuffer, box.getTopPadding(), HTML_VERTICAL_ALIGN_TOP);
                addedToStyle |= this.appendPadding(styleBuffer, box.getLeftPadding(), CSS_TEXT_ALIGN_LEFT);
                addedToStyle |= this.appendPadding(styleBuffer, box.getBottomPadding(), HTML_VERTICAL_ALIGN_BOTTOM);
                addedToStyle |= this.appendPadding(styleBuffer, box.getRightPadding(), CSS_TEXT_ALIGN_RIGHT);
            }
        }
        return addedToStyle;
    }

    protected Color appendBackcolorStyle(JRExporterGridCell gridCell, StringBuffer styleBuffer) {
        Color cellBackcolor = gridCell.getCellBackcolor();
        if (cellBackcolor != null && (this.backcolor == null || cellBackcolor.getRGB() != this.backcolor.getRGB())) {
            styleBuffer.append("background-color: #");
            styleBuffer.append(JRColorUtil.getColorHexa(cellBackcolor));
            styleBuffer.append("; ");
            return cellBackcolor;
        }
        return null;
    }

    protected void exportImage(JRPrintImage image, JRExporterGridCell gridCell) throws JRException, IOException {
        Renderable renderer;
        this.writeCellStart(gridCell);
        StringBuffer styleBuffer = new StringBuffer();
        String horizontalAlignment = CSS_TEXT_ALIGN_LEFT;
        switch (image.getHorizontalAlignmentValue()) {
            case RIGHT: {
                horizontalAlignment = CSS_TEXT_ALIGN_RIGHT;
                break;
            }
            case CENTER: {
                horizontalAlignment = CSS_TEXT_ALIGN_CENTER;
                break;
            }
            default: {
                horizontalAlignment = CSS_TEXT_ALIGN_LEFT;
            }
        }
        if (!horizontalAlignment.equals(CSS_TEXT_ALIGN_LEFT)) {
            styleBuffer.append("text-align: ");
            styleBuffer.append(horizontalAlignment);
            styleBuffer.append(";");
        }
        String verticalAlignment = HTML_VERTICAL_ALIGN_TOP;
        switch (image.getVerticalAlignmentValue()) {
            case BOTTOM: {
                verticalAlignment = HTML_VERTICAL_ALIGN_BOTTOM;
                break;
            }
            case MIDDLE: {
                verticalAlignment = HTML_VERTICAL_ALIGN_MIDDLE;
                break;
            }
            default: {
                verticalAlignment = HTML_VERTICAL_ALIGN_TOP;
            }
        }
        if (!verticalAlignment.equals(HTML_VERTICAL_ALIGN_TOP)) {
            styleBuffer.append(" vertical-align: ");
            styleBuffer.append(verticalAlignment);
            styleBuffer.append(";");
        }
        this.appendBackcolorStyle(gridCell, styleBuffer);
        boolean addedToStyle = this.appendBorderStyle(gridCell.getBox(), styleBuffer);
        if (!addedToStyle) {
            this.appendPen(styleBuffer, image.getLinePen(), null);
        }
        this.appendPaddingStyle(image.getLineBox(), styleBuffer);
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">");
        if (image.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(image.getAnchorName());
            this.writer.write("\"/>");
        }
        Renderable originalRenderer = renderer = image.getRenderable();
        boolean imageMapRenderer = renderer != null && renderer instanceof ImageMapRenderable && ((ImageMapRenderable)renderer).hasImageAreaHyperlinks();
        boolean hasHyperlinks = false;
        if (renderer != null || this.isUsingImagesToAlign) {
            int imageHeight;
            if (imageMapRenderer) {
                hasHyperlinks = true;
                this.hyperlinkStarted = false;
            } else {
                hasHyperlinks = this.startHyperlink(image);
            }
            this.writer.write("<img");
            String imagePath = null;
            String imageMapName = null;
            List<JRPrintImageAreaHyperlink> imageMapAreas = null;
            ScaleImageEnum scaleImage = image.getScaleImageValue();
            if (renderer != null) {
                if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE && this.rendererToImagePathMap.containsKey(renderer.getId())) {
                    imagePath = this.rendererToImagePathMap.get(renderer.getId());
                } else {
                    if (image.isLazy()) {
                        imagePath = ((JRImageRenderer)renderer).getImageLocation();
                    } else {
                        JRPrintElementIndex imageIndex = this.getElementIndex(gridCell);
                        this.imagesToProcess.add(imageIndex);
                        String imageName = JRHtmlExporter.getImageName(imageIndex);
                        imagePath = this.imagesURI + imageName;
                        if (this.imageNameToImageDataMap != null) {
                            if (renderer.getTypeValue() == RenderableTypeEnum.SVG) {
                                renderer = new JRWrappingSvgRenderer(renderer, (Dimension2D)new Dimension(image.getWidth(), image.getHeight()), ModeEnum.OPAQUE == image.getModeValue() ? image.getBackcolor() : null);
                            }
                            this.imageNameToImageDataMap.put(imageName, renderer.getImageData(this.jasperReportsContext));
                        }
                    }
                    this.rendererToImagePathMap.put(renderer.getId(), imagePath);
                }
                if (imageMapRenderer) {
                    Rectangle renderingArea = new Rectangle(image.getWidth(), image.getHeight());
                    if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE) {
                        imageMapName = this.imageMaps.get(new Pair<String, Rectangle>(renderer.getId(), renderingArea));
                    }
                    if (imageMapName == null) {
                        imageMapName = "map_" + this.getElementIndex(gridCell).toString();
                        imageMapAreas = ((ImageMapRenderable)originalRenderer).getImageAreaHyperlinks(renderingArea);
                        if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE) {
                            this.imageMaps.put(new Pair<String, Rectangle>(renderer.getId(), renderingArea), imageMapName);
                        }
                    }
                }
            } else {
                this.loadPxImage();
                imagePath = this.imagesURI + "px";
                scaleImage = ScaleImageEnum.FILL_FRAME;
            }
            this.writer.write(" src=\"");
            if (imagePath != null) {
                this.writer.write(imagePath);
            }
            this.writer.write("\"");
            int imageWidth = image.getWidth() - image.getLineBox().getLeftPadding() - image.getLineBox().getRightPadding();
            if (imageWidth < 0) {
                imageWidth = 0;
            }
            if ((imageHeight = image.getHeight() - image.getLineBox().getTopPadding() - image.getLineBox().getBottomPadding()) < 0) {
                imageHeight = 0;
            }
            switch (scaleImage) {
                case FILL_FRAME: {
                    this.writer.write(" style=\"width: ");
                    this.writer.write(this.toSizeUnit(imageWidth));
                    this.writer.write("; height: ");
                    this.writer.write(this.toSizeUnit(imageHeight));
                    this.writer.write("\"");
                    break;
                }
                default: {
                    double normalWidth = imageWidth;
                    double normalHeight = imageHeight;
                    if (!image.isLazy()) {
                        Dimension2D dimension;
                        Renderable tmpRenderer = RenderableUtil.getInstance(this.jasperReportsContext).getOnErrorRendererForDimension(renderer, image.getOnErrorTypeValue());
                        Dimension2D dimension2D = dimension = tmpRenderer == null ? null : tmpRenderer.getDimension(this.jasperReportsContext);
                        if (tmpRenderer == renderer && dimension != null) {
                            normalWidth = dimension.getWidth();
                            normalHeight = dimension.getHeight();
                        }
                    }
                    if (imageHeight <= 0) break;
                    double ratio = normalWidth / normalHeight;
                    if (ratio > (double)imageWidth / (double)imageHeight) {
                        this.writer.write(" style=\"width: ");
                        this.writer.write(this.toSizeUnit(imageWidth));
                        this.writer.write("\"");
                        break;
                    }
                    this.writer.write(" style=\"height: ");
                    this.writer.write(this.toSizeUnit(imageHeight));
                    this.writer.write("\"");
                }
            }
            if (imageMapName != null) {
                this.writer.write(" usemap=\"#" + imageMapName + "\"");
            }
            this.writer.write(" alt=\"\"");
            if (hasHyperlinks) {
                this.writer.write(" border=\"0\"");
            }
            if (image.getHyperlinkTooltip() != null) {
                this.writer.write(" title=\"");
                this.writer.write(JRStringUtil.xmlEncode(image.getHyperlinkTooltip()));
                this.writer.write("\"");
            }
            this.writer.write("/>");
            this.endHyperlink();
            if (imageMapAreas != null) {
                this.writer.write("\n");
                this.writeImageMap(imageMapName, image, imageMapAreas);
            }
        }
        this.writeCellEnd(gridCell);
    }

    protected JRPrintElementIndex getElementIndex(JRExporterGridCell gridCell) {
        JRPrintElementIndex imageIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, gridCell.getWrapper().getAddress());
        return imageIndex;
    }

    protected void writeImageMap(String imageMapName, JRPrintImage image, List<JRPrintImageAreaHyperlink> imageMapAreas) throws IOException {
        this.writer.write("<map name=\"" + imageMapName + "\">\n");
        ListIterator<JRPrintImageAreaHyperlink> it = imageMapAreas.listIterator(imageMapAreas.size());
        while (it.hasPrevious()) {
            JRPrintImageAreaHyperlink areaHyperlink = it.previous();
            JRPrintImageArea area = areaHyperlink.getArea();
            this.writer.write("  <area shape=\"" + JRPrintImageArea.getHtmlShape(area.getShape()) + "\"");
            this.writeImageAreaCoordinates(area.getCoordinates());
            this.writeImageAreaHyperlink(areaHyperlink.getHyperlink());
            this.writer.write("/>\n");
        }
        if (image.getHyperlinkTypeValue() != HyperlinkTypeEnum.NONE) {
            this.writer.write("  <area shape=\"default\"");
            this.writeImageAreaCoordinates(new int[]{0, 0, image.getWidth(), image.getHeight()});
            this.writeImageAreaHyperlink(image);
            this.writer.write("/>\n");
        }
        this.writer.write("</map>\n");
    }

    protected void writeImageAreaCoordinates(int[] coords) throws IOException {
        if (coords != null && coords.length > 0) {
            StringBuffer coordsEnum = new StringBuffer(coords.length * 4);
            coordsEnum.append(this.toZoom(coords[0]));
            for (int i = 1; i < coords.length; ++i) {
                coordsEnum.append(',');
                coordsEnum.append(this.toZoom(coords[i]));
            }
            this.writer.write(" coords=\"" + coordsEnum + "\"");
        }
    }

    protected void writeImageAreaHyperlink(JRPrintHyperlink hyperlink) throws IOException {
        String href = this.getHyperlinkURL(hyperlink);
        if (href == null) {
            this.writer.write(" nohref=\"nohref\"");
        } else {
            this.writer.write(" href=\"" + href + "\"");
            String target = this.getHyperlinkTarget(hyperlink);
            if (target != null) {
                this.writer.write(" target=\"");
                this.writer.write(target);
                this.writer.write("\"");
            }
        }
        if (hyperlink.getHyperlinkTooltip() != null) {
            this.writer.write(" title=\"");
            this.writer.write(JRStringUtil.xmlEncode(hyperlink.getHyperlinkTooltip()));
            this.writer.write("\"");
        }
    }

    protected void loadPxImage() throws JRException {
        this.isPxImageLoaded = true;
        if (this.imageNameToImageDataMap != null && !this.imageNameToImageDataMap.containsKey("px")) {
            Renderable pxRenderer = RenderableUtil.getInstance(this.jasperReportsContext).getRenderable("net/sf/jasperreports/engine/images/pixel.GIF");
            this.rendererToImagePathMap.put(pxRenderer.getId(), this.imagesURI + "px");
            this.imageNameToImageDataMap.put("px", pxRenderer.getImageData(this.jasperReportsContext));
        }
    }

    private boolean appendPadding(StringBuffer sb, Integer padding, String side) {
        boolean addedToStyle = false;
        if (padding > 0) {
            sb.append("padding");
            if (side != null) {
                sb.append("-");
                sb.append(side);
            }
            sb.append(": ");
            sb.append(this.toSizeUnit(padding));
            sb.append("; ");
            addedToStyle = true;
        }
        return addedToStyle;
    }

    private boolean appendPen(StringBuffer sb, JRPen pen, String side) {
        boolean addedToStyle = false;
        float borderWidth = pen.getLineWidth().floatValue();
        if (0.0f < borderWidth && borderWidth < 1.0f) {
            borderWidth = 1.0f;
        }
        String borderStyle = null;
        switch (pen.getLineStyleValue()) {
            case DOUBLE: {
                borderStyle = "double";
                break;
            }
            case DOTTED: {
                borderStyle = "dotted";
                break;
            }
            case DASHED: {
                borderStyle = "dashed";
                break;
            }
            default: {
                borderStyle = "solid";
            }
        }
        if (borderWidth > 0.0f) {
            sb.append("border");
            if (side != null) {
                sb.append("-");
                sb.append(side);
            }
            sb.append(": ");
            sb.append(this.toSizeUnit((int)borderWidth));
            sb.append(" ");
            sb.append(borderStyle);
            sb.append(" #");
            sb.append(JRColorUtil.getColorHexa(pen.getLineColor()));
            sb.append("; ");
            addedToStyle = true;
        }
        return addedToStyle;
    }

    public static String getImageName(JRPrintElementIndex printElementIndex) {
        return IMAGE_NAME_PREFIX + printElementIndex.toString();
    }

    public static JRPrintElementIndex getPrintElementIndex(String imageName) {
        if (!imageName.startsWith(IMAGE_NAME_PREFIX)) {
            throw new JRRuntimeException("Invalid image name: " + imageName);
        }
        return JRPrintElementIndex.parsePrintElementIndex(imageName.substring(IMAGE_NAME_PREFIX_LEGTH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportFrame(JRPrintFrame frame, JRExporterGridCell gridCell) throws IOException, JRException {
        this.writeCellStart(gridCell);
        StringBuffer styleBuffer = new StringBuffer();
        Color frameBackcolor = this.appendBackcolorStyle(gridCell, styleBuffer);
        this.appendBorderStyle(gridCell.getBox(), styleBuffer);
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">\n");
        if (frameBackcolor != null) {
            this.setBackcolor(frameBackcolor);
        }
        try {
            this.exportGrid(gridCell.getLayout(), false);
        }
        finally {
            if (frameBackcolor != null) {
                this.restoreBackcolor();
            }
        }
        this.writeCellEnd(gridCell);
    }

    protected void setBackcolor(Color color) {
        this.backcolorStack.addLast(this.backcolor);
        this.backcolor = color;
    }

    protected void restoreBackcolor() {
        this.backcolor = this.backcolorStack.removeLast();
    }

    protected void exportGenericElement(JRGenericPrintElement element, JRExporterGridCell gridCell, int rowHeight) throws IOException {
        GenericElementHtmlHandler handler = (GenericElementHtmlHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), HTML_EXPORTER_KEY);
        if (handler == null) {
            if (log.isDebugEnabled()) {
                log.debug("No HTML generic element handler for " + element.getGenericType());
            }
            this.writeEmptyCell(gridCell, rowHeight);
        } else {
            this.writeCellStart(gridCell);
            StringBuffer styleBuffer = new StringBuffer();
            this.appendBackcolorStyle(gridCell, styleBuffer);
            this.appendBorderStyle(gridCell.getBox(), styleBuffer);
            if (styleBuffer.length() > 0) {
                this.writer.write(" style=\"");
                this.writer.write(styleBuffer.toString());
                this.writer.write("\"");
            }
            this.writer.write(">");
            String htmlFragment = handler.getHtmlFragment(this.exporterContext, element);
            if (htmlFragment != null) {
                this.writer.write(htmlFragment);
            }
            this.writeCellEnd(gridCell);
        }
    }

    public Map<JRExporterParameter, Object> getExportParameters() {
        return this.parameters;
    }

    public String getExportPropertiesPrefix() {
        return HTML_EXPORTER_PROPERTIES_PREFIX;
    }

    @Override
    protected String getExporterKey() {
        return HTML_EXPORTER_KEY;
    }

    public JasperPrint getExportedReport() {
        return this.jasperPrint;
    }

    public String toSizeUnit(int size) {
        return String.valueOf(this.toZoom(size)) + this.sizeUnit;
    }

    public int toZoom(int size) {
        return (int)(this.zoom * (float)size);
    }

    @Override
    protected JRStyledText getStyledText(JRPrintText textElement, boolean setBackcolor) {
        short[] lineBreakOffsets;
        JRStyledText styledText = super.getStyledText(textElement, setBackcolor);
        if (styledText != null && (lineBreakOffsets = textElement.getLineBreakOffsets()) != null && lineBreakOffsets.length > 0) {
            styledText = styledText.cloneText();
            styledText.insert("\n", lineBreakOffsets);
        }
        return styledText;
    }

    protected static interface StringProvider {
        public String getStringForCollapsedTD(Object var1, int var2, int var3);

        public String getStringForEmptyTD(Object var1);

        public String getReportTableStyle();
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRHtmlExporterContext {
        protected ExporterContext() {
            super(JRHtmlExporter.this);
        }

        @Override
        public String getExportPropertiesPrefix() {
            return JRHtmlExporter.HTML_EXPORTER_PROPERTIES_PREFIX;
        }

        @Override
        public String getHyperlinkURL(JRPrintHyperlink link) {
            return JRHtmlExporter.this.getHyperlinkURL(link);
        }
    }
}

