/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementTransformer;
import net.sf.jasperreports.engine.export.GenericElementTransformerContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class GenericElementReportTransformer {
    private static final Log log = LogFactory.getLog(GenericElementReportTransformer.class);

    public static void transformGenericElements(JasperPrint report, String transformerExportKey) {
        GenericElementReportTransformer.transformGenericElements(DefaultJasperReportsContext.getInstance(), report, transformerExportKey);
    }

    public static void transformGenericElements(JasperReportsContext jasperReportsContext, JasperPrint report, String transformerExportKey) {
        TransformerContext transformerContext = new TransformerContext(jasperReportsContext, report);
        List<JRPrintPage> pages = report.getPages();
        for (JRPrintPage page : pages) {
            GenericElementReportTransformer.transformElements(transformerContext, transformerExportKey, page.getElements());
        }
    }

    protected static void transformElements(TransformerContext context, String transformerExportKey, List<JRPrintElement> elements) {
        ListIterator<JRPrintElement> it = elements.listIterator();
        while (it.hasNext()) {
            JRPrintElement element = it.next();
            if (element instanceof JRGenericPrintElement) {
                JRGenericPrintElement genericElement = (JRGenericPrintElement)element;
                GenericElementTransformer handler = (GenericElementTransformer)GenericElementHandlerEnviroment.getInstance(context.getJasperReportsContext()).getElementHandler(genericElement.getGenericType(), transformerExportKey);
                if (handler == null || !handler.toExport(genericElement)) continue;
                JRPrintElement transformed = handler.transformElement(context, genericElement);
                if (log.isDebugEnabled()) {
                    log.debug("Transformed element " + genericElement + " to " + transformed + " using the " + transformerExportKey + " transformer");
                }
                it.set(transformed);
                continue;
            }
            if (!(element instanceof JRPrintFrame)) continue;
            JRPrintFrame frame = (JRPrintFrame)element;
            GenericElementReportTransformer.transformElements(context, transformerExportKey, frame.getElements());
        }
    }

    private GenericElementReportTransformer() {
    }

    protected static class TransformerContext
    implements GenericElementTransformerContext {
        private final JasperReportsContext jasperReportsContext;
        private final JasperPrint report;

        public TransformerContext(JasperReportsContext jasperReportsContext, JasperPrint report) {
            this.jasperReportsContext = jasperReportsContext;
            this.report = report;
        }

        @Override
        public JasperReportsContext getJasperReportsContext() {
            return this.jasperReportsContext;
        }

        @Override
        public JasperPrint getReport() {
            return this.report;
        }
    }
}

