/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.table.fill;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Column;
import net.sf.jasperreports.components.table.ColumnGroup;
import net.sf.jasperreports.components.table.ColumnVisitor;
import net.sf.jasperreports.components.table.TableComponent;
import net.sf.jasperreports.components.table.fill.BuiltinExpressionEvaluator;
import net.sf.jasperreports.components.table.fill.DatasetCloneObjectFactory;
import net.sf.jasperreports.components.table.fill.FillColumn;
import net.sf.jasperreports.components.table.fill.FillTableSubreport;
import net.sf.jasperreports.components.table.fill.TableReport;
import net.sf.jasperreports.components.table.fill.TableReportBaseObjectFactory;
import net.sf.jasperreports.components.table.fill.TableReportCompileData;
import net.sf.jasperreports.components.table.fill.TableReportDataset;
import net.sf.jasperreports.components.table.fill.TableSubreport;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.component.BaseFillComponent;
import net.sf.jasperreports.engine.component.FillPrepareResult;
import net.sf.jasperreports.engine.design.JRAbstractCompiler;
import net.sf.jasperreports.engine.design.JRReportCompileData;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateFrame;
import net.sf.jasperreports.engine.fill.JRTemplatePrintFrame;
import net.sf.jasperreports.engine.util.JRReportUtils;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FillTable
extends BaseFillComponent {
    private static final Log log = LogFactory.getLog(FillTable.class);
    private final TableComponent table;
    private final JRFillObjectFactory factory;
    private final Map<List<FillColumn>, FillTableSubreport> fillSubreports = new HashMap<List<FillColumn>, FillTableSubreport>();
    private FillTableSubreport fillSubreport;
    private boolean filling;
    private List<FillColumn> fillColumns;
    private int fillWidth;
    private Map<JRStyle, JRTemplateFrame> printFrameTemplates = new HashMap<JRStyle, JRTemplateFrame>();

    public FillTable(TableComponent table, JRFillObjectFactory factory) {
        this.table = table;
        this.factory = factory;
    }

    @Override
    public void evaluate(byte evaluation) throws JRException {
        if (this.filling) {
            log.warn("Table fill did not complete, canceling previous table subreport");
            this.fillSubreport.cancelSubreportFill();
        }
        this.filling = false;
        this.evaluateColumns(evaluation);
        if (!this.fillColumns.isEmpty()) {
            this.createFillSubreport();
            this.fillSubreport.evaluateSubreport(evaluation);
        }
    }

    protected boolean toPrintColumn(BaseColumn column, byte evaluation) throws JRException {
        Boolean printWhenVal;
        JRExpression printWhenExpression = column.getPrintWhenExpression();
        boolean toPrint = printWhenExpression == null ? true : ((printWhenVal = (Boolean)this.evaluateExpression(printWhenExpression, evaluation)) == null ? false : printWhenVal);
        return toPrint;
    }

    protected JRPropertiesMap evaluateProperties(BaseColumn column, byte evaluation) throws JRException {
        JRPropertiesMap staticProperties = column.hasProperties() ? column.getPropertiesMap().cloneProperties() : null;
        JRPropertiesMap mergedProperties = null;
        JRPropertyExpression[] propExprs = column.getPropertyExpressions();
        if (propExprs == null || propExprs.length == 0) {
            mergedProperties = staticProperties;
        } else {
            JRPropertiesMap dynamicProperties = new JRPropertiesMap();
            for (int i = 0; i < propExprs.length; ++i) {
                JRPropertyExpression prop = propExprs[i];
                String value = (String)this.evaluateExpression(prop.getValueExpression(), evaluation);
                if (value == null) continue;
                dynamicProperties.setProperty(prop.getName(), value);
            }
            mergedProperties = dynamicProperties.cloneProperties();
            mergedProperties.setBaseProperties(staticProperties);
        }
        return mergedProperties;
    }

    protected void evaluateColumns(byte evaluation) {
        FillColumnEvaluator columnEvaluator = new FillColumnEvaluator(evaluation);
        List<BaseColumn> columns = this.table.getColumns();
        this.fillColumns = new ArrayList<FillColumn>(columns.size());
        this.fillWidth = 0;
        for (BaseColumn column : columns) {
            FillColumn fillColumn = column.visitColumn(columnEvaluator);
            if (fillColumn == null) continue;
            this.fillColumns.add(fillColumn);
            this.fillWidth += fillColumn.getWidth();
        }
    }

    protected void createFillSubreport() throws JRException {
        this.fillSubreport = this.fillSubreports.get(this.fillColumns);
        if (this.fillSubreport == null) {
            this.fillSubreport = this.createFillTableSubreport();
            this.fillSubreports.put(this.fillColumns, this.fillSubreport);
        }
    }

    protected FillTableSubreport createFillTableSubreport() throws JRException {
        JasperReport parentReport = this.fillContext.getFiller().getJasperReport();
        JRDataset reportSubdataset = JRReportUtils.findSubdataset(this.table.getDatasetRun(), parentReport);
        HashMap<JRExpression, BuiltinExpressionEvaluator> builtinEvaluators = new HashMap<JRExpression, BuiltinExpressionEvaluator>();
        String tableReportName = JRAbstractCompiler.getUnitName(parentReport, reportSubdataset);
        JRDataset tableSubdataset = DatasetCloneObjectFactory.cloneDataset(reportSubdataset);
        TableReportDataset reportDataset = new TableReportDataset(tableSubdataset, tableReportName);
        TableReport tableReport = new TableReport(this.fillContext, this.table, reportDataset, this.fillColumns, builtinEvaluators);
        if (log.isDebugEnabled()) {
            String tableReportXml = new JRXmlWriter(this.fillContext.getFiller().getJasperReportsContext()).write(tableReport, "UTF-8");
            log.debug("Generated table report:\n" + tableReportXml);
        }
        JRReportCompileData tableReportCompileData = this.createTableReportCompileData(parentReport, reportDataset);
        JasperReport compiledTableReport = new JasperReport((JRReport)tableReport, parentReport.getCompilerClass(), (Serializable)tableReportCompileData, new TableReportBaseObjectFactory(reportDataset), "");
        TableSubreport subreport = new TableSubreport(this.table.getDatasetRun(), this.fillContext);
        return new FillTableSubreport(this.fillContext.getFiller(), subreport, this.factory, compiledTableReport, builtinEvaluators);
    }

    protected JRReportCompileData createTableReportCompileData(JasperReport parentReport, JRDataset reportSubdataset) throws JRException {
        Serializable reportCompileDataObj = parentReport.getCompileData();
        if (!(reportCompileDataObj instanceof JRReportCompileData)) {
            throw new JRRuntimeException("Unsupported compiled report data of type " + reportCompileDataObj.getClass().getName());
        }
        JRReportCompileData reportCompileData = (JRReportCompileData)reportCompileDataObj;
        Serializable datasetCompileData = reportCompileData.getDatasetCompileData(reportSubdataset);
        TableReportCompileData tableReportCompileData = new TableReportCompileData(parentReport);
        tableReportCompileData.setMainDatasetCompileData(datasetCompileData);
        JRDataset[] datasets = parentReport.getDatasets();
        if (datasets != null) {
            for (JRDataset dataset : datasets) {
                Serializable compileData = reportCompileData.getDatasetCompileData(dataset);
                tableReportCompileData.setDatasetCompileData(dataset, compileData);
            }
        }
        return tableReportCompileData;
    }

    @Override
    public FillPrepareResult prepare(int availableHeight) {
        try {
            if (this.fillColumns.isEmpty()) {
                return FillPrepareResult.NO_PRINT_NO_OVERFLOW;
            }
            JRTemplatePrintFrame printFrame = new JRTemplatePrintFrame(this.getFrameTemplate(), this.elementId);
            JRLineBox lineBox = printFrame.getLineBox();
            FillPrepareResult result = this.fillSubreport.prepareSubreport(availableHeight - lineBox.getTopPadding() - lineBox.getBottomPadding(), this.filling);
            this.filling = result.willOverflow();
            return result;
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    @Override
    public JRPrintElement fill() {
        JRTemplatePrintFrame printFrame = new JRTemplatePrintFrame(this.getFrameTemplate(), this.elementId);
        printFrame.getPropertiesMap().setProperty("net.sf.jasperreports.export.html.uuid", this.fillContext.getComponentElement().getUUID().toString());
        JRLineBox lineBox = printFrame.getLineBox();
        printFrame.setUUID(this.fillContext.getComponentElement().getUUID());
        printFrame.setX(this.fillContext.getComponentElement().getX());
        printFrame.setY(this.fillContext.getElementPrintY());
        printFrame.setWidth(this.fillWidth + lineBox.getLeftPadding() + lineBox.getRightPadding());
        printFrame.setHeight(this.fillSubreport.getContentsStretchHeight() + lineBox.getTopPadding() + lineBox.getBottomPadding());
        List<JRStyle> styles = this.fillSubreport.getSubreportStyles();
        for (JRStyle style : styles) {
            try {
                this.fillContext.getFiller().addPrintStyle(style);
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
        }
        List<JROrigin> origins = this.fillSubreport.getSubreportOrigins();
        for (JROrigin origin : origins) {
            this.fillContext.getFiller().getJasperPrint().addOrigin(origin);
        }
        Collection<JRPrintElement> elements = this.fillSubreport.getPrintElements();
        if (elements != null) {
            for (JRPrintElement element : elements) {
                printFrame.addElement(element);
            }
        }
        this.fillSubreport.subreportPageFilled();
        return printFrame;
    }

    protected JRTemplateFrame getFrameTemplate() {
        JRStyle style = this.fillContext.getElementStyle();
        JRTemplateFrame frameTemplate = this.printFrameTemplates.get(style);
        if (frameTemplate == null) {
            frameTemplate = new JRTemplateFrame(this.fillContext.getElementOrigin(), this.fillContext.getDefaultStyleProvider());
            frameTemplate.setElement(this.fillContext.getComponentElement());
            frameTemplate = this.deduplicate(frameTemplate);
            this.printFrameTemplates.put(style, frameTemplate);
        }
        return frameTemplate;
    }

    @Override
    public void rewind() {
        if (this.filling) {
            if (log.isDebugEnabled()) {
                log.debug("Rewinding table subreport");
            }
            try {
                this.fillSubreport.rewind();
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
            this.filling = false;
        }
    }

    protected class FillColumnEvaluator
    implements ColumnVisitor<FillColumn> {
        final byte evaluation;

        public FillColumnEvaluator(byte evaluation) {
            this.evaluation = evaluation;
        }

        @Override
        public FillColumn visitColumn(Column column) {
            try {
                boolean toPrint = FillTable.this.toPrintColumn(column, this.evaluation);
                if (toPrint) {
                    JRPropertiesMap properties = FillTable.this.evaluateProperties(column, this.evaluation);
                    return new FillColumn(column, properties);
                }
                return null;
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
        }

        @Override
        public FillColumn visitColumnGroup(ColumnGroup columnGroup) {
            try {
                FillColumn fillColumn;
                boolean toPrint = FillTable.this.toPrintColumn(columnGroup, this.evaluation);
                if (toPrint) {
                    List<BaseColumn> columns = columnGroup.getColumns();
                    ArrayList<FillColumn> subColumns = new ArrayList<FillColumn>(columns.size());
                    int printWidth = 0;
                    for (BaseColumn column : columns) {
                        FillColumn fillSubColumn = column.visitColumn(this);
                        if (fillSubColumn == null) continue;
                        printWidth += fillSubColumn.getWidth();
                        subColumns.add(fillSubColumn);
                    }
                    if (subColumns.isEmpty()) {
                        fillColumn = null;
                    } else {
                        JRPropertiesMap properties = FillTable.this.evaluateProperties(columnGroup, this.evaluation);
                        fillColumn = new FillColumn(columnGroup, printWidth, subColumns, properties);
                    }
                } else {
                    fillColumn = null;
                }
                return fillColumn;
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
        }
    }
}

