/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.barcode4j;

import net.sf.jasperreports.components.barcode4j.BarcodeDesignEvaluator;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.component.ComponentDesignConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BarcodeDesignConverter
implements ComponentDesignConverter {
    private static final Log log = LogFactory.getLog(BarcodeDesignConverter.class);

    @Override
    public JRPrintElement convert(ReportConverter reportConverter, JRComponentElement element) {
        JRBasePrintImage printImage = new JRBasePrintImage(reportConverter.getDefaultStyleProvider());
        reportConverter.copyBaseAttributes(element, printImage);
        printImage.setScaleImage(ScaleImageEnum.RETAIN_SHAPE);
        Renderable barcodeImage = this.evaluateBarcode(reportConverter, element);
        printImage.setRenderable(barcodeImage);
        return printImage;
    }

    protected Renderable evaluateBarcode(ReportConverter reportConverter, JRComponentElement element) {
        try {
            BarcodeDesignEvaluator evaluator = new BarcodeDesignEvaluator(reportConverter.getJasperReportsContext(), element, reportConverter.getDefaultStyleProvider());
            return evaluator.evaluateImage();
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn("Failed to create barcode preview", e);
            }
            return null;
        }
    }
}

