/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.Box;
import it.businesslogic.ireport.BoxElement;
import it.businesslogic.ireport.GraphicReportElement;
import it.businesslogic.ireport.HyperLinkableReportElement;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.Java2DUtil;
import it.businesslogic.ireport.util.Misc;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.ImageObserver;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.util.JRImageLoader;

public class ImageReportElement
extends GraphicReportElement
implements ImageObserver,
HyperLinkableReportElement,
BoxElement {
    public static final String SCALE = "SCALE";
    public static final String VERTICAL_ALIGN = "VERTICAL_ALIGN";
    public static final String HORIZONTAL_ALIGN = "HORIZONTAL_ALIGN";
    public static final String USING_CACHE = "USING_CACHE";
    public static final String DEFAULT_SCALE = "FillFrame";
    public static final String DEFAULT_VERTICAL_ALIGN = "Top";
    public static final String DEFAULT_HORIZONTAL_ALIGN = "Left";
    public static final boolean DEFAULT_USING_CACHE = false;
    private List linkParameters = new ArrayList();
    private Image img = null;
    private static Image defimg = null;
    private String imageExpression;
    private String imageClass;
    private String hyperlinkType = "None";
    private String evaluationTime = "Now";
    private String evaluationGroup = "";
    private String anchorNameExpression = "";
    private String hyperlinkReferenceExpression = "";
    private String hyperlinkAnchorExpression = "";
    private String hyperlinkPageExpression = "";
    private String tooltipExpression = "";
    private String onErrorType = "Error";
    private int bookmarkLevel = 0;
    private boolean isLazy = false;
    private File reportDirectory = null;
    private boolean triedToLoadImg = false;
    private Box box = null;
    protected String hyperlinkTarget = "Self";

    public ImageReportElement(int x, int y, int width, int height) {
        super(x, y, Math.abs(width), Math.abs(height));
        this.setKey("image");
        if (defimg == null) {
            defimg = Misc.loadImageFromResources("it/businesslogic/ireport/icons/layout/img.gif");
        }
        this.img = null;
        this.imageExpression = "";
        this.imageClass = "java.lang.String";
        this.hyperlinkType = "None";
        this.anchorNameExpression = "";
        this.box = new Box();
    }

    public void drawObject(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        this.position.x += -10 + this.box.getLeftPadding();
        this.position.y += -10 + this.box.getTopPadding();
        this.width = this.width - this.box.getLeftPadding() - this.box.getRightPadding();
        this.height = this.height - this.box.getTopPadding() - this.box.getBottomPadding();
        x_shift_origin -= 10;
        y_shift_origin -= 10;
        this.zoom_factor = zoom_factor;
        Image imgx = this.img;
        if (imgx == null) {
            String fname = this.imageExpression;
            if (!this.triedToLoadImg && this.imageClass.equals("java.lang.String") && fname.length() > 3 && fname.charAt(0) == '\"' && fname.charAt(fname.length() - 1) == '\"') {
                fname = Misc.string_replace("\\", "\\\\", fname);
                File file = new File(fname = Misc.string_replace("", "\"", fname));
                if (!file.isAbsolute() && this.reportDirectory != null) {
                    file = new File(this.reportDirectory, fname);
                }
                if (file.exists()) {
                    this.img = Misc.loadImageFromFile(file.getAbsolutePath());
                } else {
                    try {
                        this.img = JRImageLoader.loadImage(JRImageLoader.loadImageDataFromURL((URL)MainFrame.getMainInstance().getReportClassLoader().getResource(fname)));
                    }
                    catch (Exception jrex) {
                        // empty catch block
                    }
                }
                imgx = this.img;
                this.triedToLoadImg = true;
            }
            if (imgx == null) {
                imgx = defimg;
            }
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        if (imgx != null) {
            int imageWidth = imgx.getWidth(this);
            int imageHeight = imgx.getHeight(this);
            Java2DUtil.setClip(g, this.getZoomedDim(this.position.x) - x_shift_origin, this.getZoomedDim(this.position.y) - y_shift_origin, this.getZoomedDim(this.width), this.getZoomedDim(this.height));
            if (this.getScaleImage().equalsIgnoreCase("RetainShape")) {
                if (imageWidth <= this.width && imageHeight <= this.height) {
                    Rectangle destination = new Rectangle(-x_shift_origin + this.getZoomedDim(this.position.x), -y_shift_origin + this.getZoomedDim(this.position.y), this.getZoomedDim(imageWidth), this.getZoomedDim(imageHeight));
                    Rectangle source = new Rectangle(0, 0, imageWidth, imageHeight);
                    int elem_height = this.getZoomedDim(this.height);
                    elem_height -= this.getZoomedDim(imageHeight);
                    if (this.getVerticalAlignment().equals("Middle")) {
                        destination.y += elem_height / 2;
                    } else if (this.getVerticalAlignment().equals("Bottom")) {
                        destination.y += elem_height;
                    }
                    int elem_width = this.getZoomedDim(this.width);
                    elem_width -= this.getZoomedDim(imageWidth);
                    if (this.getHorizontalAlignment().equals("Center")) {
                        destination.x += elem_width / 2;
                    } else if (this.getHorizontalAlignment().equals("Right")) {
                        destination.x += elem_width;
                    }
                    g.drawImage(imgx, destination.x, destination.y, destination.x + destination.width, destination.y + destination.height, source.x, source.y, source.width, source.height, null, this);
                } else if (this.width > 0 && this.height > 0) {
                    if ((double)imageWidth / (double)this.width > (double)imageHeight / (double)this.height) {
                        Rectangle source = new Rectangle(0, 0, imageWidth, imageHeight);
                        Rectangle destination = new Rectangle(-x_shift_origin + this.getZoomedDim(this.position.x), -y_shift_origin + this.getZoomedDim(this.position.y), this.getZoomedDim(this.width), this.getZoomedDim(Math.min(imageHeight * this.width / imageWidth, this.height)));
                        int elem_height = this.getZoomedDim(this.height);
                        elem_height -= this.getZoomedDim(Math.min(imageHeight * this.width / imageWidth, this.height));
                        if (this.getVerticalAlignment().equals("Middle")) {
                            destination.y += elem_height / 2;
                        } else if (this.getVerticalAlignment().equals("Bottom")) {
                            destination.y += elem_height;
                        }
                        g.drawImage(imgx, destination.x, destination.y, destination.x + destination.width, destination.y + destination.height, source.x, source.y, source.width, source.height, null, this);
                    } else {
                        Rectangle source = new Rectangle(0, 0, imageWidth, imageHeight);
                        Rectangle destination = new Rectangle(-x_shift_origin + this.getZoomedDim(this.position.x), -y_shift_origin + this.getZoomedDim(this.position.y), this.getZoomedDim(Math.min(imageWidth * this.height / imageHeight, this.width)), this.getZoomedDim(this.height));
                        int elem_width = this.getZoomedDim(this.width);
                        elem_width -= this.getZoomedDim(Math.min(imageWidth * this.height / imageHeight, this.width));
                        if (this.getHorizontalAlignment().equals("Center")) {
                            destination.x += elem_width / 2;
                        } else if (this.getHorizontalAlignment().equals("Right")) {
                            destination.x += elem_width;
                        }
                        g.drawImage(imgx, destination.x, destination.y, destination.x + destination.width, destination.y + destination.height, source.x, source.y, source.width, source.height, null, this);
                    }
                }
            } else if (this.getScaleImage().equalsIgnoreCase(DEFAULT_SCALE)) {
                g.drawImage(imgx, this.getZoomedDim(this.position.x) - x_shift_origin, this.getZoomedDim(this.position.y) - y_shift_origin, this.getZoomedDim(this.position.x + this.width) - x_shift_origin, this.getZoomedDim(this.position.y + this.height) - y_shift_origin, 0, 0, imageWidth, imageHeight, null, this);
            } else {
                Rectangle destination = new Rectangle(-x_shift_origin + this.getZoomedDim(this.position.x), -y_shift_origin + this.getZoomedDim(this.position.y), this.getZoomedDim(Math.min(imageWidth, this.width)), this.getZoomedDim(Math.min(imageHeight, this.height)));
                Rectangle source = new Rectangle(0, 0, Math.min(imageWidth, this.width), Math.min(imageHeight, this.height));
                int elem_height = this.getZoomedDim(this.height);
                elem_height -= this.getZoomedDim(imageHeight);
                if (this.getVerticalAlignment().equals("Middle")) {
                    destination.y += elem_height / 2;
                    if (destination.y < --y_shift_origin + this.getZoomedDim(this.position.y) + 10) {
                        source.y += -y_shift_origin + this.getZoomedDim(this.position.y) + 10 - destination.y;
                        destination.y = -y_shift_origin + this.getZoomedDim(this.position.y) + 10;
                    }
                } else if (this.getVerticalAlignment().equals("Bottom")) {
                    destination.y += elem_height;
                    if (destination.y < -y_shift_origin + this.getZoomedDim(this.position.y) + 10) {
                        source.y += -y_shift_origin + this.getZoomedDim(this.position.y) + 10 - destination.y;
                        destination.y = -y_shift_origin + this.getZoomedDim(this.position.y) + 10;
                    }
                }
                int elem_width = this.getZoomedDim(this.width);
                elem_width -= this.getZoomedDim(imageWidth);
                if (this.getHorizontalAlignment().equals("Center")) {
                    destination.x += elem_width / 2;
                    if (destination.x < -x_shift_origin + this.getZoomedDim(this.position.x - 10) + 10) {
                        source.x += -x_shift_origin + this.getZoomedDim(this.position.x - 10) + 10 - destination.x;
                        destination.x = -x_shift_origin + this.getZoomedDim(this.position.x - 10) + 10;
                    }
                } else if (this.getHorizontalAlignment().equals("Right")) {
                    destination.x += elem_width;
                    if (destination.x < -x_shift_origin + this.getZoomedDim(this.position.x - 10) + 10) {
                        source.x += -x_shift_origin + this.getZoomedDim(this.position.x - 10) + 10 - destination.x;
                        destination.x = -x_shift_origin + this.getZoomedDim(this.position.x - 10) + 10;
                    }
                }
                g.drawImage(imgx, destination.x, destination.y, destination.x + destination.width, destination.y + destination.height, source.x, source.y, source.width, source.height, null, this);
            }
            Java2DUtil.resetClip(g);
        }
        if (MainFrame.getMainInstance().getProperties().getProperty("Antialias", "true").equals("false")) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        }
        this.position.x += 10 - this.box.getLeftPadding();
        this.position.y += 10 - this.box.getTopPadding();
        this.width = this.width + this.box.getLeftPadding() + this.box.getRightPadding();
        this.height = this.height + this.box.getTopPadding() + this.box.getBottomPadding();
        super.drawBorder(g, zoom_factor, x_shift_origin += 10, y_shift_origin += 10);
        this.drawGraphicsElement(g, this.getGraphicElementPen(), zoom_factor, x_shift_origin, y_shift_origin);
        this.drawBorder(g, zoom_factor, x_shift_origin, y_shift_origin, this.getBox());
    }

    public ReportElement cloneMe() {
        ImageReportElement newReportElement = new ImageReportElement(this.position.x, this.position.y, this.width, this.height);
        this.copyBaseReportElement(newReportElement, this);
        newReportElement.setIsLazy(this.isIsLazy());
        return newReportElement;
    }

    public void copyBaseReportElement(ReportElement destination, ReportElement source) {
        super.copyBaseReportElement(destination, source);
        if (destination instanceof ImageReportElement && source instanceof ImageReportElement) {
            destination.setPropertyValue(SCALE, source.getPropertyValue(SCALE));
            destination.setPropertyValue(VERTICAL_ALIGN, source.getPropertyValue(VERTICAL_ALIGN));
            destination.setPropertyValue(HORIZONTAL_ALIGN, source.getPropertyValue(HORIZONTAL_ALIGN));
            destination.setPropertyValue(USING_CACHE, source.getPropertyValue(USING_CACHE));
            ((ImageReportElement)destination).setEvaluationGroup(new String(((ImageReportElement)source).getEvaluationGroup()));
            ((ImageReportElement)destination).setEvaluationTime(new String(((ImageReportElement)source).getEvaluationTime()));
            ((ImageReportElement)destination).setImageClass(new String(((ImageReportElement)source).getImageClass()));
            ((ImageReportElement)destination).setImageExpression(new String(((ImageReportElement)source).getImageExpression()));
            ((ImageReportElement)destination).setReportDirectory(((ImageReportElement)source).getReportDirectory());
            ((HyperLinkableReportElement)((Object)destination)).setAnchorNameExpression(new String(((HyperLinkableReportElement)((Object)source)).getAnchorNameExpression()));
            ((HyperLinkableReportElement)((Object)destination)).setHyperlinkAnchorExpression(new String(((HyperLinkableReportElement)((Object)source)).getHyperlinkAnchorExpression()));
            ((HyperLinkableReportElement)((Object)destination)).setHyperlinkPageExpression(new String(((HyperLinkableReportElement)((Object)source)).getHyperlinkPageExpression()));
            ((HyperLinkableReportElement)((Object)destination)).setHyperlinkReferenceExpression(new String(((HyperLinkableReportElement)((Object)source)).getHyperlinkReferenceExpression()));
            ((HyperLinkableReportElement)((Object)destination)).setHyperlinkType(new String(((HyperLinkableReportElement)((Object)source)).getHyperlinkType()));
        }
    }

    public void drawGraphicsElement(Graphics2D g, String pen, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        Stroke stroke = this.getPenStroke(pen, zoom_factor);
        g.setColor(this.getFgcolor());
        this.zoom_factor = zoom_factor;
        if (stroke == null || pen.equalsIgnoreCase("None")) {
            return;
        }
        this.position.x -= 10;
        this.position.y -= 10;
        Stroke oldStroke = g.getStroke();
        g.setStroke(stroke);
        g.drawRect(this.getZoomedDim(this.position.x) - (x_shift_origin -= 10), this.getZoomedDim(this.position.y) - (y_shift_origin -= 10), this.getZoomedDim(this.width), this.getZoomedDim(this.height));
        this.position.x += 10;
        this.position.y += 10;
        g.setStroke(oldStroke);
    }

    public String getHorizontalAlignment() {
        if (this.getPropertyValue(HORIZONTAL_ALIGN) == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeString("hAlign", DEFAULT_HORIZONTAL_ALIGN, true);
        }
        return this.getStringValue(HORIZONTAL_ALIGN, DEFAULT_HORIZONTAL_ALIGN);
    }

    public void setHorizontalAlignment(String horizontalAlignment) {
        this.setPropertyValue(HORIZONTAL_ALIGN, horizontalAlignment);
    }

    public String getImageClass() {
        return this.imageClass;
    }

    public void setImageClass(String imageClass) {
        this.imageClass = imageClass;
    }

    public String getVerticalAlignment() {
        if (this.getPropertyValue(VERTICAL_ALIGN) == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeString("vAlign", DEFAULT_VERTICAL_ALIGN, true);
        }
        return this.getStringValue(VERTICAL_ALIGN, DEFAULT_VERTICAL_ALIGN);
    }

    public void setVerticalAlignment(String verticalAlignment) {
        this.setPropertyValue(VERTICAL_ALIGN, verticalAlignment);
    }

    public String getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public void setEvaluationGroup(String evaluationGroup) {
        this.evaluationGroup = evaluationGroup;
    }

    public String getImageExpression() {
        return this.imageExpression;
    }

    public void setImageExpression(String imageExpression) {
        this.imageExpression = imageExpression;
        this.triedToLoadImg = false;
    }

    public String getEvaluationTime() {
        return this.evaluationTime;
    }

    public void setEvaluationTime(String evaluationTime) {
        this.evaluationTime = evaluationTime;
    }

    public Image getImg() {
        return this.img;
    }

    public Image getImgDef() {
        return defimg;
    }

    public void setImg(Image img) {
        this.img = img;
    }

    public String getHyperlinkType() {
        return this.hyperlinkType;
    }

    public void setHyperlinkType(String hyperlinkType) {
        this.hyperlinkType = hyperlinkType;
    }

    public String getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    public void setAnchorNameExpression(String anchorNameExpression) {
        this.anchorNameExpression = anchorNameExpression;
    }

    public String getScaleImage() {
        if (this.getPropertyValue(SCALE) == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeString("scaleImage", DEFAULT_SCALE, true);
        }
        return this.getStringValue(SCALE, DEFAULT_SCALE);
    }

    public void setScaleImage(String scaleImage) {
        this.setPropertyValue(SCALE, scaleImage);
    }

    public String getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    public void setHyperlinkReferenceExpression(String hyperlinkReferenceExpression) {
        this.hyperlinkReferenceExpression = hyperlinkReferenceExpression;
    }

    public String getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    public void setHyperlinkAnchorExpression(String hyperlinkAnchorExpression) {
        this.hyperlinkAnchorExpression = hyperlinkAnchorExpression;
    }

    public String getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    public void setHyperlinkPageExpression(String hyperlinkPageExpression) {
        this.hyperlinkPageExpression = hyperlinkPageExpression;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return true;
    }

    public static void setImgDef(Image defImg) {
        defimg = defImg;
    }

    public boolean isIsUsingCache() {
        return this.getBooleanValue(USING_CACHE, false);
    }

    public void setIsUsingCache(boolean isUsingCache) {
        this.setPropertyValue(USING_CACHE, new Boolean(isUsingCache));
    }

    public File getReportDirectory() {
        return this.reportDirectory;
    }

    public void setReportDirectory(File directory) {
        this.reportDirectory = directory;
    }

    public String getHyperlinkTarget() {
        return this.hyperlinkTarget;
    }

    public void setHyperlinkTarget(String hyperlinkTarget) {
        this.hyperlinkTarget = hyperlinkTarget;
    }

    public Box getBox() {
        return this.box;
    }

    public void setBox(Box box) {
        this.box = box;
    }

    public boolean isIsLazy() {
        return this.isLazy;
    }

    public void setIsLazy(boolean isLazy) {
        this.isLazy = isLazy;
    }

    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public void setBookmarkLevel(int bookmarkLevel) {
        this.bookmarkLevel = bookmarkLevel;
    }

    public String getOnErrorType() {
        return this.onErrorType;
    }

    public void setOnErrorType(String onErrorType) {
        this.onErrorType = onErrorType;
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        if (style != null) {
            if (style.getAttributeString("border", null, true) != null) {
                this.getBox().setBorder(style.getAttributeString("border", null, true));
            }
            if (style.getAttributeColor("borderColor", null, true) != null) {
                this.getBox().setBorderColor(style.getAttributeColor("borderColor", null, true));
            }
            if (style.getAttributeString("padding", null, true) != null) {
                this.getBox().setPadding(Integer.parseInt(style.getAttributeString("padding", null, true)));
            }
            if (style.getAttributeString("topBorder", null, true) != null) {
                this.getBox().setTopBorder(style.getAttributeString("topBorder", null, true));
            }
            if (style.getAttributeColor("topBorderColor", null, true) != null) {
                this.getBox().setTopBorderColor(style.getAttributeColor("topBorderColor", null, true));
            }
            if (style.getAttributeString("topPadding", null, true) != null) {
                this.getBox().setTopPadding(Integer.parseInt(style.getAttributeString("topPadding", null, true)));
            }
            if (style.getAttributeString("leftBorder", null, true) != null) {
                this.getBox().setLeftBorder(style.getAttributeString("leftBorder", null, true));
            }
            if (style.getAttributeColor("leftBorderColor", null, true) != null) {
                this.getBox().setLeftBorderColor(style.getAttributeColor("leftBorderColor", null, true));
            }
            if (style.getAttributeString("leftPadding", null, true) != null) {
                this.getBox().setLeftPadding(Integer.parseInt(style.getAttributeString("leftPadding", null, true)));
            }
            if (style.getAttributeString("rightBorder", null, true) != null) {
                this.getBox().setRightBorder(style.getAttributeString("rightBorder", null, true));
            }
            if (style.getAttributeColor("rightBorderColor", null, true) != null) {
                this.getBox().setRightBorderColor(style.getAttributeColor("rightBorderColor", null, true));
            }
            if (style.getAttributeString("rightPadding", null, true) != null) {
                this.getBox().setRightPadding(Integer.parseInt(style.getAttributeString("rightPadding", null, true)));
            }
            if (style.getAttributeString("bottomBorder", null, true) != null) {
                this.getBox().setBottomBorder(style.getAttributeString("bottomBorder", null, true));
            }
            if (style.getAttributeColor("bottomBorderColor", null, true) != null) {
                this.getBox().setBottomBorderColor(style.getAttributeColor("bottomBorderColor", null, true));
            }
            if (style.getAttributeString("bottomPadding", null, true) != null) {
                this.getBox().setBottomPadding(Integer.parseInt(style.getAttributeString("bottomPadding", null, true)));
            }
        }
    }

    public List getLinkParameters() {
        return this.linkParameters;
    }

    public void setLinkParameters(List linkParameters) {
        this.linkParameters = linkParameters;
    }

    public String getTooltipExpression() {
        return this.tooltipExpression;
    }

    public void setTooltipExpression(String tooltipExpression) {
        this.tooltipExpression = tooltipExpression;
    }
}

