/*
 * Decompiled with CFR 0.152.
 */
package ro.arhipac.adempiere.fa.process;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.compiere.model.MAsset;
import org.compiere.model.MDepreciationEntry;
import org.compiere.model.MDepreciationExp;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MPeriod;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;

public class A_Depreciation_Exp_Check
extends SvrProcess {
    private boolean p_IsTest = true;
    private int p_A_Asset_ID = -1;
    private String p_WhereClause = null;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("IsTest")) {
                this.p_IsTest = para.getParameterAsBoolean();
                continue;
            }
            if (name.equals("A_Asset_ID")) {
                this.p_A_Asset_ID = para.getParameterAsInt();
                continue;
            }
            if (!name.equals("WhereClause")) continue;
            this.p_WhereClause = (String)para.getParameter();
        }
    }

    @Override
    protected String doIt() throws Exception {
        for (int A_Asset_ID : this.getAsset_IDs()) {
            this.fixDepreciation(A_Asset_ID);
            if (!this.p_IsTest) continue;
            this.rollback();
        }
        return "Ok";
    }

    private int[] getAsset_IDs() {
        ArrayList<Object> params = new ArrayList<Object>();
        String whereClause = null;
        if (this.p_A_Asset_ID > 0) {
            whereClause = "A_Asset_ID=?";
            params.add(this.p_A_Asset_ID);
        } else {
            whereClause = this.p_WhereClause;
        }
        return new Query(this.getCtx(), "A_Asset", whereClause, this.get_TrxName()).setParameters(params).setOrderBy("A_Asset_ID").getIDs();
    }

    private void fixDepreciation(int A_Asset_ID) {
        int i;
        Timestamp tms;
        MAsset asset = MAsset.get(this.getCtx(), A_Asset_ID, this.get_TrxName());
        List<MDepreciationExp> depreciations = this.getDepreciation(asset);
        if (depreciations.get(0).getA_Period() == 0) {
            this.fixDepreciationExp(depreciations.get(0), TimeUtil.getMonthLastDay(asset.getAssetServiceDate()));
            tms = depreciations.get(0).getDateAcct();
            for (i = 1; i < depreciations.size(); ++i) {
                this.fixDepreciationExp(depreciations.get(i), TimeUtil.getMonthLastDay(TimeUtil.addMonths(tms, 1)));
                tms = depreciations.get(i).getDateAcct();
            }
        } else {
            this.fixDepreciationExp(depreciations.get(0), TimeUtil.getMonthLastDay(TimeUtil.addMonths(asset.getAssetServiceDate(), 1)));
            tms = depreciations.get(0).getDateAcct();
            for (i = 1; i < depreciations.size(); ++i) {
                this.fixDepreciationExp(depreciations.get(i), TimeUtil.getMonthLastDay(TimeUtil.addMonths(tms, 1)));
                tms = depreciations.get(i).getDateAcct();
            }
        }
        for (MDepreciationWorkfile wk : MDepreciationWorkfile.forA_Asset_ID(this.getCtx(), A_Asset_ID, this.get_TrxName())) {
            wk.setA_Current_Period();
            wk.saveEx();
            this.addLog("" + wk + ": Period=" + wk.getA_Current_Period() + ", DateAcct=" + wk.getDateAcct());
        }
    }

    private void fixDepreciationExp(MDepreciationExp exp, Timestamp dateAcctNew) {
        if (!exp.getDateAcct().equals(dateAcctNew)) {
            this.addLog("OLD1: " + exp);
            MDepreciationEntry.deleteFacts(exp);
            exp.setDateAcct(dateAcctNew);
            exp.setA_Depreciation_Entry_ID(0);
            exp.saveEx();
            this.addLog("NEW1: " + exp);
        }
        if (exp.getA_Depreciation_Entry_ID() > 0) {
            int C_Period_ID = DB.getSQLValueEx(exp.get_TrxName(), "SELECT C_Period_ID FROM A_Depreciation_Entry WHERE A_Depreciation_Entry_ID=?", exp.getA_Depreciation_Entry_ID());
            MPeriod period = MPeriod.get(exp.getCtx(), C_Period_ID);
            if (!period.isInPeriod(exp.getDateAcct())) {
                this.addLog("OLD2: " + exp);
                MDepreciationEntry.deleteFacts(exp);
                exp.setA_Depreciation_Entry_ID(0);
                exp.saveEx();
                this.addLog("NEW2: " + exp);
            }
        }
    }

    private List<MDepreciationExp> getDepreciation(MAsset asset) {
        String whereClause = "A_Asset_ID=?";
        return new Query(this.getCtx(), "A_Depreciation_Exp", whereClause, this.get_TrxName()).setParameters(asset.get_ID()).setOrderBy("A_Period").list();
    }
}

