/*
 * Decompiled with CFR 0.152.
 */
package ro.arhipac.adempiere.fa;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.acct.Fact;
import org.compiere.model.FAInvoiceAndLine;
import org.compiere.model.FactsValidator;
import org.compiere.model.I_A_Asset;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetAddition;
import org.compiere.model.MAssetDisposed;
import org.compiere.model.MAssetType;
import org.compiere.model.MClient;
import org.compiere.model.MCostDetail;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MDocType;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.SetGetModel;
import org.compiere.model.SetGetUtil;
import org.compiere.util.ArhRuntimeException;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import ro.arhipac.adempiere.fa.exceptions.AssetInvoiceWithMixedLines_LRO;
import ro.arhipac.adempiere.fa.exceptions.AssetNotImplementedException;
import ro.arhipac.adempiere.fa.exceptions.AssetProductStockedException;

public class ModelValidator
implements org.compiere.model.ModelValidator,
FactsValidator {
    private static CLogger log = CLogger.getCLogger(ModelValidator.class);
    private int m_AD_Client_ID = -1;

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addModelChange("M_AttributeSetInstance", this);
        engine.addModelChange("A_Asset", this);
        engine.addDocValidate("M_Inventory", this);
        engine.addModelChange("C_InvoiceLine", this);
        engine.addDocValidate("C_Invoice", this);
        engine.addModelChange("M_MatchInv", this);
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        if (po instanceof MMatchInv && (4 == type || 5 == type && po.is_ValueChanged("Processed"))) {
            MInvoiceLine invoiceLine;
            MMatchInv mi = (MMatchInv)po;
            if (mi.isProcessed() && (invoiceLine = new MInvoiceLine(mi.getCtx(), mi.getC_InvoiceLine_ID(), mi.get_TrxName())).isA_CreateAsset() && !invoiceLine.isA_Processed() && MAssetType.isFixedAssetGroup(mi.getCtx(), invoiceLine.getA_Asset_Group_ID())) {
                MAssetAddition.createAsset(mi);
            }
        } else if (po instanceof MInvoiceLine) {
            ModelValidator.modelChange_InvoiceLine(SetGetUtil.wrap(po), type);
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MInvoice invoice;
        if (po instanceof MInventory) {
            this.docValidate_Inventory((MInventory)po, timing);
        } else if (po instanceof MInvoice && 8 == timing) {
            MInvoice invoice2 = (MInvoice)po;
            this.validateFixedAssetsInvoice_LRO(invoice2);
        } else if (po instanceof MInvoice && 9 == timing && FAInvoiceAndLine.isFixedAssetInvoice(invoice = (MInvoice)po) && invoice.isSOTrx()) {
            MPeriod period = MPeriod.get(invoice.getCtx(), invoice.getDateAcct(), invoice.getAD_Org_ID());
            for (MInvoiceLine line : invoice.getLines()) {
                if (!FAInvoiceAndLine.isFixedAssetInvoice(line)) continue;
                I_A_Asset asset = line.getA_Asset();
                Collection<MDepreciationWorkfile> cWorkfiles = MDepreciationWorkfile.forA_Asset_ID(invoice.getCtx(), asset.getA_Asset_ID(), invoice.get_TrxName());
                for (MDepreciationWorkfile workfile : cWorkfiles) {
                    MAssetDisposed disposal = new MAssetDisposed(invoice.getCtx(), 0, invoice.get_TrxName());
                    disposal.setA_Asset_ID(asset.getA_Asset_ID());
                    disposal.setA_Disposed_Date(invoice.getDateInvoiced());
                    disposal.setA_Disposed_Reason("S1");
                    disposal.setC_Period_ID(period.getC_Period_ID());
                    disposal.setDateDoc(invoice.getDateInvoiced());
                    disposal.setDateAcct(invoice.getDateAcct());
                    disposal.setA_Proceeds(Env.ZERO);
                    disposal.setA_Disposed_Method("SL");
                    disposal.setDescription(Msg.getMsg(invoice.getCtx(), "AssetDisposalFromInvoiceLine"));
                    disposal.setPostingType(workfile.getPostingType());
                    BigDecimal qty = line.getQtyEntered();
                    if (qty.compareTo(Env.ONE) == 1 || qty.signum() < 1) {
                        qty = Env.ONE;
                    }
                    disposal.setC_InvoiceLine_ID(line.getC_InvoiceLine_ID());
                    disposal.setA_Accumulated_Depr(workfile.getA_Accumulated_Depr());
                    disposal.setA_Asset_Cost(workfile.getA_Asset_Cost());
                    BigDecimal bdDisposalAmt = workfile.getA_Asset_Cost().multiply(qty);
                    BigDecimal bdAccumDeprDelta = workfile.getA_Accumulated_Depr().multiply(qty);
                    disposal.setA_Accumulated_Depr_Delta(bdAccumDeprDelta);
                    disposal.setA_Disposal_Amt(bdDisposalAmt);
                    BigDecimal bdExpense = bdDisposalAmt.subtract(bdAccumDeprDelta).subtract(line.getLineNetAmt());
                    disposal.setExpense(bdExpense);
                    disposal.setA_Asset_Status(asset.getA_Asset_Status());
                    disposal.setIsDisposed(false);
                    disposal.saveEx();
                }
            }
        }
        return null;
    }

    private void docValidate_Inventory(MInventory inventory, int timing) {
        if (9 == timing) {
            this.createAsset(inventory);
        } else if (5 == timing) {
            MInventoryLine[] lines;
            for (MInventoryLine line : lines = inventory.getLines(false)) {
                if (line.getA_Asset_ID() <= 0) continue;
                throw new ArhRuntimeException("@A_CanNotReverseDocumentsThatCreatedAsset@");
            }
        }
    }

    private void createAsset(MInventory inventory) {
        MDocType dt = MDocType.get(inventory.getCtx(), inventory.getC_DocType_ID());
        if (!dt.isSOTrx()) {
            return;
        }
        for (MInventoryLine line : inventory.getLines(false)) {
            if (!line.isA_CreateAsset() || line.isA_Processed()) continue;
            if (line.getA_Asset_ID() > 0) {
                if (!MAssetType.isFixedAsset(line.getA_Asset_ID())) continue;
                throw new AssetNotImplementedException("Modernizare asset din stoc utilizat intern");
            }
            MProduct product = line.getProduct();
            if (product != null && line.getQtyInternalUse().signum() > 0) {
                BigDecimal qty = line.getQtyInternalUse();
                int noAssets = qty.intValue();
                if (!product.isOneAssetPerUOM()) {
                    noAssets = 1;
                } else {
                    qty = Env.ONE;
                }
                BigDecimal costPrice = this.getCostPrice(line);
                for (int j = 0; j < noAssets; ++j) {
                    BigDecimal costs = costPrice.multiply(qty);
                    MAsset asset = new MAsset(inventory, line, qty, costs);
                    asset.saveEx();
                    asset = MAsset.get(line.getCtx(), asset.get_ID(), line.get_TrxName());
                    asset.setA_Asset_Cost(costs);
                    asset.saveEx();
                    line.setA_Asset_ID(asset.get_ID());
                    line.setA_Processed(true);
                    line.saveEx();
                }
                continue;
            }
            if (!CLogMgt.isLevelFinest()) continue;
            log.finest("Asset creating is not required for " + product + ", createAsset=" + product.isCreateAsset() + ", QtyInternalUse=" + line.getQtyInternalUse());
        }
    }

    private BigDecimal getCostPrice(MInventoryLine iline) {
        MProduct product = MProduct.get(iline.getCtx(), iline.getM_Product_ID());
        MCostDetail.processProduct(product, iline.get_TrxName());
        MAcctSchema as = MClient.get(iline.getCtx()).getAcctSchema();
        MCostDetail cd = MCostDetail.get(iline.getCtx(), "M_InventoryLine_ID=?", iline.get_ID(), iline.getM_AttributeSetInstance_ID(), as.getC_AcctSchema_ID(), iline.get_TrxName());
        if (cd == null) {
            throw new AdempiereException("Nu s-au creat costuri pentru acest produs - " + iline);
        }
        BigDecimal costPrice = cd.getAmt().divide(cd.getQty(), as.getCostingPrecision(), RoundingMode.HALF_UP);
        return costPrice;
    }

    public static void modelChange_InvoiceLine(SetGetModel m, int changeType) {
        int invoice_id;
        if (-1 == changeType || 1 == changeType || 2 == changeType) {
            invoice_id = SetGetUtil.get_AttrValueAsInt(m, "C_Invoice_ID");
            boolean isSOTrx = DB.isSOTrx("C_Invoice", "C_Invoice_ID=" + invoice_id);
            boolean isAsset = false;
            boolean isFixedAsset = false;
            int assetGroup_ID = 0;
            int product_id = SetGetUtil.get_AttrValueAsInt(m, "M_Product_ID");
            if (product_id > 0) {
                MProduct prod = MProduct.get(m.getCtx(), product_id);
                isAsset = prod != null && prod.get_ID() > 0 && prod.isCreateAsset();
                assetGroup_ID = prod.getA_Asset_Group_ID();
                isFixedAsset = MAssetType.isFixedAssetGroup(m.getCtx(), assetGroup_ID);
            }
            m.set_AttrValue("A_CreateAsset", isAsset);
            if (isAsset) {
                if (!isSOTrx) {
                    m.set_AttrValue("A_Asset_Group_ID", assetGroup_ID);
                    m.set_AttrValue("A_CapvsExp", "Cap");
                }
                m.set_AttrValue("IsFixedAssetInvoice", isFixedAsset);
            } else {
                m.set_AttrValue("A_Asset_Group_ID", null);
                m.set_AttrValue("A_Asset_ID", null);
                m.set_AttrValue("IsFixedAssetInvoice", false);
            }
            if (isAsset && m instanceof MInvoiceLine) {
                MInvoiceLine line = (MInvoiceLine)((Object)m);
                if ("Exp".equals(line.getA_CapvsExp()) && line.getA_Asset_ID() <= 0 && !isSOTrx) {
                    throw new FillMandatoryException(new String[]{"A_Asset_ID"});
                }
                if (line.getLineNetAmt().signum() == 0 && !isSOTrx) {
                    throw new FillMandatoryException("QtyEntered", "PriceEntered");
                }
                MProduct product = line.getProduct();
                if (product.isStocked() && FAInvoiceAndLine.isFixedAssetInvoice(line)) {
                    throw new AssetProductStockedException(product);
                }
            }
        }
        if (4 == changeType || 5 == changeType || 6 == changeType) {
            invoice_id = SetGetUtil.get_AttrValueAsInt(m, "C_Invoice_ID");
            String sql = "UPDATE C_Invoice i SET IsFixedAssetInvoice=(SELECT COALESCE(MAX(il.IsFixedAssetInvoice),'N') FROM C_InvoiceLine il WHERE il.C_Invoice_ID=i.C_Invoice_ID AND il.IsDescription='N') WHERE C_Invoice_ID=?";
            DB.executeUpdateEx(sql, new Object[]{invoice_id}, m.get_TrxName());
        }
    }

    public static void modelChange_InventoryLine(SetGetModel m, int changeType) {
        if (-1 == changeType || 1 == changeType || 2 == changeType) {
            int product_id;
            int inventory_id = SetGetUtil.get_AttrValueAsInt(m, "M_Inventory_ID");
            boolean isInternalUseInventory = true;
            boolean isAsset = false;
            int assetGroup_ID = 0;
            if (isInternalUseInventory && (product_id = SetGetUtil.get_AttrValueAsInt(m, "M_Product_ID")) > 0) {
                MProduct prod = MProduct.get(m.getCtx(), product_id);
                isAsset = prod != null && prod.get_ID() > 0 && prod.isCreateAsset();
                assetGroup_ID = prod.getA_Asset_Group_ID();
            }
            m.set_AttrValue("A_CreateAsset", isAsset);
            if (isAsset) {
                m.set_AttrValue("A_Asset_Group_ID", assetGroup_ID);
            } else {
                m.set_AttrValue("A_Asset_Group_ID", null);
                m.set_AttrValue("A_Asset_ID", null);
            }
            if (isAsset && -1 == changeType) {
                m.set_AttrValue("QtyInternalUse", Env.ONE);
            }
            if (isAsset && m instanceof MInventoryLine) {
                MInventoryLine line = (MInventoryLine)((Object)m);
                if ("Exp".equals(line.getA_CapvsExp()) && line.getA_Asset_ID() <= 0) {
                    throw new FillMandatoryException(new String[]{"A_Asset_ID"});
                }
                if (line.getQtyInternalUse().signum() <= 0) {
                    throw new IllegalArgumentException("@QtyInternalUse@ <= 0");
                }
            }
        }
    }

    private void validateFixedAssetsInvoice_LRO(MInvoice invoice) {
        if (FAInvoiceAndLine.isFixedAssetInvoice(invoice)) {
            boolean hasFixedAssetLines = false;
            boolean hasNormalLines = false;
            for (MInvoiceLine line : invoice.getLines()) {
                MProduct product;
                if (FAInvoiceAndLine.isFixedAssetInvoice(line)) {
                    hasFixedAssetLines = true;
                } else if (line.getM_Product_ID() > 0 && (product = MProduct.get(line.getCtx(), line.getM_Product_ID())).isItem()) {
                    hasNormalLines = true;
                }
                if (!hasFixedAssetLines || !hasNormalLines) continue;
                throw new AssetInvoiceWithMixedLines_LRO();
            }
        }
    }

    @Override
    public String factsValidate(MAcctSchema schema, List<Fact> facts, PO po) {
        return null;
    }
}

