/*
 * Decompiled with CFR 0.152.
 */
package org.mb.report;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class VendorManagement
extends SvrProcess {
    Timestamp p_DateFrom;
    Timestamp p_DateTo;
    int p_SalesRep_ID;
    int p_AD_Org_ID;
    private long m_start = System.currentTimeMillis();

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            this.log.fine("prepare - " + para[i]);
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("SalesRep_ID")) {
                    this.p_SalesRep_ID = para[i].getParameterAsInt();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("DateVisit")) {
                    this.p_DateFrom = (Timestamp)para[i].getParameter();
                    this.p_DateTo = (Timestamp)para[i].getParameter_To();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        return this.loadReport();
    }

    private String loadReport() {
        StringBuffer sql = new StringBuffer();
        if (this.p_DateFrom != null && this.p_DateTo != null && this.p_SalesRep_ID != 0 && this.p_AD_Org_ID != 0) {
            try {
                sql.append("Insert InTo T_XX_VendorManagement(T_XX_VendorManagement_ID,SalesRep_ID,DateVisit,AD_Client_ID,AD_Org_ID,AD_PInstance_ID,QtyPlanning) \n ");
                sql.append("Select nextval('t_xx_vendormanagement_seq'),* From (\n Select Distinct \nsr.salesrep_id,  \n gs.current_s AS datevisit,  \n pv.ad_client_id,  \n pv.ad_org_id,  \n " + this.getAD_PInstance_ID() + ",  \n " + "Count(pv.C_BPartner_Location_ID) as QtyPlanning  \n " + "FROM C_SalesRegion sr  \n " + "INNER JOIN XX_MB_PlanningVisit pv ON(pv.C_SalesRegion_ID = sr.C_SalesRegion_ID) \n " + "INNER JOIN XX_MB_Frequency fr ON(fr.XX_MB_Frequency_ID = pv.XX_MB_Frequency_ID)  \n " + "INNER JOIN XX_MB_Day d ON(d.XX_MB_Day_ID = pv.XX_MB_Day_ID)  \n " + "INNER JOIN (SELECT generate_series(Min(DateFrom), Max(DateFrom), '1 day') current_s,Max(DateFrom) as max_DateFrom From XX_P_Time_Dimension) gs \n " + "ON( \n " + "MOD( \n " + "CAST(EXTRACT(DAY FROM (gs.current_s - pv.ValidFrom)) AS NUMERIC), \n " + "CASE  \n " + "WHEN fr.DaysOfFrequency IS NULL OR fr.DaysOfFrequency = 0 THEN 1 \n " + "ELSE fr.DaysOfFrequency  \n " + "END) = 0  \n " + ")  \n " + ",XX_P_Time_Dimension td \n " + "WHERE  \n " + "MOD( \n " + "CAST( \n " + "EXTRACT(DAY FROM (gs.current_s - pv.ValidFrom)) AS NUMERIC), \n " + "CASE  \n " + "WHEN fr.DaysOfFrequency IS NULL OR fr.DaysOfFrequency = 0 THEN 1 \n " + "ELSE fr.DaysOfFrequency  \n " + "END) = 0  \n " + "And pv.ValidFrom <= gs.current_s \n " + "And td.DateFrom = gs.current_s And td.TimeCategory='D' \n " + "And (Select min(Case When pvs.ValidFrom =pv.ValidFrom Then max_DateFrom Else pvs.ValidFrom End) from XX_MB_PlanningVisit pvs where pvs.ValidFrom >= pv.ValidFrom And pvs.c_bpartner_location_id=pv.c_bpartner_location_id And pvs.c_bpartner_id=pv.c_bpartner_id and pvs.c_SalesRegion_id=pv.c_SalesRegion_id )>= gs.current_s \n " + "And gs.current_s Between ? And ?  \n " + "And sr.SalesRep_ID=?  \n " + "And pv.AD_Org_ID=?  \n " + "Group By \n" + "sr.salesrep_id,  \n " + "gs.current_s,  \n " + "pv.ad_client_id,  \n " + "pv.ad_org_id  \n " + ") as Visit");
                System.out.println(sql.toString());
                CPreparedStatement ps = DB.prepareStatement(sql.toString(), this.get_TrxName());
                ps.setTimestamp(1, this.p_DateFrom);
                ps.setTimestamp(2, this.p_DateTo);
                ps.setInt(3, this.p_SalesRep_ID);
                ps.setInt(4, this.p_AD_Org_ID);
                ps.execute();
                this.log.fine(String.valueOf(System.currentTimeMillis() - this.m_start) + " ms");
                return "@Created@ = " + ps.getUpdateCount();
            }
            catch (SQLException ex) {
                throw new AdempiereException(ex);
            }
        }
        this.log.fine(String.valueOf(System.currentTimeMillis() - this.m_start) + " ms");
        return "@Created@ = 0";
    }
}

