/*
 * Decompiled with CFR 0.152.
 */
package org.mb.report;

import java.sql.SQLException;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class PlanningVisit
extends SvrProcess {
    private int p_SalesRep_ID = 0;
    private Timestamp p_DateVisit = null;
    private Timestamp p_DateVisitTo = null;
    private StringBuffer sql = new StringBuffer();
    private long m_start = System.currentTimeMillis();

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if (para.getParameter() != null) {
                if (name.equals("DateVisit")) {
                    this.p_DateVisit = (Timestamp)para.getParameter();
                    this.p_DateVisitTo = (Timestamp)para.getParameter_To();
                } else if (name.equals("SalesRep_ID")) {
                    this.p_SalesRep_ID = para.getParameterAsInt();
                }
            }
            ++n2;
        }
    }

    @Override
    protected String doIt() throws SQLException {
        this.sql.append("INSERT INTO T_XX_MB_PlanningVisit(C_SalesRegion_ID, SalesRep_ID, XX_MB_PlanningVisit_ID, XX_MB_Day_ID, XX_MB_Frequency_ID, Period, XX_MB_Mo_C_BPartner_ID, XX_MB_Tu_C_BPartner_ID, XX_MB_We_C_BPartner_ID, XX_MB_Th_C_BPartner_ID, XX_MB_Fr_C_BPartner_ID, XX_MB_Sa_C_BPartner_ID, XX_MB_Week, SeqNo, DateVisit, AD_Client_ID, AD_Org_ID, AD_PInstance_ID) ");
        this.sql.append("SELECT DISTINCT sr.C_SalesRegion_ID, sr.SalesRep_ID, pv.XX_MB_PlanningVisit_ID, pv.XX_MB_Day_ID, pv.XX_MB_Frequency_ID, TO_CHAR(gs.current_s, 'MM/YYYY') DateVisit, CASE \tWHEN d.SeqNo = 20 THEN pv.C_BPartner_ID \tELSE NULL END XX_MB_Mo_C_BPartner_ID, CASE \tWHEN d.SeqNo = 30 THEN pv.C_BPartner_ID \tELSE NULL END XX_MB_Tu_C_BPartner_ID, CASE \tWHEN d.SeqNo = 40 THEN pv.C_BPartner_ID \tELSE NULL END XX_MB_We_C_BPartner_ID, CASE \tWHEN d.SeqNo = 50 THEN pv.C_BPartner_ID \tELSE NULL END XX_MB_Th_C_BPartner_ID, CASE \tWHEN d.SeqNo = 60 THEN pv.C_BPartner_ID \tELSE NULL END XX_MB_Fr_C_BPartner_ID, CASE \tWHEN d.SeqNo = 70 THEN pv.C_BPartner_ID \tELSE NULL END XX_MB_Sa_C_BPartner_ID, CASE \tWHEN EXTRACT(DAY FROM gs.current_s) >= 1 AND EXTRACT(DAY FROM gs.current_s) <= 7 THEN 1 \tWHEN EXTRACT(DAY FROM gs.current_s) >= 8 AND EXTRACT(DAY FROM gs.current_s) <= 14 THEN 2 \tWHEN EXTRACT(DAY FROM gs.current_s) >= 15 AND EXTRACT(DAY FROM gs.current_s) <= 21 THEN 3 \tWHEN EXTRACT(DAY FROM gs.current_s) >= 22 THEN 4 END XX_MB_Week, pv.SeqNo,  " + DB.TO_DATE(this.p_DateVisit) + ", " + " " + this.getAD_Client_ID() + ", " + " " + Env.getAD_Org_ID(this.getCtx()) + ", " + " " + this.getAD_PInstance_ID() + " ");
        this.sql.append("FROM C_SalesRegion sr INNER JOIN XX_MB_PlanningVisit pv ON(pv.C_SalesRegion_ID = sr.C_SalesRegion_ID) INNER JOIN XX_MB_Frequency fr ON(fr.XX_MB_Frequency_ID = pv.XX_MB_Frequency_ID) INNER JOIN XX_MB_Day d ON(d.XX_MB_Day_ID = pv.XX_MB_Day_ID) INNER JOIN (SELECT generate_series(" + DB.TO_DATE(this.p_DateVisit) + ", " + DB.TO_DATE(this.p_DateVisitTo) + ", '1 day') current_s) gs " + "\tON(" + "\t\tMOD(" + "\t\t\tCAST(EXTRACT(DAY FROM (gs.current_s - pv.ValidFrom)) AS NUMERIC), " + "\t\t\tCASE " + "\t\t\t\tWHEN fr.DaysOfFrequency IS NULL OR fr.DaysOfFrequency = 0 THEN 1 " + "\t\t\t\tELSE fr.DaysOfFrequency " + "\t\t\tEND) = 0" + "\t) ");
        this.sql.append("WHERE sr.SalesRep_ID =  " + this.p_SalesRep_ID + " " + "AND pv.IsValid = 'Y' " + "AND MOD(" + "\t\tCAST(" + "\t\t\tEXTRACT(DAY FROM (gs.current_s - pv.ValidFrom)) AS NUMERIC), " + "\t\tCASE " + "\t\t\tWHEN fr.DaysOfFrequency IS NULL OR fr.DaysOfFrequency = 0 THEN 1 " + "\t\t\tELSE fr.DaysOfFrequency " + "\t\tEND) = 0 ");
        this.sql.append("ORDER BY DateVisit, XX_MB_Week");
        this.log.fine("SQL = " + this.sql.toString());
        int noInserts = 0;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(this.sql.toString(), null);
            noInserts = pstmt.executeUpdate();
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
        this.log.fine(String.valueOf(System.currentTimeMillis() - this.m_start) + " ms");
        return "@Created@ = " + noInserts;
    }
}

