/*
 * Decompiled with CFR 0.152.
 */
package org.mb.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MOrder;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class OrderBatchProcess
extends SvrProcess {
    private int p_C_DocTypeTarget_ID = 0;
    private int p_C_Order_ID = 0;
    private String p_DocStatus = null;
    private int p_C_BPartner_ID = 0;
    private String p_IsSelfService = null;
    private Timestamp p_DateOrdered_From = null;
    private Timestamp p_DateOrdered_To = null;
    private String p_DocAction = null;
    private String p_IsDelivered = null;
    private String p_IsInvoiced = null;
    private MOrder order = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_Order_ID")) {
                    this.p_C_Order_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_DocTypeTarget_ID")) {
                    this.p_C_DocTypeTarget_ID = para[i].getParameterAsInt();
                } else if (name.equals("DocStatus")) {
                    this.p_DocStatus = (String)para[i].getParameter();
                } else if (name.equals("IsSelfService")) {
                    this.p_IsSelfService = (String)para[i].getParameter();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("DateOrdered")) {
                    this.p_DateOrdered_From = (Timestamp)para[i].getParameter();
                    this.p_DateOrdered_To = (Timestamp)para[i].getParameter_To();
                } else if (name.equals("DocAction")) {
                    this.p_DocAction = (String)para[i].getParameter();
                } else if (name.equals("IsDelivered")) {
                    this.p_IsDelivered = (String)para[i].getParameter();
                } else if (name.equals("IsInvoiced")) {
                    this.p_IsInvoiced = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("C_DocTypeTarget_ID=" + this.p_C_DocTypeTarget_ID + ", DocStatus=" + this.p_DocStatus + ", IsSelfService=" + this.p_IsSelfService + ", C_BPartner_ID=" + this.p_C_BPartner_ID + ", DateOrdered=" + this.p_DateOrdered_From + "->" + this.p_DateOrdered_To + ", DocAction=" + this.p_DocAction + ", IsDelivered=" + this.p_IsDelivered + ", IsInvoiced=" + this.p_IsInvoiced);
        if (this.p_C_Order_ID == 0) {
            throw new AdempiereUserError("@NotFound@: @C_Order_ID@");
        }
        if (this.p_DocStatus == null || this.p_DocStatus.length() != 2) {
            throw new AdempiereUserError("@NotFound@: @DocStatus@");
        }
        if (this.p_DocAction == null || this.p_DocAction.length() != 2) {
            throw new AdempiereUserError("@NotFound@: @DocAction@");
        }
        StringBuffer sql = new StringBuffer("SELECT * FROM C_Order o  WHERE o.C_Order_ID=? AND o.DocStatus=? ");
        int counter = 0;
        int errCounter = 0;
        boolean ok = true;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            pstmt.setInt(1, this.p_C_Order_ID);
            pstmt.setString(2, this.p_DocStatus);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                ok = this.process(rs);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (!ok) {
            throw new AdempiereUserError("@Error@: " + this.order.getProcessMsg());
        }
        return "@Updated@=" + counter + ", @Errors@=" + errCounter;
    }

    private boolean process(ResultSet rs) {
        this.order = new MOrder(this.getCtx(), rs, this.get_TrxName());
        this.log.info(this.order.toString());
        this.order.setDocAction(this.p_DocAction);
        if (this.order.processIt(this.p_DocAction)) {
            this.order.save();
            this.addLog(0, null, null, String.valueOf(this.order.getDocumentNo()) + ": OK");
            return true;
        }
        this.addLog(0, null, null, String.valueOf(this.order.getDocumentNo()) + ": Error " + this.order.getProcessMsg());
        return false;
    }
}

