/*
 * Decompiled with CFR 0.152.
 */
package org.mb.process;

import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Trx;
import org.mb.model.MWebServiceFieldInput;
import org.mb.model.MWebServiceFieldOutput;
import org.mb.model.MWebServicePara;
import org.mb.model.MWebServiceType;

public class GenerateWebService
extends SvrProcess {
    private Trx trx;
    private String trxName;
    private String m_Value;
    private String m_Name;
    private int m_WebService;
    private int m_WebServiceMethod;
    private int m_Table;
    private int m_TableMobile;
    private String m_SynchronizedType;
    private Properties ctx;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            if (para[i].getParameterName().equals("Value")) {
                this.m_Value = para[i].getParameter() != null ? para[i].getParameter().toString() : "";
            } else if (para[i].getParameterName().equals("Name")) {
                this.m_Name = para[i].getParameter() != null ? para[i].getParameter().toString() : "";
            } else if (para[i].getParameterName().equals("WS_WebService_ID")) {
                this.m_WebService = para[i].getParameter() != null ? Integer.parseInt(para[i].getParameter().toString()) : 0;
            } else if (para[i].getParameterName().equals("WS_WebServiceMethod_ID")) {
                this.m_WebServiceMethod = para[i].getParameter() != null ? Integer.parseInt(para[i].getParameter().toString()) : 0;
            } else if (para[i].getParameterName().equals("AD_Table_ID")) {
                this.m_Table = para[i].getParameter() != null ? Integer.parseInt(para[i].getParameter().toString()) : 0;
            } else if (para[i].getParameterName().equals("XX_MB_Table_ID")) {
                this.m_TableMobile = para[i].getParameter() != null ? Integer.parseInt(para[i].getParameter().toString()) : 0;
            } else if (para[i].getParameterName().equals("SynchronizeType")) {
                this.m_SynchronizedType = para[i].getParameter() != null ? para[i].getParameter().toString() : "";
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + para[i].getParameterName());
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.ctx = this.getCtx();
        this.trxName = Trx.createTrxName();
        this.trx = Trx.get(this.trxName, true);
        return this.GenerateWebServiceType();
    }

    private String GenerateWebServiceType() {
        String nameTable = "";
        String returnMsg = "@Created@ = ";
        try {
            if (this.m_WebService != 0 && this.m_WebServiceMethod != 0 && this.m_Table != 0) {
                returnMsg = String.valueOf(returnMsg) + this.m_Name;
                MWebServiceType wst = new MWebServiceType(this.ctx, 0, this.trxName);
                wst.setValue(this.m_Value);
                wst.setName(this.m_Name);
                wst.setWS_WebService_ID(this.m_WebService);
                wst.setWS_WebServiceMethod_ID(this.m_WebServiceMethod);
                wst.setDescription(this.m_Name);
                wst.setAD_Table_ID(this.m_Table);
                wst.setIsSynchronized(true);
                wst.setSynchronizeType(this.m_SynchronizedType);
                wst.setIsActive(true);
                wst.setXX_MB_Table_ID(this.m_TableMobile);
                wst.saveEx(this.trxName);
                MTable table = new MTable(this.ctx, this.m_Table, this.trxName);
                nameTable = table.getTableName();
                MWebServicePara wsp = new MWebServicePara(this.ctx, 0, this.trxName);
                wsp.setWS_WebServiceType_ID(wst.getWS_WebServiceType_ID());
                wsp.setParameterName("TableName");
                wsp.setParameterType("C");
                wsp.setConstantValue(nameTable);
                wsp.saveEx(this.trxName);
                wsp = new MWebServicePara(this.ctx, 0, this.trxName);
                wsp.setWS_WebServiceType_ID(wst.getWS_WebServiceType_ID());
                wsp.setParameterName("RecordID");
                wsp.setParameterType("F");
                wsp.setConstantValue(null);
                wsp.saveEx(this.trxName);
                wsp = new MWebServicePara(this.ctx, 0, this.trxName);
                wsp.setWS_WebServiceType_ID(wst.getWS_WebServiceType_ID());
                wsp.setParameterName("Action");
                wsp.setParameterType("C");
                wsp.setConstantValue(wst.getSynchronizeType().equals("U") ? "Create" : "Read");
                wsp.saveEx(this.trxName);
                if (wst.getSynchronizeType().equals("U")) {
                    MColumn[] columns = table.getColumns(false);
                    int i = 0;
                    while (i < columns.length) {
                        MWebServiceFieldInput wsfi = new MWebServiceFieldInput(this.ctx, 0, this.trxName);
                        wsfi.setWS_WebServiceType_ID(wst.getWS_WebServiceType_ID());
                        wsfi.setAD_Column_ID(columns[i].getAD_Column_ID());
                        wsfi.saveEx(this.trxName);
                        ++i;
                    }
                } else if (!wst.getSynchronizeType().equals("U")) {
                    MColumn[] columns = table.getColumns(false);
                    int i = 0;
                    while (i < columns.length) {
                        MWebServiceFieldOutput wsfo = new MWebServiceFieldOutput(this.ctx, 0, this.trxName);
                        wsfo.setWS_WebServiceType_ID(wst.getWS_WebServiceType_ID());
                        wsfo.setAD_Column_ID(columns[i].getAD_Column_ID());
                        wsfo.saveEx(this.trxName);
                        ++i;
                    }
                }
            }
            this.trx.commit(true);
        }
        catch (AdempiereException e) {
            this.trx.rollback();
            returnMsg = e.getMessage();
            this.log.log(Level.SEVERE, e.getMessage());
        }
        catch (SQLException e) {
            this.trx.rollback();
            returnMsg = e.getMessage();
            this.log.log(Level.SEVERE, e.getMessage());
        }
        return returnMsg;
    }
}

