/*
 * Decompiled with CFR 0.152.
 */
package org.mb.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Trx;
import org.mb.model.MXXMBSequence;

public class GenerateSequenceMobile
extends SvrProcess {
    private int p_SalesRep_ID = 0;
    private String trxName = null;
    private Trx trx = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if (para.getParameter() != null) {
                if (name.equals("SalesRep_ID")) {
                    this.p_SalesRep_ID = para.getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++n2;
        }
        this.trxName = Trx.createTrxName("GSM");
        this.trx = Trx.get(this.trxName, true);
    }

    @Override
    protected String doIt() throws Exception {
        String returnMsg = "@Created@ = ";
        String sql = new String("SELECT DISTINCT t.AD_Table_ID, t.TableName, CASE \tWHEN s.AD_User_ID = ? AND s.AD_User_ID IS NULL \tTHEN s.XX_MB_Sequence_ID \tELSE 0 END XX_MB_Sequence_ID FROM AD_Table t LEFT JOIN XX_MB_Sequence s ON(s.AD_Table_ID = t.AD_Table_ID) WHERE t.IsView = 'N' AND t.IsSynchronized = 'Y'");
        this.log.fine("Table Result SQL = " + sql);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, this.trxName);
                pstmt.setInt(1, this.p_SalesRep_ID);
                rs = pstmt.executeQuery();
                int generated = 0;
                int m_AD_Table_ID = 0;
                int m_XX_MB_Sequence_ID = 0;
                String m_TableName = null;
                while (rs.next()) {
                    m_AD_Table_ID = rs.getInt("AD_Table_ID");
                    m_XX_MB_Sequence_ID = rs.getInt("XX_MB_Sequence_ID");
                    m_TableName = rs.getString("TableName");
                    MXXMBSequence m_MobileSequence = new MXXMBSequence(this.getCtx(), m_XX_MB_Sequence_ID, this.trxName);
                    m_MobileSequence.setAD_Table_ID(m_AD_Table_ID);
                    m_MobileSequence.setAD_User_ID(this.p_SalesRep_ID);
                    m_MobileSequence.setNameSequence(m_TableName);
                    m_MobileSequence.setCurrentNext(100);
                    m_MobileSequence.setStartNo(100);
                    m_MobileSequence.saveEx();
                    ++generated;
                    this.addLog("TableName = " + m_TableName);
                }
                this.trx.commit();
                returnMsg = String.valueOf(returnMsg) + generated;
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, "Error", e);
                returnMsg = e.getMessage();
                rs.close();
                pstmt.close();
            }
        }
        finally {
            rs.close();
            pstmt.close();
        }
        return returnMsg;
    }
}

