/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.process;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.activemq.transport.stomp.StompConnection;
import org.apache.activemq.transport.stomp.StompFrame;
import org.compiere.Adempiere;
import org.compiere.model.X_I_Order;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ImportQueue2AD
extends SvrProcess {
    private static int cnt = 0;
    private static String p_Test = "N";
    private static String p_Link = "/queue/test";
    private static String p_LinkURL = "localhost";

    public static void main(String[] args) throws Exception {
        StompConnection connection = new StompConnection();
        connection.open(p_LinkURL, 61613);
        connection.connect("", "");
        connection.subscribe(p_Link, "client");
        connection.begin("MQOrders");
        StompFrame message = connection.receive();
        System.out.println(message.getBody());
        if (ImportQueue2AD.parseXMLString(message.getBody())) {
            System.out.println("SUCCESS: Records equal to I_Orders");
        } else {
            System.out.println("ERROR: Records NOT equal to I_Orders");
        }
        if (p_Test.equals("N")) {
            connection.ack(message, "MQOrders");
        }
        connection.commit("MQOrders");
        connection.disconnect();
    }

    private static boolean parseXMLString(String message) throws SAXException, ParserConfigurationException, IOException {
        Adempiere.startupEnvironment(true);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new ByteArrayInputStream(message.getBytes()));
        Element docEle = doc.getDocumentElement();
        NodeList records = docEle.getElementsByTagName("detail");
        int i = 0;
        while (i < records.getLength()) {
            if (records.item(i).getFirstChild().getTextContent().equals("POS Order")) {
                X_I_Order order = new X_I_Order(Env.getCtx(), 0, null);
                NodeList details = records.item(i).getChildNodes();
                int j = 0;
                while (j < details.getLength()) {
                    Node n = details.item(j);
                    String column = n.getNodeName();
                    if (column.equals("BPartnerValue")) {
                        order.setBPartnerValue(n.getTextContent());
                    } else if (column.equals("DateOrdered")) {
                        order.setDateOrdered(Timestamp.valueOf(n.getTextContent()));
                        order.setDateAcct(Timestamp.valueOf(n.getTextContent()));
                    } else if (column.equals("AD_Client_ID")) {
                        order.set_ValueOfColumn("AD_Client_ID", (Object)Integer.parseInt(n.getTextContent()));
                    } else if (column.equals("AD_Org_ID")) {
                        order.setAD_Org_ID(Integer.parseInt(n.getTextContent()));
                    } else if (column.equals("DocTypeName")) {
                        order.setDocTypeName(n.getTextContent());
                    } else if (column.equals("DocumentNo")) {
                        order.setDocumentNo(n.getTextContent());
                    } else if (column.equals("PriceActual")) {
                        order.setPriceActual(BigDecimal.valueOf(Double.parseDouble(n.getTextContent())));
                    } else if (column.equals("ProductValue")) {
                        order.setProductValue(n.getTextContent());
                    } else if (column.equals("QtyOrdered")) {
                        order.setQtyOrdered(BigDecimal.valueOf(Double.parseDouble(n.getTextContent())));
                    } else if (column.equals("TaxAmt")) {
                        order.setTaxAmt(BigDecimal.valueOf(Double.parseDouble(n.getTextContent())));
                    } else if (column.equals("SalesRep_ID")) {
                        order.setSalesRep_ID(Integer.parseInt(n.getTextContent()));
                    } else if (column.equals("POSLocatorName")) {
                        order.setPosLocatorName(n.getTextContent());
                    } else if (column.equals("TaxIndicator")) {
                        order.setTaxIndicator(n.getTextContent());
                    } else if (column.equals("PaymentTermValue")) {
                        order.setPaymentTermValue(n.getTextContent());
                    }
                    String text = n.getTextContent();
                    System.out.println("Node =  " + column + " Text = " + text);
                    ++j;
                }
                order.save();
                ++cnt;
            }
            ++i;
        }
        return records.getLength() == cnt;
    }

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("Test")) {
                p_Test = (String)para[i].getParameter();
            } else if (name.equals("Link")) {
                p_Link = (String)para[i].getParameter();
            } else if (name.equals("LinkURL")) {
                p_LinkURL = (String)para[i].getParameter();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        ImportQueue2AD.main(null);
        return "Records imported? Lost count, maybe " + Integer.toString(cnt);
    }
}

